/*
 * Decompiled with CFR 0.152.
 */
package utils.nexus;

import org.apache.commons.lang.math.IntRange;

public class NexusRange {
    IntRange range;
    int steps;
    int positionVal;

    public NexusRange(IntRange range, int steps, int positionVal) {
        this.range = range;
        this.steps = steps;
        this.positionVal = positionVal;
    }

    public NexusRange(int min, int max, int positionVal) {
        this(new IntRange(min, max), 1, positionVal);
    }

    public NexusRange(int min, int max, int steps, int positionVal) {
        this(new IntRange(min, max), steps, positionVal);
    }

    public String toString() {
        String retVal = "" + this.range.getMinimumInteger() + "-" + this.getMaximumInt();
        if (this.steps != 1) {
            retVal = retVal + "\\" + this.steps;
        }
        return retVal;
    }

    public int getMinimumInt() {
        return this.range.getMinimumInteger();
    }

    public int getMaximumInt() {
        return this.range.getMaximumInteger();
    }

    public int getSteps() {
        return this.steps;
    }

    public int getPositionVal() {
        return this.positionVal;
    }

    public String debug() {
        String debug = "range=" + this.range.toString() + "steps=" + this.steps + "posVal=" + this.positionVal;
        return debug;
    }
}

