/*
 * Decompiled with CFR 0.152.
 */
package utils.nexus;

import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range
implements Comparable<Range> {
    private static final Logger logger = Logger.getLogger(Range.class);
    public int start;
    public int end;
    public int startVal;
    public int step;

    public Range(int start, int end, int startVal, int step) {
        this.start = start;
        this.end = end;
        this.startVal = startVal;
        this.step = step;
    }

    public Range(int start, int end, int startVal) {
        this(start, end, startVal, 1);
    }

    public boolean contains(int testPos, int testStart, int testStep) {
        if (testPos >= this.start && testPos <= this.end) {
            if (this.step == 1 || testStep == 1) {
                return true;
            }
            if (this.step == testStep && this.start % this.step == testStart % testStep) {
                return true;
            }
        }
        return false;
    }

    public boolean contains(int testPos, Range testRange) {
        return this.contains(testPos, testRange.start, testRange.step);
    }

    public boolean contains(int testPos) {
        return this.contains(testPos, 0, 1);
    }

    public boolean containsRange(Range compare) {
        return this.contains(compare.start, compare) && this.contains(compare.end, compare);
    }

    public boolean intersects(Range compare) {
        if (this.contains(compare.start, compare) || this.contains(compare.end, compare) || compare.contains(this.start, this) || compare.contains(this.end, this)) {
            logger.info("intersects true");
            return true;
        }
        return false;
    }

    public boolean partlyWithin(Range compare) {
        if (this.contains(compare.start, compare) || this.contains(compare.end, compare) || compare.contains(this.start, this) || compare.contains(this.end, this)) {
            logger.info("intersects true");
            return true;
        }
        return false;
    }

    public boolean within(Range compare) {
        return compare.contains(this.start, this) && compare.contains(this.end, this);
    }

    public Range getCopy() {
        return new Range(this.start, this.end, this.startVal);
    }

    public Range crop(Range cropTemplate) {
        if (this.contains(cropTemplate.end, cropTemplate)) {
            this.moveStart(cropTemplate.end + 1);
        }
        if (this.contains(cropTemplate.start, cropTemplate)) {
            this.moveEnd(cropTemplate.start - 1);
        }
        return this;
    }

    public void merge(Range additionalRange) {
        int start = Math.min(this.start, additionalRange.start);
        int end = Math.max(this.end, additionalRange.end);
        this.start = start;
        this.end = end;
    }

    public int getPosVal(int pos) {
        if (this.startVal == 0) {
            return 0;
        }
        int diff = pos - this.start;
        int posVal = this.startVal;
        if (diff > 0) {
            posVal = (this.startVal - 1 + diff) % 3 + 1;
        }
        if (diff < 0) {
            diff = Math.abs(diff);
            posVal = (this.startVal - 1 + diff) % 3 + 1;
            posVal = 4 - Math.abs(posVal);
        }
        return posVal;
    }

    private void moveStart(int newStart) {
        int newStartVal = this.getPosVal(newStart);
        this.start = newStart;
        this.startVal = newStartVal;
    }

    private void moveEnd(int newEnd) {
        this.end = newEnd;
    }

    public String toString() {
        String out = "start=" + this.start + " end=" + this.end + " startVal=" + this.startVal;
        return out;
    }

    public Range cutOut(Range additionalRange) {
        Range otherPart = this.getCopy();
        this.moveEnd(additionalRange.start - 1);
        otherPart.moveStart(additionalRange.end + 1);
        return otherPart;
    }

    @Override
    public int compareTo(Range other) {
        return this.start - other.start;
    }

    public int getLength() {
        return this.end - this.start;
    }
}

