/*
 * Decompiled with CFR 0.152.
 */
package utils.nexus;

import org.apache.log4j.Logger;
import utils.nexus.CodonPos;
import utils.nexus.CodonRanges;

public class TranslatedAminoAcidPositions {
    private static final Logger logger = Logger.getLogger(TranslatedAminoAcidPositions.class);
    private CodonRanges codonRanges;
    private int readingFrame = 1;

    public TranslatedAminoAcidPositions(CodonRanges positionsArray, int readingFrame) {
        this.codonRanges = positionsArray;
        this.readingFrame = readingFrame;
    }

    private CodonPos getTranslatedAminoAcidPositionsAt(int x) {
        CodonPos pos = null;
        pos = this.isFullCodingCodonStartingAt(x) ? new CodonPos(x, x + 2, true) : (this.isFullCodingCodonStartingAt(x + 1) ? new CodonPos(x, x, false) : (this.isFullCodingCodonStartingAt(x + 2) ? new CodonPos(x, x + 1, false) : new CodonPos(x, x + 2, false)));
        return pos;
    }

    public boolean isFullCodingCodonStartingAt(int x) {
        boolean isFullCodon = false;
        if (this.getReadingFrame() == 1 && this.getPositionsArray().getPosVal(x) == 1 && this.getPositionsArray().getPosVal(x + 1) == 2 && this.getPositionsArray().getPosVal(x + 2) == 3) {
            isFullCodon = true;
        }
        if (this.getReadingFrame() == 2 && this.getPositionsArray().getPosVal(x) == 2 && this.getPositionsArray().getPosVal(x + 1) == 3 && this.getPositionsArray().getPosVal(x + 2) == 1) {
            isFullCodon = true;
        }
        if (this.getReadingFrame() == 3 && this.getPositionsArray().getPosVal(x) == 3 && this.getPositionsArray().getPosVal(x + 1) == 1 && this.getPositionsArray().getPosVal(x + 2) == 2) {
            isFullCodon = true;
        }
        return isFullCodon;
    }

    private int getReadingFrame() {
        return this.readingFrame;
    }

    private CodonRanges getPositionsArray() {
        return this.codonRanges;
    }

    public CodonPos getCodonAtNucleotidePos(int pos) {
        return this.getTranslatedAminoAcidPositionsAt(pos);
    }

    public int getAAPosAtNucleotidePos(int pos) {
        int aaPos = this.getPositionsArray().aaPosFromNucPos(pos, this.readingFrame);
        return aaPos;
    }

    public CodonPos getCodonAtTranslatedPos(int pos) {
        int nucPos = this.getPositionsArray().nucPosFromAAPos(pos, this.readingFrame);
        CodonPos codpos = this.getCodonAtNucleotidePos(nucPos);
        return this.getCodonAtNucleotidePos(nucPos);
    }
}

