/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.includebrowser;

import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.includebrowser.IBHistoryAction;
import org.eclipse.cdt.internal.ui.includebrowser.IBHistoryListAction;
import org.eclipse.cdt.internal.ui.includebrowser.IBMessages;
import org.eclipse.cdt.internal.ui.includebrowser.IBViewPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class IBHistoryDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private IBViewPart fHierarchyView;
    private Menu fMenu;

    public IBHistoryDropDownAction(IBViewPart view) {
        this.fHierarchyView = view;
        this.fMenu = null;
        this.setToolTipText(IBMessages.IBHistoryDropDownAction_tooltip);
        CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "history_list.gif");
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        ITranslationUnit[] elements = this.fHierarchyView.getHistoryEntries();
        this.addEntries(this.fMenu, elements);
        new MenuItem(this.fMenu, 2);
        this.addActionToMenu(this.fMenu, new IBHistoryListAction(this.fHierarchyView));
        this.addActionToMenu(this.fMenu, new ClearHistoryAction(this.fHierarchyView));
        return this.fMenu;
    }

    private boolean addEntries(Menu menu, ITranslationUnit[] elements) {
        boolean checked = false;
        int min = Math.min(elements.length, 10);
        int i = 0;
        while (i < min) {
            IBHistoryAction action = new IBHistoryAction(this.fHierarchyView, elements[i]);
            action.setChecked(elements[i].equals(this.fHierarchyView.getInput()));
            checked = checked || action.isChecked();
            this.addActionToMenu(menu, action);
            ++i;
        }
        return checked;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
        new IBHistoryListAction(this.fHierarchyView).run();
    }

    public static class ClearHistoryAction
    extends Action {
        private IBViewPart fView;

        public ClearHistoryAction(IBViewPart view) {
            super(IBMessages.IBHistoryDropDownAction_ClearHistory_label);
            this.fView = view;
        }

        public void run() {
            this.fView.setHistoryEntries(new ITranslationUnit[0]);
            this.fView.setInput(null);
        }
    }
}

