/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.actions;

import org.eclipse.cdt.codan.internal.ui.CodanUIActivator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleNatureAction
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)this.selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                this.toggleNature(project, !this.hasCodanNature(project));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasCodanNature(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (true) {
                if (i >= natures.length) {
                    return false;
                }
                if ("org.eclipse.cdt.codan.core.codanNature".equals(natures[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            CodanUIActivator.log(e);
        }
        return false;
    }

    public void toggleNature(IProject project, boolean add) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if ("org.eclipse.cdt.codan.core.codanNature".equals(natures[i])) {
                    if (!add) {
                        String[] newNatures = new String[natures.length - 1];
                        System.arraycopy(natures, 0, newNatures, 0, i);
                        System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                        description.setNatureIds(newNatures);
                        project.setDescription(description, null);
                        return;
                    }
                    add = false;
                    break;
                }
                ++i;
            }
            if (add) {
                String[] newNatures = new String[natures.length + 1];
                System.arraycopy(natures, 0, newNatures, 0, natures.length);
                newNatures[natures.length] = "org.eclipse.cdt.codan.core.codanNature";
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
            }
        }
        catch (CoreException e) {
            CodanUIActivator.log(e);
        }
    }
}

