/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core.services.local;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.remote.core.IRemoteCommandShellService;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteProcessService;

public class LocalCommandShellService
implements IRemoteCommandShellService {
    private final IRemoteConnection connection;

    public LocalCommandShellService(IRemoteConnection connection) {
        this.connection = connection;
    }

    @Override
    public IRemoteConnection getRemoteConnection() {
        return this.connection;
    }

    @Override
    public IRemoteProcess getCommandShell(int flags) throws IOException {
        String[] command;
        IRemoteProcessService procService = this.connection.getService(IRemoteProcessService.class);
        if (Platform.getOS().equals("win32")) {
            command = new String[]{"cmd"};
        } else {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(System.getenv("SHELL").split("\\s+")));
            list.add("-l");
            command = list.toArray(new String[list.size()]);
        }
        IRemoteProcessBuilder builder = procService.getProcessBuilder(command);
        return builder.start(1);
    }

    public static class Factory
    implements IRemoteConnection.Service.Factory {
        @Override
        public <T extends IRemoteConnection.Service> T getService(IRemoteConnection remoteConnection, Class<T> service) {
            if (service.equals(IRemoteCommandShellService.class)) {
                return (T)new LocalCommandShellService(remoteConnection);
            }
            return null;
        }
    }
}

