/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.AbstractBreakpointVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.BreakpointVMContext;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.BreakpointVMProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ICheckUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IMemento;

public class BreakpointVMNode
extends AbstractBreakpointVMNode
implements IElementLabelProvider,
IElementMementoProvider {
    public BreakpointVMNode(BreakpointVMProvider provider) {
        super(provider);
    }

    @Override
    protected Object createBreakpiontElement(IBreakpoint bp) {
        return new BreakpointVMContext(this, bp);
    }

    public void update(ILabelUpdate[] updates) {
        HashMap<IElementLabelProvider, ArrayList<1>> delegatesMap = new HashMap<IElementLabelProvider, ArrayList<1>>(1, 1.0f);
        ILabelUpdate[] iLabelUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final ILabelUpdate update = iLabelUpdateArray[n2];
            final IBreakpoint bp = ((BreakpointVMContext)update.getElement()).getBreakpoint();
            IElementLabelProvider provider = (IElementLabelProvider)bp.getAdapter(IElementLabelProvider.class);
            if (provider == null) {
                update.done();
            } else {
                ArrayList<1> delegatesList = (ArrayList<1>)delegatesMap.get(provider);
                if (delegatesList == null) {
                    delegatesList = new ArrayList<1>(updates.length);
                    delegatesMap.put(provider, delegatesList);
                }
                delegatesList.add(new ICheckUpdate(){

                    public void setChecked(boolean checked, boolean grayed) {
                        if (update instanceof ICheckUpdate) {
                            ((ICheckUpdate)update).setChecked(checked, grayed);
                        }
                    }

                    public String[] getColumnIds() {
                        return update.getColumnIds();
                    }

                    public void setLabel(String text, int columnIndex) {
                        update.setLabel(text, columnIndex);
                    }

                    public void setFontData(FontData fontData, int columnIndex) {
                        update.setFontData(fontData, columnIndex);
                    }

                    public void setImageDescriptor(ImageDescriptor image, int columnIndex) {
                        update.setImageDescriptor(image, columnIndex);
                    }

                    public void setForeground(RGB foreground, int columnIndex) {
                        update.setForeground(foreground, columnIndex);
                    }

                    public void setBackground(RGB background, int columnIndex) {
                        update.setBackground(background, columnIndex);
                    }

                    public IPresentationContext getPresentationContext() {
                        return update.getPresentationContext();
                    }

                    public Object getElement() {
                        return bp;
                    }

                    public TreePath getElementPath() {
                        return update.getElementPath().getParentPath().createChildPath((Object)bp);
                    }

                    public Object getViewerInput() {
                        return update.getViewerInput();
                    }

                    public void setStatus(IStatus status) {
                        update.setStatus(status);
                    }

                    public IStatus getStatus() {
                        return update.getStatus();
                    }

                    public void done() {
                        update.done();
                    }

                    public void cancel() {
                        update.cancel();
                    }

                    public boolean isCanceled() {
                        return update.isCanceled();
                    }
                });
            }
            ++n2;
        }
        for (IElementLabelProvider provider : delegatesMap.keySet()) {
            List updatesList = (List)delegatesMap.get(provider);
            provider.update(updatesList.toArray(new ILabelUpdate[updatesList.size()]));
        }
    }

    public void encodeElements(IElementMementoRequest[] updates) {
        HashMap<IElementMementoProvider, ArrayList<2>> delegatesMap = new HashMap<IElementMementoProvider, ArrayList<2>>(1, 1.0f);
        IElementMementoRequest[] iElementMementoRequestArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IElementMementoRequest update = iElementMementoRequestArray[n2];
            final IBreakpoint bp = ((BreakpointVMContext)update.getElement()).getBreakpoint();
            IElementMementoProvider provider = (IElementMementoProvider)bp.getAdapter(IElementMementoProvider.class);
            if (provider == null) {
                update.done();
            } else {
                ArrayList<2> delegatesList = (ArrayList<2>)delegatesMap.get(provider);
                if (delegatesList == null) {
                    delegatesList = new ArrayList<2>(updates.length);
                    delegatesMap.put(provider, delegatesList);
                }
                delegatesList.add(new IElementMementoRequest(){

                    public IMemento getMemento() {
                        return update.getMemento();
                    }

                    public IPresentationContext getPresentationContext() {
                        return update.getPresentationContext();
                    }

                    public Object getElement() {
                        return bp;
                    }

                    public TreePath getElementPath() {
                        return update.getElementPath().getParentPath().createChildPath((Object)bp);
                    }

                    public Object getViewerInput() {
                        return update.getViewerInput();
                    }

                    public void setStatus(IStatus status) {
                        update.setStatus(status);
                    }

                    public IStatus getStatus() {
                        return update.getStatus();
                    }

                    public void done() {
                        update.done();
                    }

                    public void cancel() {
                        update.cancel();
                    }

                    public boolean isCanceled() {
                        return update.isCanceled();
                    }
                });
            }
            ++n2;
        }
        for (IElementMementoProvider provider : delegatesMap.keySet()) {
            List updatesList = (List)delegatesMap.get(provider);
            provider.encodeElements(updatesList.toArray(new IElementMementoRequest[updatesList.size()]));
        }
    }

    public void compareElements(IElementCompareRequest[] updates) {
        HashMap<IElementMementoProvider, ArrayList<3>> delegatesMap = new HashMap<IElementMementoProvider, ArrayList<3>>(1, 1.0f);
        IElementCompareRequest[] iElementCompareRequestArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IElementCompareRequest update = iElementCompareRequestArray[n2];
            final IBreakpoint bp = ((BreakpointVMContext)update.getElement()).getBreakpoint();
            IElementMementoProvider provider = (IElementMementoProvider)bp.getAdapter(IElementMementoProvider.class);
            if (provider == null) {
                update.done();
            } else {
                ArrayList<3> delegatesList = (ArrayList<3>)delegatesMap.get(provider);
                if (delegatesList == null) {
                    delegatesList = new ArrayList<3>(updates.length);
                    delegatesMap.put(provider, delegatesList);
                }
                delegatesList.add(new IElementCompareRequest(){

                    public IMemento getMemento() {
                        return update.getMemento();
                    }

                    public void setEqual(boolean equal) {
                        update.setEqual(equal);
                    }

                    public IPresentationContext getPresentationContext() {
                        return update.getPresentationContext();
                    }

                    public Object getElement() {
                        return bp;
                    }

                    public TreePath getElementPath() {
                        return update.getElementPath().getParentPath().createChildPath((Object)bp);
                    }

                    public Object getViewerInput() {
                        return update.getViewerInput();
                    }

                    public void setStatus(IStatus status) {
                        update.setStatus(status);
                    }

                    public IStatus getStatus() {
                        return update.getStatus();
                    }

                    public void done() {
                        update.done();
                    }

                    public void cancel() {
                        update.cancel();
                    }

                    public boolean isCanceled() {
                        return update.isCanceled();
                    }
                });
            }
            ++n2;
        }
        for (IElementMementoProvider provider : delegatesMap.keySet()) {
            List updatesList = (List)delegatesMap.get(provider);
            provider.compareElements(updatesList.toArray(new IElementCompareRequest[updatesList.size()]));
        }
    }
}

