/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.hyperlink;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.URLHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.internal.util.JarUtilities;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;

class URLStorageHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private URL fURL;

    public URLStorageHyperlink(IRegion region, URL url) {
        this.fRegion = region;
        this.fURL = url;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        String editorLabel;
        String path = this.fURL.toString();
        if (path.length() > 60) {
            path = String.valueOf(path.substring(0, 25)) + "..." + path.substring(path.length() - 25, path.length());
        }
        if ((editorLabel = this.getEditorLabel()) != null) {
            return NLS.bind((String)XMLUIMessages.Open_With, (Object)path, (Object)editorLabel);
        }
        return NLS.bind((String)XMLUIMessages.Open, (Object)path);
    }

    protected String getEditorLabel() {
        IEditorDescriptor descriptor = this.getEditorDescriptor();
        return descriptor != null ? descriptor.getLabel() : null;
    }

    private IEditorDescriptor getEditorDescriptor() {
        URLStorage storage = new URLStorage(this.fURL);
        String path = this.fURL.getPath();
        String name = null;
        if (path != null) {
            name = new Path(this.fURL.getPath()).lastSegment();
        }
        IContentType contentType = null;
        try (InputStream is = null;){
            is = storage.getContents();
            contentType = Platform.getContentTypeManager().findContentTypeFor(is, name);
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        return PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(name, contentType);
    }

    public void open() {
        if (this.fURL != null) {
            StorageEditorInput input = new StorageEditorInput(new URLStorage(this.fURL));
            try {
                IEditorDescriptor descriptor = this.getEditorDescriptor();
                if (descriptor != null) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)descriptor.getId(), (boolean)true);
                }
            }
            catch (PartInitException e) {
                Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
                new URLHyperlink(this.fRegion, this.fURL.toString()).open();
            }
        }
    }

    static class StorageEditorInput
    implements IStorageEditorInput {
        IStorage fStorage = null;

        StorageEditorInput(IStorage storage) {
            this.fStorage = storage;
        }

        public IStorage getStorage() throws CoreException {
            return this.fStorage;
        }

        public boolean exists() {
            return this.fStorage != null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StorageEditorInput) {
                return this.fStorage.equals(((StorageEditorInput)obj).fStorage);
            }
            return super.equals(obj);
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.fStorage.getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return this.fStorage.getFullPath() != null ? this.fStorage.getFullPath().toString() : this.fStorage.getName();
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }

    static class URLStorage
    implements IStorage {
        URL fURL = null;

        URLStorage(URL url) {
            this.fURL = url;
        }

        public boolean equals(Object obj) {
            if (obj instanceof URLStorage) {
                return this.fURL.equals(((URLStorage)obj).fURL);
            }
            return super.equals(obj);
        }

        public InputStream getContents() throws CoreException {
            InputStream stream = null;
            try {
                stream = this.fURL.toString().startsWith("jar:file") ? JarUtilities.getInputStream((URL)this.fURL) : this.fURL.openStream();
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, XMLUIPlugin.getDefault().getBundle().getSymbolicName(), 4, this.fURL.toString(), (Throwable)e));
            }
            return stream;
        }

        public IPath getFullPath() {
            return new Path(this.fURL.toString());
        }

        public String getName() {
            return new Path(this.fURL.getFile()).lastSegment();
        }

        public boolean isReadOnly() {
            return true;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }
}

