# Copyright 2022 D-Wave Systems Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.

# as of Cython 0.29.28, __annotations__ are not included for Cython objects.
# so we specify their types here.

import typing

from dimod.typing import Variable

T = typing.TypeVar('T')


class cyVariables:
    def __init__(self, iterable: typing.Optional[typing.Iterable[Variable]] = None): ...
    def __contains__(self, v: Variable) -> bool: ...
    def __copy__(self: T) -> T: ...
    @typing.overload
    def __getitem__(self, idx: int) -> Variable: ...
    @typing.overload
    def __getitem__(self: T, idx: slice) -> T: ...
    def __iter__(self) -> typing.Iterator[Variable]: ...
    def __len__(self) -> int: ...
    def _append(self, v: typing.Optional[Variable] = None, permissive: bool = False) -> Variable: ...
    def _clear(self) -> None: ...
    def _is_range(self) -> bool: ...
    def _extend(self, iterable: typing.Iterable[Variable], permissive: bool = False) -> None: ...
    def _pop(self) -> Variable: ...
    def _relabel(self, mapping: typing.Mapping[Variable, Variable]) -> None: ...
    def _relabel_as_integers(self) -> typing.Mapping[int, Variable]: ...
    def _remove(self, v: Variable) -> None: ...
    def copy(self: T) -> T: ...
    def count(self, v: Variable) -> int: ...
    def index(self, v: Variable, permissive: bool = False) -> int: ...
