# distutils: language = c++
# cython: language_level=3

# Copyright 2021 D-Wave Systems Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.

cimport cython

from dimod.libcpp.quadratic_model cimport QuadraticModel as cppQuadraticModel
from dimod.libcpp.vartypes cimport Vartype as cppVartype


cdef class cyQM_template(cyQMBase):
    cdef cppQuadraticModel[bias_type, index_type]* cppqm

    cdef public int REAL_INTERACTIONS

    cdef Py_ssize_t _add_quadratic(self, index_type, index_type, bias_type) except -1
    cdef cppVartype cppvartype(self, object) except? cppVartype.SPIN
    cdef const cppQuadraticModel[bias_type, index_type]* data(self)
