; da65 V2.19 - N/A
; Created:    2025-11-04 02:06:02
; Input file: unalf14.raw
; Page:       1


        .setcpu "6502"

; ----------------------------------------------------------------------------
DOSVEC_lo       := $000A       ; 10 PROGRAM RUN VECTOR
DOSVEC_hi       := $000B
zp_b0           := $00B0
zp_b1           := $00B1
acc16_l         := $00B2
acc16_h         := $00B3
zp_b4           := $00B4
zp_b5           := $00B5
stackptr_l      := $00B6
stackptr_h      := $00B7
zp_b8           := $00B8
zp_b9           := $00B9
outbuf_ptr_l    := $00BA
outbuf_ptr_h    := $00BB
zp_bc           := $00BC
zp_bd           := $00BD
zp_be           := $00BE
zp_bf           := $00BF
SDMCTL          := $022F       ; 559 DMACTL SHADOW
SHFLOC          := $02BE       ; 702
MEMTOP_lo       := $02E5       ; 741 END OF FREE RAM
MEMTOP_hi       := $02E6
MEMLO_hi        := $02E8
ICCOM           := $0342       ; 834 ; Command byte (see C_* constants) (set by user)
ICBAL           := $0344       ; 836 ; Buffer address, LSB (set by user)
ICBAH           := $0345       ; 837 ; Buffer address, MSB (set by user)
ICBLL           := $0348       ; 840 ; Buffer length, LSB (set by user)
ICBLH           := $0349       ; 841 ; Buffer length, MSB (set by user)
ICAX1           := $034A       ; 842 ; AUX1 byte (2nd param in BASIC OPEN) (set by user)
ICAX2           := $034B       ; 843 ; AUX2 byte (4rd param in BASIC OPEN) (set by user)
BOOTRG          := $0700       ; 1792 PROGRAM AREA
input_file      := $7000
output_dir      := $7050
outfile_l       := $70A0
outfile_h       := $70A1
linbuf          := $7120
CIOV            := $E456       ; 58454 ; Main CIO entry point!
; ----------------------------------------------------------------------------
save_SDMCTL:
        .byte   $00            ; 7173 00
L7174:  .byte   $00            ; 7174 00
L7175:  .byte   $00            ; 7175 00
L7176:  .byte   $00            ; 7176 00
L7177:  .byte   $00            ; 7177 00
L7178:  .byte   $00            ; 7178 00
L7179:  .byte   $00            ; 7179 00
L717A:  .byte   $00            ; 717A 00
L717B:  .byte   $00            ; 717B 00
L717C:  .byte   $00            ; 717C 00
L717D:  .byte   $00            ; 717D 00
L717E:  .byte   $00            ; 717E 00
; calculated
cksum_l:.byte   $00            ; 717F 00
cksum_h:.byte   $00            ; 7180 00
L7181:  .byte   $00            ; 7181 00
L7182:  .byte   $30            ; 7182 30
inbuf_len_l:
        .byte   $00            ; 7183 00
inbuf_len_h:
        .byte   $00            ; 7184 00
inbuf_adr_l:
        .byte   $00            ; 7185 00
inbuf_adr_h:
        .byte   $00            ; 7186 00
outbuf_adr_l:
        .byte   $00            ; 7187 00
outbuf_adr_h:
        .byte   $00            ; 7188 00
L7189:  .byte   $00            ; 7189 00
L718A:  .byte   $00            ; 718A 00
L718B:  .byte   $00            ; 718B 00
L718C:  .byte   $00            ; 718C 00
; arc/alf signature, $1a
alf_header:
        .byte   $00            ; 718D 00
; alf signature, $0f
alf_hdr_sig:
        .byte   $00            ; 718E 00
; null-terminated compressed filename, 13 bytes
alf_hdr_filename:
        .byte   $20,$20,$20,$20,$20,$20,$20,$20; 718F 20 20 20 20 20 20 20 20
        .byte   $20,$20,$20,$20,$20; 7197 20 20 20 20 20
; compressed size, 4 bytes, LSB first
alf_hdr_compsize0:
        .byte   $00            ; 719C 00
alf_hdr_compsize1:
        .byte   $00            ; 719D 00
alf_hdr_compsize2:
        .byte   $00            ; 719E 00
; always 0, archived file never >= 16MB
alf_hdr_compsize3:
        .byte   $00            ; 719F 00
; 2 bytes, MS-DOS date format (see Arcinfo)
alf_hdr_date0:
        .byte   $00            ; 71A0 00
alf_hdr_date1:
        .byte   $00            ; 71A1 00
; 2 bytes, MS-DOS time format (see Arcinfo)
alf_hdr_time0:
        .byte   $00            ; 71A2 00
alf_hdr_time1:
        .byte   $00            ; 71A3 00
; CRC stored in file header
alf_hdr_cksum_l:
        .byte   $00            ; 71A4 00
alf_hdr_cksum_h:
        .byte   $00            ; 71A5 00
; uncompressed size, 4 bytes, LSB first
alf_hdr_origsize0:
        .byte   $00            ; 71A6 00
alf_hdr_origsize1:
        .byte   $00            ; 71A7 00
alf_hdr_origsize2:
        .byte   $00            ; 71A8 00
; last byte in alf header
alf_hdr_origsize3:
        .byte   $00            ; 71A9 00
L71AA:  .byte   $00            ; 71AA 00
L71AB:  .byte   $00            ; 71AB 00
shift_counter:
        .byte   $09            ; 71AC 09
L71AD:  .byte   $00            ; 71AD 00
L71AE:  .byte   $02            ; 71AE 02
L71AF:  .byte   $00            ; 71AF 00
L71B0:  .byte   $00            ; 71B0 00
outbuf_len_l:
        .byte   $00            ; 71B1 00
outbuf_len_h:
        .byte   $00            ; 71B2 00
disable_screen_flag:
        .byte   $00            ; 71B3 00
L71B4:  .byte   $00            ; 71B4 00
L71B5:  .byte   $00            ; 71B5 00
L71B6:  .byte   $00            ; 71B6 00
L71B7:  .byte   $00            ; 71B7 00
; ----------------------------------------------------------------------------
msg_banner:
        .byte   "}V1.4     ALFUNCRUNCH     07/10"; 71B8 7D 56 31 2E 34 20 20 20
                               ; 71C0 20 20 41 4C 46 55 4E 43
                               ; 71C8 52 55 4E 43 48 20 20 20
                               ; 71D0 20 20 30 37 2F 31 30
        .byte   "/88"          ; 71D7 2F 38 38
        .byte   $9B,$9B,$00    ; 71DA 9B 9B 00
prompt_infile:
        .byte   "File to decompress:"; 71DD 46 69 6C 65 20 74 6F 20
                               ; 71E5 64 65 63 6F 6D 70 72 65
                               ; 71ED 73 73 3A
        .byte   $9B,$00        ; 71F0 9B 00
prompt_outdir:
        .byte   "Output Directory: "; 71F2 4F 75 74 70 75 74 20 44
                               ; 71FA 69 72 65 63 74 6F 72 79
                               ; 7202 3A 20
        .byte   $9B,$00        ; 7204 9B 00
msg_complete:
        .byte   "Processing complete"; 7206 50 72 6F 63 65 73 73 69
                               ; 720E 6E 67 20 63 6F 6D 70 6C
                               ; 7216 65 74 65
        .byte   $9B,$00        ; 7219 9B 00
msg_uncrunching:
        .byte   "Uncrunching: "; 721B 55 6E 63 72 75 6E 63 68
                               ; 7223 69 6E 67 3A 20
        .byte   $00            ; 7228 00
prompt_screen_off:
        .byte   "Screen off for speed ? "; 7229 53 63 72 65 65 6E 20 6F
                               ; 7231 66 66 20 66 6F 72 20 73
                               ; 7239 70 65 65 64 20 3F 20
        .byte   $00            ; 7240 00
emsg_not_alf:
        .byte   "Not an AlfCrunch file!"; 7241 4E 6F 74 20 61 6E 20 41
                               ; 7249 6C 66 43 72 75 6E 63 68
                               ; 7251 20 66 69 6C 65 21
        .byte   $9B,$00        ; 7257 9B 00
emsg_outdir_too_long:
        .byte   "Output Directory Is Too Long"; 7259 4F 75 74 70 75 74 20 44
                               ; 7261 69 72 65 63 74 6F 72 79
                               ; 7269 20 49 73 20 54 6F 6F 20
                               ; 7271 4C 6F 6E 67
        .byte   $9B,$00        ; 7275 9B 00
emsg_outdir_invalid:
        .byte   "Output Directory Is Invalid"; 7277 4F 75 74 70 75 74 20 44
                               ; 727F 69 72 65 63 74 6F 72 79
                               ; 7287 20 49 73 20 49 6E 76 61
                               ; 728F 6C 69 64
        .byte   $9B,$00        ; 7292 9B 00
emsg_open_input:
        .byte   "Error Opening Input File"; 7294 45 72 72 6F 72 20 4F 70
                               ; 729C 65 6E 69 6E 67 20 49 6E
                               ; 72A4 70 75 74 20 46 69 6C 65
        .byte   $9B,$00        ; 72AC 9B 00
emsg_eof_extra:
        .byte   "Extra bytes at EOF. Don't add t"; 72AE 45 78 74 72 61 20 62 79
                               ; 72B6 74 65 73 20 61 74 20 45
                               ; 72BE 4F 46 2E 20 44 6F 6E 27
                               ; 72C6 74 20 61 64 64 20 74
        .byte   "o file"       ; 72CD 6F 20 66 69 6C 65
        .byte   $9B,$00        ; 72D3 9B 00
emsg_write_output:
        .byte   "Error writing output file"; 72D5 45 72 72 6F 72 20 77 72
                               ; 72DD 69 74 69 6E 67 20 6F 75
                               ; 72E5 74 70 75 74 20 66 69 6C
                               ; 72ED 65
        .byte   $9B,$00        ; 72EE 9B 00
emsg_read_input:
        .byte   "Error reading input file"; 72F0 45 72 72 6F 72 20 72 65
                               ; 72F8 61 64 69 6E 67 20 69 6E
                               ; 7300 70 75 74 20 66 69 6C 65
        .byte   $9B,$00        ; 7308 9B 00
emsg_input_overrun:
        .byte   "Input buffer overrun"; 730A 49 6E 70 75 74 20 62 75
                               ; 7312 66 66 65 72 20 6F 76 65
                               ; 731A 72 72 75 6E
        .byte   $9B,$00        ; 731E 9B 00
emsg_checksum:
        .byte   "File checksum in error"; 7320 46 69 6C 65 20 63 68 65
                               ; 7328 63 6B 73 75 6D 20 69 6E
                               ; 7330 20 65 72 72 6F 72
        .byte   $9B,$00        ; 7336 9B 00
emsg_memlo:
        .byte   "Error, memlo must be under $300"; 7338 45 72 72 6F 72 2C 20 6D
                               ; 7340 65 6D 6C 6F 20 6D 75 73
                               ; 7348 74 20 62 65 20 75 6E 64
                               ; 7350 65 72 20 24 33 30 30
        .byte   "0"            ; 7357 30
        .byte   $9B,$00        ; 7358 9B 00
; ----------------------------------------------------------------------------
startup:jsr     open_kdev      ; 735A 20 B4 7B
        lda     SDMCTL         ; 735D AD 2F 02
        sta     save_SDMCTL    ; 7360 8D 73 71
        lda     MEMLO_hi       ; 7363 AD E8 02
        cmp     #$30           ; 7366 C9 30
        bcs     print_emsg_memlo; 7368 B0 50
; ldx #<msg_banner : ldy #>msg_banner
print_msg_banner:
        ldx     #$B8           ; 736A A2 B8
        ldy     #$71           ; 736C A0 71
        jsr     printstr       ; 736E 20 8B 7A
        lda     #$40           ; 7371 A9 40
        sta     SHFLOC         ; 7373 8D BE 02
        jsr     get_cli_arg    ; 7376 20 CE 7B
        bcs     have_infile    ; 7379 B0 0B
        jsr     copy_cli_arg   ; 737B 20 11 7C
        lda     #$01           ; 737E A9 01
        sta     disable_screen_flag; 7380 8D B3 71
        jmp     L7395          ; 7383 4C 95 73

; ----------------------------------------------------------------------------
; either a filename was passed as an argument (sparta), or enterd at the prompt
have_infile:
        lda     #$9B           ; 7386 A9 9B
        jsr     putchar        ; 7388 20 9F 7A
; ldx #<prompt_infile : ldy #>prompt_infile
print_prompt_infile:
        ldx     #$DD           ; 738B A2 DD
        ldy     #$71           ; 738D A0 71
        jsr     printstr       ; 738F 20 8B 7A
        jsr     getline        ; 7392 20 19 7B
L7395:  lda     linbuf_idx     ; 7395 AD 79 7A
        bne     copy_filename  ; 7398 D0 2A
exit:   jsr     close_kdev     ; 739A 20 C3 7B
; ldx #<msg_complete : ldy #>msg_complete
print_msg_complete:
        ldx     #$06           ; 739D A2 06
        ldy     #$72           ; 739F A0 72
        jsr     printstr       ; 73A1 20 8B 7A
        lda     save_SDMCTL    ; 73A4 AD 73 71
        sta     SDMCTL         ; 73A7 8D 2F 02
        ldx     #$30           ; 73AA A2 30
        jsr     close_iocb     ; 73AC 20 48 7B
        lda     BOOTRG         ; 73AF AD 00 07
        cmp     #$53           ; 73B2 C9 53
        beq     sparta_exit    ; 73B4 F0 03
        jmp     (DOSVEC_lo)    ; 73B6 6C 0A 00

; ----------------------------------------------------------------------------
sparta_exit:
        rts                    ; 73B9 60

; ----------------------------------------------------------------------------
; ldx #<emsg_memlo : ldy #>emsg_memlo
print_emsg_memlo:
        ldx     #$38           ; 73BA A2 38
        ldy     #$73           ; 73BC A0 73
        jsr     printstr       ; 73BE 20 8B 7A
        jmp     exit           ; 73C1 4C 9A 73

; ----------------------------------------------------------------------------
copy_filename:
        jsr     ucase_linbuf   ; 73C4 20 5E 7B
        jsr     ensure_d_prefix; 73C7 20 CF 7D
        jsr     ensure_suffix  ; 73CA 20 0C 7E
        ldx     linbuf_idx     ; 73CD AE 79 7A
copy_filename_loop:
        lda     linbuf,x       ; 73D0 BD 20 71
        sta     input_file,x   ; 73D3 9D 00 70
        dex                    ; 73D6 CA
        bpl     copy_filename_loop; 73D7 10 F7
        jsr     get_cli_arg    ; 73D9 20 CE 7B
        bcs     print_prompt_outdir; 73DC B0 06
        jsr     copy_cli_arg   ; 73DE 20 11 7C
        jmp     have_outdir    ; 73E1 4C EE 73

; ----------------------------------------------------------------------------
; ldx #<prompt_outdir : ldy #>prompt_outdir
print_prompt_outdir:
        ldx     #$F2           ; 73E4 A2 F2
        ldy     #$71           ; 73E6 A0 71
        jsr     printstr       ; 73E8 20 8B 7A
        jsr     getline        ; 73EB 20 19 7B
; either a dir was passed as an argument (sparta), or enterd at the prompt
have_outdir:
        lda     linbuf_idx     ; 73EE AD 79 7A
        beq     exit           ; 73F1 F0 A7
        lda     #$00           ; 73F3 A9 00
        sta     L7174          ; 73F5 8D 74 71
        jsr     ucase_linbuf   ; 73F8 20 5E 7B
        jsr     ensure_d_prefix; 73FB 20 CF 7D
        jsr     L7D86          ; 73FE 20 86 7D
        bcc     copy_outdir    ; 7401 90 0A
; ldx #<emsg_outdir_invalid : ldy #>emsg_outdir_invalid
print_emsg_outdir_invalid2:
        ldx     #$77           ; 7403 A2 77
        ldy     #$72           ; 7405 A0 72
        jsr     printstr       ; 7407 20 8B 7A
        jmp     exit           ; 740A 4C 9A 73

; ----------------------------------------------------------------------------
copy_outdir:
        ldx     linbuf_idx     ; 740D AE 79 7A
cod_loop:
        lda     linbuf,x       ; 7410 BD 20 71
        sta     output_dir,x   ; 7413 9D 50 70
        dex                    ; 7416 CA
        bpl     cod_loop       ; 7417 10 F7
        ldx     disable_screen_flag; 7419 AE B3 71
        bne     disable_screen ; 741C D0 14
; ldx #<prompt_screen_off : ldy #>prompt_screen_off
print_prompt_screen_off:
        ldx     #$29           ; 741E A2 29
        ldy     #$72           ; 7420 A0 72
        jsr     printstr       ; 7422 20 8B 7A
        jsr     getline        ; 7425 20 19 7B
        lda     linbuf         ; 7428 AD 20 71
        jsr     toupper        ; 742B 20 51 7B
        cmp     #$59           ; 742E C9 59
        bne     open_input     ; 7430 D0 09
disable_screen:
        ldx     #$00           ; 7432 A2 00
        sta     SDMCTL         ; 7434 8D 2F 02
        inx                    ; 7437 E8
        stx     disable_screen_flag; 7438 8E B3 71
open_input:
        ldx     #$10           ; 743B A2 10
; lda #<input_file ; ldy #>input_file
lday_input_file:
        lda     #$00           ; 743D A9 00
        ldy     #$70           ; 743F A0 70
        jsr     open_read      ; 7441 20 76 7B
        bpl     read_alf_header; 7444 10 0A
; ldx #<emsg_open_input : ldy #>emsg_open_input
print_emsg_open_input:
        ldx     #$94           ; 7446 A2 94
        ldy     #$72           ; 7448 A0 72
        jsr     printstr       ; 744A 20 8B 7A
        jmp     exit           ; 744D 4C 9A 73

; ----------------------------------------------------------------------------
; 29 ($1D) bytes, read into alf_header
read_alf_header:
        lda     #$8D           ; 7450 A9 8D
        sta     buf_adr_l      ; 7452 8D 7B 7A
        lda     #$71           ; 7455 A9 71
        sta     buf_adr_h      ; 7457 8D 7C 7A
        lda     #$1D           ; 745A A9 1D
        sta     buf_len_l      ; 745C 8D 7D 7A
        lda     #$00           ; 745F A9 00
        sta     buf_len_h      ; 7461 8D 7E 7A
        ldx     #$10           ; 7464 A2 10
        jsr     readblock      ; 7466 20 CF 7A
        bpl     check_arc_sig  ; 7469 10 21
        cpy     #$88           ; 746B C0 88
        bne     print_emsg_open_input; 746D D0 D7
        lda     buf_len_h      ; 746F AD 7E 7A
        bne     check_arc_sig  ; 7472 D0 18
        lda     buf_len_l      ; 7474 AD 7D 7A
        beq     L7489          ; 7477 F0 10
        cmp     #$1D           ; 7479 C9 1D
        bcs     check_arc_sig  ; 747B B0 0F
        lda     L71B4          ; 747D AD B4 71
        beq     print_emsg_open_input; 7480 F0 C4
; ldx #<emsg_eof_extra : ldy #>emsg_eof_extra
print_emsg_eof_extra:
        ldx     #$AE           ; 7482 A2 AE
        ldy     #$72           ; 7484 A0 72
        jsr     printstr       ; 7486 20 8B 7A
L7489:  jmp     exit           ; 7489 4C 9A 73

; ----------------------------------------------------------------------------
; first byte of header is $1A, just like ARC
check_arc_sig:
        lda     alf_header     ; 748C AD 8D 71
        cmp     #$1A           ; 748F C9 1A
        beq     check_alf_sig  ; 7491 F0 0A
; ldx #<emsg_not_alf : ldy #>emsg_not_alf
print_emsg_not_alf:
        ldx     #$41           ; 7493 A2 41
        ldy     #$72           ; 7495 A0 72
        jsr     printstr       ; 7497 20 8B 7A
        jmp     exit           ; 749A 4C 9A 73

; ----------------------------------------------------------------------------
; 2nd byte of header (compression type) is $0F
check_alf_sig:
        lda     alf_hdr_sig    ; 749D AD 8E 71
        cmp     #$0F           ; 74A0 C9 0F
        bne     print_emsg_not_alf; 74A2 D0 EF
        lda     L7174          ; 74A4 AD 74 71
        bne     L74B1          ; 74A7 D0 08
        jsr     L7CA9          ; 74A9 20 A9 7C
        lda     #$01           ; 74AC A9 01
        sta     L7174          ; 74AE 8D 74 71
L74B1:  ldx     #$00           ; 74B1 A2 00
L74B3:  lda     output_dir,x   ; 74B3 BD 50 70
        cmp     #$9B           ; 74B6 C9 9B
        beq     L74C7          ; 74B8 F0 0D
        inx                    ; 74BA E8
        bpl     L74B3          ; 74BB 10 F6
; ldx #<emsg_outdir_too_long : ldy #>emsg_outdir_too_long
print_emsg_outdir_too_long:
        ldx     #$59           ; 74BD A2 59
        ldy     #$72           ; 74BF A0 72
        jsr     printstr       ; 74C1 20 8B 7A
        jmp     exit           ; 74C4 4C 9A 73

; ----------------------------------------------------------------------------
L74C7:  lda     output_dir,x   ; 74C7 BD 50 70
        cmp     #$3E           ; 74CA C9 3E
        beq     L74DF          ; 74CC F0 11
        cmp     #$3A           ; 74CE C9 3A
        beq     L74DF          ; 74D0 F0 0D
        dex                    ; 74D2 CA
        bpl     L74C7          ; 74D3 10 F2
; ldx #<emsg_outdir_invalid : ldy #>emsg_outdir_invalid
print_emsg_outdir_invalid:
        ldx     #$77           ; 74D5 A2 77
        ldy     #$72           ; 74D7 A0 72
        jsr     printstr       ; 74D9 20 8B 7A
        jmp     exit           ; 74DC 4C 9A 73

; ----------------------------------------------------------------------------
L74DF:  txa                    ; 74DF 8A
        tay                    ; 74E0 A8
L74E1:  lda     output_dir,x   ; 74E1 BD 50 70
        sta     outfile_l,x    ; 74E4 9D A0 70
        dex                    ; 74E7 CA
        bpl     L74E1          ; 74E8 10 F7
        iny                    ; 74EA C8
        ldx     #$00           ; 74EB A2 00
L74ED:  lda     alf_hdr_filename,x; 74ED BD 8F 71
        sta     outfile_l,y    ; 74F0 99 A0 70
        beq     L74FB          ; 74F3 F0 06
        inx                    ; 74F5 E8
        iny                    ; 74F6 C8
        bpl     L74ED          ; 74F7 10 F4
        bmi     print_emsg_not_alf; 74F9 30 98
L74FB:  lda     #$9B           ; 74FB A9 9B
        sta     outfile_l,y    ; 74FD 99 A0 70
        lda     #$00           ; 7500 A9 00
        sta     outfile_h,y    ; 7502 99 A1 70
        jsr     L7EE4          ; 7505 20 E4 7E
        bcc     open_outfile   ; 7508 90 03
        jmp     read_alf_header; 750A 4C 50 74

; ----------------------------------------------------------------------------
; lda #<outfile ; ldy #>outfile
open_outfile:
        ldx     #$30           ; 750D A2 30
        lda     #$A0           ; 750F A9 A0
        ldy     #$70           ; 7511 A0 70
        jsr     open_write     ; 7513 20 7B 7B
        bpl     print_msg_uncrunching; 7516 10 0A
; ldx #<emsg_write_output : ldy #>emsg_write_output
print_emsg_write_output:
        ldx     #$D5           ; 7518 A2 D5
        ldy     #$72           ; 751A A0 72
        jsr     printstr       ; 751C 20 8B 7A
        jmp     exit           ; 751F 4C 9A 73

; ----------------------------------------------------------------------------
; ldx #<msg_uncrunching : ldy #>msg_uncrunching
print_msg_uncrunching:
        ldx     #$1B           ; 7522 A2 1B
        ldy     #$72           ; 7524 A0 72
        jsr     printstr       ; 7526 20 8B 7A
; ldx #<outfile ; ldy #>outfile
print_filename:
        ldx     #$A0           ; 7529 A2 A0
        ldy     #$70           ; 752B A0 70
        jsr     printstr       ; 752D 20 8B 7A
        lda     #$01           ; 7530 A9 01
        sta     L71B4          ; 7532 8D B4 71
        lda     alf_hdr_compsize0; 7535 AD 9C 71
        ora     alf_hdr_compsize1; 7538 0D 9D 71
        ora     alf_hdr_compsize2; 753B 0D 9E 71
        ora     alf_hdr_compsize3; 753E 0D 9F 71
        beq     next_header    ; 7541 F0 03
        jsr     uncrunch_file  ; 7543 20 4E 75
next_header:
        ldx     #$30           ; 7546 A2 30
        jsr     close_iocb     ; 7548 20 48 7B
        jmp     read_alf_header; 754B 4C 50 74

; ----------------------------------------------------------------------------
uncrunch_file:
        lda     #$00           ; 754E A9 00
        sta     L71AF          ; 7550 8D AF 71
        sta     L71B0          ; 7553 8D B0 71
        sta     outbuf_len_l   ; 7556 8D B1 71
        sta     outbuf_len_h   ; 7559 8D B2 71
        sta     L71B6          ; 755C 8D B6 71
        sta     L71B7          ; 755F 8D B7 71
        sta     L718C          ; 7562 8D 8C 71
        sta     cksum_l        ; 7565 8D 7F 71
        sta     cksum_h        ; 7568 8D 80 71
        lda     #$09           ; 756B A9 09
        sta     shift_counter  ; 756D 8D AC 71
        lda     #$00           ; 7570 A9 00
        sta     L71AD          ; 7572 8D AD 71
        lda     #$02           ; 7575 A9 02
        sta     L71AE          ; 7577 8D AE 71
        lda     #$00           ; 757A A9 00
        sta     stackptr_l     ; 757C 85 B6
        lda     #$60           ; 757E A9 60
        sta     stackptr_h     ; 7580 85 B7
        jsr     setup_io_bufs  ; 7582 20 78 79
        ldx     #$10           ; 7585 A2 10
        lda     inbuf_adr_l    ; 7587 AD 85 71
        sta     buf_adr_l      ; 758A 8D 7B 7A
        lda     inbuf_adr_h    ; 758D AD 86 71
        sta     buf_adr_h      ; 7590 8D 7C 7A
        lda     inbuf_len_l    ; 7593 AD 83 71
        sta     buf_len_l      ; 7596 8D 7D 7A
        lda     inbuf_len_h    ; 7599 AD 84 71
        sta     buf_len_h      ; 759C 8D 7E 7A
        jsr     L7A19          ; 759F 20 19 7A
        sty     L718C          ; 75A2 8C 8C 71
        jsr     L79E7          ; 75A5 20 E7 79
        lda     buf_len_l      ; 75A8 AD 7D 7A
        ora     buf_len_h      ; 75AB 0D 7E 7A
        bne     L75B1          ; 75AE D0 01
        rts                    ; 75B0 60

; ----------------------------------------------------------------------------
L75B1:  jsr     L76D0          ; 75B1 20 D0 76
        lda     acc16_h        ; 75B4 A5 B3
        cmp     #$01           ; 75B6 C9 01
        bne     uncrunch_blk   ; 75B8 D0 21
        lda     acc16_l        ; 75BA A5 B2
        cmp     #$01           ; 75BC C9 01
        bne     uncrunch_blk   ; 75BE D0 1B
        jsr     write_output   ; 75C0 20 C0 79
        lda     alf_hdr_cksum_l; 75C3 AD A4 71
        cmp     cksum_l        ; 75C6 CD 7F 71
        bne     print_emsg_checksum; 75C9 D0 08
        lda     alf_hdr_cksum_h; 75CB AD A5 71
        cmp     cksum_h        ; 75CE CD 80 71
        beq     cksum_ok       ; 75D1 F0 07
; ldx #<emsg_checksum : ldy #>emsg_checksum
print_emsg_checksum:
        ldx     #$20           ; 75D3 A2 20
        ldy     #$73           ; 75D5 A0 73
        jsr     printstr       ; 75D7 20 8B 7A
cksum_ok:
        rts                    ; 75DA 60

; ----------------------------------------------------------------------------
uncrunch_blk:
        lda     acc16_l        ; 75DB A5 B2
        cmp     #$00           ; 75DD C9 00
        bne     L760B          ; 75DF D0 2A
        lda     acc16_h        ; 75E1 A5 B3
        cmp     #$01           ; 75E3 C9 01
        bne     L760B          ; 75E5 D0 24
        jsr     init_counters  ; 75E7 20 0C 78
        jsr     L76D0          ; 75EA 20 D0 76
        lda     acc16_l        ; 75ED A5 B2
        sta     L717D          ; 75EF 8D 7D 71
        sta     L7179          ; 75F2 8D 79 71
        lda     acc16_h        ; 75F5 A5 B3
        sta     L717E          ; 75F7 8D 7E 71
        sta     L717A          ; 75FA 8D 7A 71
        lda     acc16_l        ; 75FD A5 B2
        sta     L7177          ; 75FF 8D 77 71
        sta     L7178          ; 7602 8D 78 71
        jsr     store_outbyte  ; 7605 20 26 78
        jmp     L75B1          ; 7608 4C B1 75

; ----------------------------------------------------------------------------
L760B:  lda     acc16_l        ; 760B A5 B2
        sta     L717D          ; 760D 8D 7D 71
        sta     L7175          ; 7610 8D 75 71
        lda     acc16_h        ; 7613 A5 B3
        sta     L717E          ; 7615 8D 7E 71
        sta     L7176          ; 7618 8D 76 71
        lda     acc16_h        ; 761B A5 B3
        cmp     L717C          ; 761D CD 7C 71
        bcc     L7641          ; 7620 90 1F
        lda     acc16_l        ; 7622 A5 B2
        cmp     L717B          ; 7624 CD 7B 71
        bcc     L7641          ; 7627 90 18
        lda     L7179          ; 7629 AD 79 71
        sta     acc16_l        ; 762C 85 B2
        sta     L717D          ; 762E 8D 7D 71
        lda     L717A          ; 7631 AD 7A 71
        sta     acc16_h        ; 7634 85 B3
        sta     L717E          ; 7636 8D 7E 71
        lda     L7178          ; 7639 AD 78 71
        sta     acc16_l        ; 763C 85 B2
        jsr     push_acc16     ; 763E 20 F6 78
L7641:  lda     L717E          ; 7641 AD 7E 71
        beq     L7670          ; 7644 F0 2A
        lda     L717D          ; 7646 AD 7D 71
        sta     zp_b4          ; 7649 85 B4
        lda     L717E          ; 764B AD 7E 71
        sta     zp_b5          ; 764E 85 B5
        jsr     L7899          ; 7650 20 99 78
        ldy     #$02           ; 7653 A0 02
        lda     (zp_b0),y      ; 7655 B1 B0
        sta     acc16_l        ; 7657 85 B2
        jsr     push_acc16     ; 7659 20 F6 78
        ldy     #$00           ; 765C A0 00
        lda     (zp_b0),y      ; 765E B1 B0
        sta     acc16_l        ; 7660 85 B2
        sta     L717D          ; 7662 8D 7D 71
        iny                    ; 7665 C8
        lda     (zp_b0),y      ; 7666 B1 B0
        sta     acc16_h        ; 7668 85 B3
        sta     L717E          ; 766A 8D 7E 71
        jmp     L7641          ; 766D 4C 41 76

; ----------------------------------------------------------------------------
L7670:  lda     L717D          ; 7670 AD 7D 71
        sta     acc16_l        ; 7673 85 B2
        sta     L7178          ; 7675 8D 78 71
        sta     L7177          ; 7678 8D 77 71
        lda     L717E          ; 767B AD 7E 71
        sta     acc16_h        ; 767E 85 B3
        jsr     push_acc16     ; 7680 20 F6 78
L7683:  lda     L71AF          ; 7683 AD AF 71
        ora     L71B0          ; 7686 0D B0 71
        beq     L7694          ; 7689 F0 09
        jsr     pop_acc16      ; 768B 20 44 79
        jsr     store_outbyte  ; 768E 20 26 78
        jmp     L7683          ; 7691 4C 83 76

; ----------------------------------------------------------------------------
L7694:  jsr     L78C2          ; 7694 20 C2 78
        lda     L7175          ; 7697 AD 75 71
        sta     acc16_l        ; 769A 85 B2
        sta     L7179          ; 769C 8D 79 71
        lda     L7176          ; 769F AD 76 71
        sta     acc16_h        ; 76A2 85 B3
        sta     L717A          ; 76A4 8D 7A 71
        lda     L717B          ; 76A7 AD 7B 71
        sta     zp_b4          ; 76AA 85 B4
        lda     L717C          ; 76AC AD 7C 71
        sta     zp_b5          ; 76AF 85 B5
        cmp     L71AE          ; 76B1 CD AE 71
        bcc     L76CD          ; 76B4 90 17
        lda     zp_b4          ; 76B6 A5 B4
        cmp     L71AD          ; 76B8 CD AD 71
        bcc     L76CD          ; 76BB 90 10
        lda     shift_counter  ; 76BD AD AC 71
        cmp     #$0C           ; 76C0 C9 0C
        beq     L76CD          ; 76C2 F0 09
        inc     shift_counter  ; 76C4 EE AC 71
        asl     L71AD          ; 76C7 0E AD 71
        rol     L71AE          ; 76CA 2E AE 71
L76CD:  jmp     L75B1          ; 76CD 4C B1 75

; ----------------------------------------------------------------------------
L76D0:  lda     L71B6          ; 76D0 AD B6 71
        sta     zp_b8          ; 76D3 85 B8
        lda     L71B7          ; 76D5 AD B7 71
        sta     zp_b9          ; 76D8 85 B9
        ldx     #$02           ; 76DA A2 02
L76DC:  lsr     zp_b9          ; 76DC 46 B9
        ror     zp_b8          ; 76DE 66 B8
        dex                    ; 76E0 CA
        bpl     L76DC          ; 76E1 10 F9
        lda     zp_b8          ; 76E3 A5 B8
        sta     L71AA          ; 76E5 8D AA 71
        lda     zp_b9          ; 76E8 A5 B9
        sta     L71AB          ; 76EA 8D AB 71
        lda     inbuf_len_l    ; 76ED AD 83 71
        sec                    ; 76F0 38
        sbc     zp_b8          ; 76F1 E5 B8
        sta     zp_bc          ; 76F3 85 BC
        lda     inbuf_len_h    ; 76F5 AD 84 71
        sbc     zp_b9          ; 76F8 E5 B9
        sta     zp_bd          ; 76FA 85 BD
        lda     zp_bd          ; 76FC A5 BD
        bne     L770F          ; 76FE D0 0F
        lda     zp_bc          ; 7700 A5 BC
        cmp     #$03           ; 7702 C9 03
        bcs     L770F          ; 7704 B0 09
        ldx     L718C          ; 7706 AE 8C 71
        bpl     L771C          ; 7709 10 11
        cmp     #$02           ; 770B C9 02
        bcc     L7712          ; 770D 90 03
L770F:  jmp     L779B          ; 770F 4C 9B 77

; ----------------------------------------------------------------------------
L7712:  ldx     #$0A           ; 7712 A2 0A
        ldy     #$0A           ; 7714 A0 0A
        jsr     printstr       ; 7716 20 8B 7A
        jmp     cleanup_and_exit; 7719 4C 7F 78

; ----------------------------------------------------------------------------
L771C:  tay                    ; 771C A8
        dey                    ; 771D 88
        ldx     inbuf_adr_l    ; 771E AE 85 71
        stx     zp_be          ; 7721 86 BE
        ldx     inbuf_adr_h    ; 7723 AE 86 71
        stx     zp_bf          ; 7726 86 BF
        lda     inbuf_adr_l    ; 7728 AD 85 71
        clc                    ; 772B 18
        adc     zp_b8          ; 772C 65 B8
        sta     zp_b8          ; 772E 85 B8
        lda     inbuf_adr_h    ; 7730 AD 86 71
        adc     zp_b9          ; 7733 65 B9
        sta     zp_b9          ; 7735 85 B9
L7737:  lda     (zp_b8),y      ; 7737 B1 B8
        sta     (zp_be),y      ; 7739 91 BE
        dey                    ; 773B 88
        bpl     L7737          ; 773C 10 F9
        lda     inbuf_len_l    ; 773E AD 83 71
        sec                    ; 7741 38
        sbc     zp_bc          ; 7742 E5 BC
        sta     buf_len_l      ; 7744 8D 7D 7A
        lda     inbuf_len_h    ; 7747 AD 84 71
        sbc     #$00           ; 774A E9 00
        sta     buf_len_h      ; 774C 8D 7E 7A
        lda     inbuf_adr_l    ; 774F AD 85 71
        clc                    ; 7752 18
        adc     zp_bc          ; 7753 65 BC
        sta     buf_adr_l      ; 7755 8D 7B 7A
        lda     inbuf_adr_h    ; 7758 AD 86 71
        adc     #$00           ; 775B 69 00
        sta     buf_adr_h      ; 775D 8D 7C 7A
        ldx     #$10           ; 7760 A2 10
        jsr     L7A19          ; 7762 20 19 7A
        sty     L718C          ; 7765 8C 8C 71
        bpl     L7771          ; 7768 10 07
        cpy     #$88           ; 776A C0 88
        beq     L7771          ; 776C F0 03
        jmp     cleanup_and_exit; 776E 4C 7F 78

; ----------------------------------------------------------------------------
L7771:  jsr     L79E7          ; 7771 20 E7 79
        lda     L71AA          ; 7774 AD AA 71
        sta     zp_b8          ; 7777 85 B8
        lda     L71AB          ; 7779 AD AB 71
        sta     zp_b9          ; 777C 85 B9
        ldx     #$02           ; 777E A2 02
L7780:  asl     zp_b8          ; 7780 06 B8
        rol     zp_b9          ; 7782 26 B9
        dex                    ; 7784 CA
        bpl     L7780          ; 7785 10 F9
        lda     L71B6          ; 7787 AD B6 71
        sec                    ; 778A 38
        sbc     zp_b8          ; 778B E5 B8
        sta     L71B6          ; 778D 8D B6 71
        lda     L71B7          ; 7790 AD B7 71
        sbc     zp_b9          ; 7793 E5 B9
        sta     L71B7          ; 7795 8D B7 71
        jmp     L76D0          ; 7798 4C D0 76

; ----------------------------------------------------------------------------
L779B:  lda     zp_b8          ; 779B A5 B8
        sta     zp_bc          ; 779D 85 BC
        clc                    ; 779F 18
        adc     inbuf_adr_l    ; 77A0 6D 85 71
        sta     zp_b8          ; 77A3 85 B8
        lda     zp_b9          ; 77A5 A5 B9
        sta     zp_bd          ; 77A7 85 BD
        adc     inbuf_adr_h    ; 77A9 6D 86 71
        sta     zp_b9          ; 77AC 85 B9
        ldy     #$00           ; 77AE A0 00
        lda     L71B6          ; 77B0 AD B6 71
        and     #$07           ; 77B3 29 07
        bne     L77E1          ; 77B5 D0 2A
        lda     (zp_b8),y      ; 77B7 B1 B8
        sta     acc16_h        ; 77B9 85 B3
        iny                    ; 77BB C8
        lda     (zp_b8),y      ; 77BC B1 B8
        sta     acc16_l        ; 77BE 85 B2
L77C0:  lda     #$0F           ; 77C0 A9 0F
        sec                    ; 77C2 38
        sbc     shift_counter  ; 77C3 ED AC 71
        tax                    ; 77C6 AA
L77C7:  lsr     acc16_h        ; 77C7 46 B3
        ror     acc16_l        ; 77C9 66 B2
        dex                    ; 77CB CA
        bpl     L77C7          ; 77CC 10 F9
        lda     shift_counter  ; 77CE AD AC 71
        clc                    ; 77D1 18
        adc     L71B6          ; 77D2 6D B6 71
        sta     L71B6          ; 77D5 8D B6 71
        lda     #$00           ; 77D8 A9 00
        adc     L71B7          ; 77DA 6D B7 71
        sta     L71B7          ; 77DD 8D B7 71
        rts                    ; 77E0 60

; ----------------------------------------------------------------------------
L77E1:  ldx     #$02           ; 77E1 A2 02
L77E3:  lda     (zp_b8),y      ; 77E3 B1 B8
        sta     L7189,x        ; 77E5 9D 89 71
        iny                    ; 77E8 C8
        dex                    ; 77E9 CA
        bpl     L77E3          ; 77EA 10 F7
        lda     L71B6          ; 77EC AD B6 71
        and     #$07           ; 77EF 29 07
        tax                    ; 77F1 AA
        dex                    ; 77F2 CA
L77F3:  asl     L7189          ; 77F3 0E 89 71
        rol     L718A          ; 77F6 2E 8A 71
        rol     L718B          ; 77F9 2E 8B 71
        dex                    ; 77FC CA
        bpl     L77F3          ; 77FD 10 F4
        lda     L718A          ; 77FF AD 8A 71
        sta     acc16_l        ; 7802 85 B2
        lda     L718B          ; 7804 AD 8B 71
        sta     acc16_h        ; 7807 85 B3
        jmp     L77C0          ; 7809 4C C0 77

; ----------------------------------------------------------------------------
init_counters:
        lda     #$09           ; 780C A9 09
        sta     shift_counter  ; 780E 8D AC 71
        lda     #$00           ; 7811 A9 00
        sta     L71AD          ; 7813 8D AD 71
        lda     #$02           ; 7816 A9 02
        sta     L71AE          ; 7818 8D AE 71
        lda     #$02           ; 781B A9 02
        sta     L717B          ; 781D 8D 7B 71
        lda     #$01           ; 7820 A9 01
        sta     L717C          ; 7822 8D 7C 71
        rts                    ; 7825 60

; ----------------------------------------------------------------------------
; save decrunched byte in outbuf, update checksum, write outbuf if full
store_outbyte:
        ldy     #$00           ; 7826 A0 00
        lda     acc16_l        ; 7828 A5 B2
        sta     (outbuf_ptr_l),y; 782A 91 BA
        clc                    ; 782C 18
        adc     cksum_l        ; 782D 6D 7F 71
        sta     cksum_l        ; 7830 8D 7F 71
        lda     #$00           ; 7833 A9 00
        adc     cksum_h        ; 7835 6D 80 71
        sta     cksum_h        ; 7838 8D 80 71
        inc     outbuf_ptr_l   ; 783B E6 BA
        bne     out_ptr_hi_ok  ; 783D D0 02
        inc     outbuf_ptr_h   ; 783F E6 BB
out_ptr_hi_ok:
        inc     outbuf_len_l   ; 7841 EE B1 71
        bne     out_len_hi_ok  ; 7844 D0 03
        inc     outbuf_len_h   ; 7846 EE B2 71
out_len_hi_ok:
        lda     outbuf_len_h   ; 7849 AD B2 71
        cmp     inbuf_len_h    ; 784C CD 84 71
        bcc     outbuf_not_full; 784F 90 47
        lda     outbuf_len_l   ; 7851 AD B1 71
        cmp     inbuf_len_l    ; 7854 CD 83 71
        bcc     outbuf_not_full; 7857 90 3F
        lda     outbuf_adr_l   ; 7859 AD 87 71
        sta     buf_adr_l      ; 785C 8D 7B 7A
        lda     outbuf_adr_h   ; 785F AD 88 71
        sta     buf_adr_h      ; 7862 8D 7C 7A
        lda     outbuf_len_l   ; 7865 AD B1 71
        sta     buf_len_l      ; 7868 8D 7D 7A
        lda     outbuf_len_h   ; 786B AD B2 71
        sta     buf_len_h      ; 786E 8D 7E 7A
        ldx     #$30           ; 7871 A2 30
        jsr     writeblock     ; 7873 20 D3 7A
        bpl     init_outbuf    ; 7876 10 0E
; ldx #<emsg_checksum : ldy #>emsg_checksum
print_emsg_write_output_2:
        ldx     #$D5           ; 7878 A2 D5
        ldy     #$72           ; 787A A0 72
        jsr     printstr       ; 787C 20 8B 7A
cleanup_and_exit:
        pla                    ; 787F 68
        pla                    ; 7880 68
        pla                    ; 7881 68
        pla                    ; 7882 68
        jmp     exit           ; 7883 4C 9A 73

; ----------------------------------------------------------------------------
init_outbuf:
        lda     outbuf_adr_l   ; 7886 AD 87 71
        sta     outbuf_ptr_l   ; 7889 85 BA
        lda     outbuf_adr_h   ; 788B AD 88 71
        sta     outbuf_ptr_h   ; 788E 85 BB
        lda     #$00           ; 7890 A9 00
        sta     outbuf_len_l   ; 7892 8D B1 71
        sta     outbuf_len_h   ; 7895 8D B2 71
outbuf_not_full:
        rts                    ; 7898 60

; ----------------------------------------------------------------------------
L7899:  lda     zp_b4          ; 7899 A5 B4
        sta     zp_b0          ; 789B 85 B0
        lda     zp_b5          ; 789D A5 B5
        sta     zp_b1          ; 789F 85 B1
        asl     zp_b0          ; 78A1 06 B0
        rol     zp_b1          ; 78A3 26 B1
        lda     zp_b0          ; 78A5 A5 B0
        clc                    ; 78A7 18
        adc     zp_b4          ; 78A8 65 B4
        sta     zp_b0          ; 78AA 85 B0
        lda     zp_b1          ; 78AC A5 B1
        adc     zp_b5          ; 78AE 65 B5
        sta     zp_b1          ; 78B0 85 B1
        lda     zp_b0          ; 78B2 A5 B0
        clc                    ; 78B4 18
        adc     L7181          ; 78B5 6D 81 71
        sta     zp_b0          ; 78B8 85 B0
        lda     zp_b1          ; 78BA A5 B1
        adc     L7182          ; 78BC 6D 82 71
        sta     zp_b1          ; 78BF 85 B1
        rts                    ; 78C1 60

; ----------------------------------------------------------------------------
L78C2:  lda     L717B          ; 78C2 AD 7B 71
        sta     zp_b4          ; 78C5 85 B4
        lda     L717C          ; 78C7 AD 7C 71
        sta     zp_b5          ; 78CA 85 B5
        jsr     L7899          ; 78CC 20 99 78
        lda     L7177          ; 78CF AD 77 71
        sta     acc16_l        ; 78D2 85 B2
        ldy     #$02           ; 78D4 A0 02
        sta     (zp_b0),y      ; 78D6 91 B0
        lda     L7179          ; 78D8 AD 79 71
        sta     acc16_l        ; 78DB 85 B2
        lda     L717A          ; 78DD AD 7A 71
        sta     acc16_h        ; 78E0 85 B3
        ldy     #$00           ; 78E2 A0 00
        lda     acc16_l        ; 78E4 A5 B2
        sta     (zp_b0),y      ; 78E6 91 B0
        iny                    ; 78E8 C8
        lda     acc16_h        ; 78E9 A5 B3
        sta     (zp_b0),y      ; 78EB 91 B0
        inc     L717B          ; 78ED EE 7B 71
        bne     L78F5          ; 78F0 D0 03
        inc     L717C          ; 78F2 EE 7C 71
L78F5:  rts                    ; 78F5 60

; ----------------------------------------------------------------------------
; push 2 byte 'register' to software stack
push_acc16:
        ldy     #$00           ; 78F6 A0 00
        lda     acc16_l        ; 78F8 A5 B2
        sta     (stackptr_l),y ; 78FA 91 B6
        iny                    ; 78FC C8
        lda     acc16_h        ; 78FD A5 B3
        sta     (stackptr_l),y ; 78FF 91 B6
        lda     stackptr_l     ; 7901 A5 B6
        clc                    ; 7903 18
        adc     #$02           ; 7904 69 02
        sta     stackptr_l     ; 7906 85 B6
        bcc     L790C          ; 7908 90 02
        inc     stackptr_h     ; 790A E6 B7
L790C:  lda     stackptr_h     ; 790C A5 B7
        cmp     #$70           ; 790E C9 70
        bcc     L791C          ; 7910 90 0A
; ldx #<emsg_stk_overrun : ldy #>emsg_stk_overrun
print_emsg_stk_overrun:
        ldx     #$25           ; 7912 A2 25
        ldy     #$79           ; 7914 A0 79
        jsr     printstr       ; 7916 20 8B 7A
        jmp     cleanup_and_exit; 7919 4C 7F 78

; ----------------------------------------------------------------------------
L791C:  inc     L71AF          ; 791C EE AF 71
        bne     L7924          ; 791F D0 03
        inc     L71B0          ; 7921 EE B0 71
L7924:  rts                    ; 7924 60

; ----------------------------------------------------------------------------
emsg_stk_overrun:
        .byte   "STACK OVERRUN"; 7925 53 54 41 43 4B 20 4F 56
                               ; 792D 45 52 52 55 4E
        .byte   $9B,$00        ; 7932 9B 00
emsg_stk_underrun:
        .byte   "STACK UNDERRUN"; 7934 53 54 41 43 4B 20 55 4E
                               ; 793C 44 45 52 52 55 4E
        .byte   $9B,$00        ; 7942 9B 00
; ----------------------------------------------------------------------------
; pop 2 byte 'register' from software stack
pop_acc16:
        lda     stackptr_l     ; 7944 A5 B6
        sec                    ; 7946 38
        sbc     #$02           ; 7947 E9 02
        sta     stackptr_l     ; 7949 85 B6
        lda     stackptr_h     ; 794B A5 B7
        sbc     #$00           ; 794D E9 00
        sta     stackptr_h     ; 794F 85 B7
        ldy     #$00           ; 7951 A0 00
        lda     (stackptr_l),y ; 7953 B1 B6
        sta     acc16_l        ; 7955 85 B2
        iny                    ; 7957 C8
        lda     (stackptr_l),y ; 7958 B1 B6
        sta     acc16_h        ; 795A 85 B3
        lda     stackptr_h     ; 795C A5 B7
        cmp     #$60           ; 795E C9 60
        bcs     L796C          ; 7960 B0 0A
; ldx #<emsg_stk_underrun : ldy #>emsg_stk_underrun
print_emsg_stk_underrun:
        ldx     #$34           ; 7962 A2 34
        ldy     #$79           ; 7964 A0 79
        jsr     printstr       ; 7966 20 8B 7A
        jmp     cleanup_and_exit; 7969 4C 7F 78

; ----------------------------------------------------------------------------
L796C:  lda     L71AF          ; 796C AD AF 71
        bne     L7974          ; 796F D0 03
        dec     L71B0          ; 7971 CE B0 71
L7974:  dec     L71AF          ; 7974 CE AF 71
        rts                    ; 7977 60

; ----------------------------------------------------------------------------
setup_io_bufs:
        lda     MEMTOP_lo      ; 7978 AD E5 02
        sec                    ; 797B 38
        sbc     #$DC           ; 797C E9 DC
        sta     inbuf_len_l    ; 797E 8D 83 71
        lda     MEMTOP_hi      ; 7981 AD E6 02
        sbc     #$7F           ; 7984 E9 7F
        sta     inbuf_len_h    ; 7986 8D 84 71
        lsr     inbuf_len_h    ; 7989 4E 84 71
        ror     inbuf_len_l    ; 798C 6E 83 71
        lda     inbuf_len_h    ; 798F AD 84 71
        cmp     #$1F           ; 7992 C9 1F
        bcc     L79A0          ; 7994 90 0A
        lda     #$00           ; 7996 A9 00
        sta     inbuf_len_l    ; 7998 8D 83 71
        lda     #$1F           ; 799B A9 1F
        sta     inbuf_len_h    ; 799D 8D 84 71
L79A0:  lda     #$DC           ; 79A0 A9 DC
        sta     inbuf_adr_l    ; 79A2 8D 85 71
        lda     #$7F           ; 79A5 A9 7F
        sta     inbuf_adr_h    ; 79A7 8D 86 71
        lda     #$DC           ; 79AA A9 DC
        clc                    ; 79AC 18
        adc     inbuf_len_l    ; 79AD 6D 83 71
        sta     outbuf_adr_l   ; 79B0 8D 87 71
        sta     outbuf_ptr_l   ; 79B3 85 BA
        lda     #$7F           ; 79B5 A9 7F
        adc     inbuf_len_h    ; 79B7 6D 84 71
        sta     outbuf_adr_h   ; 79BA 8D 88 71
        sta     outbuf_ptr_h   ; 79BD 85 BB
        rts                    ; 79BF 60

; ----------------------------------------------------------------------------
write_output:
        lda     outbuf_len_l   ; 79C0 AD B1 71
        ora     outbuf_len_h   ; 79C3 0D B2 71
        bne     have_output    ; 79C6 D0 01
        rts                    ; 79C8 60

; ----------------------------------------------------------------------------
have_output:
        lda     outbuf_adr_l   ; 79C9 AD 87 71
        sta     buf_adr_l      ; 79CC 8D 7B 7A
        lda     outbuf_adr_h   ; 79CF AD 88 71
        sta     buf_adr_h      ; 79D2 8D 7C 7A
        lda     outbuf_len_l   ; 79D5 AD B1 71
        sta     buf_len_l      ; 79D8 8D 7D 7A
        lda     outbuf_len_h   ; 79DB AD B2 71
        sta     buf_len_h      ; 79DE 8D 7E 7A
        ldx     #$30           ; 79E1 A2 30
        jsr     writeblock     ; 79E3 20 D3 7A
        rts                    ; 79E6 60

; ----------------------------------------------------------------------------
L79E7:  lda     buf_adr_l      ; 79E7 AD 7B 7A
        clc                    ; 79EA 18
        adc     buf_len_l      ; 79EB 6D 7D 7A
        sta     zp_be          ; 79EE 85 BE
        lda     buf_adr_h      ; 79F0 AD 7C 7A
        adc     buf_len_h      ; 79F3 6D 7E 7A
        sta     zp_bf          ; 79F6 85 BF
        ldx     #$02           ; 79F8 A2 02
        bne     L7A0A          ; 79FA D0 0E
L79FC:  ldy     #$00           ; 79FC A0 00
        tya                    ; 79FE 98
        sta     (zp_be),y      ; 79FF 91 BE
        inc     zp_be          ; 7A01 E6 BE
        bne     L7A07          ; 7A03 D0 02
        inc     zp_bf          ; 7A05 E6 BF
L7A07:  dex                    ; 7A07 CA
        bmi     L7A18          ; 7A08 30 0E
L7A0A:  lda     zp_bf          ; 7A0A A5 BF
        cmp     outbuf_adr_h   ; 7A0C CD 88 71
        bcc     L79FC          ; 7A0F 90 EB
        lda     zp_be          ; 7A11 A5 BE
        cmp     outbuf_adr_l   ; 7A13 CD 87 71
        bcc     L79FC          ; 7A16 90 E4
L7A18:  rts                    ; 7A18 60

; ----------------------------------------------------------------------------
L7A19:  lda     alf_hdr_compsize2; 7A19 AD 9E 71
        ora     alf_hdr_compsize3; 7A1C 0D 9F 71
        beq     L7A28          ; 7A1F F0 07
L7A21:  jsr     readblock      ; 7A21 20 CF 7A
        jsr     L7A5D          ; 7A24 20 5D 7A
        rts                    ; 7A27 60

; ----------------------------------------------------------------------------
L7A28:  lda     alf_hdr_compsize1; 7A28 AD 9D 71
        cmp     buf_len_h      ; 7A2B CD 7E 7A
        bcc     L7A40          ; 7A2E 90 10
        beq     L7A34          ; 7A30 F0 02
        bcs     L7A21          ; 7A32 B0 ED
L7A34:  lda     alf_hdr_compsize0; 7A34 AD 9C 71
        cmp     buf_len_l      ; 7A37 CD 7D 7A
        bcc     L7A40          ; 7A3A 90 04
        beq     L7A40          ; 7A3C F0 02
        bcs     L7A21          ; 7A3E B0 E1
L7A40:  lda     alf_hdr_compsize0; 7A40 AD 9C 71
        sta     buf_len_l      ; 7A43 8D 7D 7A
        lda     alf_hdr_compsize1; 7A46 AD 9D 71
        sta     buf_len_h      ; 7A49 8D 7E 7A
        lda     buf_len_l      ; 7A4C AD 7D 7A
        ora     buf_len_h      ; 7A4F 0D 7E 7A
        beq     L7A57          ; 7A52 F0 03
        jsr     readblock      ; 7A54 20 CF 7A
L7A57:  ldy     #$88           ; 7A57 A0 88
        jsr     L7A5D          ; 7A59 20 5D 7A
        rts                    ; 7A5C 60

; ----------------------------------------------------------------------------
L7A5D:  lda     alf_hdr_compsize0; 7A5D AD 9C 71
        sec                    ; 7A60 38
        sbc     buf_len_l      ; 7A61 ED 7D 7A
        sta     alf_hdr_compsize0; 7A64 8D 9C 71
        lda     alf_hdr_compsize1; 7A67 AD 9D 71
        sbc     buf_len_h      ; 7A6A ED 7E 7A
        sta     alf_hdr_compsize1; 7A6D 8D 9D 71
        lda     alf_hdr_compsize2; 7A70 AD 9E 71
        sbc     #$00           ; 7A73 E9 00
        sta     alf_hdr_compsize2; 7A75 8D 9E 71
        rts                    ; 7A78 60

; ----------------------------------------------------------------------------
linbuf_idx:
        .byte   $00,$00        ; 7A79 00 00
buf_adr_l:
        .byte   $00            ; 7A7B 00
buf_adr_h:
        .byte   $00            ; 7A7C 00
buf_len_l:
        .byte   $00            ; 7A7D 00
buf_len_h:
        .byte   $00            ; 7A7E 00
open_fileadr_l:
        .byte   $00            ; 7A7F 00
open_fileadr_h:
        .byte   $00            ; 7A80 00
save_x: .byte   $00            ; 7A81 00
save_y: .byte   $00            ; 7A82 00
save_a: .byte   $00            ; 7A83 00
; ----------------------------------------------------------------------------
kdev:   .byte   "K:"           ; 7A84 4B 3A
        .byte   $9B            ; 7A86 9B
; unused?
p3dev:  .byte   "P3:"          ; 7A87 50 33 3A
        .byte   $9B            ; 7A8A 9B
; ----------------------------------------------------------------------------
; X = LSB, Y = MSB of string. SELF MODIFYING!
printstr:
        stx     printstr_op_lo ; 7A8B 8E 94 7A
        sty     printstr_op_hi ; 7A8E 8C 95 7A
        ldy     #$00           ; 7A91 A0 00
; $B9 = LDA abs,y
printstr_loop:
        .byte   $B9            ; 7A93 B9
; gets modified
printstr_op_lo:
        .byte   $93            ; 7A94 93
; gets modified
printstr_op_hi:
        .byte   $7A            ; 7A95 7A
        beq     printstr_done  ; 7A96 F0 06
        jsr     putchar        ; 7A98 20 9F 7A
        iny                    ; 7A9B C8
        bne     printstr_loop  ; 7A9C D0 F5
printstr_done:
        rts                    ; 7A9E 60

; ----------------------------------------------------------------------------
; print character in A, saves A/X/Y regs
putchar:stx     save_x         ; 7A9F 8E 81 7A
        sty     save_y         ; 7AA2 8C 82 7A
        sta     save_a         ; 7AA5 8D 83 7A
        ldx     #$00           ; 7AA8 A2 00
        lda     #$0B           ; 7AAA A9 0B
        sta     ICCOM,x        ; 7AAC 9D 42 03
        lda     #$00           ; 7AAF A9 00
        sta     ICBLL,x        ; 7AB1 9D 48 03
        sta     ICBLH,x        ; 7AB4 9D 49 03
        lda     save_a         ; 7AB7 AD 83 7A
        jsr     CIOV           ; 7ABA 20 56 E4
        lda     save_a         ; 7ABD AD 83 7A
        ldx     save_x         ; 7AC0 AE 81 7A
        ldy     save_y         ; 7AC3 AC 82 7A
        rts                    ; 7AC6 60

; ----------------------------------------------------------------------------
        lda     #$05           ; 7AC7 A9 05
        bne     do_block_io    ; 7AC9 D0 0A
        lda     #$09           ; 7ACB A9 09
        bne     do_block_io    ; 7ACD D0 06
readblock:
        lda     #$07           ; 7ACF A9 07
        bne     do_block_io    ; 7AD1 D0 02
writeblock:
        lda     #$0B           ; 7AD3 A9 0B
do_block_io:
        sta     ICCOM,x        ; 7AD5 9D 42 03
        lda     buf_adr_l      ; 7AD8 AD 7B 7A
        sta     ICBAL,x        ; 7ADB 9D 44 03
        lda     buf_adr_h      ; 7ADE AD 7C 7A
        sta     ICBAH,x        ; 7AE1 9D 45 03
        lda     buf_len_l      ; 7AE4 AD 7D 7A
        sta     ICBLL,x        ; 7AE7 9D 48 03
        lda     buf_len_h      ; 7AEA AD 7E 7A
        sta     ICBLH,x        ; 7AED 9D 49 03
        jsr     CIOV           ; 7AF0 20 56 E4
        php                    ; 7AF3 08
        lda     ICBLL,x        ; 7AF4 BD 48 03
        sta     buf_len_l      ; 7AF7 8D 7D 7A
        lda     ICBLH,x        ; 7AFA BD 49 03
        sta     buf_len_h      ; 7AFD 8D 7E 7A
        plp                    ; 7B00 28
        rts                    ; 7B01 60

; ----------------------------------------------------------------------------
        ldx     #$20           ; 7B02 A2 20
        bne     getcx          ; 7B04 D0 02
; read 1 byte from E: (IOCB0)
getc0:  ldx     #$00           ; 7B06 A2 00
getcx:  lda     #$07           ; 7B08 A9 07
        sta     ICCOM,x        ; 7B0A 9D 42 03
        lda     #$00           ; 7B0D A9 00
        sta     ICBLL,x        ; 7B0F 9D 48 03
        sta     ICBLH,x        ; 7B12 9D 49 03
        jsr     CIOV           ; 7B15 20 56 E4
        rts                    ; 7B18 60

; ----------------------------------------------------------------------------
; read a line of input from E:
getline:lda     #$00           ; 7B19 A9 00
        sta     linbuf_idx     ; 7B1B 8D 79 7A
nextchar:
        jsr     getc0          ; 7B1E 20 06 7B
        cmp     #$7E           ; 7B21 C9 7E
        beq     do_backspace   ; 7B23 F0 1B
        cmp     #$9B           ; 7B25 C9 9B
        beq     getline_done   ; 7B27 F0 10
        ldy     linbuf_idx     ; 7B29 AC 79 7A
        cpy     #$4E           ; 7B2C C0 4E
        bcs     nextchar       ; 7B2E B0 EE
        sta     linbuf,y       ; 7B30 99 20 71
        inc     linbuf_idx     ; 7B33 EE 79 7A
        jmp     nextchar       ; 7B36 4C 1E 7B

; ----------------------------------------------------------------------------
getline_done:
        ldy     linbuf_idx     ; 7B39 AC 79 7A
        sta     linbuf,y       ; 7B3C 99 20 71
        rts                    ; 7B3F 60

; ----------------------------------------------------------------------------
do_backspace:
        dec     linbuf_idx     ; 7B40 CE 79 7A
        lda     #$7E           ; 7B43 A9 7E
        jmp     nextchar       ; 7B45 4C 1E 7B

; ----------------------------------------------------------------------------
close_iocb:
        lda     #$0C           ; 7B48 A9 0C
        sta     ICCOM,x        ; 7B4A 9D 42 03
        jsr     CIOV           ; 7B4D 20 56 E4
        rts                    ; 7B50 60

; ----------------------------------------------------------------------------
toupper:cmp     #$7B           ; 7B51 C9 7B
        bcc     le_z           ; 7B53 90 01
        rts                    ; 7B55 60

; ----------------------------------------------------------------------------
le_z:   cmp     #$61           ; 7B56 C9 61
        bcs     ge_a           ; 7B58 B0 01
        rts                    ; 7B5A 60

; ----------------------------------------------------------------------------
ge_a:   sbc     #$20           ; 7B5B E9 20
        rts                    ; 7B5D 60

; ----------------------------------------------------------------------------
ucase_linbuf:
        ldy     linbuf_idx     ; 7B5E AC 79 7A
        beq     ucase_linbuf_done; 7B61 F0 12
        dey                    ; 7B63 88
        tya                    ; 7B64 98
        cmp     #$52           ; 7B65 C9 52
        bcs     ucase_linbuf_done; 7B67 B0 0C
ucase_linbuf_loop:
        lda     linbuf,y       ; 7B69 B9 20 71
        jsr     toupper        ; 7B6C 20 51 7B
        sta     linbuf,y       ; 7B6F 99 20 71
        dey                    ; 7B72 88
        bpl     ucase_linbuf_loop; 7B73 10 F4
ucase_linbuf_done:
        rts                    ; 7B75 60

; ----------------------------------------------------------------------------
; X = IOCB<<4, A=<buf, Y=>buf
open_read:
        pha                    ; 7B76 48
        lda     #$04           ; 7B77 A9 04
        bne     finish_open    ; 7B79 D0 12
open_write:
        pha                    ; 7B7B 48
        lda     #$08           ; 7B7C A9 08
        bne     finish_open    ; 7B7E D0 0D
; not used?
open_update:
        pha                    ; 7B80 48
        lda     #$0C           ; 7B81 A9 0C
        bne     finish_open    ; 7B83 D0 08
; not used?
open_append:
        pha                    ; 7B85 48
        lda     #$09           ; 7B86 A9 09
        bne     finish_open    ; 7B88 D0 03
open_dir:
        pha                    ; 7B8A 48
        lda     #$06           ; 7B8B A9 06
; #$03 in A = CIO OPEN command
finish_open:
        sta     open_fileadr_l ; 7B8D 8D 7F 7A
        sty     open_fileadr_h ; 7B90 8C 80 7A
        jsr     close_iocb     ; 7B93 20 48 7B
        lda     #$03           ; 7B96 A9 03
        sta     ICCOM,x        ; 7B98 9D 42 03
        lda     open_fileadr_l ; 7B9B AD 7F 7A
        sta     ICAX1,x        ; 7B9E 9D 4A 03
        lda     open_fileadr_h ; 7BA1 AD 80 7A
        sta     ICBAH,x        ; 7BA4 9D 45 03
        pla                    ; 7BA7 68
        sta     ICBAL,x        ; 7BA8 9D 44 03
        lda     #$00           ; 7BAB A9 00
        sta     ICAX2,x        ; 7BAD 9D 4B 03
        jsr     CIOV           ; 7BB0 20 56 E4
        rts                    ; 7BB3 60

; ----------------------------------------------------------------------------
open_kdev:
        ldx     #$10           ; 7BB4 A2 10
        jsr     close_iocb     ; 7BB6 20 48 7B
        ldx     #$20           ; 7BB9 A2 20
; lda #<kdev ; ldy #>kdev
lday_kdev:
        lda     #$84           ; 7BBB A9 84
        ldy     #$7A           ; 7BBD A0 7A
        jsr     open_read      ; 7BBF 20 76 7B
        rts                    ; 7BC2 60

; ----------------------------------------------------------------------------
close_kdev:
        ldx     #$10           ; 7BC3 A2 10
        jsr     close_iocb     ; 7BC5 20 48 7B
        ldx     #$20           ; 7BC8 A2 20
        jsr     close_iocb     ; 7BCA 20 48 7B
        rts                    ; 7BCD 60

; ----------------------------------------------------------------------------
; spartados only; returns with C clear if there's an arg, or set if not
get_cli_arg:
        lda     DOSVEC_lo      ; 7BCE A5 0A
        clc                    ; 7BD0 18
        adc     #$3F           ; 7BD1 69 3F
        sta     zp_be          ; 7BD3 85 BE
        lda     DOSVEC_hi      ; 7BD5 A5 0B
        adc     #$00           ; 7BD7 69 00
        sta     zp_bf          ; 7BD9 85 BF
        lda     BOOTRG         ; 7BDB AD 00 07
        cmp     #$53           ; 7BDE C9 53
        bne     L7BF9          ; 7BE0 D0 17
        lda     L7CA8          ; 7BE2 AD A8 7C
        beq     L7BF9          ; 7BE5 F0 12
        ldy     L71B5          ; 7BE7 AC B5 71
L7BEA:  lda     (zp_be),y      ; 7BEA B1 BE
        cmp     #$9B           ; 7BEC C9 9B
        beq     L7BF9          ; 7BEE F0 09
        cmp     #$20           ; 7BF0 C9 20
        beq     L7BFB          ; 7BF2 F0 07
        iny                    ; 7BF4 C8
        cpy     #$40           ; 7BF5 C0 40
        bcc     L7BEA          ; 7BF7 90 F1
L7BF9:  sec                    ; 7BF9 38
        rts                    ; 7BFA 60

; ----------------------------------------------------------------------------
L7BFB:  lda     (zp_be),y      ; 7BFB B1 BE
        cmp     #$9B           ; 7BFD C9 9B
        beq     L7BF9          ; 7BFF F0 F8
        cmp     #$20           ; 7C01 C9 20
        bne     L7C0C          ; 7C03 D0 07
        iny                    ; 7C05 C8
        cpy     #$40           ; 7C06 C0 40
        bcc     L7BFB          ; 7C08 90 F1
        bcs     L7BF9          ; 7C0A B0 ED
L7C0C:  sty     L71B5          ; 7C0C 8C B5 71
        clc                    ; 7C0F 18
        rts                    ; 7C10 60

; ----------------------------------------------------------------------------
; copy sparta cli arg to linbuf, append EOL ($9b)
copy_cli_arg:
        ldx     #$00           ; 7C11 A2 00
        ldy     L71B5          ; 7C13 AC B5 71
cca_loop:
        lda     (zp_be),y      ; 7C16 B1 BE
        sta     linbuf,x       ; 7C18 9D 20 71
        cmp     #$9B           ; 7C1B C9 9B
        beq     cca_append_eol ; 7C1D F0 0A
        cmp     #$20           ; 7C1F C9 20
        beq     cca_append_eol ; 7C21 F0 06
        inx                    ; 7C23 E8
        iny                    ; 7C24 C8
        cpy     #$40           ; 7C25 C0 40
        bcc     cca_loop       ; 7C27 90 ED
cca_append_eol:
        lda     #$9B           ; 7C29 A9 9B
        sta     linbuf,x       ; 7C2B 9D 20 71
        stx     linbuf_idx     ; 7C2E 8E 79 7A
        rts                    ; 7C31 60

; ----------------------------------------------------------------------------
emsg_read_main_dir:
        .byte   "Error reading main directory"; 7C32 45 72 72 6F 72 20 72 65
                               ; 7C3A 61 64 69 6E 67 20 6D 61
                               ; 7C42 69 6E 20 64 69 72 65 63
                               ; 7C4A 74 6F 72 79
        .byte   $9B,$00        ; 7C4E 9B 00
emsg_credir_failed:
        .byte   "CREDIR failed for the above pat"; 7C50 43 52 45 44 49 52 20 66
                               ; 7C58 61 69 6C 65 64 20 66 6F
                               ; 7C60 72 20 74 68 65 20 61 62
                               ; 7C68 6F 76 65 20 70 61 74
        .byte   "h"            ; 7C6F 68
        .byte   $9B,$00        ; 7C70 9B 00
emsg_outpath_build:
        .byte   "Output path cannot be built"; 7C72 4F 75 74 70 75 74 20 70
                               ; 7C7A 61 74 68 20 63 61 6E 6E
                               ; 7C82 6F 74 20 62 65 20 62 75
                               ; 7C8A 69 6C 74
        .byte   $9B,$00        ; 7C8D 9B 00
msg_credir_issued:
        .byte   "CREDIR issued for:"; 7C8F 43 52 45 44 49 52 20 69
                               ; 7C97 73 73 75 65 64 20 66 6F
                               ; 7C9F 72 3A
        .byte   $9B,$00        ; 7CA1 9B 00
L7CA3:  .byte   "*.*"          ; 7CA3 2A 2E 2A
        .byte   $9B            ; 7CA6 9B
L7CA7:  .byte   $00            ; 7CA7 00
; ----------------------------------------------------------------------------
L7CA8:  .byte   $01            ; 7CA8 01
L7CA9:  lda     #$00           ; 7CA9 A9 00
        sta     L7CA7          ; 7CAB 8D A7 7C
        sta     L7CA8          ; 7CAE 8D A8 7C
        jmp     L7D6B          ; 7CB1 4C 6B 7D

; ----------------------------------------------------------------------------
L7CB4:  ldx     L7CA7          ; 7CB4 AE A7 7C
L7CB7:  lda     output_dir,x   ; 7CB7 BD 50 70
        cmp     #$3E           ; 7CBA C9 3E
        beq     L7CE0          ; 7CBC F0 22
        cmp     #$9B           ; 7CBE C9 9B
        beq     L7CC5          ; 7CC0 F0 03
        inx                    ; 7CC2 E8
        bpl     L7CB7          ; 7CC3 10 F2
L7CC5:  lda     L7CA7          ; 7CC5 AD A7 7C
        beq     print_emsg_read_main_dir; 7CC8 F0 0A
; ldx #<emsg_outpath_build : ldy #>emsg_outpath_build
print_emsg_outpath_build:
        ldx     #$72           ; 7CCA A2 72
        ldy     #$7C           ; 7CCC A0 7C
        jsr     printstr       ; 7CCE 20 8B 7A
        jmp     L7CDB          ; 7CD1 4C DB 7C

; ----------------------------------------------------------------------------
; ldx #<emsg_read_main_dir : ldy #>emsg_read_main_dir
print_emsg_read_main_dir:
        ldx     #$32           ; 7CD4 A2 32
        ldy     #$7C           ; 7CD6 A0 7C
        jsr     printstr       ; 7CD8 20 8B 7A
L7CDB:  pla                    ; 7CDB 68
        pla                    ; 7CDC 68
        jmp     exit           ; 7CDD 4C 9A 73

; ----------------------------------------------------------------------------
L7CE0:  stx     L7CA7          ; 7CE0 8E A7 7C
L7CE3:  lda     output_dir,x   ; 7CE3 BD 50 70
        sta     outfile_l,x    ; 7CE6 9D A0 70
        dex                    ; 7CE9 CA
        bpl     L7CE3          ; 7CEA 10 F7
        ldx     L7CA7          ; 7CEC AE A7 7C
        inx                    ; 7CEF E8
        stx     L7CA7          ; 7CF0 8E A7 7C
        ldy     #$00           ; 7CF3 A0 00
L7CF5:  lda     L7CA3,y        ; 7CF5 B9 A3 7C
        sta     outfile_l,x    ; 7CF8 9D A0 70
        inx                    ; 7CFB E8
        iny                    ; 7CFC C8
        cpy     #$04           ; 7CFD C0 04
        bcc     L7CF5          ; 7CFF 90 F4
        ldx     #$40           ; 7D01 A2 40
        lda     #$A0           ; 7D03 A9 A0
        ldy     #$70           ; 7D05 A0 70
        jsr     open_dir       ; 7D07 20 8A 7B
        php                    ; 7D0A 08
        ldx     #$40           ; 7D0B A2 40
        jsr     close_iocb     ; 7D0D 20 48 7B
        plp                    ; 7D10 28
        bmi     L7D16          ; 7D11 30 03
        jmp     L7D6B          ; 7D13 4C 6B 7D

; ----------------------------------------------------------------------------
L7D16:  ldx     L7CA7          ; 7D16 AE A7 7C
        dex                    ; 7D19 CA
        dex                    ; 7D1A CA
        lda     output_dir,x   ; 7D1B BD 50 70
        cmp     #$3A           ; 7D1E C9 3A
        beq     print_emsg_read_main_dir; 7D20 F0 B2
        inx                    ; 7D22 E8
        lda     #$9B           ; 7D23 A9 9B
        sta     outfile_l,x    ; 7D25 9D A0 70
        lda     #$00           ; 7D28 A9 00
        sta     outfile_h,x    ; 7D2A 9D A1 70
; ldx #<msg_credir_issued : ldy #>msg_credir_issued
print_msg_credir_issued:
        ldx     #$8F           ; 7D2D A2 8F
        ldy     #$7C           ; 7D2F A0 7C
        jsr     printstr       ; 7D31 20 8B 7A
        ldx     #$A0           ; 7D34 A2 A0
        ldy     #$70           ; 7D36 A0 70
        jsr     printstr       ; 7D38 20 8B 7A
        ldx     #$40           ; 7D3B A2 40
        lda     #$2A           ; 7D3D A9 2A
        sta     ICCOM,x        ; 7D3F 9D 42 03
        lda     #$A0           ; 7D42 A9 A0
        sta     ICBAL,x        ; 7D44 9D 44 03
        lda     #$70           ; 7D47 A9 70
        sta     ICBAH,x        ; 7D49 9D 45 03
        lda     #$80           ; 7D4C A9 80
        sta     ICBLL,x        ; 7D4E 9D 48 03
        lda     #$00           ; 7D51 A9 00
        sta     ICBLH,x        ; 7D53 9D 49 03
        sta     ICAX1,x        ; 7D56 9D 4A 03
        sta     ICAX2,x        ; 7D59 9D 4B 03
        jsr     CIOV           ; 7D5C 20 56 E4
        bpl     L7D6B          ; 7D5F 10 0A
; ldx #<emsg_credir_failed : ldy #>emsg_credir_failed
print_emsg_credir_failed:
        ldx     #$50           ; 7D61 A2 50
        ldy     #$7C           ; 7D63 A0 7C
        jsr     printstr       ; 7D65 20 8B 7A
        jmp     L7CDB          ; 7D68 4C DB 7C

; ----------------------------------------------------------------------------
L7D6B:  ldx     #$40           ; 7D6B A2 40
        lda     #$50           ; 7D6D A9 50
        ldy     #$70           ; 7D6F A0 70
        jsr     open_dir       ; 7D71 20 8A 7B
        php                    ; 7D74 08
        ldx     #$40           ; 7D75 A2 40
        jsr     close_iocb     ; 7D77 20 48 7B
        plp                    ; 7D7A 28
        bmi     L7D7F          ; 7D7B 30 02
        clc                    ; 7D7D 18
        rts                    ; 7D7E 60

; ----------------------------------------------------------------------------
L7D7F:  jmp     L7CB4          ; 7D7F 4C B4 7C

; ----------------------------------------------------------------------------
; filespec for directory
stardotstar:
        .byte   "*.*"          ; 7D82 2A 2E 2A
        .byte   $9B            ; 7D85 9B
; ----------------------------------------------------------------------------
L7D86:  jsr     L7DBF          ; 7D86 20 BF 7D
        bcc     L7D8C          ; 7D89 90 01
        rts                    ; 7D8B 60

; ----------------------------------------------------------------------------
L7D8C:  dex                    ; 7D8C CA
L7D8D:  lda     linbuf,x       ; 7D8D BD 20 71
        cmp     #$3E           ; 7D90 C9 3E
        beq     L7D9D          ; 7D92 F0 09
        cmp     #$3A           ; 7D94 C9 3A
        beq     L7D9D          ; 7D96 F0 05
        dex                    ; 7D98 CA
        bpl     L7D8D          ; 7D99 10 F2
        sec                    ; 7D9B 38
        rts                    ; 7D9C 60

; ----------------------------------------------------------------------------
L7D9D:  ldy     #$00           ; 7D9D A0 00
        inx                    ; 7D9F E8
        lda     linbuf,x       ; 7DA0 BD 20 71
        cmp     #$9B           ; 7DA3 C9 9B
        beq     L7DAD          ; 7DA5 F0 06
        cmp     #$20           ; 7DA7 C9 20
        beq     L7DAD          ; 7DA9 F0 02
        clc                    ; 7DAB 18
        rts                    ; 7DAC 60

; ----------------------------------------------------------------------------
L7DAD:  lda     stardotstar,y  ; 7DAD B9 82 7D
        sta     linbuf,x       ; 7DB0 9D 20 71
        inx                    ; 7DB3 E8
        iny                    ; 7DB4 C8
        cpy     #$04           ; 7DB5 C0 04
        bcc     L7DAD          ; 7DB7 90 F4
        dex                    ; 7DB9 CA
        stx     linbuf_idx     ; 7DBA 8E 79 7A
        clc                    ; 7DBD 18
        rts                    ; 7DBE 60

; ----------------------------------------------------------------------------
L7DBF:  ldx     #$00           ; 7DBF A2 00
L7DC1:  lda     linbuf,x       ; 7DC1 BD 20 71
        cmp     #$9B           ; 7DC4 C9 9B
        beq     L7DCD          ; 7DC6 F0 05
        inx                    ; 7DC8 E8
        bpl     L7DC1          ; 7DC9 10 F6
        sec                    ; 7DCB 38
        rts                    ; 7DCC 60

; ----------------------------------------------------------------------------
L7DCD:  clc                    ; 7DCD 18
        rts                    ; 7DCE 60

; ----------------------------------------------------------------------------
ensure_d_prefix:
        lda     linbuf         ; 7DCF AD 20 71
        cmp     #$44           ; 7DD2 C9 44
        bne     L7DE2          ; 7DD4 D0 0C
        lda     #$3A           ; 7DD6 A9 3A
        cmp     $7121          ; 7DD8 CD 21 71
        beq     L7E06          ; 7DDB F0 29
        cmp     $7122          ; 7DDD CD 22 71
        beq     L7E06          ; 7DE0 F0 24
L7DE2:  lda     linbuf_idx     ; 7DE2 AD 79 7A
        tax                    ; 7DE5 AA
        clc                    ; 7DE6 18
        adc     #$03           ; 7DE7 69 03
        sta     linbuf_idx     ; 7DE9 8D 79 7A
        tay                    ; 7DEC A8
L7DED:  lda     linbuf,x       ; 7DED BD 20 71
        sta     linbuf,y       ; 7DF0 99 20 71
        dey                    ; 7DF3 88
        dex                    ; 7DF4 CA
        bpl     L7DED          ; 7DF5 10 F6
        lda     #$44           ; 7DF7 A9 44
        ldx     #$31           ; 7DF9 A2 31
        ldy     #$3A           ; 7DFB A0 3A
        sta     linbuf         ; 7DFD 8D 20 71
        stx     $7121          ; 7E00 8E 21 71
        sty     $7122          ; 7E03 8C 22 71
L7E06:  rts                    ; 7E06 60

; ----------------------------------------------------------------------------
alfext: .byte   ".ALF"         ; 7E07 2E 41 4C 46
        .byte   $9B            ; 7E0B 9B
; ----------------------------------------------------------------------------
ensure_suffix:
        ldx     linbuf_idx     ; 7E0C AE 79 7A
        ldy     #$00           ; 7E0F A0 00
L7E11:  lda     linbuf,x       ; 7E11 BD 20 71
        cmp     #$2E           ; 7E14 C9 2E
        beq     L7E21          ; 7E16 F0 09
        iny                    ; 7E18 C8
        dex                    ; 7E19 CA
        bpl     L7E11          ; 7E1A 10 F5
        ldx     linbuf_idx     ; 7E1C AE 79 7A
        bne     L7E25          ; 7E1F D0 04
L7E21:  cpy     #$00           ; 7E21 C0 00
        bne     L7E37          ; 7E23 D0 12
L7E25:  ldy     #$00           ; 7E25 A0 00
L7E27:  lda     alfext,y       ; 7E27 B9 07 7E
        sta     linbuf,x       ; 7E2A 9D 20 71
        inx                    ; 7E2D E8
        iny                    ; 7E2E C8
        cpy     #$05           ; 7E2F C0 05
        bcc     L7E27          ; 7E31 90 F4
        dex                    ; 7E33 CA
        stx     linbuf_idx     ; 7E34 8E 79 7A
L7E37:  rts                    ; 7E37 60

; ----------------------------------------------------------------------------
L7E38:  .byte   $00,$00,$00,$00,$00,$00,$00,$00; 7E38 00 00 00 00 00 00 00 00
        .byte   $00,$00,$00    ; 7E40 00 00 00
L7E43:  .byte   $00,$00,$00,$00,$00,$00,$00,$00; 7E43 00 00 00 00 00 00 00 00
        .byte   $00,$00,$00    ; 7E4B 00 00 00
; ----------------------------------------------------------------------------
L7E4E:  lda     #$20           ; 7E4E A9 20
        ldx     #$0A           ; 7E50 A2 0A
L7E52:  sta     L7E38,x        ; 7E52 9D 38 7E
        sta     L7E43,x        ; 7E55 9D 43 7E
        dex                    ; 7E58 CA
        bpl     L7E52          ; 7E59 10 F7
        ldx     #$00           ; 7E5B A2 00
        ldy     #$00           ; 7E5D A0 00
L7E5F:  lda     alf_hdr_filename,x; 7E5F BD 8F 71
        beq     L7E75          ; 7E62 F0 11
        cmp     #$2E           ; 7E64 C9 2E
        bne     L7E6C          ; 7E66 D0 04
        ldy     #$07           ; 7E68 A0 07
        bne     L7E6F          ; 7E6A D0 03
L7E6C:  sta     L7E38,y        ; 7E6C 99 38 7E
L7E6F:  inx                    ; 7E6F E8
        iny                    ; 7E70 C8
        cpy     #$0B           ; 7E71 C0 0B
        bcc     L7E5F          ; 7E73 90 EA
L7E75:  rts                    ; 7E75 60

; ----------------------------------------------------------------------------
L7E76:  ldx     #$00           ; 7E76 A2 00
L7E78:  lda     output_dir,x   ; 7E78 BD 50 70
        cmp     #$9B           ; 7E7B C9 9B
        beq     L7E82          ; 7E7D F0 03
        inx                    ; 7E7F E8
        bne     L7E78          ; 7E80 D0 F6
L7E82:  lda     output_dir,x   ; 7E82 BD 50 70
        cmp     #$3E           ; 7E85 C9 3E
        beq     L7E90          ; 7E87 F0 07
        cmp     #$3A           ; 7E89 C9 3A
        beq     L7E90          ; 7E8B F0 03
        dex                    ; 7E8D CA
        bpl     L7E82          ; 7E8E 10 F2
L7E90:  ldy     #$00           ; 7E90 A0 00
        inx                    ; 7E92 E8
L7E93:  lda     output_dir,x   ; 7E93 BD 50 70
        cmp     #$2A           ; 7E96 C9 2A
        bne     L7EB3          ; 7E98 D0 19
        lda     #$3F           ; 7E9A A9 3F
L7E9C:  sta     L7E43,y        ; 7E9C 99 43 7E
        iny                    ; 7E9F C8
        cpy     #$08           ; 7EA0 C0 08
        bcc     L7E9C          ; 7EA2 90 F8
        inx                    ; 7EA4 E8
L7EA5:  lda     output_dir,x   ; 7EA5 BD 50 70
        cmp     #$2E           ; 7EA8 C9 2E
        beq     L7EC1          ; 7EAA F0 15
        cmp     #$9B           ; 7EAC C9 9B
        beq     L7EC0          ; 7EAE F0 10
        inx                    ; 7EB0 E8
        bne     L7EA5          ; 7EB1 D0 F2
L7EB3:  cmp     #$2E           ; 7EB3 C9 2E
        beq     L7EC1          ; 7EB5 F0 0A
        sta     L7E43,y        ; 7EB7 99 43 7E
        inx                    ; 7EBA E8
        iny                    ; 7EBB C8
        cpy     #$08           ; 7EBC C0 08
        bcc     L7E93          ; 7EBE 90 D3
L7EC0:  rts                    ; 7EC0 60

; ----------------------------------------------------------------------------
L7EC1:  inx                    ; 7EC1 E8
        ldy     #$08           ; 7EC2 A0 08
L7EC4:  lda     output_dir,x   ; 7EC4 BD 50 70
        cmp     #$9B           ; 7EC7 C9 9B
        beq     L7EC0          ; 7EC9 F0 F5
        cmp     #$2A           ; 7ECB C9 2A
        bne     L7EDA          ; 7ECD D0 0B
        lda     #$3F           ; 7ECF A9 3F
L7ED1:  sta     L7E43,y        ; 7ED1 99 43 7E
        iny                    ; 7ED4 C8
        cpy     #$0B           ; 7ED5 C0 0B
        bcc     L7ED1          ; 7ED7 90 F8
        rts                    ; 7ED9 60

; ----------------------------------------------------------------------------
L7EDA:  sta     L7E43,y        ; 7EDA 99 43 7E
        inx                    ; 7EDD E8
        iny                    ; 7EDE C8
        cpy     #$0B           ; 7EDF C0 0B
        bcc     L7EC4          ; 7EE1 90 E1
        rts                    ; 7EE3 60

; ----------------------------------------------------------------------------
L7EE4:  jsr     L7E4E          ; 7EE4 20 4E 7E
        jsr     L7E76          ; 7EE7 20 76 7E
        ldx     #$00           ; 7EEA A2 00
L7EEC:  lda     L7E43,x        ; 7EEC BD 43 7E
        cmp     #$3F           ; 7EEF C9 3F
        beq     L7EF8          ; 7EF1 F0 05
        cmp     L7E38,x        ; 7EF3 DD 38 7E
        bne     print_msg_skipping; 7EF6 D0 07
L7EF8:  inx                    ; 7EF8 E8
        cpx     #$0B           ; 7EF9 E0 0B
        bcc     L7EEC          ; 7EFB 90 EF
        clc                    ; 7EFD 18
        rts                    ; 7EFE 60

; ----------------------------------------------------------------------------
; ldx #<msg_skipping : ldy #>msg_skipping
print_msg_skipping:
        ldx     #$1D           ; 7EFF A2 1D
        ldy     #$7F           ; 7F01 A0 7F
        jsr     printstr       ; 7F03 20 8B 7A
        ldx     #$00           ; 7F06 A2 00
pskp_loop:
        lda     alf_hdr_filename,x; 7F08 BD 8F 71
        beq     pskp_done      ; 7F0B F0 06
        jsr     putchar        ; 7F0D 20 9F 7A
        inx                    ; 7F10 E8
        bpl     pskp_loop      ; 7F11 10 F5
pskp_done:
        lda     #$9B           ; 7F13 A9 9B
        jsr     putchar        ; 7F15 20 9F 7A
        jsr     L7F3D          ; 7F18 20 3D 7F
        sec                    ; 7F1B 38
        rts                    ; 7F1C 60

; ----------------------------------------------------------------------------
msg_skipping:
        .byte   "Skipping: "   ; 7F1D 53 6B 69 70 70 69 6E 67
                               ; 7F25 3A 20
        .byte   $00            ; 7F27 00
emsg_locate:
        .byte   "Error During Locate"; 7F28 45 72 72 6F 72 20 44 75
                               ; 7F30 72 69 6E 67 20 4C 6F 63
                               ; 7F38 61 74 65
        .byte   $9B,$00        ; 7F3B 9B 00
; ----------------------------------------------------------------------------
L7F3D:  lda     #$DC           ; 7F3D A9 DC
        sta     buf_adr_l      ; 7F3F 8D 7B 7A
        lda     #$7F           ; 7F42 A9 7F
        sta     buf_adr_h      ; 7F44 8D 7C 7A
        lda     MEMTOP_lo      ; 7F47 AD E5 02
        sec                    ; 7F4A 38
        sbc     #$DC           ; 7F4B E9 DC
        sta     inbuf_len_l    ; 7F4D 8D 83 71
        lda     MEMTOP_hi      ; 7F50 AD E6 02
        sbc     #$7F           ; 7F53 E9 7F
        sta     inbuf_len_h    ; 7F55 8D 84 71
L7F58:  lda     alf_hdr_compsize0; 7F58 AD 9C 71
        ora     alf_hdr_compsize1; 7F5B 0D 9D 71
        ora     alf_hdr_compsize2; 7F5E 0D 9E 71
        bne     L7F64          ; 7F61 D0 01
        rts                    ; 7F63 60

; ----------------------------------------------------------------------------
L7F64:  lda     alf_hdr_compsize2; 7F64 AD 9E 71
        bne     L7F8C          ; 7F67 D0 23
        lda     inbuf_len_h    ; 7F69 AD 84 71
        cmp     alf_hdr_compsize1; 7F6C CD 9D 71
        bcc     L7F8C          ; 7F6F 90 1B
        beq     L7F75          ; 7F71 F0 02
        bcs     L7F7D          ; 7F73 B0 08
L7F75:  lda     inbuf_len_l    ; 7F75 AD 83 71
        cmp     alf_hdr_compsize0; 7F78 CD 9C 71
        bcc     L7F8C          ; 7F7B 90 0F
L7F7D:  lda     alf_hdr_compsize0; 7F7D AD 9C 71
        sta     buf_len_l      ; 7F80 8D 7D 7A
        lda     alf_hdr_compsize1; 7F83 AD 9D 71
        sta     buf_len_h      ; 7F86 8D 7E 7A
        jmp     L7F98          ; 7F89 4C 98 7F

; ----------------------------------------------------------------------------
L7F8C:  lda     inbuf_len_l    ; 7F8C AD 83 71
        sta     buf_len_l      ; 7F8F 8D 7D 7A
        lda     inbuf_len_h    ; 7F92 AD 84 71
        sta     buf_len_h      ; 7F95 8D 7E 7A
L7F98:  ldx     #$10           ; 7F98 A2 10
        jsr     readblock      ; 7F9A 20 CF 7A
        bpl     L7FA9          ; 7F9D 10 0A
; ldx #<emsg_locate : ldy #>emsg_locate
print_emsg_locate:
        ldx     #$28           ; 7F9F A2 28
        ldy     #$7F           ; 7FA1 A0 7F
        jsr     printstr       ; 7FA3 20 8B 7A
        jmp     cleanup_and_exit; 7FA6 4C 7F 78

; ----------------------------------------------------------------------------
L7FA9:  lda     alf_hdr_compsize0; 7FA9 AD 9C 71
        sec                    ; 7FAC 38
        sbc     buf_len_l      ; 7FAD ED 7D 7A
        sta     alf_hdr_compsize0; 7FB0 8D 9C 71
        lda     alf_hdr_compsize1; 7FB3 AD 9D 71
        sbc     buf_len_h      ; 7FB6 ED 7E 7A
        sta     alf_hdr_compsize1; 7FB9 8D 9D 71
        lda     alf_hdr_compsize2; 7FBC AD 9E 71
        sbc     #$00           ; 7FBF E9 00
        sta     alf_hdr_compsize2; 7FC1 8D 9E 71
        jmp     L7F58          ; 7FC4 4C 58 7F

; ----------------------------------------------------------------------------
entrypoint:
        jmp     startup        ; 7FC7 4C 5A 73

; ----------------------------------------------------------------------------
        .byte   $4C,$4E,$75,$4C,$00,$00,$20,$71; 7FCA 4C 4E 75 4C 00 00 20 71
        .byte   $00,$70,$A0,$70,$50,$70,$00,$00; 7FD2 00 70 A0 70 50 70 00 00
        .byte   $01,$04,$C7,$7F; 7FDA 01 04 C7 7F
