#!/usr/bin/perl -w

LINE: while(<>) {
	chomp;

	next if /^\s*$/;
	next if /^\s+\.byte/;
	next if /^\s+\.setcpu/;
	next if /^\s+;/;

	# join lone label: with next line
	if(/^[a-zA-Z0-9_]+:\s*$/) {
		$_ .= <>;
		redo LINE;
	}

	# comment-only lines:
	if(/^;\s+(.*)/) {
		print "/* $1 */\n";
		next;
	}

	if(s/(^[a-zA-Z0-9_]+):?//) {
		my $label = $1;
		if(/:=\s*\$([0-9A-F]{4})/) {
			print "u16 $label = 0x$1;\n";
			next;
		} elsif(/\.byte/) {
			/; ([0-9A-F]{4})\s/;
			print "u16 $label = 0x$1;\n";
			next;
		} else {
			print "$label:\n";
		}
	}

	s/\s+;.*//;
	s/^\s*([a-z]{3})\s*//;
	my $mnem = $1;
	s/\s*$//;
	my $operand = $_;
	my $arg = "";

	print "\t";

	if(!$operand) {
		$mnem .= "_a" if $mnem =~ /asl|lsr|rol|ror/;
		print $mnem . "();\n";
		next;
	}

	$operand =~ s,\$,0x,;
	$operand =~ s,;.*,,;

	#print "mnem '$mnem', operand '$operand'\n";
	if($operand =~ /#(.*)/) {
		print $mnem . "_i(" . $1 . ");\n";
		next;
	}

	if($operand =~ /\(([^)]+)\),y/) {
		print $mnem . "_ind_y(" . $1 . ");\n";
		next;
	}

	if($operand =~ /(.+),([xy])/) {
		print $mnem . "_abs_" . $2 . "(" . $1 . ");\n";
		next;
	}

	print $mnem . "(" . $operand . ");\n";
}
