/* fake 6502. a perl script converts this:

	ldy #10
loop:
	lda blah,y
	sta (p1),y
	dey
	bpl loop

to something like:
	ldy_i(10)
loop:
	lda_absy(blah)
	sta_zpy(p1)
	dey();
	bpl(loop);

where e.g.

	#define ldy_i(x) Y=x; ZF=!Y; NF=Y&0x80;

	#define lda_absy(x) A=mem[x+y]; ZF=!A; NF=A&0x80;

	#define sta_zpy(x) mem[(mem[x] | mem[x+1] << 8) + y] = A;

	#define dey() Y--; ZF=!Y; NF=Y&0x80;

	#define bpl(x) if(!NF) goto x

...and the 'loop:' is a real C line label.

we don't worry about the V flag since unalf doesn't use it.

This isn't emulation exactly, and it isn't dynamic recompilation because
it's static. "Static recompilation" maybe?

*/

#include "f65.h"

u8 A, X, Y, S = 0xff, tmp; /* tmp is result for cmp/cpx/cpy */
u8 mem[1 << 16]; /* 64K */
u8 *stack = mem + 0x100; /* page 1 */

u8 CF, ZF, NF; /* flags should really be a bitfield, *shrug* */

unsigned int wtmp;

void dump_state(void) {
	fprintf(stderr,
			"A = $%02x  X = $%02x  Y = $%02x  S = $%02x | "
			"CF = %d  ZF=%d  NF=%d\n",
			A, X, Y, S, (CF ? 1 : 0), (ZF ? 1 : 0), (NF ? 1 : 0));
}

void dump_mem(int start, int end) {
	int count = 0;
	while(start <= end) {
		if(count % 16 == 0) {
			if(count) fputc('\n', stderr);
			fprintf(stderr, "%04x:", start);
		}
		fprintf(stderr, " %02x", mem[start]);
		count++;
		start++;
	}
	fputc('\n', stderr);
}
