/*  $Id: Controller.h,v 1.13 2024/04/08 03:43:50 sarrazip Exp $

    cosmosmash - A space rock shooting video game.
    Copyright (C) 2007-2011 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this program; if not, write to the Free
    Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA  02110-1301, USA.
*/

#ifndef _H_Controller
#define _H_Controller

#include <flatzebra/Couple.h>
#include <SDL_keycode.h>

#include <vector>


class Controller
{
public:

    Controller() {}

    virtual ~Controller() {}

    /** Do any processing that needs to be done at the start of a tick.
    */
    virtual void startOfTick() {}

    /** Called by engine to inform this controller that the keyboard
        state has changed.
    */
    virtual void processKey(SDL_Keycode /*keysym*/, bool /*pressed*/) {}

    /** Indicates if the player has just asked to start a game.
        Returns true if yes, and then 'isExtendedMode' indicates
        if the non-Intellivision extensions must be activated.
        Otherwise, returns false and 'isExtendedMode' is false.
    */
    virtual bool isStartRequested(bool &isExtendedMode) = 0;

    /** Request to end the game (not quit the program).
    */
    virtual bool isEndRequested() { return false; }

    virtual bool isPauseRequested() { return false; }

    virtual bool isResumeRequested() { return false; }

    virtual bool isShootingActive() = 0;

    virtual bool isHyperspaceRequested() = 0;

    virtual bool isLeftMoveRequested() = 0;

    virtual bool isRightMoveRequested() = 0;

    virtual bool isFullScreenToggleRequested() = 0;

    /** Do any processing that needs to be done at the end of a tick.
    */
    virtual void endOfTick() {}


    // Methods by which engine informs controller about game state:


    virtual void beginGameState() {}

    virtual void setPlayerPos(flatzebra::Couple /*pos*/) {}

    virtual void addRockPos(flatzebra::Couple /*pos*/) {}

    virtual void addSpinnerPos(flatzebra::Couple /*pos*/) {}

    virtual void addPulsarPos(flatzebra::Couple /*pos*/) {}

    virtual void endGameState() {}

};


#endif  /* _H_Controller */
