/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.lsb;

import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.util.cmd.CmdLineOptions;
import java.util.Map;

public class LSBConfig
extends OpenStegoConfig {
    public static final String MAX_BITS_USED_PER_CHANNEL = "maxBitsUsedPerChannel";
    private int maxBitsUsedPerChannel = 3;

    @Override
    protected Map<String, Object> convertCmdLineOptionsToMap(CmdLineOptions options) throws OpenStegoException {
        Map<String, Object> map = super.convertCmdLineOptionsToMap(options);
        if (options.getOption("-b") != null) {
            map.put(MAX_BITS_USED_PER_CHANNEL, options.getIntegerValue("-b", "LSB", 4));
        }
        return map;
    }

    @Override
    protected void processConfigItem(String key, Object value) throws OpenStegoException {
        super.processConfigItem(key, value);
        if (key.equals(MAX_BITS_USED_PER_CHANNEL)) {
            assert (value instanceof Integer);
            this.maxBitsUsedPerChannel = (Integer)value;
            if (this.maxBitsUsedPerChannel < 1 || this.maxBitsUsedPerChannel > 8) {
                throw new OpenStegoException(null, "LSB", 5, value);
            }
        }
    }

    public int getMaxBitsUsedPerChannel() {
        return this.maxBitsUsedPerChannel;
    }

    public void setMaxBitsUsedPerChannel(int maxBitsUsedPerChannel) {
        this.maxBitsUsedPerChannel = maxBitsUsedPerChannel;
    }
}

