/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.randlsb;

import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.plugin.lsb.LSBDataHeader;
import com.openstego.desktop.util.ImageHolder;
import com.openstego.desktop.util.StringUtil;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class RandomLSBInputStream
extends InputStream {
    private final ImageHolder image;
    private LSBDataHeader dataHeader = null;
    private int channelBitsUsed;
    private final int imgWidth;
    private final int imgHeight;
    private final OpenStegoConfig config;
    private final Set<String> bitRead = new HashSet<String>();
    private final Random rand;

    public RandomLSBInputStream(ImageHolder image, OpenStegoConfig config) throws OpenStegoException {
        if (image == null || image.getImage() == null) {
            throw new OpenStegoException(null, "LSB", 2);
        }
        this.image = image;
        this.channelBitsUsed = 1;
        this.config = config;
        this.imgWidth = image.getImage().getWidth();
        this.imgHeight = image.getImage().getHeight();
        this.rand = new Random(StringUtil.passwordHash(config.getPassword()));
        this.readHeader();
    }

    private void readHeader() throws OpenStegoException {
        this.dataHeader = new LSBDataHeader(this, this.config);
        this.channelBitsUsed = this.dataHeader.getChannelBitsUsed();
    }

    @Override
    public int read() {
        byte[] bitSet = new byte[8];
        for (int i = 0; i < 8; ++i) {
            int bit;
            int channel;
            int y;
            int x;
            String key;
            do {
                x = this.rand.nextInt(this.imgWidth);
                y = this.rand.nextInt(this.imgHeight);
                channel = this.rand.nextInt(3);
                bit = this.rand.nextInt(this.channelBitsUsed);
            } while (this.bitRead.contains(key = x + "_" + y + "_" + channel + "_" + bit));
            this.bitRead.add(key);
            bitSet[i] = (byte)this.getPixelBit(x, y, channel, bit);
        }
        return (bitSet[0] << 7) + (bitSet[1] << 6) + (bitSet[2] << 5) + (bitSet[3] << 4) + (bitSet[4] << 3) + (bitSet[5] << 2) + (bitSet[6] << 1) + bitSet[7];
    }

    public LSBDataHeader getDataHeader() {
        return this.dataHeader;
    }

    private int getPixelBit(int x, int y, int channel, int bit) {
        return this.image.getImage().getRGB(x, y) >> channel * 8 + bit & 1;
    }
}

