/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.randlsb;

import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.plugin.lsb.LSBConfig;
import com.openstego.desktop.plugin.lsb.LSBDataHeader;
import com.openstego.desktop.util.ImageHolder;
import com.openstego.desktop.util.StringUtil;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class RandomLSBOutputStream
extends OutputStream {
    private final ImageHolder image;
    private int channelBitsUsed;
    private final int dataLength;
    private final String fileName;
    private final int imgWidth;
    private final int imgHeight;
    private final OpenStegoConfig config;
    private final Set<String> bitWritten = new HashSet<String>();
    private final Random rand;

    public RandomLSBOutputStream(ImageHolder image, int dataLength, String fileName, OpenStegoConfig config) throws OpenStegoException {
        if (image == null || image.getImage() == null) {
            throw new OpenStegoException(null, "LSB", 2);
        }
        this.dataLength = dataLength;
        this.imgWidth = image.getImage().getWidth();
        this.imgHeight = image.getImage().getHeight();
        this.config = config;
        if (image.getImage().getType() == 1) {
            this.image = image;
        } else {
            BufferedImage newImg = new BufferedImage(this.imgWidth, this.imgHeight, 1);
            this.image = new ImageHolder(newImg, image.getMetadata());
            for (int x = 0; x < this.imgWidth; ++x) {
                for (int y = 0; y < this.imgHeight; ++y) {
                    newImg.setRGB(x, y, image.getImage().getRGB(x, y));
                }
            }
        }
        this.channelBitsUsed = 1;
        this.fileName = fileName;
        this.rand = new Random(StringUtil.passwordHash(config.getPassword()));
        this.writeHeader();
    }

    private void writeHeader() throws OpenStegoException {
        int channelBits = 1;
        try {
            int noOfPixels = this.imgWidth * this.imgHeight;
            LSBDataHeader header = new LSBDataHeader(this.dataLength, channelBits, this.fileName, this.config);
            int headerSize = header.getHeaderSize();
            while ((double)(noOfPixels * 3 * channelBits) / 8.0 < (double)(headerSize + this.dataLength)) {
                if (++channelBits <= ((LSBConfig)this.config).getMaxBitsUsedPerChannel()) continue;
                throw new OpenStegoException(null, "LSB", 3);
            }
            header.setChannelBitsUsed(channelBits);
            this.write(header.getHeaderData());
            this.channelBitsUsed = channelBits;
        }
        catch (OpenStegoException osEx) {
            throw osEx;
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
    }

    @Override
    public void write(int data) {
        for (int i = 0; i < 8; ++i) {
            int bit;
            int channel;
            int y;
            int x;
            String key;
            boolean bitValue = (data >> 7 - i & 1) == 1;
            do {
                x = this.rand.nextInt(this.imgWidth);
                y = this.rand.nextInt(this.imgHeight);
                channel = this.rand.nextInt(3);
                bit = this.rand.nextInt(this.channelBitsUsed);
            } while (this.bitWritten.contains(key = x + "_" + y + "_" + channel + "_" + bit));
            this.bitWritten.add(key);
            this.setPixelBit(x, y, channel, bit, bitValue);
        }
    }

    public ImageHolder getImage() {
        return this.image;
    }

    private void setPixelBit(int x, int y, int channel, int bit, boolean bitValue) {
        int newPixel;
        int pixel = this.image.getImage().getRGB(x, y);
        if (bitValue) {
            newPixel = pixel | 1 << bit + channel * 8;
        } else {
            int newColor = -2;
            for (int i = 0; i < bit + channel * 8; ++i) {
                newColor = newColor << 1 | 1;
            }
            newPixel = pixel & newColor;
        }
        this.image.getImage().setRGB(x, y, newPixel);
    }
}

