/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.template.image;

import com.openstego.desktop.DataHidingPlugin;
import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.util.ImageHolder;
import com.openstego.desktop.util.ImageUtil;
import com.openstego.desktop.util.cmd.CmdLineOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;

public abstract class DHImagePluginTemplate<C extends OpenStegoConfig>
extends DataHidingPlugin<C> {
    protected static List<String> readFormats = null;
    protected static List<String> writeFormats = null;

    @Override
    public final byte[] getDiff(byte[] stegoData, String stegoFileName, byte[] coverData, String coverFileName, String diffFileName) throws OpenStegoException {
        ImageHolder stegoImage = ImageUtil.byteArrayToImage(stegoData, stegoFileName);
        ImageHolder coverImage = ImageUtil.byteArrayToImage(coverData, coverFileName);
        ImageHolder diffImage = ImageUtil.getDiffImage(stegoImage, coverImage);
        return ImageUtil.imageToByteArray(diffImage, diffFileName, this);
    }

    @Override
    public List<String> getReadableFileExtensions() {
        String[] formats;
        if (readFormats != null) {
            return readFormats;
        }
        readFormats = new ArrayList<String>();
        for (String s : formats = ImageIO.getReaderFormatNames()) {
            String format = s.toLowerCase();
            if (format.contains("jpeg") && format.contains("2000")) {
                format = "jp2";
            }
            if (readFormats.contains(format)) continue;
            readFormats.add(format);
        }
        Collections.sort(readFormats);
        return readFormats;
    }

    @Override
    public List<String> getWritableFileExtensions() throws OpenStegoException {
        String[] formats;
        if (writeFormats != null) {
            return writeFormats;
        }
        writeFormats = new ArrayList<String>();
        for (String s : formats = ImageIO.getWriterFormatNames()) {
            String format = s.toLowerCase();
            if (format.contains("jpeg") && format.contains("2000")) {
                format = "jp2";
            }
            if (writeFormats.contains(format)) continue;
            writeFormats.add(format);
        }
        Collections.sort(writeFormats);
        return writeFormats;
    }

    @Override
    public void populateStdCmdLineOptions(CmdLineOptions options) {
    }
}

