/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.util;

import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.OpenStegoPlugin;
import com.openstego.desktop.util.CommonUtil;
import com.openstego.desktop.util.StringUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PluginManager {
    private static final List<OpenStegoPlugin<?>> plugins = new ArrayList();
    private static final Map<String, OpenStegoPlugin<?>> pluginsMap = new HashMap();

    private PluginManager() {
    }

    public static void loadPlugins() throws OpenStegoException {
        ArrayList<String> pluginList = new ArrayList<String>();
        try (InputStream is = PluginManager.class.getResourceAsStream("/OpenStegoPlugins.internal");
             InputStream isExt = PluginManager.class.getResourceAsStream("/OpenStegoPlugins.external");){
            if (is != null) {
                pluginList.addAll(StringUtil.getStringLines(new String(CommonUtil.streamToBytes(is))));
            }
            if (isExt != null) {
                pluginList.addAll(StringUtil.getStringLines(new String(CommonUtil.streamToBytes(isExt))));
            }
            for (String pluginClass : pluginList) {
                OpenStegoPlugin plugin = (OpenStegoPlugin)Class.forName(pluginClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                plugins.add(plugin);
                pluginsMap.put(plugin.getName().toUpperCase(), plugin);
            }
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
    }

    public static List<String> getPluginNames() {
        return plugins.stream().map(OpenStegoPlugin::getName).collect(Collectors.toList());
    }

    public static List<OpenStegoPlugin<?>> getPlugins() {
        return plugins;
    }

    public static List<OpenStegoPlugin<?>> getDataHidingPlugins() {
        ArrayList dhPlugins = new ArrayList();
        for (OpenStegoPlugin<?> plugin : plugins) {
            if (!plugin.getPurposes().contains((Object)OpenStegoPlugin.Purpose.DATA_HIDING)) continue;
            dhPlugins.add(plugin);
        }
        return dhPlugins;
    }

    public static List<OpenStegoPlugin<?>> getWatermarkingPlugins() {
        ArrayList dhPlugins = new ArrayList();
        for (OpenStegoPlugin<?> plugin : plugins) {
            if (!plugin.getPurposes().contains((Object)OpenStegoPlugin.Purpose.WATERMARKING)) continue;
            dhPlugins.add(plugin);
        }
        return dhPlugins;
    }

    public static OpenStegoPlugin<?> getPluginByName(String name) {
        return pluginsMap.get(name.toUpperCase());
    }
}

