/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.util.dwt;

import com.openstego.desktop.util.CommonUtil;
import com.openstego.desktop.util.dwt.Filter;
import com.openstego.desktop.util.dwt.FilterGH;
import com.openstego.desktop.util.dwt.Image;
import com.openstego.desktop.util.dwt.ImageTree;

public class DWTUtil {
    private DWTUtil() {
    }

    public static ImageTree waveletTransform(Image origImg, int level, FilterGH[] filterGHList, int method) {
        int maxLevel;
        ImageTree returnTree;
        Image coarseImg = null;
        int width = origImg.getWidth();
        int height = origImg.getHeight();
        Image tempImg = new Image(width, height);
        DWTUtil.copyIntoImage(tempImg, origImg, 0, 0);
        ImageTree tempTree = returnTree = new ImageTree();
        returnTree.setLevel(0);
        int min = origImg.getWidth();
        if (origImg.getHeight() < min) {
            min = origImg.getHeight();
        }
        if ((maxLevel = (int)(Math.log(min) / Math.log(2.0)) - 2) < level) {
            level = maxLevel;
        }
        if (level < 1) {
            returnTree.setImage(tempImg);
            return returnTree;
        }
        for (int i = 0; i < level; ++i) {
            width = (width + 1) / 2;
            height = (height + 1) / 2;
            coarseImg = new Image(width, height);
            Image horizontalImg = new Image(width, height);
            Image verticalImg = new Image(width, height);
            Image diagonalImg = new Image(width, height);
            DWTUtil.decomposition(tempImg, coarseImg, horizontalImg, verticalImg, diagonalImg, filterGHList[i].getG(), filterGHList[i].getH(), method);
            tempTree.setCoarse(new ImageTree());
            tempTree.setHorizontal(new ImageTree());
            tempTree.setVertical(new ImageTree());
            tempTree.setDiagonal(new ImageTree());
            tempTree.getCoarse().setLevel(i + 1);
            tempTree.getHorizontal().setLevel(i + 1);
            tempTree.getVertical().setLevel(i + 1);
            tempTree.getDiagonal().setLevel(i + 1);
            tempTree.getHorizontal().setImage(horizontalImg);
            tempTree.getVertical().setImage(verticalImg);
            tempTree.getDiagonal().setImage(diagonalImg);
            if (i != level - 1) {
                tempImg = new Image(width, height);
                DWTUtil.copyIntoImage(tempImg, coarseImg, 0, 0);
                coarseImg = null;
            }
            tempTree = tempTree.getCoarse();
        }
        tempTree.setImage(coarseImg);
        return returnTree;
    }

    public static void decomposition(Image inputImg, Image coarseImg, Image horizontalImg, Image verticalImg, Image diagonalImg, Filter filterG, Filter filterH, int method) {
        Image tempImg = new Image(coarseImg.getWidth(), inputImg.getHeight());
        DWTUtil.convoluteLines(tempImg, inputImg, filterH, method);
        DWTUtil.convoluteRows(coarseImg, tempImg, filterH, method);
        DWTUtil.convoluteRows(horizontalImg, tempImg, filterG, method);
        tempImg = new Image(verticalImg.getWidth(), inputImg.getHeight());
        DWTUtil.convoluteLines(tempImg, inputImg, filterG, method);
        DWTUtil.convoluteRows(verticalImg, tempImg, filterH, method);
        DWTUtil.convoluteRows(diagonalImg, tempImg, filterG, method);
    }

    public static void convoluteLines(Image outputImg, Image inputImg, Filter filter, int method) {
        block8: for (int i = 0; i < inputImg.getHeight(); ++i) {
            switch (method) {
                case 0: {
                    DWTUtil.filterCutOff(inputImg, inputImg.getWidth() * i, inputImg.getWidth(), 1, outputImg, outputImg.getWidth() * i, outputImg.getWidth(), 1, filter);
                    continue block8;
                }
                case 1: {
                    DWTUtil.filterInvCutOff(inputImg, inputImg.getWidth() * i, inputImg.getWidth(), 1, outputImg, outputImg.getWidth() * i, outputImg.getWidth(), 1, filter);
                    continue block8;
                }
                case 2: {
                    DWTUtil.filterPeriodical(inputImg, inputImg.getWidth() * i, inputImg.getWidth(), 1, outputImg, outputImg.getWidth() * i, outputImg.getWidth(), 1, filter);
                    continue block8;
                }
                case 3: {
                    DWTUtil.filterInvPeriodical(inputImg, inputImg.getWidth() * i, inputImg.getWidth(), 1, outputImg, outputImg.getWidth() * i, outputImg.getWidth(), 1, filter);
                    continue block8;
                }
                case 4: {
                    DWTUtil.filterMirror(inputImg, inputImg.getWidth() * i, inputImg.getWidth(), 1, outputImg, outputImg.getWidth() * i, outputImg.getWidth(), 1, filter);
                    continue block8;
                }
                case 5: {
                    DWTUtil.filterInvMirror(inputImg, inputImg.getWidth() * i, inputImg.getWidth(), 1, outputImg, outputImg.getWidth() * i, outputImg.getWidth(), 1, filter);
                }
            }
        }
    }

    public static void convoluteRows(Image outputImg, Image inputImg, Filter filter, int method) {
        block8: for (int i = 0; i < inputImg.getWidth(); ++i) {
            switch (method) {
                case 0: {
                    DWTUtil.filterCutOff(inputImg, i, inputImg.getHeight(), inputImg.getWidth(), outputImg, i, outputImg.getHeight(), outputImg.getWidth(), filter);
                    continue block8;
                }
                case 1: {
                    DWTUtil.filterInvCutOff(inputImg, i, inputImg.getHeight(), inputImg.getWidth(), outputImg, i, outputImg.getHeight(), outputImg.getWidth(), filter);
                    continue block8;
                }
                case 2: {
                    DWTUtil.filterPeriodical(inputImg, i, inputImg.getHeight(), inputImg.getWidth(), outputImg, i, outputImg.getHeight(), outputImg.getWidth(), filter);
                    continue block8;
                }
                case 3: {
                    DWTUtil.filterInvPeriodical(inputImg, i, inputImg.getHeight(), inputImg.getWidth(), outputImg, i, outputImg.getHeight(), outputImg.getWidth(), filter);
                    continue block8;
                }
                case 4: {
                    DWTUtil.filterMirror(inputImg, i, inputImg.getHeight(), inputImg.getWidth(), outputImg, i, outputImg.getHeight(), outputImg.getWidth(), filter);
                    continue block8;
                }
                case 5: {
                    DWTUtil.filterInvMirror(inputImg, i, inputImg.getHeight(), inputImg.getWidth(), outputImg, i, outputImg.getHeight(), outputImg.getWidth(), filter);
                }
            }
        }
    }

    public static void filterCutOff(Image inputImg, int inStart, int inLen, int inStep, Image outputImg, int outStart, int outLen, int outStep, Filter filter) {
        for (int i = 0; i < outLen; ++i) {
            int fStart = Math.max(2 * i - (inLen - 1), filter.getStart());
            int fEnd = Math.min(2 * i, filter.getEnd());
            for (int j = fStart; j <= fEnd; ++j) {
                double[] dArray = outputImg.getData();
                int n = outStart + i * outStep;
                dArray[n] = dArray[n] + filter.getData()[j - filter.getStart()] * inputImg.getData()[inStart + (2 * i - j) * inStep];
            }
        }
    }

    public static void filterInvCutOff(Image inputImg, int inStart, int inLen, int inStep, Image outputImg, int outStart, int outLen, int outStep, Filter filter) {
        for (int i = 0; i < outLen; ++i) {
            int fStart = Math.max(CommonUtil.ceilingHalf(filter.getStart() + i), 0);
            int fEnd = Math.min(CommonUtil.floorHalf(filter.getEnd() + i), inLen - 1);
            for (int j = fStart; j <= fEnd; ++j) {
                double[] dArray = outputImg.getData();
                int n = outStart + i * outStep;
                dArray[n] = dArray[n] + filter.getData()[2 * j - i - filter.getStart()] * inputImg.getData()[inStart + j * inStep];
            }
        }
    }

    public static void filterPeriodical(Image inputImg, int inStart, int inLen, int inStep, Image outputImg, int outStart, int outLen, int outStep, Filter filter) {
        for (int i = 0; i < outLen; ++i) {
            int fStart = filter.getStart();
            int fEnd = filter.getEnd();
            int iStart = CommonUtil.mod(2 * i - fStart, inLen);
            for (int j = fStart; j <= fEnd; ++j) {
                double[] dArray = outputImg.getData();
                int n = outStart + i * outStep;
                dArray[n] = dArray[n] + filter.getData()[j - fStart] * inputImg.getData()[inStart + iStart * inStep];
                if (--iStart >= 0) continue;
                iStart += inLen;
            }
        }
    }

    public static void filterInvPeriodical(Image inputImg, int inStart, int inLen, int inStep, Image outputImg, int outStart, int outLen, int outStep, Filter filter) {
        for (int i = 0; i < outLen; ++i) {
            int fStart = CommonUtil.ceilingHalf(filter.getStart() + i);
            int fEnd = CommonUtil.floorHalf(filter.getEnd() + i);
            int iStart = CommonUtil.mod(fStart, inLen);
            for (int j = fStart; j <= fEnd; ++j) {
                double[] dArray = outputImg.getData();
                int n = outStart + i * outStep;
                dArray[n] = dArray[n] + filter.getData()[2 * j - i - filter.getStart()] * inputImg.getData()[inStart + iStart * inStep];
                if (++iStart < inLen) continue;
                iStart -= inLen;
            }
        }
    }

    public static void filterMirror(Image inputImg, int inStart, int inLen, int inStep, Image outputImg, int outStart, int outLen, int outStep, Filter filter) {
        for (int i = 0; i < outLen; ++i) {
            int fStart = filter.getStart();
            int fEnd = filter.getEnd();
            for (int j = fStart; j <= fEnd; ++j) {
                int inPos = 2 * i - j;
                if (inPos < 0 && (inPos = -inPos) >= inLen || inPos >= inLen && (inPos = 2 * inLen - 2 - inPos) < 0) continue;
                double[] dArray = outputImg.getData();
                int n = outStart + i * outStep;
                dArray[n] = dArray[n] + filter.getData()[j - fStart] * inputImg.getData()[inStart + inPos * inStep];
            }
        }
    }

    public static void filterInvMirror(Image inputImg, int inStart, int inLen, int inStep, Image outputImg, int outStart, int outLen, int outStep, Filter filter) {
        for (int i = 0; i < outLen; ++i) {
            int fStart = CommonUtil.ceilingHalf(filter.getStart() + i);
            int fEnd = CommonUtil.floorHalf(filter.getEnd() + i);
            for (int j = fStart; j <= fEnd; ++j) {
                int inPos = j;
                if (inPos < 0 && (inPos = filter.isHiPass() ? -inPos - 1 : -inPos) >= inLen || inPos >= inLen && (inPos = filter.isHiPass() ? 2 * inLen - 2 - inPos : 2 * inLen - 1 - inPos) < 0) continue;
                double[] dArray = outputImg.getData();
                int n = outStart + i * outStep;
                dArray[n] = dArray[n] + filter.getData()[2 * j - i - filter.getStart()] * inputImg.getData()[inStart + inPos * inStep];
            }
        }
    }

    public static Image inverseTransform(ImageTree tree, FilterGH[] filterGHList, int method) {
        if (tree.getImage() == null) {
            Image coarseImg = DWTUtil.inverseTransform(tree.getCoarse(), filterGHList, method);
            Image horizontalImg = DWTUtil.inverseTransform(tree.getHorizontal(), filterGHList, method);
            Image verticalImg = DWTUtil.inverseTransform(tree.getVertical(), filterGHList, method);
            Image diagonalImg = DWTUtil.inverseTransform(tree.getDiagonal(), filterGHList, method);
            int width = coarseImg.getWidth() + horizontalImg.getWidth();
            int height = coarseImg.getHeight() + verticalImg.getHeight();
            Image retImg = new Image(width, height);
            if (tree.getFlag() == 0) {
                DWTUtil.invDecomposition(retImg, coarseImg, horizontalImg, verticalImg, diagonalImg, filterGHList[tree.getLevel()], method);
            } else {
                DWTUtil.copyIntoImage(retImg, coarseImg, 0, 0);
                DWTUtil.copyIntoImage(retImg, horizontalImg, coarseImg.getWidth(), 0);
                DWTUtil.copyIntoImage(retImg, verticalImg, 0, coarseImg.getHeight());
                DWTUtil.copyIntoImage(retImg, diagonalImg, coarseImg.getWidth(), coarseImg.getHeight());
            }
            return retImg;
        }
        return tree.getImage();
    }

    public static void invDecomposition(Image sumImg, Image coarseImg, Image horizontalImg, Image verticalImg, Image diagonalImg, FilterGH filterGH, int method) {
        Filter filterH;
        Filter filterG;
        if (filterGH.getType() == 0) {
            filterG = filterGH.getG();
            filterH = filterGH.getH();
        } else {
            filterG = filterGH.getGi();
            filterH = filterGH.getHi();
        }
        Image tempImg = new Image(coarseImg.getWidth(), sumImg.getHeight());
        DWTUtil.convoluteRows(tempImg, coarseImg, filterH, method);
        DWTUtil.convoluteRows(tempImg, horizontalImg, filterG, method);
        DWTUtil.convoluteLines(sumImg, tempImg, filterH, method);
        tempImg = new Image(verticalImg.getWidth(), sumImg.getHeight());
        DWTUtil.convoluteRows(tempImg, verticalImg, filterH, method);
        DWTUtil.convoluteRows(tempImg, diagonalImg, filterG, method);
        DWTUtil.convoluteLines(sumImg, tempImg, filterG, method);
    }

    public static int findDeepestLevel(int width, int height) {
        int level = 0;
        int w = width;
        int h = height;
        while (w % 2 == 0 && h % 2 == 0) {
            w /= 2;
            h /= 2;
            ++level;
        }
        return level - 1;
    }

    public static void setPixel(Image image, int x, int y, double val) {
        if (image != null && x >= 0 && x < image.getWidth() && y >= 0 && y < image.getHeight()) {
            image.getData()[x + y * image.getWidth()] = val;
        }
    }

    public static double getPixel(Image image, int x, int y) {
        if (image == null || x < 0 || x >= image.getWidth() || y < 0 || y >= image.getHeight()) {
            return 0.0;
        }
        return image.getData()[x + y * image.getWidth()];
    }

    private static void copyIntoImage(Image img1, Image img2, int x, int y) {
        int count = 0;
        double[] temp = img2.getData();
        int start = img1.getWidth() * y + x;
        for (int i = 0; i < img2.getHeight(); ++i) {
            for (int j = 0; j < img2.getWidth(); ++j) {
                int aim = start + j + img1.getWidth() * i;
                img1.getData()[aim] = temp[count];
                ++count;
            }
        }
    }
}

