/*
 * Pixel Dungeon
 * Copyright (C) 2012-2015 Oleg Dolya
 *
 * Shattered Pixel Dungeon
 * Copyright (C) 2014-2025 Evan Debenham
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 */

package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;

public class Invulnerability extends FlavourBuff {

	{
		type = Buff.buffType.POSITIVE;
		announced = true;
	}

	public static final float DURATION	= 3f;

	@Override
	public void fx(boolean on) {
		if (!target.buffs(ChampionEnemy.class).isEmpty()) return;
		if (on) target.sprite.aura( 0xFFFF00, 5 );
		else target.sprite.clearAura();
	}

	@Override
	public int icon() {
		return BuffIndicator.ANKH;
	}

	@Override
	public float iconFadePercent() {
		return Math.max(0, (DURATION - visualcooldown()) / DURATION);
	}

	{
		immunities.add(Paralysis.class);
		immunities.add(Frost.class);
	}

	@Override
	public boolean attachTo(Char target) {
		if (super.attachTo(target)){
			Buff.detach(target, Paralysis.class);
			Buff.detach(target, Frost.class);
			return true;
		} else {
			return false;
		}
	}

}
