(defclass PERSON (is-a USER)
  (slot sex (access read-only)
            (create-accessor read)
            (storage shared))
  (slot age (type NUMBER)
            (create-accessor read-write)))
(defclass FEMALE (is-a PERSON)
  (slot sex (source composite)
            (default female)))
(defclass MALE (is-a PERSON)
  (slot sex (source composite)
            (default male)))
(defclass GIRL (is-a FEMALE)
  (role concrete)
  (slot age (source composite)
            (default 4)
            (range 0.0 17.9)))
(defclass WOMAN (is-a FEMALE)
  (role concrete)
  (slot age (source composite)
            (default 25)
            (range 18.0 100.0)))
(defclass BOY (is-a MALE)
  (role concrete)
  (slot age (source composite)
            (default 4)
            (range 0.0 17.9)))
(defclass MAN (is-a MALE)
  (role concrete)
  (slot age (source composite)
            (default 25)
            (range 18.0 100.0)))
(definstances PEOPLE
  (Man-1 of MAN (age 18))
  (Man-2 of MAN (age 60))
  (Woman-1 of WOMAN (age 18))
  (Woman-2 of WOMAN (age 60))
  (Woman-3 of WOMAN)
  (Boy-1 of BOY (age 8))
  (Boy-2 of BOY)
  (Boy-3 of BOY)
  (Boy-4 of BOY)
  (Girl-1 of GIRL (age 8))
  (Girl-2 of GIRL))
(deffunction count-instances (?class)
  (bind ?count 0)
  (do-for-all-instances ((?ins ?class)) TRUE
     (bind ?count (+ ?count 1)))
  ?count)
(deffunction count-instances-2 (?class)
  (length$ (find-all-instances ((?ins ?class)) TRUE)))
(defclass A (is-a USER) (role concrete))
(defclass B (is-a A) (role concrete))
(defclass C (is-a A) (role concrete))
(defclass D (is-a B C) (role concrete))
(defglobal ?*list* = (create$ V W))
(defclass V (is-a USER) (role concrete))
(defclass W (is-a USER) (role concrete))
(defclass X (is-a USER) (role concrete))
(defclass Y (is-a USER) (role concrete))
(defclass Z (is-a USER) (role concrete))
