Minutes from 10th OpenVDB TSC meeting, Mar. 7, 2019

Attendees: *Ken* M., *Nick* A., *Dan* B., *Peter* C., *Jeff* L.

Additional Attendees: Bruce Chernia (Intel), Andrew Pearce (DWA),
Thanh Ha (LF), John Mertic (LF), Daniel Elliot (Weta)

Agenda:

1) Confirmation of quorum
2) Selection of secretary
3) OpenVDB BOF @ SIGGRAPH
4) Posting questions to Forum or mailing list or ...
5) Contributing.md
6) Houdini MMB improvements for Mako Templates
7) unifying open-source and native SOPs
8) OpenVDB 6.0.0 next steps and announcement
9) CI/CMake Update *
10) VDB tools and grid member functions *
11) Documentation *
12) Source headers *
13) JIRA Improvements *
14) Other? *
15) Schedule next meeting

* This was an optimistic agenda, we only had time to discuss items 1-8 and 15.

1) A quorum was confirmed.

2) Secretary - Dan Bailey

3) OpenVDB BOF @ SIGGRAPH

The TAC has proposed a Siggraph Birds of a Feather to discuss the ASWF with a
focus on governance and migration of the first few projects. This will likely
include some of the proposed agenda for the OpenVDB course, meaning the course
content will be more focused on the project itself than the governance.

4) Posting questions to Forum or mailing list or ...

There was a post to the OpenVDB Google groups forum by a member of the
community that suggested that the forum was no longer monitored by the
maintainers. Ken previously made a post to the forum which was slightly
ambiguous and has since clarified the situation.

We need to decide the process by which people should ask questions. John is
helping OpenColorIO move from their own forum to groups.io which is the
service used to host our three ASWF mailing lists (openvdb-dev, openvdb-user,
openvdb-tsc-private). The benefits are that it would help consolidate
communication and that lots of people prefer mailing lists. The service also
offers a calendar and file storage per mailing list. China communication is
also possible because it doesn't run through a Google service that is blocked
by the firewall. John confirmed that it is possible to bring over the history
from the forum to the new mailing list, however users would need to be
migrated manually. For OpenColorIO, they are communicating that they're
closing the forum and directing the subscribed members how to sign up to the
new mailing list. This can serve as a useful way to cull out subscribed
members that are no longer interested in the forum.

John highlighted that some communities prefer differentiating developer-
related discussion to user-related discussions hence the openvdb-dev and
openvdb-user lists, but that may not be right for OpenVDB. He also mentioned
that many projects use a rotating triage person who will be responsible for
responding and forwarding emails that come into the forum or mailing list.
There was support for trying this idea.

There was a brief discussion about what to do with GitHub issues, an email
redirection could be set up or it could be shut down entirely to avoid
confusion. The project still needs clearer documentation about how to
contribute and a follow-on announcement to clarify the process to the
community. All TSC members to look at Dan's email regarding contribution.md as
a first step to improving this. A vote will be scheduled for next time about
which services to keep and which ones to discard.

5) Contributing.md

After approval from the TSC in a previous meeting, Jeff has submitted a PR to
remove the explicit 25% contribution time for committers. There was some
confusion about the distinction between committers and TSC members. John
clarified with an example that in the situation where a company might have 20
people with committer priviliges, there may be desire to have a subset of
these committers represented on the TSC so as not to increase the
representation of that company in TSC votes. That is not currently an issue
for OpenVDB.

Ken wanted a change to the wording to ensure that committers were active
developers and specifically on the project. John thought that Ken's proposed
changes were fine and that there was sufficient ability for the TSC to revoke
committer privileges for an individual that has ceased to contribute
development to the project. Unanimous vote in favour of Ken's proposed changes
to Jeff's PR.

6) Houdini MMB improvements for Mako Templates

This PR has been outstanding for some time. Dan has concerns about the code
not being tested and allowed to drift so that it was no longer functional.
Jeff thought this was the best place to document how to make changes that
could be picked up by mako templates and would discourage rewriting of this
code in the future.

It was decided that Nick would make two tweaks to his PR - to match the branch
names that Jeff has chosen for Houdini and to add a #define to disable the
code from being compiled by default unless explicitly enabled, then we approve
and merge. Dan to bump the email thread with his proposed MMB changes to the
mako templates as this was not included as part of this PR.

7) Unifying open-source and native SOPs

General discussion of the proposed change. Nick asked about using namespacing
as an alternative and Jeff explained some limitations in the namespacing
approach such as the operator type bar only being applicable for HDAs and not
for compiled SOPs. Dan explained the proposed ophide policy mechanism of using
a compile-time flag optionally overriden by a run-time environment variable.

Nick is concerned about the phases of this proposed solution, particularly
about any confusion arising from introducing the interlacing of the label
names before the ophide policy has been implemented. No objections raised to
tackling this proposal in a different order. Nick and Dan to comment further
on the PR.

8) OpenVDB 6.0.0 next steps and announcement

OpenVDB 6.0.0 has only undergone a soft release and has yet to be officially
announced. The main blocker is updating the Doxygen documentation on the
website. Discussion followed about changing the process, Thanh suggested an
approach using ReadTheDocs or GitHub Pages that might be suitable. Decision
made to proceed with this release using the current process and to table
further changes to the documentation for a later date.

15) Next Meeting

Next meeting is scheduled for March 21st, 2019, 11am-12pm PST.
