//----------------------------------------------------------------------------
//
// TSDuck - The MPEG Transport Stream Toolkit
// Copyright (c) 2005-2023, Thierry Lelegard
// BSD-2-Clause license, see LICENSE.txt file or https://tsduck.io/license
//
//----------------------------------------------------------------------------
//!
//!  @file
//!  Sources of time information for transport streams.
//!
//----------------------------------------------------------------------------

#pragma once
#include "tsEnumeration.h"

namespace ts {
    //!
    //! Sources of time information for transport streams.
    //!
    enum class TimeSource : uint8_t {
        UNDEFINED = 0,  //!< Undefined source of time information.
        HARDWARE,       //!< Hardware-generated time, any local hardware (NIC for instance).
        KERNEL,         //!< OS kernel time stamp.
        TSP,            //!< Application time stamp, generated by tsp when the chunk of TS packets is received.
        RTP,            //!< RTP (Real Time Protocol) time stamp.
        SRT,            //!< SRT (Secure Reliable Transport) source time.
        M2TS,           //!< M2TS Bluray-style time stamp.
        PCR,            //!< PCR (Program Clock Reference), the transport stream system clock.
        DTS,            //!< DTS (Decoding Time Stamp), in a video or audio stream.
        PTS,            //!< PTS (Presentation Time Stamp), in a video or audio stream.
    };

    //!
    //! Enumeration description of ts::TimeSource.
    //!
    TSDUCKDLL extern const Enumeration TimeSourceEnum;
}
