// DES with chaining modes test vectors

struct TV_SCTE52_2003 {
    uint8_t key[8];
    uint8_t iv[8];
    size_t  plain_size;
    uint8_t plain[256];
    size_t  cipher_size;
    uint8_t cipher [256];
};

static const TV_SCTE52_2003 tv_scte52_2003 [] = {
    // Test vectors from http://www.scte.org/documents/pdf/Standards/ANSI_SCTE%2052%202008.pdf
    {
        {0xAB, 0xCD, 0xEF, 0x01, 0x23, 0x45, 0x67, 0x89},
        {0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF},
        24,
        {0xDE, 0x7A, 0x43, 0x63, 0xBA, 0x55, 0x5C, 0x20,
         0xFD, 0x78, 0x9E, 0x2A, 0x88, 0x24, 0x77, 0xE7,
         0x18, 0xB6, 0x43, 0x38, 0x6C, 0x60, 0xC3, 0x89},
        24,
        {0x95, 0x69, 0x1A, 0xB2, 0x7D, 0x89, 0x55, 0x54,
         0x3F, 0xEE, 0x8E, 0xAE, 0x7F, 0x93, 0x01, 0x27,
         0x3B, 0x08, 0xDF, 0xF0, 0x20, 0x21, 0x4F, 0x23},
    },
    {
        {0xAB, 0xCD, 0xEF, 0x01, 0x23, 0x45, 0x67, 0x89},
        {0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF},
        19,
        {0xDE, 0x7A, 0x43, 0x63, 0xBA, 0x55, 0x5C, 0x20,
         0xFD, 0x78, 0x9E, 0x2A, 0x88, 0x24, 0x77, 0xE7,
         0x18, 0xB6, 0x43},
        19,
        {0x95, 0x69, 0x1A, 0xB2, 0x7D, 0x89, 0x55, 0x54,
         0x3F, 0xEE, 0x8E, 0xAE, 0x7F, 0x93, 0x01, 0x27,
         0x48, 0xE9, 0xEF},
    },
};

struct TV_SCTE52_2008 {
    uint8_t key[8];
    uint8_t iv[8];
    uint8_t short_iv[8];
    size_t  plain_size;
    uint8_t plain[256];
    size_t  cipher_size;
    uint8_t cipher [256];
};

static const TV_SCTE52_2008 tv_scte52_2008 [] = {
    // Test vectors from http://www.scte.org/documents/pdf/Standards/ANSI_SCTE%2052%202008.pdf
    {
        {0xAB, 0xCD, 0xEF, 0x01, 0x23, 0x45, 0x67, 0x89},
        {0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF},
        {0xFE, 0xDC, 0xBA, 0x98, 0x76, 0x54, 0x32, 0x10},
        24,
        {0xDE, 0x7A, 0x43, 0x63, 0xBA, 0x55, 0x5C, 0x20,
         0xFD, 0x78, 0x9E, 0x2A, 0x88, 0x24, 0x77, 0xE7,
         0x18, 0xB6, 0x43, 0x38, 0x6C, 0x60, 0xC3, 0x89},
        24,
        {0x95, 0x69, 0x1A, 0xB2, 0x7D, 0x89, 0x55, 0x54,
         0x3F, 0xEE, 0x8E, 0xAE, 0x7F, 0x93, 0x01, 0x27,
         0x3B, 0x08, 0xDF, 0xF0, 0x20, 0x21, 0x4F, 0x23},
    },
    {
        {0xAB, 0xCD, 0xEF, 0x01, 0x23, 0x45, 0x67, 0x89},
        {0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF},
        {0xFE, 0xDC, 0xBA, 0x98, 0x76, 0x54, 0x32, 0x10},
        19,
        {0xDE, 0x7A, 0x43, 0x63, 0xBA, 0x55, 0x5C, 0x20,
         0xFD, 0x78, 0x9E, 0x2A, 0x88, 0x24, 0x77, 0xE7,
         0x18, 0xB6, 0x43},
        19,
        {0x95, 0x69, 0x1A, 0xB2, 0x7D, 0x89, 0x55, 0x54,
         0x3F, 0xEE, 0x8E, 0xAE, 0x7F, 0x93, 0x01, 0x27,
         0x48, 0xE9, 0xEF},
    },
    {
        {0xAB, 0xCD, 0xEF, 0x01, 0x23, 0x45, 0x67, 0x89},
        {0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF},
        {0xFE, 0xDC, 0xBA, 0x98, 0x76, 0x54, 0x32, 0x10},
        5,
        {0xDE, 0x7A, 0x43, 0x63, 0xBA},
        5,
        {0xF0, 0xDE, 0x78, 0xBF, 0xDE},
    },
};
