/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.compression;

import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.compression.Compression;

public class ZlibCompression
implements Compression {
    private static final int BUF_SIZE = 4096;
    private final byte[] tempBuf = new byte[4096];
    private Deflater deflater;
    private Inflater inflater;

    @Override
    public void init(Compression.Mode mode) {
        switch (mode) {
            case DEFLATE: {
                this.deflater = new Deflater(-1);
                break;
            }
            case INFLATE: {
                this.inflater = new Inflater();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public boolean isDelayed() {
        return false;
    }

    @Override
    public void compress(Buffer buffer) {
        int len;
        this.deflater.setInput(buffer.array(), buffer.rpos(), buffer.available());
        buffer.wpos(buffer.rpos());
        while ((len = this.deflater.deflate(this.tempBuf, 0, 4096, 2)) > 0) {
            buffer.putRawBytes(this.tempBuf, 0, len);
        }
    }

    @Override
    public void uncompress(Buffer from, Buffer to) throws TransportException {
        this.inflater.setInput(from.array(), from.rpos(), from.available());
        try {
            int len;
            while ((len = this.inflater.inflate(this.tempBuf, 0, 4096)) > 0) {
                to.putRawBytes(this.tempBuf, 0, len);
            }
            return;
        }
        catch (DataFormatException e) {
            throw new TransportException(DisconnectReason.COMPRESSION_ERROR, "uncompress: inflate returned " + e.getMessage());
        }
    }

    public static class Factory
    implements Factory.Named<Compression> {
        @Override
        public Compression create() {
            return new ZlibCompression();
        }

        @Override
        public String getName() {
            return "zlib";
        }
    }
}

