// -*- c++ -*-

/*
 *  Author: Arvin Schnell
 */


#ifndef Analyser_h
#define Analyser_h


#ifdef HAVE_FFTW
#  include <drfftw.h>
#else
#  include "fft.h"
#endif

#include "Sample.h"


class Analyser
{

public:

    Analyser ();

    enum { MONO, LEFT, RIGHT };

    bool realize (Display*, Window);
    bool destroy ();
    bool isrealized () const { return realized; }

    void resize (bool);

    bool shot (const int32_t*, int, bool);

    void draw (XRectangle, bool = true);

    void clear (bool);

    void set_alpha (double);
    void set_decay (double);
    void set_search (bool);
    void set_marker (short);

private:

    Display* display;
    Window window;

    double alpha;
    double decay;
    bool search;
    unsigned short marker[2];
    bool logfreq;

    bool realized;

    void drawpeaktext (bool);
    void drawpeakmarker ();

    void peaksearch (bool);

    void drawgrid (bool);

    void envelope ();

    void snd2u (const int32_t*, int);

    void analyse (const int32_t*, int);

    unsigned int width, height;

    GC gc;

    int font_width, font_height;

    /*
      we have three coordinate systems on the x-axis
      1. frequency (f) from 0 to sample.rate / 2
      2. frequency-channel (fc) from 0 to num_fft - 1
      3. screen-x (sx) from 0 to window.width - 1
    */

    unsigned short sx2fc (unsigned short) const;
    unsigned short fc2sx (unsigned short) const;

    unsigned short f2fc (double) const;
    double fc2f (unsigned short) const;

    unsigned short f2sx (double) const;	// handy shortcut
    double sx2f (unsigned short) const;	// handy shortcut

    int* xfoo;		// tables used to transform sx and fc
    int* xbarfoo;
    void calcfoo ();

    /*
      we have two coordinate systems on the x-axis
      1. dB (db) from lower to upper
      2. screen-y (sy) from 0 to window.height - 1
    */

    unsigned short db2sy (double) const;

    unsigned int num_fft;	// number of frequency-channels

#ifdef HAVE_FFTW
    fftw_real* value_u;		// u-values of current cycle [sample.length]
    fftw_real* value_tmp;	// [sample.length]
    rfftw_plan plan;
#else
    double* value_u;		// u-values of current cycle [sample.length]
#endif

    double* value_db;		// dB-values of current cycle [num_fft]

    short* value_y;		// y of current cycle [num_fft]
    short* value_y_old;		// y of last cycle [num_fft]

    double* value_e;		// values for envelope [sample.length]

    double peak_f, peak_db;
    int peak_count;

    short peak_sx, peak_sy;	// position on screen, used and set in peaktext()
    char peak_text[10];

};


#endif
