

/*
 *  Author: Arvin Schnell
 */


#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <iostream>

using std::cerr;

#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/AtomMgr.h>
#include <Xm/Protocols.h>

#include "Sample.h"
#include "main.h"
#include "control.h"
#include "utils.h"
#include "config.h"

#include "xanalyser.xpm"
#include "xscope.xpm"


const char* program_name;

Widget shell, toplevel;
XtAppContext app_context;

Pixmap a_iconpixmap, a_iconmask;
Pixmap s_iconpixmap, s_iconmask;

Atom wm_delete_window;


// Xresources

XAnalyser xanalyser;

XtResource resources[] = {

    { "samplerate", "SampleRate", XtRInt, sizeof (int),
      XtOffsetOf (XAnalyser, sample_rate), XtRImmediate, (XtPointer) 44100 },
    { "samplelength", "SampleLength", XtRInt, sizeof (int),
      XtOffsetOf (XAnalyser, sample_length), XtRImmediate, (XtPointer) 2048 },
    { "sampleresolution", "SampleResolution", XtRInt, sizeof (int),
      XtOffsetOf (XAnalyser, sample_resolution), XtRImmediate, (XtPointer) 16 },
    { "sampledevice", "SampleDevice", XtRString, sizeof (String),
      XtOffsetOf (XAnalyser, sample_device), XtRString, (XtPointer) "default" },
    { "dcadjust", "DCAdjust", XtRBoolean, sizeof (Boolean),
      XtOffsetOf (XAnalyser, dcadjust), XtRImmediate, (XtPointer) True },
    { "source", "Source", XtRString, sizeof (String),
      XtOffsetOf (XAnalyser, source), XtRString, (XtPointer) "Soundcard" },
    { "filename", "Filename", XtRString, sizeof (String),
      XtOffsetOf (XAnalyser, filename), XtRString, (XtPointer) "test.cdr" },
    { "upperdb", "UpperDB", XtRFloat, sizeof (float),
      XtOffsetOf (XAnalyser, upper_db), XtRString, (XtPointer) "+10.0" },
    { "lowerdb", "LowerDB", XtRFloat, sizeof (float),
      XtOffsetOf (XAnalyser, lower_db), XtRString, (XtPointer) "-100.0" },
    { "alpha", "Alpha", XtRFloat, sizeof (float),
      XtOffsetOf (XAnalyser, alpha), XtRString, (XtPointer) "20.0" },
    { "decay", "Decay", XtRFloat, sizeof (float),
      XtOffsetOf (XAnalyser, decay), XtRString, (XtPointer) "48.0" },
    { "stereo", "Stereo", XtRBoolean, sizeof (Boolean),
      XtOffsetOf (XAnalyser, stereo), XtRImmediate, (XtPointer) True },

    { "zoom", "Zoom", XtRFloat, sizeof (float),
      XtOffsetOf (XAnalyser, zoom), XtRString, (XtPointer) "6.0" },

    { "datacolor", "DataColor", XtRPixel, sizeof (Pixel),
      XtOffsetOf (XAnalyser, datacolor), XtRString, (XtPointer) "firebrick1" },
    { "backgroundcolor", "BackgroundColor", XtRPixel, sizeof (Pixel),
      XtOffsetOf (XAnalyser, backgroundcolor), XtRString, (XtPointer) "gray20" },
    { "markercolor", "MarkerColor", XtRPixel, sizeof (Pixel),
      XtOffsetOf (XAnalyser, markercolor), XtRString, (XtPointer) "yellow" },
    { "majorgridcolor", "MajorGridColor", XtRPixel, sizeof (Pixel),
      XtOffsetOf (XAnalyser, majorgridcolor), XtRString, (XtPointer) "gray60" },
    { "minorgridcolor", "MinorGridColor", XtRPixel, sizeof (Pixel),
      XtOffsetOf (XAnalyser, minorgridcolor), XtRString, (XtPointer) "gray40" },
    { "gridfont", "GridFont", XtRFontStruct, sizeof (XFontStruct*),
      XtOffsetOf (XAnalyser, gridfont), XtRString, (XtPointer) "fixed" }

};


XrmOptionDescRec cmdline_options[] = {
    { "-rate", ".samplerate", XrmoptionSepArg, "" },
    { "-length", ".samplelength", XrmoptionSepArg, "" },
    { "-resolution", ".sampleresolution", XrmoptionSepArg, "" },
    { "-device", ".sampledevice", XrmoptionSepArg, "" },
    { "-mono", ".stereo", XrmoptionNoArg, "False" },
    { "-stereo", ".stereo", XrmoptionNoArg, "True" },
    { "-soundcard", ".source", XrmoptionNoArg, "Soundcard" },
    { "-diskfile", ".source", XrmoptionNoArg, "Diskfile" },
    { "-filename", ".filename", XrmoptionSepArg, "" },
    { "-dcadjust", ".dcadjust", XrmoptionSepArg, "" }
};


String fallbacks[] = {
#include "XAnalyser.ad.h"
    0
};


void usage () __attribute__ ((__noreturn__));
void
usage ()
{
    cerr << "usage: " << program_name << " [-rate rate] [-length length] "
	"[-resolution resolution] [-device device] [-dcadjust bool] "
	"[-soundcard] [-diskfile] [-file file]\n";

    exit (EXIT_FAILURE);
}


int
main (int argc, char* argv[])
{
    program_name = argv[0];

    shell = XtAppInitialize (&app_context, "XAnalyser",
			     cmdline_options, XtNumber (cmdline_options),
			     &argc, argv, fallbacks, 0, 0);

    if (argc != 1)
	usage ();

    XtGetApplicationResources (shell, (XtPointer) &xanalyser,
			       resources, XtNumber (resources), 0, 0);

    toplevel = XmCreateMainWindow (shell, "MainWindow", 0, 0);
    XtManageChild (toplevel);

    control_create ();

    XtRealizeWidget (shell);

    wm_delete_window = XmInternAtom (XtDisplay (toplevel),
				     "WM_DELETE_WINDOW", False);

    XmAddWMProtocolCallback (shell, wm_delete_window, control_close, 0);

    // icon

    Display* display = XtDisplay (shell);

    XpmCreatePixmapFromData (display, XtWindow (shell),
			     xanalyser_xpm, &a_iconpixmap, &a_iconmask, 0);

    XpmCreatePixmapFromData (display, XtWindow (shell),
			     xscope_xpm, &s_iconpixmap, &s_iconmask, 0);

    // FIXME: under high cpu/X11 load the icon does not appear
    // usleep( 500 );  // works (sometimes), but I don't like it

    XtVaSetValues (shell, XtNiconPixmap, a_iconpixmap, XtNiconMask,
		   a_iconmask, (char*) NULL);

    if (strcasecmp (xanalyser.source, "Soundcard") == 0)
	sample.source = Sample::SOUNDCARD;
    else
	sample.source = Sample::DISKFILE;

    sample.filename = xanalyser.filename;
    sample.rate = xanalyser.sample_rate;
    sample.length = xanalyser.sample_length;
    sample.resolution = xanalyser.sample_resolution;
    sample.device = xanalyser.sample_device;

    control_set_default ();

    analyser_manage ();
    scope_manage ();

    set_sensitivity ();

    XtAppMainLoop (app_context);
}
