// -*- c++ -*-

/*
 *  Author: Arvin Schnell
 */


#ifndef pcm_alsa_h
#define pcm_alsa_h


#define ALSA_PCM_OLD_HW_PARAMS_API
#define ALSA_PCM_OLD_SW_PARAMS_API

#include <alsa/asoundlib.h>

#include "pcm.h"


class PCMALSA : public PCM
{

public:

    PCMALSA (const char* name, pcm_type_t type, pcm_mode_t mode,
	     pcm_format_t format, int channels, int rate, int buffer_size);
    ~PCMALSA ();

    void info () const;
    size_t size ();
    off_t seek (off_t offset, int whence);
    size_t read (void* buffer, size_t frames);
    size_t write (void* buffer, size_t frames);

private:

    snd_pcm_t* handle;

};


#endif
