acopw(1)

# NAME

acopw - generate cryptographically secure random passwords

# SYNOPSIS

*acopw* [*-h*|*--help*] [*-v*|*--version*]++
*acopw random* [*-l* _length_] [*-n*] [*-u*] [*-L*] [*-s*] [*-e* _char_]...++
*acopw diceware* [*-l* _length_] [*-s* _separator_] [*-c*]++
*acopw pin* [*-l* _length_]

# DESCRIPTION

*acopw* is an easy-to-use command line utility for generating cryptographically
secure random passwords, diceware passwords, and PINs. It uses a simple
generation algorithm, a ChaCha8 stream cipher, and Go's built-in random number
generator to ensure the highest level of randomness, security, and performance.

# GLOBAL OPTIONS

*-h*, *--help*
	Show help message and quit.

*-v*, *--version*
	Show version number and quit.

# COMMANDS

*r*, *random* [OPTIONS]
	Generate a random password with optional character set restrictions.

	Options are:

	*-l*, *--length=NUM*
		Sets the length of the password. Default is 128.

	*-n*, *--numbers*
		Whether to include numbers in the password. Defaults to true if no
		options are given.

	*-s*, *--symbols*
		Whether to include symbols in the password. Defaults to true if no
		options are given.

	*-u*, *--uppercase*
		Whether to include uppercase letters in the password. Defaults to true
		if no options are given.

	*-L*, *--lowercase*
		Whether to include lowercase letters in the password. Defaults to true
		if no options are given.

	*-e*, *--exclude=CHAR*
		Excludes a specific character from the generated password. Repeat to
		exclude more characters.

*d*, *diceware* [OPTIONS]
	Generate a diceware password, also known as a passphrase.

	Options are:

	*-l*, *--length=NUM*
		Sets the number of words to generate. Default is 8.

	*-s*, *--separator=STRING*
		Sets the separator between words. Default is a space.

	*-c*, *--capitalized*
		Whether to capitalize a random word in the password. Default is true.

*p*, *pin* [OPTIONS]
	Generate a numeric PIN.

	Options are:

	*-l*, *--length=NUM*
		Sets the length of the PIN. Default is 6.

# EXAMPLES

*Example 1. Generate a random password of length 24:*
	$ acopw random -l 24

*Example 2. Generate a random password but exclude certain characters:*
	$ acopw random -e '@' -e '#'

*Example 3. Generate a random password without symbols:*
	$ acopw random -n -u -L

*Example 4. Generate a diceware password with 12 words:*
	$ acopw diceware -l 12

*Example 5. Generate a diceware password with a custom separator:*
	$ acopw diceware -s '-'

*Example 6. Generate a PIN of length 4:*
	$ acopw pin -l 4

# AUTHORS

Maintained by James Pond <james@cipher.host>.
