package app

import (
	"fmt"
	"os"

	"git.sr.ht/~jamesponddotco/acopw-go"
	"github.com/urfave/cli/v2"
	"golang.org/x/term"
)

// DicewareAction is the action for the diceware command.
func DicewareAction(c *cli.Context) error {
	generator := &acopw.Diceware{
		Length:     int(c.Uint("length")),
		Separator:  c.String("separator"),
		Capitalize: c.Bool("capitalized"),
	}

	var (
		password   = generator.Generate()
		isTerminal = term.IsTerminal(int(os.Stdout.Fd()))
	)

	if isTerminal {
		if _, err := fmt.Fprintln(c.App.Writer, password); err != nil {
			return fmt.Errorf("%w", err)
		}

		return nil
	}

	if _, err := fmt.Fprint(c.App.Writer, password); err != nil {
		return fmt.Errorf("%w", err)
	}

	return nil
}
