;
;        file       : torcs.nsi
;        created    : Wed Feb 2 15:35:10 CET 2005
;        copyright  : (C) 2005-2025 Bernhard Wymann
;        email      : berniw@bluewin.ch
;
;        This program is free software; you can redistribute it and/or modify
;        it under the terms of the GNU General Public License as published by
;        the Free Software Foundation; either version 2 of the License, or
;        (at your option) any later version.

; HM NIS Edit Wizard helper defines

!define VER_MAJOR 1
!define VER_MINOR 3
!define VER_REVISION 8
!define VER_EXTRA
!define VER_RELDATE 20250426

!define PRODUCT_NAME "TORCS - The Open Racing Car Simulator"
!define PRODUCT_VERSION "${VER_MAJOR}.${VER_MINOR}.${VER_REVISION}${VER_EXTRA}"
!define PRODUCT_PUBLISHER "The TORCS Team"
!define PRODUCT_WEB_SITE "http://www.torcs.org"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\wtorcs.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
;!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
;!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"
!define MUI_ICON "base\Ticon.ico"
!define MUI_UNICON "base\Ticon.ico"

; Welcome page
!define MUI_WELCOMEPAGE_TITLE_3LINES
!insertmacro MUI_PAGE_WELCOME
; License page
!define MUI_LICENSEPAGE_CHECKBOX
!insertmacro MUI_PAGE_LICENSE "base\COPYING"

; Old version installed page
Page custom PageReinstall PageLeaveReinstall

; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\wtorcs.exe"
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\readme.txt"
!define MUI_FINISHPAGE_TITLE_3LINES
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

;--------------------------------
;Reserve Files

  ;These files should be inserted before other files in the data block

  ReserveFile "torcs.ini"
  !insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "torcs_${PRODUCT_VERSION}_setup.exe"
InstallDir "$PROGRAMFILES\torcs"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Section "Base System" SEC01
  SectionIn RO
  SetOverwrite try
  
  SetOutPath "$INSTDIR\cars\155-DTM"
  File "base\cars\155-DTM\155-DTM-lod1.acc"
  File "base\cars\155-DTM\155-DTM-lod2.acc"
  File "base\cars\155-DTM\155-DTM.acc"
  File "base\cars\155-DTM\155-DTM.rgb"
  File "base\cars\155-DTM\155-DTM.xml"
  File "base\cars\155-DTM\readme.txt"
  File "base\cars\155-DTM\shadow.rgb"
  File "base\cars\155-DTM\tex-wheel.rgb"
  
  SetOutPath "$INSTDIR\cars\acura-nsx-sz"
  File "base\cars\acura-nsx-sz\acura-nsx-sz-lod1.acc"
  File "base\cars\acura-nsx-sz\acura-nsx-sz-lod2.acc"
  File "base\cars\acura-nsx-sz\acura-nsx-sz.acc"
  File "base\cars\acura-nsx-sz\acura-nsx-sz.rgb"
  File "base\cars\acura-nsx-sz\acura-nsx-sz.xml"
  File "base\cars\acura-nsx-sz\readme.txt"
  File "base\cars\acura-nsx-sz\shadow.rgb"
  File "base\cars\acura-nsx-sz\tex-wheel.rgb"

  SetOutPath "$INSTDIR\cars\baja-bug"
  File "base\cars\baja-bug\baja-bug-lod1.acc"
  File "base\cars\baja-bug\baja-bug-lod2.acc"
  File "base\cars\baja-bug\baja-bug.acc"
  File "base\cars\baja-bug\baja-bug.rgb"
  File "base\cars\baja-bug\baja-bug.xml"
  File "base\cars\baja-bug\readme.txt"
  File "base\cars\baja-bug\shadow.rgb"
  File "base\cars\baja-bug\tex-wheel.rgb"

  SetOutPath "$INSTDIR\cars\buggy"
  File "base\cars\buggy\buggy-lod1.acc"
  File "base\cars\buggy\buggy-lod2.acc"
  File "base\cars\buggy\buggy.acc"
  File "base\cars\buggy\buggy.rgb"
  File "base\cars\buggy\buggy.xml"
  File "base\cars\buggy\shadow.rgb"
  File "base\cars\buggy\tex-wheel.rgb"

  SetOutPath "$INSTDIR\cars\car1-trb1"
  File "base\cars\car1-trb1\car1-trb1.acc"
  File "base\cars\car1-trb1\car1-trb1.rgb"
  File "base\cars\car1-trb1\car1-trb1.xml"
  File "base\cars\car1-trb1\readme.txt"
  File "base\cars\car1-trb1\shadow.rgb"
  File "base\cars\car1-trb1\tex-wheel.rgb"

  SetOutPath "$INSTDIR\cars\car1-trb3"
  File "base\cars\car1-trb3\car1-trb3-lod1.acc"
  File "base\cars\car1-trb3\car1-trb3-lod2.acc"
  File "base\cars\car1-trb3\car1-trb3.acc"
  File "base\cars\car1-trb3\car1-trb3.rgb"
  File "base\cars\car1-trb3\car1-trb3.xml"
  File "base\cars\car1-trb3\readme.txt"
  File "base\cars\car1-trb3\shadow.rgb"
  File "base\cars\car1-trb3\tex-wheel.rgb"

  SetOutPath "$INSTDIR\cars\car2-trb1"
  File "base\cars\car2-trb1\car2-trb1.acc"
  File "base\cars\car2-trb1\car2-trb1.rgb"
  File "base\cars\car2-trb1\car2-trb1.xml"
  File "base\cars\car2-trb1\readme.txt"
  File "base\cars\car2-trb1\shadow.rgb"
  File "base\cars\car2-trb1\tex-wheel.rgb"

  SetOutPath "$INSTDIR\cars\car3-trb1"
  File "base\cars\car3-trb1\car3-trb1.acc"
  File "base\cars\car3-trb1\car3-trb1.rgb"
  File "base\cars\car3-trb1\car3-trb1.xml"
  File "base\cars\car3-trb1\readme.txt"
  File "base\cars\car3-trb1\shadow.rgb"
  File "base\cars\car3-trb1\tex-wheel.rgb"

  SetOutPath "$INSTDIR\cars\car4-trb1"
  File "base\cars\car4-trb1\car4-trb1.acc"
  File "base\cars\car4-trb1\car4-trb1.rgb"
  File "base\cars\car4-trb1\car4-trb1.xml"
  File "base\cars\car4-trb1\readme.txt"
  File "base\cars\car4-trb1\shadow.rgb"
  File "base\cars\car4-trb1\tex-wheel.rgb"

  SetOutPath "$INSTDIR\cars\car5-trb1"
  File "base\cars\car5-trb1\car5-trb1.acc"
  File "base\cars\car5-trb1\car5-trb1.rgb"
  File "base\cars\car5-trb1\car5-trb1.xml"
  File "base\cars\car5-trb1\driver.rgb"
  File "base\cars\car5-trb1\readme.txt"
  File "base\cars\car5-trb1\shadow.rgb"
  File "base\cars\car5-trb1\tex-wheel.rgb"

  SetOutPath "$INSTDIR\cars\car6-trb1"
  File "base\cars\car6-trb1\car6-trb1.acc"
  File "base\cars\car6-trb1\car6-trb1.rgb"
  File "base\cars\car6-trb1\car6-trb1.xml"
  File "base\cars\car6-trb1\driver.rgb"
  File "base\cars\car6-trb1\readme.txt"
  File "base\cars\car6-trb1\shadow.rgb"
  File "base\cars\car6-trb1\tex-wheel.rgb"

  SetOutPath "$INSTDIR\cars\car7-trb1"
  File "base\cars\car7-trb1\car7-trb1.acc"
  File "base\cars\car7-trb1\car7-trb1.rgb"
  File "base\cars\car7-trb1\car7-trb1.xml"
  File "base\cars\car7-trb1\driver.rgb"
  File "base\cars\car7-trb1\readme.txt"
  File "base\cars\car7-trb1\shadow.rgb"
  File "base\cars\car7-trb1\tex-wheel.rgb"
  
  SetOutPath "$INSTDIR\cars\car8-trb1"
  File "base\cars\car8-trb1\car8-trb1.acc"
  File "base\cars\car8-trb1\car8-trb1.rgb"
  File "base\cars\car8-trb1\car8-trb1.xml"
  File "base\cars\car8-trb1\driver.rgb"
  File "base\cars\car8-trb1\readme.txt"
  File "base\cars\car8-trb1\shadow.rgb"
  File "base\cars\car8-trb1\tex-wheel.rgb"

  SetOutPath "$INSTDIR\cars\p406"
  File "base\cars\p406\p406-lod1.acc"
  File "base\cars\p406\p406-lod2.acc"
  File "base\cars\p406\p406-lod3.acc"
  File "base\cars\p406\p406-lod4.acc"
  File "base\cars\p406\p406-lod5.acc"
  File "base\cars\p406\p406-lod6.acc"
  File "base\cars\p406\p406-lod7.acc"
  File "base\cars\p406\p406.acc"
  File "base\cars\p406\p406.rgb"
  File "base\cars\p406\p406.xml"
  File "base\cars\p406\shadow.rgb"
  File "base\cars\p406\tex-wheel.rgb"

  SetOutPath "$INSTDIR\cars\car1-ow1"
  File "base\cars\car1-ow1\car1-ow1.acc"
  File "base\cars\car1-ow1\car1-ow1.rgb"
  File "base\cars\car1-ow1\car1-ow1.xml"
  File "base\cars\car1-ow1\readme.txt"
  File "base\cars\car1-ow1\shadow.rgb"
  File "base\cars\car1-ow1\tex-wheel.rgb"

  SetOutPath "$INSTDIR\cars\car1-stock1"
  File "base\cars\car1-stock1\car1-stock1.acc"
  File "base\cars\car1-stock1\car1-stock1.rgb"
  File "base\cars\car1-stock1\car1-stock1.xml"
  File "base\cars\car1-stock1\readme.txt"
  File "base\cars\car1-stock1\shadow.rgb"
  File "base\cars\car1-stock1\tex-wheel.rgb"
  File "base\cars\car1-stock1\carbon-128.rgb"
  File "base\cars\car1-stock1\driver.rgb"
  File "base\cars\car1-stock1\grill.rgb"

  SetOutPath "$INSTDIR\cars\car1-stock2"
  File "base\cars\car1-stock2\car1-stock2.acc"
  File "base\cars\car1-stock2\car1-stock2.rgb"
  File "base\cars\car1-stock2\car1-stock2.xml"
  File "base\cars\car1-stock2\readme.txt"
  File "base\cars\car1-stock2\shadow.rgb"
  File "base\cars\car1-stock2\tex-wheel.rgb"
  File "base\cars\car1-stock2\carbon-128.rgb"
  File "base\cars\car1-stock2\driver.rgb"

SetOutPath "$INSTDIR\categories"
  File "base\categories\ow1.xml"
  File "base\categories\trb1.xml"
  File "base\categories\trb3.xml"
  File "base\categories\stock1.xml"
  File "base\categories\stock2.xml"
  File "base\categories\free.xml"
  File "base\categories\Historic.xml"
  File "base\categories\Offroad-4WD-GrA.xml"
  File "base\categories\Offroad-RWD-GrA.xml"
  File "base\categories\Track-4WD-GrB.xml"
  File "base\categories\Track-FWD-GrA.xml"
  File "base\categories\Track-FWD-GrB.xml"
  File "base\categories\Track-RWD-GrA.xml"
  File "base\categories\Track-RWD-GrB.xml"
  File "base\categories\Track-RWD-GrC.xml"
  
  SetOutPath "$INSTDIR\wheels\openwheel1-1"
  File "base\wheels\openwheel1-1\readme.txt"
  File "base\wheels\openwheel1-1\wheel0.acc"
  File "base\wheels\openwheel1-1\wheel1.acc"
  File "base\wheels\openwheel1-1\wheel2.acc"
  File "base\wheels\openwheel1-1\wheel3.acc"
  File "base\wheels\openwheel1-1\wheel3d.png"

  SetOutPath "$INSTDIR\wheels\trb1-1"
  File "base\wheels\trb1-1\readme.txt"
  File "base\wheels\trb1-1\wheel0.acc"
  File "base\wheels\trb1-1\wheel1.acc"
  File "base\wheels\trb1-1\wheel2.acc"
  File "base\wheels\trb1-1\wheel3.acc"
  File "base\wheels\trb1-1\wheel3d.png"

  SetOutPath "$INSTDIR\wheels\trb1-2"
  File "base\wheels\trb1-2\readme.txt"
  File "base\wheels\trb1-2\wheel0.acc"
  File "base\wheels\trb1-2\wheel1.acc"
  File "base\wheels\trb1-2\wheel2.acc"
  File "base\wheels\trb1-2\wheel3.acc"
  File "base\wheels\trb1-2\wheel3d.png"

  SetOutPath "$INSTDIR\wheels\trb1-3"
  File "base\wheels\trb1-3\readme.txt"
  File "base\wheels\trb1-3\wheel0.acc"
  File "base\wheels\trb1-3\wheel1.acc"
  File "base\wheels\trb1-3\wheel2.acc"
  File "base\wheels\trb1-3\wheel3.acc"
  File "base\wheels\trb1-3\wheel3d.png"

  SetOutPath "$INSTDIR\wheels\trb1-4"
  File "base\wheels\trb1-4\readme.txt"
  File "base\wheels\trb1-4\wheel0.acc"
  File "base\wheels\trb1-4\wheel1.acc"
  File "base\wheels\trb1-4\wheel2.acc"
  File "base\wheels\trb1-4\wheel3.acc"
  File "base\wheels\trb1-4\wheel3d.png"

  SetOutPath "$INSTDIR\wheels\trb1-5"
  File "base\wheels\trb1-5\readme.txt"
  File "base\wheels\trb1-5\wheel0.acc"
  File "base\wheels\trb1-5\wheel1.acc"
  File "base\wheels\trb1-5\wheel2.acc"
  File "base\wheels\trb1-5\wheel3.acc"
  File "base\wheels\trb1-5\wheel3d.png"

  SetOutPath "$INSTDIR\wheels\trb1-6"
  File "base\wheels\trb1-6\readme.txt"
  File "base\wheels\trb1-6\wheel0.acc"
  File "base\wheels\trb1-6\wheel1.acc"
  File "base\wheels\trb1-6\wheel2.acc"
  File "base\wheels\trb1-6\wheel3.acc"
  File "base\wheels\trb1-6\wheel3d.png"

  SetOutPath "$INSTDIR\wheels\stock1-1"
  File "base\wheels\stock1-1\readme.txt"
  File "base\wheels\stock1-1\wheel0.acc"
  File "base\wheels\stock1-1\wheel1.acc"
  File "base\wheels\stock1-1\wheel2.acc"
  File "base\wheels\stock1-1\wheel3.acc"
  File "base\wheels\stock1-1\wheel3d.png"

  SetOutPath "$INSTDIR\wheels\stock1-2"
  File "base\wheels\stock1-2\readme.txt"
  File "base\wheels\stock1-2\wheel0.acc"
  File "base\wheels\stock1-2\wheel1.acc"
  File "base\wheels\stock1-2\wheel2.acc"
  File "base\wheels\stock1-2\wheel3.acc"
  File "base\wheels\stock1-2\wheel3d.png"

SetOutPath "$INSTDIR\wheels\stock1-3"
  File "base\wheels\stock1-3\readme.txt"
  File "base\wheels\stock1-3\wheel0.acc"
  File "base\wheels\stock1-3\wheel1.acc"
  File "base\wheels\stock1-3\wheel2.acc"
  File "base\wheels\stock1-3\wheel3.acc"
  File "base\wheels\stock1-3\wheel3d.png"

SetOutPath "$INSTDIR\data\music"
  File "base\data\music\torcs1.ogg"
  
  SetOutPath "$INSTDIR"
  File "base\client.dll"
  File /oname=readme.txt readme_for_user.txt

  SetOutPath "$INSTDIR\config"
  File "base\config\graph.xml"
  File "base\config\params.dtd"
  File "base\config\raceengine.xml"

  SetOutPath "$INSTDIR\config\raceman"
  File "base\config\raceman\champ.xml"
  File "base\config\raceman\dtmrace.xml"
  File "base\config\raceman\endrace.xml"
  File "base\config\raceman\ncrace.xml"
  File "base\config\raceman\practice.xml"
  File "base\config\raceman\quickrace.xml"

  SetOutPath "$INSTDIR\config"
  File "base\config\screen.xml"
  File "base\config\sound.xml"
  File "base\config\style.xsl"

  SetOutPath "$INSTDIR"
  File "base\COPYING"
  SetOutPath "$INSTDIR\data\fonts"
  File "base\data\fonts\b5.glf"
  File "base\data\fonts\b6.glf"
  File "base\data\fonts\b7.glf"
  File "base\data\fonts\digital.glf"
  File "base\data\fonts\fragile.glf"

  SetOutPath "$INSTDIR\data\img"
  File "base\data\img\arrow-down-pushed.png"
  File "base\data\img\arrow-down.png"
  File "base\data\img\arrow-left-pushed.png"
  File "base\data\img\arrow-left.png"
  File "base\data\img\arrow-right-pushed.png"
  File "base\data\img\arrow-right.png"
  File "base\data\img\arrow-up-pushed.png"
  File "base\data\img\arrow-up.png"
  File "base\data\img\ruler-pushed.png"
  File "base\data\img\ruler.png"
  File "base\data\img\splash-dtm.png"
  File "base\data\img\splash-dtmstart.png"
  File "base\data\img\splash-filesel.png"
  File "base\data\img\splash-graphconf.png"
  File "base\data\img\splash-graphic.png"
  File "base\data\img\splash-joycal.png"
  File "base\data\img\splash-main.png"
  File "base\data\img\splash-mousecal.png"
  File "base\data\img\splash-mouseconf.png"
  File "base\data\img\splash-options.png"
  File "base\data\img\splash-practice.png"
  File "base\data\img\splash-qr.png"
  File "base\data\img\splash-qrdrv.png"
  File "base\data\img\splash-qrloading.png"
  File "base\data\img\splash-qrtrk.png"
  File "base\data\img\splash-quit.png"
  File "base\data\img\splash-raceopt.png"
  File "base\data\img\splash-result.png"
  File "base\data\img\splash-run-practice.png"
  File "base\data\img\splash-simucfg.png"
  File "base\data\img\splash-single-player.png"
  File "base\data\img\splash.png"

  SetOutPath "$INSTDIR\data\objects"
  File "base\data\objects\ad1.ac"
  File "base\data\objects\bridge-arch.ac"
  File "base\data\objects\bridge.ac"
  File "base\data\objects\building1.ac"
  File "base\data\objects\building2.ac"
  File "base\data\objects\forest1.ac"
  File "base\data\objects\forest2.ac"
  File "base\data\objects\forest3.ac"
  File "base\data\objects\needle.ac"
  File "base\data\objects\stadium1.ac"
  File "base\data\objects\stand-inter.ac"
  File "base\data\objects\stand-main.ac"
  File "base\data\objects\stand-wall.ac"
  File "base\data\objects\tree1.ac"
  File "base\data\objects\tree10.ac"
  File "base\data\objects\tree11.ac"
  File "base\data\objects\tree12.ac"
  File "base\data\objects\tree13.ac"
  File "base\data\objects\tree14.ac"
  File "base\data\objects\tree15.ac"
  File "base\data\objects\tree16.ac"
  File "base\data\objects\tree17.ac"
  File "base\data\objects\tree2.ac"
  File "base\data\objects\tree3.ac"
  File "base\data\objects\tree4.ac"
  File "base\data\objects\tree5.ac"
  File "base\data\objects\tree6.ac"
  File "base\data\objects\tree7.ac"
  File "base\data\objects\tree8.ac"
  File "base\data\objects\tree9.ac"
  File "base\data\objects\treeg1.ac"

  SetOutPath "$INSTDIR\data\sound"
  File "base\data\sound\206_engine.wav"
  File "base\data\sound\935.wav"
  File "base\data\sound\944.wav"
  File "base\data\sound\alpha-romeo.wav"
  File "base\data\sound\axle.wav"
  File "base\data\sound\backfire.wav"
  File "base\data\sound\backfire_loop.wav"
  File "base\data\sound\boom.wav"
  File "base\data\sound\bottom_crash.wav"
  File "base\data\sound\clkdtmb2.wav"
  File "base\data\sound\corolla1400hi2.wav"
  File "base\data\sound\crash1.wav"
  File "base\data\sound\crash2.wav"
  File "base\data\sound\crash3.wav"
  File "base\data\sound\crash4.wav"
  File "base\data\sound\crash5.wav"
  File "base\data\sound\crash6.wav"
  File "base\data\sound\curb_ride.wav"
  File "base\data\sound\engine-1.wav"
  File "base\data\sound\evo7_engine.wav"
  File "base\data\sound\evo7_engine_f.wav"
  File "base\data\sound\f360.wav"
  File "base\data\sound\ferrarif355.wav"
  File "base\data\sound\ferrarif50.wav"
  File "base\data\sound\ford1b.wav"
  File "base\data\sound\ford2c.wav"
  File "base\data\sound\gear_change1.wav"
  File "base\data\sound\gt40.wav"
  File "base\data\sound\impreza2002_engine.wav"
  File "base\data\sound\lamborghinidiablo.wav"
  File "base\data\sound\locked.wav"
  File "base\data\sound\lotus.wav"
  File "base\data\sound\mclarenf1.wav"
  File "base\data\sound\nsx.wav"
  File "base\data\sound\out_of_road-3.wav"
  File "base\data\sound\out_of_road.wav"
  File "base\data\sound\porsche_engine.wav"
  File "base\data\sound\renault-v10.wav"
  File "base\data\sound\road-ride.wav"
  File "base\data\sound\skid.wav"
  File "base\data\sound\skid_metal.wav"
  File "base\data\sound\skid_tyres.wav"
  File "base\data\sound\turbo1.wav"
  File "base\data\sound\viper2.wav"
  File "base\data\sound\viper_long.wav"
  File "base\data\sound\xj220.wav"

  SetOutPath "$INSTDIR\data\textures"
  File "base\data\textures\arbor2_n.rgb"
  File "base\data\textures\back-sign.rgb"
  File "base\data\textures\background.png"
  File "base\data\textures\breaklight1.rgb"
  File "base\data\textures\breaklight2.rgb"
  File "base\data\textures\building1.rgb"
  File "base\data\textures\building2.rgb"
  File "base\data\textures\bump-2.rgb"
  File "base\data\textures\bump-3.rgb"
  File "base\data\textures\bump-4.rgb"
  File "base\data\textures\bump-5.rgb"
  File "base\data\textures\bump-6.rgb"
  File "base\data\textures\bump-7.rgb"
  File "base\data\textures\bump-8.rgb"
  File "base\data\textures\bump-9.rgb"
  File "base\data\textures\bump-as.rgb"
  File "base\data\textures\bump-finegrain.rgb"
  File "base\data\textures\bump-sand.rgb"
  File "base\data\textures\concrete.rgb"
  File "base\data\textures\concrete2.rgb"
  File "base\data\textures\counter-bg-10.rgb"
  File "base\data\textures\counter-bg-rpm.rgb"
  File "base\data\textures\counter-bg.rgb"
  File "base\data\textures\counter-bg2.rgb"
  File "base\data\textures\counter.rgb"
  File "base\data\textures\env.png"
  File "base\data\textures\envshadow.png"
  File "base\data\textures\fire0.rgb"
  File "base\data\textures\fire1.rgb"
  File "base\data\textures\forest1-r.rgb"
  File "base\data\textures\forest1.rgb"
  File "base\data\textures\forest2.rgb"
  File "base\data\textures\forest3.rgb"
  File "base\data\textures\frontlight1.rgb"
  File "base\data\textures\frontlight2.rgb"
  File "base\data\textures\grassg1.rgb"
  File "base\data\textures\grassg2.rgb"
  File "base\data\textures\grassg3.rgb"
  File "base\data\textures\grey-tracks.rgb"
  File "base\data\textures\logo.rgb"
  File "base\data\textures\panel-empty.rgb"
  File "base\data\textures\people1.rgb"
  File "base\data\textures\pit-left.rgb"
  File "base\data\textures\pit-right.rgb"
  File "base\data\textures\poutre3.rgb"
  File "base\data\textures\pylon1.rgb"
  File "base\data\textures\pylon2.rgb"
  File "base\data\textures\pylon3.rgb"
  File "base\data\textures\rearlight1.rgb"
  File "base\data\textures\rearlight2.rgb"
  File "base\data\textures\red-light-off.rgb"
  File "base\data\textures\red-light-on.rgb"
  File "base\data\textures\rock2.rgb"
  File "base\data\textures\rock3.rgb"
  File "base\data\textures\rpm20000.rgb"
  File "base\data\textures\rpm5500.rgb"
  File "base\data\textures\rpm7000.rgb"
  File "base\data\textures\rpm8000.rgb"
  File "base\data\textures\rpm8500.rgb"
  File "base\data\textures\smoke.rgb"
  File "base\data\textures\speed240.rgb"
  File "base\data\textures\speed300.rgb"
  File "base\data\textures\speed360.rgb"
  File "base\data\textures\torcs-ad1.rgb"
  File "base\data\textures\torcsad1.rgb"
  File "base\data\textures\torcsad2.rgb"
  File "base\data\textures\tr-asphalt-both.rgb"
  File "base\data\textures\tr-asphalt-both_nmm.rgb"
  File "base\data\textures\tr-asphalt-grass-l.rgb"
  File "base\data\textures\tr-asphalt-grass-r.rgb"
  File "base\data\textures\tr-asphalt-l.rgb"
  File "base\data\textures\tr-asphalt-left.rgb"
  File "base\data\textures\tr-asphalt-left_nmm.rgb"
  File "base\data\textures\tr-asphalt-l_nmm.rgb"
  File "base\data\textures\tr-asphalt-p.rgb"
  File "base\data\textures\tr-asphalt-p_nmm.rgb"
  File "base\data\textures\tr-asphalt-right.rgb"
  File "base\data\textures\tr-asphalt-right_nmm.rgb"
  File "base\data\textures\tr-asphalt-road1.rgb"
  File "base\data\textures\tr-asphalt-sand.rgb"
  File "base\data\textures\tr-asphalt.rgb"
  File "base\data\textures\tr-asphalt_nmm.rgb"
  File "base\data\textures\tr-b-asphalt-grass6-l1.rgb"
  File "base\data\textures\tr-b-asphalt-grass6.rgb"
  File "base\data\textures\tr-b-asphalt-grass7-l1.rgb"
  File "base\data\textures\tr-b-asphalt-grass7.rgb"
  File "base\data\textures\tr-b-asphalt-gravel-l1.rgb"
  File "base\data\textures\tr-b-asphalt-gravel.rgb"
  File "base\data\textures\tr-b-asphalt-l1.rgb"
  File "base\data\textures\tr-b-asphalt-l1p.rgb"
  File "base\data\textures\tr-b-asphalt-sand3-l1.rgb"
  File "base\data\textures\tr-b-asphalt-sand3.rgb"
  File "base\data\textures\tr-b-asphalt.rgb"
  File "base\data\textures\tr-b-concrete4-concrete-l1.rgb"
  File "base\data\textures\tr-b-concrete4-concrete-l1p.rgb"
  File "base\data\textures\tr-b-road1-grass6-l2.rgb"
  File "base\data\textures\tr-b-road1-grass6.rgb"
  File "base\data\textures\tr-b-road1-gravel-l2.rgb"
  File "base\data\textures\tr-b-road1-l2.rgb"
  File "base\data\textures\tr-b-road1-l2p.rgb"
  File "base\data\textures\tr-b-road1-sand3-l2.rgb"
  File "base\data\textures\tr-b-road1-sand3.rgb"
  File "base\data\textures\tr-bar-gr.rgb"
  File "base\data\textures\tr-bar-gr_n.rgb"
  File "base\data\textures\tr-bar-turn1.rgb"
  File "base\data\textures\tr-bar.rgb"
  File "base\data\textures\tr-barrier.rgb"
  File "base\data\textures\tr-concrete-pit.rgb"
  File "base\data\textures\tr-concrete.rgb"
  File "base\data\textures\tr-concrete4.rgb"
  File "base\data\textures\tr-concrete_nmm.rgb"
  File "base\data\textures\tr-curb-l.rgb"
  File "base\data\textures\tr-curb-r.rgb"
  File "base\data\textures\tr-dirt.rgb"
  File "base\data\textures\tr-dirtb.rgb"
  File "base\data\textures\tr-fake-road-2.rgb"
  File "base\data\textures\tr-fake-road-borders.rgb"
  File "base\data\textures\tr-fake-road-lines.rgb"
  File "base\data\textures\tr-fake-road.rgb"
  File "base\data\textures\tr-grass.rgb"
  File "base\data\textures\tr-grass2.rgb"
  File "base\data\textures\tr-grass3.rgb"
  File "base\data\textures\tr-grass4.rgb"
  File "base\data\textures\tr-grass5.rgb"
  File "base\data\textures\tr-grass6.rgb"
  File "base\data\textures\tr-grass7.rgb"
  File "base\data\textures\tr-gravel.rgb"
  File "base\data\textures\tr-road1-asphalt.rgb"
  File "base\data\textures\tr-road1-pit.rgb"
  File "base\data\textures\tr-road1.rgb"
  File "base\data\textures\tr-sand.rgb"
  File "base\data\textures\tr-sand2.rgb"
  File "base\data\textures\tr-sand3.rgb"
  File "base\data\textures\tr-snow.rgb"
  File "base\data\textures\tr-stone-wall.rgb"
  File "base\data\textures\tr-stone-wall2.rgb"
  File "base\data\textures\tr-tirewall.rgb"
  File "base\data\textures\tr-wall.rgb"
  File "base\data\textures\tr-wall_nmm.rgb"
  File "base\data\textures\tr-water.rgb"
  File "base\data\textures\tree1.rgb"
  File "base\data\textures\tree10.rgb"
  File "base\data\textures\tree11.rgb"
  File "base\data\textures\tree12.rgb"
  File "base\data\textures\tree13.rgb"
  File "base\data\textures\tree14.rgb"
  File "base\data\textures\tree15.rgb"
  File "base\data\textures\tree16.rgb"
  File "base\data\textures\tree17.rgb"
  File "base\data\textures\tree18.rgb"
  File "base\data\textures\tree19.rgb"
  File "base\data\textures\tree2.rgb"
  File "base\data\textures\tree20.rgb"
  File "base\data\textures\tree3.rgb"
  File "base\data\textures\tree4.rgb"
  File "base\data\textures\tree5.rgb"
  File "base\data\textures\tree7.rgb"
  File "base\data\textures\tree8.rgb"
  File "base\data\textures\tree9.rgb"
  File "base\data\textures\treebui1.rgb"
  File "base\data\textures\treebui2.rgb"
  File "base\data\textures\treeg1.rgb"
  File "base\data\textures\turn100L.rgb"
  File "base\data\textures\turn100R.rgb"
  File "base\data\textures\turn150L.rgb"
  File "base\data\textures\turn150R.rgb"
  File "base\data\textures\turn200L.rgb"
  File "base\data\textures\turn200R.rgb"
  File "base\data\textures\turn300L.rgb"
  File "base\data\textures\turn300R.rgb"
  File "base\data\textures\turn50L.rgb"
  File "base\data\textures\turn50R.rgb"

  SetOutPath "$INSTDIR\data\tracks"
  File "base\data\tracks\dirt.xml"
  File "base\data\tracks\objects.xml"
  File "base\data\tracks\oval.xml"
  File "base\data\tracks\road.xml"
  File "base\data\tracks\surfaces.xml"

  SetOutPath "$INSTDIR\drivers\berniw\1"
  File "base\drivers\berniw\1\car1-stock1.rgb"
  File "base\drivers\berniw\1\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw\10"
  File "base\drivers\berniw\10\car1-trb3.rgb"
  File "base\drivers\berniw\10\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw\2"
  File "base\drivers\berniw\2\car1-stock1.rgb"
  File "base\drivers\berniw\2\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw\3"
  File "base\drivers\berniw\3\car1-trb1.rgb"
  File "base\drivers\berniw\3\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw\4"
  File "base\drivers\berniw\4\car2-trb1.rgb"
  File "base\drivers\berniw\4\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw\5"
  File "base\drivers\berniw\5\car3-trb1.rgb"
  File "base\drivers\berniw\5\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw\6"
  File "base\drivers\berniw\6\car4-trb1.rgb"
  File "base\drivers\berniw\6\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw\7"
  File "base\drivers\berniw\7\car5-trb1.rgb"
  File "base\drivers\berniw\7\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw\8"
  File "base\drivers\berniw\8\car6-trb1.rgb"
  File "base\drivers\berniw\8\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw\9"
  File "base\drivers\berniw\9\car7-trb1.rgb"
  File "base\drivers\berniw\9\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw"
  File "base\drivers\berniw\berniw.dll"
  File "base\drivers\berniw\berniw.xml"
  File "base\drivers\berniw\logo.rgb"

  SetOutPath "$INSTDIR\drivers\berniw2\1"
  File "base\drivers\berniw2\1\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw2\10"
  File "base\drivers\berniw2\10\car1-trb3.rgb"
  File "base\drivers\berniw2\10\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw2\2"
  File "base\drivers\berniw2\2\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw2\3"
  File "base\drivers\berniw2\3\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw2\4"
  File "base\drivers\berniw2\4\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw2\5"
  File "base\drivers\berniw2\5\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw2\6"
  File "base\drivers\berniw2\6\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw2\7"
  File "base\drivers\berniw2\7\car5-trb1.rgb"
  File "base\drivers\berniw2\7\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw2\8"
  File "base\drivers\berniw2\8\car4-trb1.rgb"
  File "base\drivers\berniw2\8\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw2\9"
  File "base\drivers\berniw2\9\car7-trb1.rgb"
  File "base\drivers\berniw2\9\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw2"
  File "base\drivers\berniw2\berniw2.dll"
  File "base\drivers\berniw2\berniw2.xml"
  File "base\drivers\berniw2\logo.rgb"

  SetOutPath "$INSTDIR\drivers\berniw3\1"
  File "base\drivers\berniw3\1\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw3\10"
  File "base\drivers\berniw3\10\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw3\2"
  File "base\drivers\berniw3\2\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw3\3"
  File "base\drivers\berniw3\3\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw3\4"
  File "base\drivers\berniw3\4\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw3\5"
  File "base\drivers\berniw3\5\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw3\6"
  File "base\drivers\berniw3\6\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw3\7"
  File "base\drivers\berniw3\7\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw3\8"
  File "base\drivers\berniw3\8\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw3\9"
  File "base\drivers\berniw3\9\default.xml"

  SetOutPath "$INSTDIR\drivers\berniw3"
  File "base\drivers\berniw3\berniw3.dll"
  File "base\drivers\berniw3\berniw3.xml"
  File "base\drivers\berniw3\logo.rgb"

  SetOutPath "$INSTDIR\drivers\bt\0"
  File "base\drivers\bt\0\car1-stock1.rgb"
  File "base\drivers\bt\0\default.xml"

  SetOutPath "$INSTDIR\drivers\bt\0\practice"
  
  SetOutPath "$INSTDIR\drivers\bt\0\qualifying"
  
  SetOutPath "$INSTDIR\drivers\bt\0\race"
  
  SetOutPath "$INSTDIR\drivers\bt\1"
  File "base\drivers\bt\1\car1-stock1.rgb"
  File "base\drivers\bt\1\default.xml"

  SetOutPath "$INSTDIR\drivers\bt\1\practice"

  SetOutPath "$INSTDIR\drivers\bt\1\qualifying"

  SetOutPath "$INSTDIR\drivers\bt\1\race"

  SetOutPath "$INSTDIR\drivers\bt\2"
  File "base\drivers\bt\2\car1-trb1.rgb"
  File "base\drivers\bt\2\default.xml"

  SetOutPath "$INSTDIR\drivers\bt\3"
  File "base\drivers\bt\3\car2-trb1.rgb"
  File "base\drivers\bt\3\default.xml"

  SetOutPath "$INSTDIR\drivers\bt\4"
  File "base\drivers\bt\4\car3-trb1.rgb"
  File "base\drivers\bt\4\default.xml"

  SetOutPath "$INSTDIR\drivers\bt\5"
  File "base\drivers\bt\5\car4-trb1.rgb"
  File "base\drivers\bt\5\default.xml"

  SetOutPath "$INSTDIR\drivers\bt\6"
  File "base\drivers\bt\6\car5-trb1.rgb"
  File "base\drivers\bt\6\default.xml"

  SetOutPath "$INSTDIR\drivers\bt\7"
  File "base\drivers\bt\7\car6-trb1.rgb"
  File "base\drivers\bt\7\default.xml"

  SetOutPath "$INSTDIR\drivers\bt\8"
  File "base\drivers\bt\8\car7-trb1.rgb"
  File "base\drivers\bt\8\default.xml"

  SetOutPath "$INSTDIR\drivers\bt\9"
  File "base\drivers\bt\9\default.xml"

  SetOutPath "$INSTDIR\drivers\bt"
  File "base\drivers\bt\bt.dll"
  File "base\drivers\bt\bt.xml"
  File "base\drivers\bt\logo.rgb"

  SetOutPath "$INSTDIR\drivers\damned\0"
  File "base\drivers\damned\0\default.xml"

  SetOutPath "$INSTDIR\drivers\damned\1"
  File "base\drivers\damned\1\default.xml"

  SetOutPath "$INSTDIR\drivers\damned\2"
  File "base\drivers\damned\2\default.xml"

  SetOutPath "$INSTDIR\drivers\damned\3"
  File "base\drivers\damned\3\default.xml"

  SetOutPath "$INSTDIR\drivers\damned\4"
  File "base\drivers\damned\4\default.xml"

  SetOutPath "$INSTDIR\drivers\damned\5"
  File "base\drivers\damned\5\default.xml"

  SetOutPath "$INSTDIR\drivers\damned\6"
  File "base\drivers\damned\6\car5-trb1.rgb"
  File "base\drivers\damned\6\default.xml"

  SetOutPath "$INSTDIR\drivers\damned\7"
  File "base\drivers\damned\7\car6-trb1.rgb"
  File "base\drivers\damned\7\default.xml"

  SetOutPath "$INSTDIR\drivers\damned\8"
  File "base\drivers\damned\8\car7-trb1.rgb"
  File "base\drivers\damned\8\default.xml"

  SetOutPath "$INSTDIR\drivers\damned\9"
  File "base\drivers\damned\9\car1-trb3.rgb"
  File "base\drivers\damned\9\default.xml"

  SetOutPath "$INSTDIR\drivers\damned"
  File "base\drivers\damned\damned.dll"
  File "base\drivers\damned\damned.xml"
  File "base\drivers\damned\logo.rgb"

  SetOutPath "$INSTDIR\drivers\human"
  File "base\drivers\human\car.xml"
  File "base\drivers\human\human.dll"
  File "base\drivers\human\human.xml"
  File "base\drivers\human\logo.rgb"
  File "base\drivers\human\preferences.xml"

  SetOutPath "$INSTDIR\drivers\inferno\1"
  File "base\drivers\inferno\1\default.xml"

  SetOutPath "$INSTDIR\drivers\inferno\10"
  File "base\drivers\inferno\10\car1-trb3.rgb"
  File "base\drivers\inferno\10\default.xml"

  SetOutPath "$INSTDIR\drivers\inferno\2"
  File "base\drivers\inferno\2\default.xml"
  File "base\drivers\inferno\2\p406.rgb"

  SetOutPath "$INSTDIR\drivers\inferno\3"
  File "base\drivers\inferno\3\car1-trb1.rgb"
  File "base\drivers\inferno\3\default.xml"

  SetOutPath "$INSTDIR\drivers\inferno\4"
  File "base\drivers\inferno\4\car2-trb1.rgb"
  File "base\drivers\inferno\4\default.xml"

  SetOutPath "$INSTDIR\drivers\inferno\5"
  File "base\drivers\inferno\5\car3-trb1.rgb"
  File "base\drivers\inferno\5\default.xml"

  SetOutPath "$INSTDIR\drivers\inferno\6"
  File "base\drivers\inferno\6\car4-trb1.rgb"
  File "base\drivers\inferno\6\default.xml"

  SetOutPath "$INSTDIR\drivers\inferno\7"
  File "base\drivers\inferno\7\car5-trb1.rgb"
  File "base\drivers\inferno\7\default.xml"

  SetOutPath "$INSTDIR\drivers\inferno\8"
  File "base\drivers\inferno\8\car6-trb1.rgb"
  File "base\drivers\inferno\8\default.xml"

  SetOutPath "$INSTDIR\drivers\inferno\9"
  File "base\drivers\inferno\9\car7-trb1.rgb"
  File "base\drivers\inferno\9\default.xml"

  SetOutPath "$INSTDIR\drivers\inferno"
  File "base\drivers\inferno\inferno.dll"
  File "base\drivers\inferno\inferno.xml"
  File "base\drivers\inferno\logo.rgb"

  SetOutPath "$INSTDIR\drivers\inferno2\1"
  File "base\drivers\inferno2\1\default.xml"
  File "base\drivers\inferno2\1\defaultcar.xml"

  SetOutPath "$INSTDIR\drivers\inferno2\10"
  File "base\drivers\inferno2\10\default.xml"
  File "base\drivers\inferno2\10\defaultcar.xml"

  SetOutPath "$INSTDIR\drivers\inferno2\2"
  File "base\drivers\inferno2\2\default.xml"
  File "base\drivers\inferno2\2\defaultcar.xml"

  SetOutPath "$INSTDIR\drivers\inferno2\3"
  File "base\drivers\inferno2\3\default.xml"
  File "base\drivers\inferno2\3\defaultcar.xml"

  SetOutPath "$INSTDIR\drivers\inferno2\4"
  File "base\drivers\inferno2\4\default.xml"
  File "base\drivers\inferno2\4\defaultcar.xml"

  SetOutPath "$INSTDIR\drivers\inferno2\5"
  File "base\drivers\inferno2\5\default.xml"
  File "base\drivers\inferno2\5\defaultcar.xml"

  SetOutPath "$INSTDIR\drivers\inferno2\6"
  File "base\drivers\inferno2\6\default.xml"
  File "base\drivers\inferno2\6\defaultcar.xml"

  SetOutPath "$INSTDIR\drivers\inferno2\7"
  File "base\drivers\inferno2\7\default.xml"
  File "base\drivers\inferno2\7\defaultcar.xml"

  SetOutPath "$INSTDIR\drivers\inferno2\8"
  File "base\drivers\inferno2\8\default.xml"
  File "base\drivers\inferno2\8\defaultcar.xml"

  SetOutPath "$INSTDIR\drivers\inferno2\9"
  File "base\drivers\inferno2\9\default.xml"
  File "base\drivers\inferno2\9\defaultcar.xml"

  SetOutPath "$INSTDIR\drivers\inferno2"
  File "base\drivers\inferno2\inferno2.dll"
  File "base\drivers\inferno2\inferno2.xml"
  File "base\drivers\inferno2\logo.rgb"

  SetOutPath "$INSTDIR\drivers\lliaw\1"
  File "base\drivers\lliaw\1\default.xml"

  SetOutPath "$INSTDIR\drivers\lliaw\10"
  File "base\drivers\lliaw\10\default.xml"

  SetOutPath "$INSTDIR\drivers\lliaw\2"
  File "base\drivers\lliaw\2\default.xml"

  SetOutPath "$INSTDIR\drivers\lliaw\3"
  File "base\drivers\lliaw\3\car1-trb1.rgb"
  File "base\drivers\lliaw\3\default.xml"

  SetOutPath "$INSTDIR\drivers\lliaw\4"
  File "base\drivers\lliaw\4\car2-trb1.rgb"
  File "base\drivers\lliaw\4\default.xml"

  SetOutPath "$INSTDIR\drivers\lliaw\5"
  File "base\drivers\lliaw\5\car3-trb1.rgb"
  File "base\drivers\lliaw\5\default.xml"

  SetOutPath "$INSTDIR\drivers\lliaw\6"
  File "base\drivers\lliaw\6\car4-trb1.rgb"
  File "base\drivers\lliaw\6\default.xml"

  SetOutPath "$INSTDIR\drivers\lliaw\7"
  File "base\drivers\lliaw\7\car5-trb1.rgb"
  File "base\drivers\lliaw\7\default.xml"

  SetOutPath "$INSTDIR\drivers\lliaw\8"
  File "base\drivers\lliaw\8\car6-trb1.rgb"
  File "base\drivers\lliaw\8\default.xml"

  SetOutPath "$INSTDIR\drivers\lliaw\9"
  File "base\drivers\lliaw\9\car7-trb1.rgb"
  File "base\drivers\lliaw\9\default.xml"

  SetOutPath "$INSTDIR\drivers\lliaw"
  File "base\drivers\lliaw\lliaw.dll"
  File "base\drivers\lliaw\lliaw.xml"
  File "base\drivers\lliaw\logo.rgb"

  SetOutPath "$INSTDIR\drivers\olethros\0"
  File "base\drivers\olethros\0\default.xml"

  SetOutPath "$INSTDIR\drivers\olethros\1"
  File "base\drivers\olethros\1\default.xml"

  SetOutPath "$INSTDIR\drivers\olethros\2"
  File "base\drivers\olethros\2\car1-trb1.rgb"
  File "base\drivers\olethros\2\default.xml"

  SetOutPath "$INSTDIR\drivers\olethros\3"
  File "base\drivers\olethros\3\car2-trb1.rgb"
  File "base\drivers\olethros\3\default.xml"

  SetOutPath "$INSTDIR\drivers\olethros\4"
  File "base\drivers\olethros\4\car3-trb1.rgb"
  File "base\drivers\olethros\4\default.xml"

  SetOutPath "$INSTDIR\drivers\olethros\5"
  File "base\drivers\olethros\5\car4-trb1.rgb"
  File "base\drivers\olethros\5\default.xml"

  SetOutPath "$INSTDIR\drivers\olethros\6"
  File "base\drivers\olethros\6\car5-trb1.rgb"
  File "base\drivers\olethros\6\default.xml"

  SetOutPath "$INSTDIR\drivers\olethros\7"
  File "base\drivers\olethros\7\car6-trb1.rgb"
  File "base\drivers\olethros\7\default.xml"

  SetOutPath "$INSTDIR\drivers\olethros\8"
  File "base\drivers\olethros\8\car7-trb1.rgb"
  File "base\drivers\olethros\8\default.xml"

  SetOutPath "$INSTDIR\drivers\olethros\9"
  File "base\drivers\olethros\9\car1-trb3.rgb"
  File "base\drivers\olethros\9\default.xml"

  SetOutPath "$INSTDIR\drivers\olethros"
  File "base\drivers\olethros\logo.rgb"
  File "base\drivers\olethros\olethros.dll"
  File "base\drivers\olethros\olethros.xml"

  SetOutPath "$INSTDIR\drivers\sparkle\0"
  File "base\drivers\sparkle\0\baja-bug.rgb"
  File "base\drivers\sparkle\0\default.xml"

  SetOutPath "$INSTDIR\drivers\sparkle"
  File "base\drivers\sparkle\logo.rgb"
  File "base\drivers\sparkle\sparkle.xml"

  SetOutPath "$INSTDIR\drivers\tita\1"
  File "base\drivers\tita\1\default.xml"

  SetOutPath "$INSTDIR\drivers\tita\10"
  File "base\drivers\tita\10\default.xml"

  SetOutPath "$INSTDIR\drivers\tita\2"
  File "base\drivers\tita\2\default.xml"

  SetOutPath "$INSTDIR\drivers\tita\3"
  File "base\drivers\tita\3\car1-trb1.rgb"
  File "base\drivers\tita\3\default.xml"

  SetOutPath "$INSTDIR\drivers\tita\4"
  File "base\drivers\tita\4\car2-trb1.rgb"
  File "base\drivers\tita\4\default.xml"

  SetOutPath "$INSTDIR\drivers\tita\5"
  File "base\drivers\tita\5\car3-trb1.rgb"
  File "base\drivers\tita\5\default.xml"

  SetOutPath "$INSTDIR\drivers\tita\6"
  File "base\drivers\tita\6\car4-trb1.rgb"
  File "base\drivers\tita\6\default.xml"

  SetOutPath "$INSTDIR\drivers\tita\7"
  File "base\drivers\tita\7\car5-trb1.rgb"
  File "base\drivers\tita\7\default.xml"

  SetOutPath "$INSTDIR\drivers\tita\8"
  File "base\drivers\tita\8\car6-trb1.rgb"
  File "base\drivers\tita\8\default.xml"

  SetOutPath "$INSTDIR\drivers\tita\9"
  File "base\drivers\tita\9\car7-trb1.rgb"
  File "base\drivers\tita\9\default.xml"

  SetOutPath "$INSTDIR\drivers\tita"
  File "base\drivers\tita\logo.rgb"
  File "base\drivers\tita\tita.dll"
  File "base\drivers\tita\tita.xml"

  SetOutPath "$INSTDIR"
  File "base\glut32.dll"
  File "base\learning.dll"
  File "base\logo-skinner.png"

  SetOutPath "$INSTDIR\menu"
  File "base\menu\entry.xml"

  SetOutPath "$INSTDIR\modules\simu"
  File "base\modules\simu\simuv2.dll"

  SetOutPath "$INSTDIR\modules\track"
  File "base\modules\track\track.dll"

  SetOutPath "$INSTDIR"
  File "base\nfs2ac.exe"
  File "base\nfsperf.exe"
  File "base\OpenAL32.dll"
  File "base\libogg.dll"
  File "base\libvorbis.dll"
  File "base\libvorbisfile.dll"
  File "base\robottools.dll"
  
  SetOutPath "$INSTDIR"
  File "base\tgf.dll"
  File "base\Ticon.ico"
  File "base\Ticon.png"
  File "base\trackgen.exe"

  SetOutPath "$INSTDIR\tracks\dirt\dirt-1"
  File "base\tracks\dirt\dirt-1\background.png"
  File "base\tracks\dirt\dirt-1\castle-arbor_n.rgb"
  File "base\tracks\dirt\dirt-1\concrete_white.rgb"
  File "base\tracks\dirt\dirt-1\dirt-1.acc"
  File "base\tracks\dirt\dirt-1\dirt-1.png"
  File "base\tracks\dirt\dirt-1\dirt-1.xml"
  File "base\tracks\dirt\dirt-1\pylon-arbor_n.rgb"
  File "base\tracks\dirt\dirt-1\pylon3.rgb"
  File "base\tracks\dirt\dirt-1\readme.txt"
  File "base\tracks\dirt\dirt-1\rock3.rgb"
  File "base\tracks\dirt\dirt-1\shadow2.rgb"
  File "base\tracks\dirt\dirt-1\tr-barrier-curve.rgb"
  File "base\tracks\dirt\dirt-1\tr-barrier-start.rgb"
  File "base\tracks\dirt\dirt-1\tr-barrier.rgb"
  File "base\tracks\dirt\dirt-1\tr-dirt.rgb"
  File "base\tracks\dirt\dirt-1\tr-dirtb.rgb"
  File "base\tracks\dirt\dirt-1\tr-grass.rgb"
  File "base\tracks\dirt\dirt-1\tree13_n.rgb"
  File "base\tracks\dirt\dirt-1\tree15_n.rgb"
  File "base\tracks\dirt\dirt-1\tree16_n.rgb"
  File "base\tracks\dirt\dirt-1\tree17_n.rgb"
  File "base\tracks\dirt\dirt-1\tree1_n.rgb"
  File "base\tracks\dirt\dirt-1\tree2_n.rgb"
  File "base\tracks\dirt\dirt-1\tree3_n.rgb"
  File "base\tracks\dirt\dirt-1\tree4_n.rgb"
  File "base\tracks\dirt\dirt-1\tree5_n.rgb"
  File "base\tracks\dirt\dirt-1\tree7_n.rgb"
  File "base\tracks\dirt\dirt-1\tree8_n.rgb"
  File "base\tracks\dirt\dirt-1\tree9_n.rgb"
  File "base\tracks\dirt\dirt-1\water.rgb"
  File "base\tracks\dirt\dirt-1\waterplants-arbor_n.rgb"

  SetOutPath "$INSTDIR\tracks\dirt\dirt-2"
  File "base\tracks\dirt\dirt-2\dirt-2.xml"
  File "base\tracks\dirt\dirt-2\background.png"
  File "base\tracks\dirt\dirt-2\dirt-2.acc"
  File "base\tracks\dirt\dirt-2\dirt-2.png"
  File "base\tracks\dirt\dirt-2\readme.txt"
  File "base\tracks\dirt\dirt-2\barrier-d2.png"
  File "base\tracks\dirt\dirt-2\BLBDBK.png"
  File "base\tracks\dirt\dirt-2\concretetile.png"
  File "base\tracks\dirt\dirt-2\CONCSH01.png"
  File "base\tracks\dirt\dirt-2\curb-bw-d2.png"
  File "base\tracks\dirt\dirt-2\dirt-bw-d2.png"
  File "base\tracks\dirt\dirt-2\dirt-bw-lines-left-d2.png"
  File "base\tracks\dirt\dirt-2\dirt-side-bw-d2.png"
  File "base\tracks\dirt\dirt-2\dirt-side-pit-bw-d2.png"
  File "base\tracks\dirt\dirt-2\grass-bw-d2.png"
  File "base\tracks\dirt\dirt-2\house12.png"
  File "base\tracks\dirt\dirt-2\house12r.png"
  File "base\tracks\dirt\dirt-2\house13.png"
  File "base\tracks\dirt\dirt-2\house13r.png"
  File "base\tracks\dirt\dirt-2\house14r.png"
  File "base\tracks\dirt\dirt-2\house15.png"
  File "base\tracks\dirt\dirt-2\logo_trb2.png"
  File "base\tracks\dirt\dirt-2\logo_water.png"
  File "base\tracks\dirt\dirt-2\megafuel_trucktank.png"
  File "base\tracks\dirt\dirt-2\mycast.png"
  File "base\tracks\dirt\dirt-2\PASS10.png"
  File "base\tracks\dirt\dirt-2\PASS3.png"
  File "base\tracks\dirt\dirt-2\PASS4.png"
  File "base\tracks\dirt\dirt-2\pitfacade1.png"
  File "base\tracks\dirt\dirt-2\pitfacade2.png"
  File "base\tracks\dirt\dirt-2\pylon1.rgb"
  File "base\tracks\dirt\dirt-2\pylon2.rgb"
  File "base\tracks\dirt\dirt-2\pylon3.rgb"
  File "base\tracks\dirt\dirt-2\raceline-bw-d2.png"
  File "base\tracks\dirt\dirt-2\readme.txt"
  File "base\tracks\dirt\dirt-2\red_bridge.png"
  File "base\tracks\dirt\dirt-2\roof11.png"
  File "base\tracks\dirt\dirt-2\shadow2.rgb"
  File "base\tracks\dirt\dirt-2\silo1-pipe.png"
  File "base\tracks\dirt\dirt-2\silo1-w.png"
  File "base\tracks\dirt\dirt-2\strawbale-bw.png"
  File "base\tracks\dirt\dirt-2\trb_red_bridge.png"
  File "base\tracks\dirt\dirt-2\tree10_n.png"
  File "base\tracks\dirt\dirt-2\tree13_n.png"
  File "base\tracks\dirt\dirt-2\tree15_n.png"
  File "base\tracks\dirt\dirt-2\tree18_n.png"
  File "base\tracks\dirt\dirt-2\treeS3_n.png"
  File "base\tracks\dirt\dirt-2\treeUGLIES02_n.png"
  File "base\tracks\dirt\dirt-2\truck_arbor_bt_n.png"
  File "base\tracks\dirt\dirt-2\truck_arbor_speedy_n.png"
  File "base\tracks\dirt\dirt-2\wall11.png"
  File "base\tracks\dirt\dirt-2\wall14-2.png"
  File "base\tracks\dirt\dirt-2\wall14.png"
  File "base\tracks\dirt\dirt-2\wall-concrete.png"
  File "base\tracks\dirt\dirt-2\wall-water.png"
  
  SetOutPath "$INSTDIR\tracks\dirt\dirt-3"
  File "base\tracks\dirt\dirt-3\advert-cola.png"
  File "base\tracks\dirt\dirt-3\advert-joes.png"
  File "base\tracks\dirt\dirt-3\advert-ols.png"
  File "base\tracks\dirt\dirt-3\ambush-inn.png"
  File "base\tracks\dirt\dirt-3\background.png"
  File "base\tracks\dirt\dirt-3\barrier-fence_n.png"
  File "base\tracks\dirt\dirt-3\barrier-rusty.png"
  File "base\tracks\dirt\dirt-3\barrier-wooden_n.png"
  File "base\tracks\dirt\dirt-3\black.png"
  File "base\tracks\dirt\dirt-3\bridgeplanks.png"
  File "base\tracks\dirt\dirt-3\cabin.png"
  File "base\tracks\dirt\dirt-3\dirt-3.acc"
  File "base\tracks\dirt\dirt-3\dirt-3.png"
  File "base\tracks\dirt\dirt-3\dirt-3.xml"
  File "base\tracks\dirt\dirt-3\dirt-grass.png"
  File "base\tracks\dirt\dirt-3\dirt-grass2.png"
  File "base\tracks\dirt\dirt-3\dirt-pits.png"
  File "base\tracks\dirt\dirt-3\dirt-side.png"
  File "base\tracks\dirt\dirt-3\grass-clump-arbor_n.png"
  File "base\tracks\dirt\dirt-3\hat.png"
  File "base\tracks\dirt\dirt-3\newdirt.png"
  File "base\tracks\dirt\dirt-3\newdirt2.png"
  File "base\tracks\dirt\dirt-3\newgrass.png"
  File "base\tracks\dirt\dirt-3\pit-walls.png"
  File "base\tracks\dirt\dirt-3\poutre2_arbor_n.rgb"
  File "base\tracks\dirt\dirt-3\poutre3_arbor_n.rgb"
  File "base\tracks\dirt\dirt-3\readme.txt"
  File "base\tracks\dirt\dirt-3\shadow2.png"
  File "base\tracks\dirt\dirt-3\shadow2.rgb"
  File "base\tracks\dirt\dirt-3\shadow3.png"
  File "base\tracks\dirt\dirt-3\sign-left_n.png"
  File "base\tracks\dirt\dirt-3\sign-pit_n.png"
  File "base\tracks\dirt\dirt-3\stone1.png"
  File "base\tracks\dirt\dirt-3\tank.png"
  File "base\tracks\dirt\dirt-3\tr-house-arbor_n.png"
  File "base\tracks\dirt\dirt-3\tree_bush2_arbor_n.png"
  File "base\tracks\dirt\dirt-3\tree_gum2_arbor_n.png"
  File "base\tracks\dirt\dirt-3\tree_gum_arbor_n.png"
  SetOutPath "$INSTDIR\tracks\dirt\dirt-4"
  File "base\tracks\dirt\dirt-4\background.png"
  File "base\tracks\dirt\dirt-4\dirt-4.ac"
  File "base\tracks\dirt\dirt-4\dirt-4.png"
  File "base\tracks\dirt\dirt-4\dirt-4.xml"
  SetOutPath "$INSTDIR\tracks\dirt\dirt-5"
  File "base\tracks\dirt\dirt-5\background.png"
  File "base\tracks\dirt\dirt-5\dirt-5.ac"
  File "base\tracks\dirt\dirt-5\dirt-5.png"
  File "base\tracks\dirt\dirt-5\dirt-5.xml"
  SetOutPath "$INSTDIR\tracks\dirt\dirt-6"
  File "base\tracks\dirt\dirt-6\background.png"
  File "base\tracks\dirt\dirt-6\dirt-6.ac"
  File "base\tracks\dirt\dirt-6\dirt-6.png"
  File "base\tracks\dirt\dirt-6\dirt-6.xml"
  SetOutPath "$INSTDIR\tracks\dirt\mixed-1"
  File "base\tracks\dirt\mixed-1\background.png"
  File "base\tracks\dirt\mixed-1\env1.png"
  File "base\tracks\dirt\mixed-1\mixed-1.acc"
  File "base\tracks\dirt\mixed-1\mixed-1.png"
  File "base\tracks\dirt\mixed-1\mixed-1.xml"
  File "base\tracks\dirt\mixed-1\shadow2.rgb"
  SetOutPath "$INSTDIR\tracks\dirt\mixed-2"
  File "base\tracks\dirt\mixed-2\background.png"
  File "base\tracks\dirt\mixed-2\env.rgb"
  File "base\tracks\dirt\mixed-2\mixed-2.ac"
  File "base\tracks\dirt\mixed-2\mixed-2.png"
  File "base\tracks\dirt\mixed-2\mixed-2.xml"
  SetOutPath "$INSTDIR\tracks\oval\a-speedway"
  File "base\tracks\oval\a-speedway\a-speedway.ac"
  File "base\tracks\oval\a-speedway\a-speedway.png"
  File "base\tracks\oval\a-speedway\a-speedway.xml"
  File "base\tracks\oval\a-speedway\background.png"
  SetOutPath "$INSTDIR\tracks\oval\b-speedway"
  File "base\tracks\oval\b-speedway\b-speedway.ac"
  File "base\tracks\oval\b-speedway\b-speedway.png"
  File "base\tracks\oval\b-speedway\b-speedway.xml"
  File "base\tracks\oval\b-speedway\background.png"
  SetOutPath "$INSTDIR\tracks\oval\c-speedway"
  File "base\tracks\oval\c-speedway\background.png"
  File "base\tracks\oval\c-speedway\c-speedway.ac"
  File "base\tracks\oval\c-speedway\c-speedway.png"
  File "base\tracks\oval\c-speedway\c-speedway.xml"
  SetOutPath "$INSTDIR\tracks\oval\d-speedway"
  File "base\tracks\oval\d-speedway\background.png"
  File "base\tracks\oval\d-speedway\d-speedway.ac"
  File "base\tracks\oval\d-speedway\d-speedway.png"
  File "base\tracks\oval\d-speedway\d-speedway.xml"
  SetOutPath "$INSTDIR\tracks\oval\e-speedway"
  File "base\tracks\oval\e-speedway\background.png"
  File "base\tracks\oval\e-speedway\e-speedway.ac"
  File "base\tracks\oval\e-speedway\e-speedway.png"
  File "base\tracks\oval\e-speedway\e-speedway.xml"
  SetOutPath "$INSTDIR\tracks\oval\e-track-5"
  File "base\tracks\oval\e-track-5\background.png"
  File "base\tracks\oval\e-track-5\e-track-5.ac"
  File "base\tracks\oval\e-track-5\e-track-5.png"
  File "base\tracks\oval\e-track-5\e-track-5.xml"
  SetOutPath "$INSTDIR\tracks\oval\f-speedway"
  File "base\tracks\oval\f-speedway\background.png"
  File "base\tracks\oval\f-speedway\f-speedway.ac"
  File "base\tracks\oval\f-speedway\f-speedway.png"
  File "base\tracks\oval\f-speedway\f-speedway.xml"
  SetOutPath "$INSTDIR\tracks\oval\g-speedway"
  File "base\tracks\oval\g-speedway\background.png"
  File "base\tracks\oval\g-speedway\g-speedway.ac"
  File "base\tracks\oval\g-speedway\g-speedway.png"
  File "base\tracks\oval\g-speedway\g-speedway.xml"
  SetOutPath "$INSTDIR\tracks\oval\michigan"
  File "base\tracks\oval\michigan\allborg-trees_n.rgb"
  File "base\tracks\oval\michigan\arbor_frame_n.rgb"
  File "base\tracks\oval\michigan\asphalt-bw-m1-1_n.rgb"
  File "base\tracks\oval\michigan\asphalt-bw-m1-pit-1_n.rgb"
  File "base\tracks\oval\michigan\asphalt-bw-m1-pitentry-1_n.rgb"
  File "base\tracks\oval\michigan\asphalt-bw-m1-pitentry-leftside-1_n.rgb"
  File "base\tracks\oval\michigan\background.png"
  File "base\tracks\oval\michigan\block1.rgb"
  File "base\tracks\oval\michigan\block2.rgb"
  File "base\tracks\oval\michigan\border-dirt.rgb"
  File "base\tracks\oval\michigan\facade4-512.rgb"
  File "base\tracks\oval\michigan\forest1-tree-m1_n.rgb"
  File "base\tracks\oval\michigan\grass-m1-2.rgb"
  File "base\tracks\oval\michigan\grass-m1.rgb"
  File "base\tracks\oval\michigan\grass-m3-arbor_n.rgb"
  File "base\tracks\oval\michigan\michigan-arbor_n.rgb"
  File "base\tracks\oval\michigan\michigan.acc"
  File "base\tracks\oval\michigan\michigan.png"
  File "base\tracks\oval\michigan\michigan.xml"
  File "base\tracks\oval\michigan\poutre3_arbor_n.rgb"
  File "base\tracks\oval\michigan\readme.txt"
  File "base\tracks\oval\michigan\roof3.rgb"
  File "base\tracks\oval\michigan\roof5.rgb"
  File "base\tracks\oval\michigan\shadow2.rgb"
  File "base\tracks\oval\michigan\std.rgb"
  File "base\tracks\oval\michigan\tarmac-wall-2-g2.rgb"
  File "base\tracks\oval\michigan\tent.rgb"
  File "base\tracks\oval\michigan\torcs-url-yellow-red.rgb"
  File "base\tracks\oval\michigan\torcs0_arbor_n.rgb"
  File "base\tracks\oval\michigan\torcs1.rgb"
  File "base\tracks\oval\michigan\truck_arbor_berniw_n.rgb"
  File "base\tracks\oval\michigan\truck_arbor_bt_n.rgb"
  File "base\tracks\oval\michigan\truck_arbor_ctd_n.rgb"
  File "base\tracks\oval\michigan\truck_arbor_cylos_n.rgb"
  File "base\tracks\oval\michigan\truck_arbor_inferno_n.rgb"
  File "base\tracks\oval\michigan\truck_arbor_speedy_n.rgb"
  File "base\tracks\oval\michigan\truck_arbor_tanhoj_n.rgb"
  File "base\tracks\oval\michigan\truck_arbor_tita_n.rgb"
  File "base\tracks\oval\michigan\wall-m1-2.rgb"
  File "base\tracks\oval\michigan\wall-m1.rgb"
  File "base\tracks\oval\michigan\wall-torcs.rgb"
  File "base\tracks\oval\michigan\wall4.rgb"
  File "base\tracks\oval\michigan\raceline.png"
  SetOutPath "$INSTDIR\tracks\road\aalborg"
  File "base\tracks\road\aalborg\aalborg.acc"
  File "base\tracks\road\aalborg\aalborg.png"
  File "base\tracks\road\aalborg\aalborg.xml"
  File "base\tracks\road\aalborg\allborg-trees_n.rgb"
  File "base\tracks\road\aalborg\background.png"
  File "base\tracks\road\aalborg\raceline.png"
  File "base\tracks\road\aalborg\barr1.rgb"
  File "base\tracks\road\aalborg\grass-aa.rgb"
  File "base\tracks\road\aalborg\poutre4.rgb"
  File "base\tracks\road\aalborg\readme.txt"
  File "base\tracks\road\aalborg\shadow2.rgb"
  File "base\tracks\road\aalborg\spectator.rgb"
  File "base\tracks\road\aalborg\tarmac-wall-1-g2.rgb"
  File "base\tracks\road\aalborg\tarmac-wall-2-g2.rgb"
  File "base\tracks\road\aalborg\torcs1.rgb"
  File "base\tracks\road\aalborg\tr-asphalt-2-aa-r_n.rgb"
  File "base\tracks\road\aalborg\tr-asphalt-aa-bw1_n.rgb"
  File "base\tracks\road\aalborg\tr-asphalt-aa-bw2-e_n.rgb"
  File "base\tracks\road\aalborg\tr-asphalt-aa-bw2-s_n.rgb"
  File "base\tracks\road\aalborg\tr-asphalt-aa-bw2_n.rgb"
  File "base\tracks\road\aalborg\tr-asphalt-aa-l_n.rgb"
  File "base\tracks\road\aalborg\tr-asphalt-aa-pe-bw1_n.rgb"
  File "base\tracks\road\aalborg\tr-asphalt-aa-pt-bw1_n.rgb"
  File "base\tracks\road\aalborg\tr-asphalt-aa-ro-bw1_n.rgb"
  File "base\tracks\road\aalborg\tr-asphalt-to-g-aa-l_n.rgb"
  File "base\tracks\road\aalborg\tr-barrier-aa-1.rgb"
  File "base\tracks\road\aalborg\tr-curb-bw-aa-r.rgb"
  File "base\tracks\road\aalborg\tr-g-to-asphalt-aa-l_n.rgb"
  File "base\tracks\road\aalborg\tr-grass-aa-l_n.rgb"
  SetOutPath "$INSTDIR\tracks\road\alpine-1"
  File "base\tracks\road\alpine-1\alpine-1.acc"
  File "base\tracks\road\alpine-1\alpine-1.png"
  File "base\tracks\road\alpine-1\alpine-1.xml"
  File "base\tracks\road\alpine-1\arbor01.rgb"
  File "base\tracks\road\alpine-1\asgrassr_n.rgb"
  File "base\tracks\road\alpine-1\background.png"
  File "base\tracks\road\alpine-1\barg3.rgb"
  File "base\tracks\road\alpine-1\barrier.rgb"
  File "base\tracks\road\alpine-1\concdal.rgb"
  File "base\tracks\road\alpine-1\gconcrete.rgb"
  File "base\tracks\road\alpine-1\ggrass3.rgb"
  File "base\tracks\road\alpine-1\house.rgb"
  File "base\tracks\road\alpine-1\mur2.rgb"
  File "base\tracks\road\alpine-1\murpub.rgb"
  File "base\tracks\road\alpine-1\poutre3.rgb"
  File "base\tracks\road\alpine-1\road1.rgb"
  File "base\tracks\road\alpine-1\road4.rgb"
  File "base\tracks\road\alpine-1\rockg0.rgb"
  File "base\tracks\road\alpine-1\shadow2.rgb"
  File "base\tracks\road\alpine-1\torcs2.rgb"
  File "base\tracks\road\alpine-1\treeg10.rgb"
  File "base\tracks\road\alpine-1\truck0.rgb"
  File "base\tracks\road\alpine-1\truck1.rgb"
  File "base\tracks\road\alpine-1\walls.rgb"
  File "base\tracks\road\alpine-1\walls2.rgb"
  File "base\tracks\road\alpine-1\raceline.png"
  SetOutPath "$INSTDIR\tracks\road\alpine-2"
  File "base\tracks\road\alpine-2\alpine-2.acc"
  File "base\tracks\road\alpine-2\alpine-2.png"
  File "base\tracks\road\alpine-2\alpine-2.xml"
  File "base\tracks\road\alpine-2\arbor2_n.rgb"
  File "base\tracks\road\alpine-2\armco2_arbor.png"
  File "base\tracks\road\alpine-2\armcoturn_arbor.png"
  File "base\tracks\road\alpine-2\armco_snow_arbor.png"
  File "base\tracks\road\alpine-2\background.png"
  File "base\tracks\road\alpine-2\BARS_tree_n.png"
  File "base\tracks\road\alpine-2\BLBDBK.png"
  File "base\tracks\road\alpine-2\BLDG05_tree.png"
  File "base\tracks\road\alpine-2\brick01.png"
  File "base\tracks\road\alpine-2\cliff.png"
  File "base\tracks\road\alpine-2\CMNTA.png"
  File "base\tracks\road\alpine-2\concdark.png"
  File "base\tracks\road\alpine-2\CONCRE.png"
  File "base\tracks\road\alpine-2\concrete01.png"
  File "base\tracks\road\alpine-2\concrete2.rgb"
  File "base\tracks\road\alpine-2\concwall.png"
  File "base\tracks\road\alpine-2\concwall2.png"
  File "base\tracks\road\alpine-2\GRDRA_tree_n.png"
  File "base\tracks\road\alpine-2\ice.png"
  File "base\tracks\road\alpine-2\LOGOMELA.png"
  File "base\tracks\road\alpine-2\LOGOMELC.png"
  File "base\tracks\road\alpine-2\ppla_tree_n.png"
  File "base\tracks\road\alpine-2\pplb_tree_n.png"
  File "base\tracks\road\alpine-2\pplc_tree_n.png"
  File "base\tracks\road\alpine-2\racelinedark.png"
  File "base\tracks\road\alpine-2\racelinedark2light.png"
  File "base\tracks\road\alpine-2\racelinelight.png"
  File "base\tracks\road\alpine-2\racelinelight2dark.png"
  File "base\tracks\road\alpine-2\RAILtree_n.png"
  File "base\tracks\road\alpine-2\readme.txt"
  File "base\tracks\road\alpine-2\road-line-edge.png"
  File "base\tracks\road\alpine-2\road-lines2.png"
  File "base\tracks\road\alpine-2\road-linesbrleft.png"
  File "base\tracks\road\alpine-2\road-linesbroken.png"
  File "base\tracks\road\alpine-2\road-linesbrrightt.png"
  File "base\tracks\road\alpine-2\road-pit.png"
  File "base\tracks\road\alpine-2\road-snow.png"
  File "base\tracks\road\alpine-2\road.png"
  File "base\tracks\road\alpine-2\road2snow-edge.png"
  File "base\tracks\road\alpine-2\road2snow.png"
  File "base\tracks\road\alpine-2\rockwall.png"
  File "base\tracks\road\alpine-2\rockwall2.png"
  File "base\tracks\road\alpine-2\SEATS.png"
  File "base\tracks\road\alpine-2\shadow2.png"
  File "base\tracks\road\alpine-2\shadow2.rgb"
  File "base\tracks\road\alpine-2\snow.png"
  File "base\tracks\road\alpine-2\snow_2.png"
  File "base\tracks\road\alpine-2\snow_3.png"
  File "base\tracks\road\alpine-2\snow_4.png"
  File "base\tracks\road\alpine-2\steel01.png"
  File "base\tracks\road\alpine-2\TOWER_tree_n.png"
  File "base\tracks\road\alpine-2\tr-stone-wall.rgb"
  File "base\tracks\road\alpine-2\tree1_n.png"
  File "base\tracks\road\alpine-2\tree2_n.png"
  File "base\tracks\road\alpine-2\tree3_n.png"
  File "base\tracks\road\alpine-2\tree6_n.png"
  File "base\tracks\road\alpine-2\tree7_n.png"
  File "base\tracks\road\alpine-2\tree8_n.png"
  File "base\tracks\road\alpine-2\truck_arbor_berniw_n.rgb"
  File "base\tracks\road\alpine-2\truck_arbor_dummy_n.rgb"
  File "base\tracks\road\alpine-2\truck_arbor_hymie_n.rgb"
  File "base\tracks\road\alpine-2\truck_arbor_inferno_n.rgb"
  File "base\tracks\road\alpine-2\truck_arbor_mouse_n.rgb"
  File "base\tracks\road\alpine-2\truck_arbor_ole_n.rgb"
  File "base\tracks\road\alpine-2\truck_arbor_speedy_n.rgb"
  File "base\tracks\road\alpine-2\truck_arbor_tp_n.rgb"
  File "base\tracks\road\alpine-2\truck_arbor_usr_n.rgb"
  File "base\tracks\road\alpine-2\WALL.png"
  SetOutPath "$INSTDIR\tracks\road\e-track-1"
  File "base\tracks\road\e-track-1\background.png"
  File "base\tracks\road\e-track-1\raceline.png"
  File "base\tracks\road\e-track-1\e-track-1.acc"
  File "base\tracks\road\e-track-1\e-track-1.png"
  File "base\tracks\road\e-track-1\e-track-1.xml"
  File "base\tracks\road\e-track-1\geo-bw1.rgb"
  File "base\tracks\road\e-track-1\readme.txt"
  File "base\tracks\road\e-track-1\shadow2.rgb"
  File "base\tracks\road\e-track-1\tr-asphalt-bw3-pit-e_n.rgb"
  File "base\tracks\road\e-track-1\tr-asphalt-bw3-pit-l_n.rgb"
  File "base\tracks\road\e-track-1\tr-asphalt-bw3-pit_n.rgb"
  File "base\tracks\road\e-track-1\tr-asphalt-bw3_n.rgb"
  File "base\tracks\road\e-track-1\tr-barrier-bw.rgb"
  File "base\tracks\road\e-track-1\tr-curb-bw-l.rgb"
  File "base\tracks\road\e-track-1\tr-curb-bw-r.rgb"
  File "base\tracks\road\e-track-1\tr-grass-bw1.rgb"
  File "base\tracks\road\e-track-1\tr-grass-bw2.rgb"  
  SetOutPath "$INSTDIR\tracks\road\e-track-2"
  File "base\tracks\road\e-track-2\01.png"
  File "base\tracks\road\e-track-2\02.png"
  File "base\tracks\road\e-track-2\ALAUBM.png"
  File "base\tracks\road\e-track-2\asphalt-e2.png"
  File "base\tracks\road\e-track-2\asphalt-pit-e2.png"
  File "base\tracks\road\e-track-2\asphalt-sl-e2.png"
  File "base\tracks\road\e-track-2\asphalt-tile-e2.png"
  File "base\tracks\road\e-track-2\asphalt-tile-stripes-e2.png"
  File "base\tracks\road\e-track-2\asphalt-white-tile.png"
  File "base\tracks\road\e-track-2\background.png"
  File "base\tracks\road\e-track-2\back-sign.png"
  File "base\tracks\road\e-track-2\barrier-1.png"
  File "base\tracks\road\e-track-2\barrier-2.png"
  File "base\tracks\road\e-track-2\block4f.png"
  File "base\tracks\road\e-track-2\block4s.png"
  File "base\tracks\road\e-track-2\block5-arbor_n.png"
  File "base\tracks\road\e-track-2\block5f.png"
  File "base\tracks\road\e-track-2\block5fqa.png"
  File "base\tracks\road\e-track-2\block5s.png"
  File "base\tracks\road\e-track-2\block5t.png"
  File "base\tracks\road\e-track-2\border2m.png"
  File "base\tracks\road\e-track-2\border-grass-e2.png"
  File "base\tracks\road\e-track-2\border-grass-end-e2.png"
  File "base\tracks\road\e-track-2\border-grass-start-e2.png"
  File "base\tracks\road\e-track-2\border-gravel-e2.png"
  File "base\tracks\road\e-track-2\border-gravel-end-e2.png"
  File "base\tracks\road\e-track-2\border-gravel-start-e2.png"
  File "base\tracks\road\e-track-2\bordertile.png"
  File "base\tracks\road\e-track-2\BUS.png"
  File "base\tracks\road\e-track-2\CAMPER01.png"
  File "base\tracks\road\e-track-2\CAMPER02.png"
  File "base\tracks\road\e-track-2\CAMPER3.png"
  File "base\tracks\road\e-track-2\CAMPER41.png"
  File "base\tracks\road\e-track-2\CAMPER4.png"
  File "base\tracks\road\e-track-2\CAR01.png"
  File "base\tracks\road\e-track-2\CAR02.png"
  File "base\tracks\road\e-track-2\CAR05.png"
  File "base\tracks\road\e-track-2\CAR06.png"
  File "base\tracks\road\e-track-2\CHtree_n.png"
  File "base\tracks\road\e-track-2\CMNTA.png"
  File "base\tracks\road\e-track-2\CMNTBB.png"
  File "base\tracks\road\e-track-2\CMNTB.png"
  File "base\tracks\road\e-track-2\conc.png"
  File "base\tracks\road\e-track-2\concrete-wall1.png"
  File "base\tracks\road\e-track-2\CONCTP.png"
  File "base\tracks\road\e-track-2\curb-red-white-e2.png"
  File "base\tracks\road\e-track-2\e-track-2.acc"
  File "base\tracks\road\e-track-2\e-track-2.png"
  File "base\tracks\road\e-track-2\e-track-2.xml"
  File "base\tracks\road\e-track-2\fence_arbor_n.png"
  File "base\tracks\road\e-track-2\FNCEB.png"
  File "base\tracks\road\e-track-2\GBtree_n.png"
  File "base\tracks\road\e-track-2\GEtree_n.png"
  File "base\tracks\road\e-track-2\grass-bw-d2.png"
  File "base\tracks\road\e-track-2\grass-cut-e2.png"
  File "base\tracks\road\e-track-2\grass-dirt-e2.png"
  File "base\tracks\road\e-track-2\grass-e2.png"
  File "base\tracks\road\e-track-2\grass-end-e2.png"
  File "base\tracks\road\e-track-2\grass-start-e2.png"
  File "base\tracks\road\e-track-2\gravel-e2.png"
  File "base\tracks\road\e-track-2\gravel-end-e2.png"
  File "base\tracks\road\e-track-2\gravel-start-e2.png"
  File "base\tracks\road\e-track-2\GSPAtree.png"
  File "base\tracks\road\e-track-2\house16roof.png"
  File "base\tracks\road\e-track-2\house17base.png"
  File "base\tracks\road\e-track-2\house17concrete.png"
  File "base\tracks\road\e-track-2\house17elevator.png"
  File "base\tracks\road\e-track-2\house17facade.png"
  File "base\tracks\road\e-track-2\house17roof.png"
  File "base\tracks\road\e-track-2\house18chimney.png"
  File "base\tracks\road\e-track-2\house18facade.png"
  File "base\tracks\road\e-track-2\house18top.png"
  File "base\tracks\road\e-track-2\house20facade.png"
  File "base\tracks\road\e-track-2\house21w1.png"
  File "base\tracks\road\e-track-2\house21w2.png"
  File "base\tracks\road\e-track-2\house22base.png"
  File "base\tracks\road\e-track-2\house22facade.png"
  File "base\tracks\road\e-track-2\house23facade.png"
  File "base\tracks\road\e-track-2\house24brick.png"
  File "base\tracks\road\e-track-2\house24facade.png"
  File "base\tracks\road\e-track-2\house24roof.png"
  File "base\tracks\road\e-track-2\house24timber2.png"
  File "base\tracks\road\e-track-2\house24timber.png"
  File "base\tracks\road\e-track-2\house25ch.png"
  File "base\tracks\road\e-track-2\house25chtop.png"
  File "base\tracks\road\e-track-2\house25elevator.png"
  File "base\tracks\road\e-track-2\house25facade.png"
  File "base\tracks\road\e-track-2\house25roof.png"
  File "base\tracks\road\e-track-2\house25side.png"
  File "base\tracks\road\e-track-2\house26base.png"
  File "base\tracks\road\e-track-2\house26ceil.png"
  File "base\tracks\road\e-track-2\house26elev.png"
  File "base\tracks\road\e-track-2\house26facade.png"
  File "base\tracks\road\e-track-2\house26parking.png"
  File "base\tracks\road\e-track-2\house27facade.png"
  File "base\tracks\road\e-track-2\house27r1.png"
  File "base\tracks\road\e-track-2\house27r2.png"
  File "base\tracks\road\e-track-2\house27side.png"
  File "base\tracks\road\e-track-2\house28facade.png"
  File "base\tracks\road\e-track-2\house31facade.png"
  File "base\tracks\road\e-track-2\house31roof.png"
  File "base\tracks\road\e-track-2\house32facade.png"
  File "base\tracks\road\e-track-2\house32roof.png"
  File "base\tracks\road\e-track-2\house33facade.png"
  File "base\tracks\road\e-track-2\house33side.png"
  File "base\tracks\road\e-track-2\house34facade.png"
  File "base\tracks\road\e-track-2\house34roof.png"
  File "base\tracks\road\e-track-2\house35facade.png"
  File "base\tracks\road\e-track-2\house36facade.png"
  File "base\tracks\road\e-track-2\improveyou-wall.png"
  File "base\tracks\road\e-track-2\IYtree_n.png"
  File "base\tracks\road\e-track-2\LAMAOP.png"
  File "base\tracks\road\e-track-2\MASE01.png"
  File "base\tracks\road\e-track-2\MASE02.png"
  File "base\tracks\road\e-track-2\mycast.png"
  File "base\tracks\road\e-track-2\PASS10.png"
  File "base\tracks\road\e-track-2\PASS3.png"
  File "base\tracks\road\e-track-2\PASS4.png"
  File "base\tracks\road\e-track-2\PDKKA13.png"
  File "base\tracks\road\e-track-2\PITWB.png"
  File "base\tracks\road\e-track-2\pylon1.rgb"
  File "base\tracks\road\e-track-2\pylon2.rgb"
  File "base\tracks\road\e-track-2\pylon3.rgb"
  File "base\tracks\road\e-track-2\raceline.png"
  File "base\tracks\road\e-track-2\readme.txt"
  File "base\tracks\road\e-track-2\road-dirt.png"
  File "base\tracks\road\e-track-2\road-e2.png"
  File "base\tracks\road\e-track-2\rock1-e2.png"
  File "base\tracks\road\e-track-2\rock-wall-e2.png"
  File "base\tracks\road\e-track-2\shadow2.png"
  File "base\tracks\road\e-track-2\shadow2.rgb"
  File "base\tracks\road\e-track-2\STAIRSD.png"
  File "base\tracks\road\e-track-2\STAIRS.png"
  File "base\tracks\road\e-track-2\tent2.png"
  File "base\tracks\road\e-track-2\tire-wall-at.png"
  File "base\tracks\road\e-track-2\tire-wall-green.png"
  File "base\tracks\road\e-track-2\tire-wall-se.png"
  File "base\tracks\road\e-track-2\tire-wall-ur.png"
  File "base\tracks\road\e-track-2\toilette.png"
  File "base\tracks\road\e-track-2\TOPCROWD.png"
  File "base\tracks\road\e-track-2\tree11_n.png"
  File "base\tracks\road\e-track-2\tree18end_n.png"
  File "base\tracks\road\e-track-2\tree18_n.png"
  File "base\tracks\road\e-track-2\tree18side1_n.png"
  File "base\tracks\road\e-track-2\tree18side2_n.png"
  File "base\tracks\road\e-track-2\tree7_n.png"
  File "base\tracks\road\e-track-2\tree9_n.png"
  File "base\tracks\road\e-track-2\tree_eva_n.png"
  File "base\tracks\road\e-track-2\treefc_n.png"
  File "base\tracks\road\e-track-2\TreeRNS3.png"
  File "base\tracks\road\e-track-2\TreeRNS4.png"
  File "base\tracks\road\e-track-2\TreeRNS5.png"
  File "base\tracks\road\e-track-2\treeS3_n.png"
  File "base\tracks\road\e-track-2\treeUGLIES01_n.png"
  File "base\tracks\road\e-track-2\treeUGLIES02_n.png"
  File "base\tracks\road\e-track-2\TRIBA08.png"
  File "base\tracks\road\e-track-2\TRIBA11.png"
  File "base\tracks\road\e-track-2\TRIBB01.png"
  File "base\tracks\road\e-track-2\TRIBB02.png"
  File "base\tracks\road\e-track-2\TRIBB03.png"
  File "base\tracks\road\e-track-2\turn100.png"
  File "base\tracks\road\e-track-2\turn200.png"
  File "base\tracks\road\e-track-2\turn25.png"
  File "base\tracks\road\e-track-2\turn300.png"
  File "base\tracks\road\e-track-2\turn50.png"
  SetOutPath "$INSTDIR\tracks\road\e-track-3"
  File "base\tracks\road\e-track-3\e-track-3.xml"
  File "base\tracks\road\e-track-3\background.png"
  File "base\tracks\road\e-track-3\e-track-3.acc"
  File "base\tracks\road\e-track-3\e-track-3.png"
  File "base\tracks\road\e-track-3\readme.txt"
  File "base\tracks\road\e-track-3\asphalt2-bw-e3.png"
  File "base\tracks\road\e-track-3\asphalt-bw-e3-lines-l.png"
  File "base\tracks\road\e-track-3\asphalt-bw-e3-pit-l.png"
  File "base\tracks\road\e-track-3\asphalt-bw-e3.png"
  File "base\tracks\road\e-track-3\asphalt-white-tile.png"
  File "base\tracks\road\e-track-3\back-sign.png"
  File "base\tracks\road\e-track-3\barrier.png"
  File "base\tracks\road\e-track-3\BLBDBK.png"
  File "base\tracks\road\e-track-3\concrete2.rgb"
  File "base\tracks\road\e-track-3\concrete.rgb"
  File "base\tracks\road\e-track-3\CONCSH01.png"
  File "base\tracks\road\e-track-3\curb-green-carpet.png"
  File "base\tracks\road\e-track-3\curb-red-carpet.png"
  File "base\tracks\road\e-track-3\curb-white-concrete.png"
  File "base\tracks\road\e-track-3\fence_arbor_n.png"
  File "base\tracks\road\e-track-3\grass-e3.png"
  File "base\tracks\road\e-track-3\grass-side-e3.png"
  File "base\tracks\road\e-track-3\logo_megafuel.png"
  File "base\tracks\road\e-track-3\logo_trb2.png"
  File "base\tracks\road\e-track-3\logo_x4y.png"
  File "base\tracks\road\e-track-3\megafuel-wall.png"
  File "base\tracks\road\e-track-3\mycast.png"
  File "base\tracks\road\e-track-3\PASS10.png"
  File "base\tracks\road\e-track-3\PASS3.png"
  File "base\tracks\road\e-track-3\PASS4.png"
  File "base\tracks\road\e-track-3\PDKKA13.png"
  File "base\tracks\road\e-track-3\pylon1.rgb"
  File "base\tracks\road\e-track-3\pylon2.rgb"
  File "base\tracks\road\e-track-3\pylon3.rgb"
  File "base\tracks\road\e-track-3\raceline.png"
  File "base\tracks\road\e-track-3\readme.txt"
  File "base\tracks\road\e-track-3\shadow2.rgb"
  File "base\tracks\road\e-track-3\tirewall.png"
  File "base\tracks\road\e-track-3\tree11_n.png"
  File "base\tracks\road\e-track-3\tree12_n.png"
  File "base\tracks\road\e-track-3\tree195_n.png"
  File "base\tracks\road\e-track-3\tree19_n.png"
  File "base\tracks\road\e-track-3\tree35_n.png"
  File "base\tracks\road\e-track-3\tree4_n.png"
  File "base\tracks\road\e-track-3\treeS3_n.png"
  File "base\tracks\road\e-track-3\treeUGLIES01_n.png"
  File "base\tracks\road\e-track-3\TRIBA08.png"
  File "base\tracks\road\e-track-3\TRIBA11.png"
  File "base\tracks\road\e-track-3\TRIBB01.png"
  File "base\tracks\road\e-track-3\TRIBB02.png"
  File "base\tracks\road\e-track-3\TRIBB03.png"
  File "base\tracks\road\e-track-3\turn100.png"
  File "base\tracks\road\e-track-3\turn200.png"
  File "base\tracks\road\e-track-3\turn25.png"
  File "base\tracks\road\e-track-3\turn300.png"
  File "base\tracks\road\e-track-3\turn50.png"
  SetOutPath "$INSTDIR\tracks\road\e-track-4"
  File "base\tracks\road\e-track-4\background.png"
  File "base\tracks\road\e-track-4\e-track-4.acc"
  File "base\tracks\road\e-track-4\e-track-4.png"
  File "base\tracks\road\e-track-4\raceline.png"
  File "base\tracks\road\e-track-4\e-track-4.xml"
  SetOutPath "$INSTDIR\tracks\road\e-track-6"
  File "base\tracks\road\e-track-6\01.png"
  File "base\tracks\road\e-track-6\02.png"
  File "base\tracks\road\e-track-6\ALAUBM.png"
  File "base\tracks\road\e-track-6\armco.png"
  File "base\tracks\road\e-track-6\background.png"
  File "base\tracks\road\e-track-6\BLBDBK.png"
  File "base\tracks\road\e-track-6\block1.rgb"
  File "base\tracks\road\e-track-6\BRDGA.png"
  File "base\tracks\road\e-track-6\BRDGB.png"
  File "base\tracks\road\e-track-6\BRIQUE.png"
  File "base\tracks\road\e-track-6\BUS.png"
  File "base\tracks\road\e-track-6\CAMPER01.png"
  File "base\tracks\road\e-track-6\CAMPER02.png"
  File "base\tracks\road\e-track-6\CAMPER3.png"
  File "base\tracks\road\e-track-6\CAMPER4.png"
  File "base\tracks\road\e-track-6\CAMPER41.png"
  File "base\tracks\road\e-track-6\CAR01.png"
  File "base\tracks\road\e-track-6\CAR02.png"
  File "base\tracks\road\e-track-6\CAR03.png"
  File "base\tracks\road\e-track-6\CAR04.png"
  File "base\tracks\road\e-track-6\CAR05.png"
  File "base\tracks\road\e-track-6\CAR06.png"
  File "base\tracks\road\e-track-6\CAR07.png"
  File "base\tracks\road\e-track-6\CAR08.png"
  File "base\tracks\road\e-track-6\CHtree_n.png"
  File "base\tracks\road\e-track-6\cliff2.png"
  File "base\tracks\road\e-track-6\CMNTA.png"
  File "base\tracks\road\e-track-6\CMNTB.png"
  File "base\tracks\road\e-track-6\CMNTBB.png"
  File "base\tracks\road\e-track-6\conc.png"
  File "base\tracks\road\e-track-6\concrete.rgb"
  File "base\tracks\road\e-track-6\concrete2.rgb"
  File "base\tracks\road\e-track-6\CONCSH01.png"
  File "base\tracks\road\e-track-6\CONCTP.png"
  File "base\tracks\road\e-track-6\CRNA.png"
  File "base\tracks\road\e-track-6\CRNB.png"
  File "base\tracks\road\e-track-6\CRNC.png"
  File "base\tracks\road\e-track-6\CRND.png"
  File "base\tracks\road\e-track-6\CRNF.png"
  File "base\tracks\road\e-track-6\DIST01.png"
  File "base\tracks\road\e-track-6\DIST03.png"
  File "base\tracks\road\e-track-6\DIST04.png"
  File "base\tracks\road\e-track-6\e-track-6.acc"
  File "base\tracks\road\e-track-6\e-track-6.png"
  File "base\tracks\road\e-track-6\e-track-6.xml"
  File "base\tracks\road\e-track-6\F3BASE.png"
  File "base\tracks\road\e-track-6\FENCWIRE_arbor_n.png"
  File "base\tracks\road\e-track-6\FNCEB.png"
  File "base\tracks\road\e-track-6\GBtree_n.png"
  File "base\tracks\road\e-track-6\GEtree_n.png"
  File "base\tracks\road\e-track-6\GRASS.png"
  File "base\tracks\road\e-track-6\grass3.png"
  File "base\tracks\road\e-track-6\GRASSAND.png"
  File "base\tracks\road\e-track-6\GSPAtree.png"
  File "base\tracks\road\e-track-6\GSTNDA.png"
  File "base\tracks\road\e-track-6\H15FRNT.png"
  File "base\tracks\road\e-track-6\H15RF.png"
  File "base\tracks\road\e-track-6\H15SFRNT.png"
  File "base\tracks\road\e-track-6\H15SIDE1.png"
  File "base\tracks\road\e-track-6\H15SIDE2.png"
  File "base\tracks\road\e-track-6\H15SIDE3.png"
  File "base\tracks\road\e-track-6\H17F1.png"
  File "base\tracks\road\e-track-6\H17F2.png"
  File "base\tracks\road\e-track-6\H17F3.png"
  File "base\tracks\road\e-track-6\H17F4.png"
  File "base\tracks\road\e-track-6\H17F5.png"
  File "base\tracks\road\e-track-6\H17F6.png"
  File "base\tracks\road\e-track-6\H17FA.png"
  File "base\tracks\road\e-track-6\H17FB.png"
  File "base\tracks\road\e-track-6\H17FNT.png"
  File "base\tracks\road\e-track-6\H17SID.png"
  File "base\tracks\road\e-track-6\H17TOP.png"
  File "base\tracks\road\e-track-6\H21F1.png"
  File "base\tracks\road\e-track-6\H21F2.png"
  File "base\tracks\road\e-track-6\H21F3.png"
  File "base\tracks\road\e-track-6\H21F4.png"
  File "base\tracks\road\e-track-6\H21F5.png"
  File "base\tracks\road\e-track-6\H21F6.png"
  File "base\tracks\road\e-track-6\H21FA.png"
  File "base\tracks\road\e-track-6\H21FB.png"
  File "base\tracks\road\e-track-6\H21FNT.png"
  File "base\tracks\road\e-track-6\H21SID.png"
  File "base\tracks\road\e-track-6\H21TOP.png"
  File "base\tracks\road\e-track-6\H25RF.png"
  File "base\tracks\road\e-track-6\H26F1.png"
  File "base\tracks\road\e-track-6\H26F2.png"
  File "base\tracks\road\e-track-6\H26F3.png"
  File "base\tracks\road\e-track-6\H26F4.png"
  File "base\tracks\road\e-track-6\H26F5.png"
  File "base\tracks\road\e-track-6\H26F6.png"
  File "base\tracks\road\e-track-6\H26FA.png"
  File "base\tracks\road\e-track-6\H26FB.png"
  File "base\tracks\road\e-track-6\H26FNT.png"
  File "base\tracks\road\e-track-6\H26SID.png"
  File "base\tracks\road\e-track-6\H26TOP.png"
  File "base\tracks\road\e-track-6\H28FRNT.png"
  File "base\tracks\road\e-track-6\IYtree_n.png"
  File "base\tracks\road\e-track-6\LAMAOP.png"
  File "base\tracks\road\e-track-6\LOGOAG.png"
  File "base\tracks\road\e-track-6\LOGOAG2.png"
  File "base\tracks\road\e-track-6\LOGOAT.png"
  File "base\tracks\road\e-track-6\LOGODUN2.png"
  File "base\tracks\road\e-track-6\LOGOFSTN.png"
  File "base\tracks\road\e-track-6\LOGOGFLG.png"
  File "base\tracks\road\e-track-6\LOGOMBIL.png"
  File "base\tracks\road\e-track-6\LOGOPANA.png"
  File "base\tracks\road\e-track-6\LOGOSUIS.png"
  File "base\tracks\road\e-track-6\LOGOTSUB.png"
  File "base\tracks\road\e-track-6\M40A.png"
  File "base\tracks\road\e-track-6\MASE01.png"
  File "base\tracks\road\e-track-6\MASE02.png"
  File "base\tracks\road\e-track-6\MOB1DUO.png"
  File "base\tracks\road\e-track-6\MUR43A.png"
  File "base\tracks\road\e-track-6\MUR43B.png"
  File "base\tracks\road\e-track-6\OBJA24_arbor_n.png"
  File "base\tracks\road\e-track-6\PDKKA13.png"
  File "base\tracks\road\e-track-6\PITWB.png"
  File "base\tracks\road\e-track-6\pylon1.rgb"
  File "base\tracks\road\e-track-6\RA4BRIG5.png"
  File "base\tracks\road\e-track-6\RDGRTRAN.png"
  File "base\tracks\road\e-track-6\readme.txt"
  File "base\tracks\road\e-track-6\ROAD2_n.png"
  File "base\tracks\road\e-track-6\ROADC.png"
  File "base\tracks\road\e-track-6\roadgras.png"
  File "base\tracks\road\e-track-6\roadgrsd.png"
  File "base\tracks\road\e-track-6\ROADPARK.png"
  File "base\tracks\road\e-track-6\ROADPE_n.png"
  File "base\tracks\road\e-track-6\ROADPL_n.png"
  File "base\tracks\road\e-track-6\ROADPT_n.png"
  File "base\tracks\road\e-track-6\roadsand.png"
  File "base\tracks\road\e-track-6\ROAD_n.png"
  File "base\tracks\road\e-track-6\rroadgrs.png"
  File "base\tracks\road\e-track-6\RSA02.png"
  File "base\tracks\road\e-track-6\S463ET.png"
  File "base\tracks\road\e-track-6\S46POR.png"
  File "base\tracks\road\e-track-6\SAND02.png"
  File "base\tracks\road\e-track-6\SEMA02.png"
  File "base\tracks\road\e-track-6\shadow2.png"
  File "base\tracks\road\e-track-6\shadow2.rgb"
  File "base\tracks\road\e-track-6\shadow3.png"
  File "base\tracks\road\e-track-6\STAIRS.png"
  File "base\tracks\road\e-track-6\STAIRSD.png"
  File "base\tracks\road\e-track-6\TENTG.png"
  File "base\tracks\road\e-track-6\TENTH.png"
  File "base\tracks\road\e-track-6\TOITCAS.png"
  File "base\tracks\road\e-track-6\TOPCROWD.png"
  File "base\tracks\road\e-track-6\torcsad1.rgb"
  File "base\tracks\road\e-track-6\torcsad2.rgb"
  File "base\tracks\road\e-track-6\tree-fir_n.png"
  File "base\tracks\road\e-track-6\tree-pine1_n.png"
  File "base\tracks\road\e-track-6\treefc_n.png"
  File "base\tracks\road\e-track-6\treeline_n.png"
  File "base\tracks\road\e-track-6\TreeRNS3.png"
  File "base\tracks\road\e-track-6\TreeRNS4.png"
  File "base\tracks\road\e-track-6\TreeRNS5.png"
  File "base\tracks\road\e-track-6\treeUGLIES01_n.png"
  File "base\tracks\road\e-track-6\treeUGLIES02_n.png"
  File "base\tracks\road\e-track-6\treeUGLIES04_n.png"
  File "base\tracks\road\e-track-6\tree_apple_n.png"
  File "base\tracks\road\e-track-6\tree_bush_n.png"
  File "base\tracks\road\e-track-6\tree_maple_n.png"
  File "base\tracks\road\e-track-6\TRIBA07_arbor_n.png"
  File "base\tracks\road\e-track-6\TRIBA08.png"
  File "base\tracks\road\e-track-6\TRIBA09_arbor_n.png"
  File "base\tracks\road\e-track-6\TRIBA11.png"
  File "base\tracks\road\e-track-6\TRIBB01.png"
  File "base\tracks\road\e-track-6\TRIBB02.png"
  File "base\tracks\road\e-track-6\TRIBB03.png"
  File "base\tracks\road\e-track-6\wall2.png"
  File "base\tracks\road\e-track-6\WHEEL.png"
  File "base\tracks\road\e-track-6\WHEELS6.png"
  File "base\tracks\road\e-track-6\ZBRID.png"
  File "base\tracks\road\e-track-6\ZPIT.png"
  File "base\tracks\road\e-track-6\ZPIT3.png"
  File "base\tracks\road\e-track-6\raceline.png"
  SetOutPath "$INSTDIR\tracks\road\eroad"
  File "base\tracks\road\eroad\background.png"
  File "base\tracks\road\eroad\eroad.acc"
  File "base\tracks\road\eroad\eroad.png"
  File "base\tracks\road\eroad\raceline.png"
  File "base\tracks\road\eroad\eroad.xml"
  File "base\tracks\road\eroad\readme.txt"
  File "base\tracks\road\eroad\shadow2.rgb"
  File "base\tracks\road\eroad\tr-asphalt-bw1-pits_n.rgb"
  File "base\tracks\road\eroad\tr-asphalt-l2bw1-pe_n.rgb"
  File "base\tracks\road\eroad\tr-asphalt-l2bw1-pl_n.rgb"
  File "base\tracks\road\eroad\tr-asphalt-l2bw1_n.rgb"
  File "base\tracks\road\eroad\tr-barrier-bw2.rgb"
  File "base\tracks\road\eroad\tr-wall-torcs1-left.rgb"
  File "base\tracks\road\eroad\tr-wall-torcs1-right.rgb"
  SetOutPath "$INSTDIR\tracks\road\forza"
  File "base\tracks\road\forza\100.png"
  File "base\tracks\road\forza\300.png"
  File "base\tracks\road\forza\ABtree_n.png"
  File "base\tracks\road\forza\background.png"
  File "base\tracks\road\forza\BAtree_n.png"
  File "base\tracks\road\forza\BEtree_n.png"
  File "base\tracks\road\forza\BLBDBK.png"
  File "base\tracks\road\forza\BLDA.png"
  File "base\tracks\road\forza\BLDAB.png"
  File "base\tracks\road\forza\BLUPOLE.png"
  File "base\tracks\road\forza\BRtree_n.png"
  File "base\tracks\road\forza\BTOWB.png"
  File "base\tracks\road\forza\BUtree_n.png"
  File "base\tracks\road\forza\CAtree_n.png"
  File "base\tracks\road\forza\CHtree_n.png"
  File "base\tracks\road\forza\CMNTA.png"
  File "base\tracks\road\forza\CMNTB.png"
  File "base\tracks\road\forza\CMNTBB.png"
  File "base\tracks\road\forza\conc.png"
  File "base\tracks\road\forza\CONCTP.png"
  File "base\tracks\road\forza\CRNA.png"
  File "base\tracks\road\forza\CRNB.png"
  File "base\tracks\road\forza\CRNC.png"
  File "base\tracks\road\forza\CRND.png"
  File "base\tracks\road\forza\CRNF.png"
  File "base\tracks\road\forza\DBLOGO.png"
  File "base\tracks\road\forza\FERRED.png"
  File "base\tracks\road\forza\FLTBLK.png"
  File "base\tracks\road\forza\FNCEB.png"
  File "base\tracks\road\forza\forza.acc"
  File "base\tracks\road\forza\forza.png"
  File "base\tracks\road\forza\forza.xml"
  File "base\tracks\road\forza\FRRI.png"
  File "base\tracks\road\forza\FRtree_n.png"
  File "base\tracks\road\forza\G2tree_n.png"
  File "base\tracks\road\forza\GBtree_n.png"
  File "base\tracks\road\forza\GCtree_n.png"
  File "base\tracks\road\forza\GDtree_n.png"
  File "base\tracks\road\forza\GEtree_n.png"
  File "base\tracks\road\forza\GFtree_n.png"
  File "base\tracks\road\forza\GGtree.png"
  File "base\tracks\road\forza\GNtree_n.png"
  File "base\tracks\road\forza\GRAS2B.png"
  File "base\tracks\road\forza\GRtree_n.png"
  File "base\tracks\road\forza\GSBLUE.png"
  File "base\tracks\road\forza\GSBSTAIR.png"
  File "base\tracks\road\forza\GSDH.png"
  File "base\tracks\road\forza\GSPAtree.png"
  File "base\tracks\road\forza\GSRNDF.png"
  File "base\tracks\road\forza\GSSOLID.png"
  File "base\tracks\road\forza\GStree_n.png"
  File "base\tracks\road\forza\GSUNDER.png"
  File "base\tracks\road\forza\ITtree_n.png"
  File "base\tracks\road\forza\IYtree_n.png"
  File "base\tracks\road\forza\LIGHT.png"
  File "base\tracks\road\forza\LOGOAGIP.png"
  File "base\tracks\road\forza\LOGOBRDG.png"
  File "base\tracks\road\forza\LOGOBRDS.png"
  File "base\tracks\road\forza\LOGOCAMP.png"
  File "base\tracks\road\forza\LOGOCAST.png"
  File "base\tracks\road\forza\LOGODTWO.png"
  File "base\tracks\road\forza\LOGOFOST.png"
  File "base\tracks\road\forza\LOGOFSTN.png"
  File "base\tracks\road\forza\LOGOITAL.png"
  File "base\tracks\road\forza\LOGOJOE.png"
  File "base\tracks\road\forza\LOGOMAG.png"
  File "base\tracks\road\forza\LOGOMBLO.png"
  File "base\tracks\road\forza\LOGOSELE.png"
  File "base\tracks\road\forza\LOGOSHL.png"
  File "base\tracks\road\forza\MAGNMAR.png"
  File "base\tracks\road\forza\METALA.png"
  File "base\tracks\road\forza\PDtree_n.png"
  File "base\tracks\road\forza\PEtree_n.png"
  File "base\tracks\road\forza\PFtree_n.png"
  File "base\tracks\road\forza\PITBLD.png"
  File "base\tracks\road\forza\PITLITE.png"
  File "base\tracks\road\forza\PITPPL.png"
  File "base\tracks\road\forza\PITWB.png"
  File "base\tracks\road\forza\POLEA.png"
  File "base\tracks\road\forza\POLLOL.png"
  File "base\tracks\road\forza\readme.txt"
  File "base\tracks\road\forza\REF.png"
  File "base\tracks\road\forza\Road-crack1.png"
  File "base\tracks\road\forza\Road-crack2.png"
  File "base\tracks\road\forza\Road.png"
  File "base\tracks\road\forza\ROADPGC.png"
  File "base\tracks\road\forza\ROADPL_n.png"
  File "base\tracks\road\forza\ROADSF_n.png"
  File "base\tracks\road\forza\RSA_n.png"
  File "base\tracks\road\forza\RSDOT_n.png"
  File "base\tracks\road\forza\RSGRAS_n.png"
  File "base\tracks\road\forza\RSROAD_n.png"
  File "base\tracks\road\forza\RSSAGR_n.png"
  File "base\tracks\road\forza\RSSAND_n.png"
  File "base\tracks\road\forza\RS_n.png"
  File "base\tracks\road\forza\SANDT_n.png"
  File "base\tracks\road\forza\SAND_n.png"
  File "base\tracks\road\forza\shadow2.rgb"
  File "base\tracks\road\forza\raceline.png"
  File "base\tracks\road\forza\STAIRS.png"
  File "base\tracks\road\forza\STAIRSD.png"
  File "base\tracks\road\forza\STNDUND.png"
  File "base\tracks\road\forza\STNDUNDR.png"
  File "base\tracks\road\forza\TAGTNTOP.png"
  File "base\tracks\road\forza\TENTA.png"
  File "base\tracks\road\forza\TENTD.png"
  File "base\tracks\road\forza\TENTG.png"
  File "base\tracks\road\forza\TENTH.png"
  File "base\tracks\road\forza\TEtree_n.png"
  File "base\tracks\road\forza\TIME1A.png"
  File "base\tracks\road\forza\TIME1B.png"
  File "base\tracks\road\forza\TIME2A.png"
  File "base\tracks\road\forza\TIME2B.png"
  File "base\tracks\road\forza\TIME2C.png"
  File "base\tracks\road\forza\TIRE2.png"
  File "base\tracks\road\forza\TIRE3.png"
  File "base\tracks\road\forza\TIRE4.png"
  File "base\tracks\road\forza\TIRE4A.png"
  File "base\tracks\road\forza\TNTSHD.png"
  File "base\tracks\road\forza\TOPCROWD.png"
  File "base\tracks\road\forza\tree1_n.png"
  File "base\tracks\road\forza\tree2_n.png"
  File "base\tracks\road\forza\tree3_n.png"
  File "base\tracks\road\forza\treefc_n.png"
  File "base\tracks\road\forza\treel1_n.png"
  File "base\tracks\road\forza\treel2_n.png"
  File "base\tracks\road\forza\treel3_n.png"
  File "base\tracks\road\forza\treel4_n.png"
  File "base\tracks\road\forza\treetd_n.png"
  File "base\tracks\road\forza\TRETRNK.png"
  File "base\tracks\road\forza\TRKJUM.png"
  File "base\tracks\road\forza\TRKJUMA.png"
  File "base\tracks\road\forza\TRKJUMB.png"
  File "base\tracks\road\forza\TRKJUMC.png"
  File "base\tracks\road\forza\TURNA.png"
  File "base\tracks\road\forza\TURNB.png"
  File "base\tracks\road\forza\WAtree_n.png"
  File "base\tracks\road\forza\WHEEL.png"
  File "base\tracks\road\forza\WIREWOOD.png"
  SetOutPath "$INSTDIR\tracks\road\g-track-1"
  File "base\tracks\road\g-track-1\asphalt-bw-g1-1_n.rgb"
  File "base\tracks\road\g-track-1\asphalt-bw-g1-patch-1_n.rgb"
  File "base\tracks\road\g-track-1\asphalt-bw-g1-patch-2_n.rgb"
  File "base\tracks\road\g-track-1\asphalt-bw-g1-patch-3_n.rgb"
  File "base\tracks\road\g-track-1\asphalt-bw-g1-pitentry-side_n.rgb"
  File "base\tracks\road\g-track-1\asphalt-bw-g1-pitentry_n.rgb"
  File "base\tracks\road\g-track-1\asphalt-bw-g1-pit_n.rgb"
  File "base\tracks\road\g-track-1\asphalt-bw-g1-sidel-end_n.rgb"
  File "base\tracks\road\g-track-1\asphalt-bw-g1-sidel-start_n.rgb"
  File "base\tracks\road\g-track-1\asphalt-bw-g1-sidel_n.rgb"
  File "base\tracks\road\g-track-1\background.png"
  File "base\tracks\road\g-track-1\barr1.rgb"
  File "base\tracks\road\g-track-1\earth_and_grass.rgb"
  File "base\tracks\road\g-track-1\facade1-512.rgb"
  File "base\tracks\road\g-track-1\facade6-512.rgb"
  File "base\tracks\road\g-track-1\facade7.rgb"
  File "base\tracks\road\g-track-1\fence-arbor_n.rgb"
  File "base\tracks\road\g-track-1\g-track-1.acc"
  File "base\tracks\road\g-track-1\g-track-1.png"
  File "base\tracks\road\g-track-1\g-track-1.xml"
  File "base\tracks\road\g-track-1\grass-g1.rgb"
  File "base\tracks\road\g-track-1\poutre3_arbor_n.rgb"
  File "base\tracks\road\g-track-1\poutre4.rgb"
  File "base\tracks\road\g-track-1\readme.txt"
  File "base\tracks\road\g-track-1\roof1.rgb"
  File "base\tracks\road\g-track-1\roof3.rgb"
  File "base\tracks\road\g-track-1\shadow2.rgb"
  File "base\tracks\road\g-track-1\spectator.rgb"
  File "base\tracks\road\g-track-1\std.rgb"
  File "base\tracks\road\g-track-1\tarmac-wall-2-g2.rgb"
  File "base\tracks\road\g-track-1\tent.rgb"
  File "base\tracks\road\g-track-1\torcs0_arbor_n.rgb"
  File "base\tracks\road\g-track-1\torcs1.rgb"
  File "base\tracks\road\g-track-1\tr-asphalt-aa-bw1_n.rgb"
  File "base\tracks\road\g-track-1\tree53_n.rgb"
  File "base\tracks\road\g-track-1\truck_arbor_berniw_n.rgb"
  File "base\tracks\road\g-track-1\truck_arbor_bt_n.rgb"
  File "base\tracks\road\g-track-1\truck_arbor_inferno_n.rgb"
  File "base\tracks\road\g-track-1\truck_arbor_speedy_n.rgb"
  File "base\tracks\road\g-track-1\truck_arbor_tita_n.rgb"
  File "base\tracks\road\g-track-1\wall-green-yellow.rgb"
  File "base\tracks\road\g-track-1\wall-grey.rgb"
  File "base\tracks\road\g-track-1\wall4.rgb"
  File "base\tracks\road\g-track-1\raceline.png"  
  SetOutPath "$INSTDIR\tracks\road\g-track-2"
  File "base\tracks\road\g-track-2\alltree.rgb"
  File "base\tracks\road\g-track-2\arbor01.rgb"
  File "base\tracks\road\g-track-2\asconcr.rgb"
  File "base\tracks\road\g-track-2\asphalt.rgb"
  File "base\tracks\road\g-track-2\asphalt4.rgb"
  File "base\tracks\road\g-track-2\asp_n.rgb"
  File "base\tracks\road\g-track-2\background.png"
  File "base\tracks\road\g-track-2\barg2.rgb"
  File "base\tracks\road\g-track-2\barg3.rgb"
  File "base\tracks\road\g-track-2\barr1.rgb"
  File "base\tracks\road\g-track-2\concdal.rgb"
  File "base\tracks\road\g-track-2\g-track-2.acc"
  File "base\tracks\road\g-track-2\g-track-2.png"
  File "base\tracks\road\g-track-2\g-track-2.xml"
  File "base\tracks\road\g-track-2\gconcrete.rgb"
  File "base\tracks\road\g-track-2\grassg1.rgb"
  File "base\tracks\road\g-track-2\grassg3.rgb"
  File "base\tracks\road\g-track-2\gsand.rgb"
  File "base\tracks\road\g-track-2\gtirewall.rgb"
  File "base\tracks\road\g-track-2\poutre3_arbor_n.rgb"
  File "base\tracks\road\g-track-2\poutre4.rgb"
  File "base\tracks\road\g-track-2\readme.txt"
  File "base\tracks\road\g-track-2\rock4.rgb"
  File "base\tracks\road\g-track-2\shadow2.rgb"
  File "base\tracks\road\g-track-2\spec.rgb"
  File "base\tracks\road\g-track-2\std.rgb"
  File "base\tracks\road\g-track-2\tent.rgb"
  File "base\tracks\road\g-track-2\torcs0_arbor_n.rgb"
  File "base\tracks\road\g-track-2\torcs1.rgb"
  File "base\tracks\road\g-track-2\torcs2.rgb"
  File "base\tracks\road\g-track-2\trcurbl.rgb"
  File "base\tracks\road\g-track-2\trcurbr.rgb"
  File "base\tracks\road\g-track-2\treewate.rgb"
  File "base\tracks\road\g-track-2\raceline.png"
  SetOutPath "$INSTDIR\tracks\road\g-track-3"
  File "base\tracks\road\g-track-3\arbor-wood_n.rgb"
  File "base\tracks\road\g-track-3\arbor01.rgb"
  File "base\tracks\road\g-track-3\asasphr.rgb"
  File "base\tracks\road\g-track-3\asconcr.rgb"
  File "base\tracks\road\g-track-3\asgrassr_n.rgb"
  File "base\tracks\road\g-track-3\asphalt4.rgb"
  File "base\tracks\road\g-track-3\asp_n.rgb"
  File "base\tracks\road\g-track-3\assandr.rgb"
  File "base\tracks\road\g-track-3\background.png"
  File "base\tracks\road\g-track-3\barg2.rgb"
  File "base\tracks\road\g-track-3\barg3.rgb"
  File "base\tracks\road\g-track-3\concdal.rgb"
  File "base\tracks\road\g-track-3\g-track-3.acc"
  File "base\tracks\road\g-track-3\g-track-3.png"
  File "base\tracks\road\g-track-3\g-track-3.xml"
  File "base\tracks\road\g-track-3\gconcrete.rgb"
  File "base\tracks\road\g-track-3\ggrass3.rgb"
  File "base\tracks\road\g-track-3\gsand.rgb"
  File "base\tracks\road\g-track-3\gtirewall.rgb"
  File "base\tracks\road\g-track-3\house.rgb"
  File "base\tracks\road\g-track-3\mur2.rgb"
  File "base\tracks\road\g-track-3\readme.txt"
  File "base\tracks\road\g-track-3\road1.rgb"
  File "base\tracks\road\g-track-3\road2.rgb"
  File "base\tracks\road\g-track-3\road3.rgb"
  File "base\tracks\road\g-track-3\road4.rgb"
  File "base\tracks\road\g-track-3\road5.rgb"
  File "base\tracks\road\g-track-3\rockg0.rgb"
  File "base\tracks\road\g-track-3\shadow2.rgb"
  File "base\tracks\road\g-track-3\raceline.png"
  File "base\tracks\road\g-track-3\torcs1.rgb"
  File "base\tracks\road\g-track-3\torcs2.rgb"
  File "base\tracks\road\g-track-3\treebui1.rgb"
  File "base\tracks\road\g-track-3\treeg10.rgb"
  File "base\tracks\road\g-track-3\truck0.rgb"
  File "base\tracks\road\g-track-3\truck1.rgb"
  File "base\tracks\road\g-track-3\walls.rgb"
  File "base\tracks\road\g-track-3\walls2.rgb"
  SetOutPath "$INSTDIR\tracks\road\ole-road-1"
  File "base\tracks\road\ole-road-1\background.png"
  File "base\tracks\road\ole-road-1\close-bush.rgb"
  File "base\tracks\road\ole-road-1\concrete-patch.png"
  File "base\tracks\road\ole-road-1\cracked-asphalt.png"
  File "base\tracks\road\ole-road-1\ole-concrete-pits.png"
  File "base\tracks\road\ole-road-1\ole-concrete-side.png"
  File "base\tracks\road\ole-road-1\ole-road-1.acc"
  File "base\tracks\road\ole-road-1\ole-road-1.png"
  File "base\tracks\road\ole-road-1\raceline.png"
  File "base\tracks\road\ole-road-1\ole-road-1.xml"
  File "base\tracks\road\ole-road-1\patched-asphalt-1.png"
  File "base\tracks\road\ole-road-1\patched-asphalt-2.png"
  File "base\tracks\road\ole-road-1\readme.txt"
  File "base\tracks\road\ole-road-1\shadow2.rgb"
  File "base\tracks\road\ole-road-1\tr-asphalt-l_nmm.rgb"
  SetOutPath "$INSTDIR\tracks\road\ruudskogen"
  File "base\tracks\road\ruudskogen\arb01_n.png"
  File "base\tracks\road\ruudskogen\arb02_n.png"
  File "base\tracks\road\ruudskogen\background.png"
  File "base\tracks\road\ruudskogen\dekk01.png"
  File "base\tracks\road\ruudskogen\env.png"
  File "base\tracks\road\ruudskogen\grass01.png"
  File "base\tracks\road\ruudskogen\grass02.png"
  File "base\tracks\road\ruudskogen\hus02.png"
  File "base\tracks\road\ruudskogen\hytte01.png"
  File "base\tracks\road\ruudskogen\lave01.png"
  File "base\tracks\road\ruudskogen\lave02.png"
  File "base\tracks\road\ruudskogen\readme.txt"
  File "base\tracks\road\ruudskogen\rk_tree_1_n.png"
  File "base\tracks\road\ruudskogen\rk_tree_2_n.png"
  File "base\tracks\road\ruudskogen\rk_tree_3_n.png"
  File "base\tracks\road\ruudskogen\road-edge.png"
  File "base\tracks\road\ruudskogen\road01-dashlines.png"
  File "base\tracks\road\ruudskogen\road01-pitentry.png"
  File "base\tracks\road\ruudskogen\road01-pits_n.png"
  File "base\tracks\road\ruudskogen\road01.png"
  File "base\tracks\road\ruudskogen\road02.png"
  File "base\tracks\road\ruudskogen\road03.png"
  File "base\tracks\road\ruudskogen\ruudskogen.acc"
  File "base\tracks\road\ruudskogen\ruudskogen.png"
  File "base\tracks\road\ruudskogen\ruudskogen.xml"
  File "base\tracks\road\ruudskogen\ruudskog_arbor.png"
  File "base\tracks\road\ruudskogen\sand01.png"
  File "base\tracks\road\ruudskogen\raceline.png"
  File "base\tracks\road\ruudskogen\shadow2.rgb"
  SetOutPath "$INSTDIR\tracks\road\spring"
  File "base\tracks\road\spring\spring.acc"
  File "base\tracks\road\spring\raceline.png"
  File "base\tracks\road\spring\background.png"
  File "base\tracks\road\spring\spring.xml"
  File "base\tracks\road\spring\spring.png"
  SetOutPath "$INSTDIR\tracks\road\street-1"
  File "base\tracks\road\street-1\background.png"
  File "base\tracks\road\street-1\barr1.rgb"
  File "base\tracks\road\street-1\concdal.rgb"
  File "base\tracks\road\street-1\grass-aa.rgb"
  File "base\tracks\road\street-1\house.rgb"
  File "base\tracks\road\street-1\poutre3_arbor_n.rgb"
  File "base\tracks\road\street-1\readme.txt"
  File "base\tracks\road\street-1\roof1.rgb"
  File "base\tracks\road\street-1\shadow2.rgb"
  File "base\tracks\road\street-1\std.rgb"
  File "base\tracks\road\street-1\street-1.acc"
  File "base\tracks\road\street-1\street-1.png"
  File "base\tracks\road\street-1\street-1.xml"
  File "base\tracks\road\street-1\texte1.png"
  File "base\tracks\road\street-1\torcs1.rgb"
  File "base\tracks\road\street-1\town-border-arbor.png"
  File "base\tracks\road\street-1\tr-asphalt-2-aa-r_n.png"
  File "base\tracks\road\street-1\tr-asphalt-aa-bw1_n.rgb"
  File "base\tracks\road\street-1\tr-building1.rgb"
  File "base\tracks\road\street-1\tr-building2.rgb"
  File "base\tracks\road\street-1\tr-building3.rgb"
  File "base\tracks\road\street-1\tr-building5.rgb"
  File "base\tracks\road\street-1\tr-building6.rgb"
  File "base\tracks\road\street-1\tr-building7.rgb"
  File "base\tracks\road\street-1\tr-building8.rgb"
  File "base\tracks\road\street-1\tr-building9.rgb"
  File "base\tracks\road\street-1\tr-curb-bw-aa-r.rgb"
  File "base\tracks\road\street-1\tr-house-arbor2_n.png"
  File "base\tracks\road\street-1\tr-house-arbor_n.png"
  File "base\tracks\road\street-1\tr-road1-pit_n.rgb"
  File "base\tracks\road\street-1\tr-road1_n.rgb"
  File "base\tracks\road\street-1\tr-spec.png"
  File "base\tracks\road\street-1\tree-border_n.rgb"
  File "base\tracks\road\street-1\tree-new_n.rgb"
  File "base\tracks\road\street-1\tree-poplar_n.rgb"
  File "base\tracks\road\street-1\treeg10_n.rgb"
  File "base\tracks\road\street-1\truck0.rgb"
  File "base\tracks\road\street-1\truck_arbor_ctd_n.rgb"
  File "base\tracks\road\street-1\walls.rgb"
  File "base\tracks\road\street-1\walls2.rgb"
  File "base\tracks\road\street-1\raceline.png"
  SetOutPath "$INSTDIR\tracks\road\wheel-1"
  File "base\tracks\road\wheel-1\wheel-1.xml"
  File "base\tracks\road\wheel-1\background.png"
  File "base\tracks\road\wheel-1\wheel-1.acc"
  File "base\tracks\road\wheel-1\wheel-1.png"
  File "base\tracks\road\wheel-1\readme.txt"
  File "base\tracks\road\wheel-1\asphalt2-bw-w1.png"
  File "base\tracks\road\wheel-1\asphalt-border-bw-w1.png"
  File "base\tracks\road\wheel-1\asphalt-bw-w1-lines-l.png"
  File "base\tracks\road\wheel-1\asphalt-bw-w1-pit-l.png"
  File "base\tracks\road\wheel-1\asphalt-bw-w1.png"
  File "base\tracks\road\wheel-1\asphalt-white-tile.png"
  File "base\tracks\road\wheel-1\back-sign.png"
  File "base\tracks\road\wheel-1\barrier-metal-bw-w1.png"
  File "base\tracks\road\wheel-1\BLBDBK.png"
  File "base\tracks\road\wheel-1\block4f.png"
  File "base\tracks\road\wheel-1\block4s.png"
  File "base\tracks\road\wheel-1\concrete2.rgb"
  File "base\tracks\road\wheel-1\concrete.rgb"
  File "base\tracks\road\wheel-1\CONCSH01.png"
  File "base\tracks\road\wheel-1\curb-yellow-blue.png"
  File "base\tracks\road\wheel-1\curb-yellow-red.png"
  File "base\tracks\road\wheel-1\fence_arbor_n.png"
  File "base\tracks\road\wheel-1\flatspot-wall.png"
  File "base\tracks\road\wheel-1\garage1.png"
  File "base\tracks\road\wheel-1\garage2.png"
  File "base\tracks\road\wheel-1\garage3.png"
  File "base\tracks\road\wheel-1\garage5.png"
  File "base\tracks\road\wheel-1\grass-border-bw-w1.png"
  File "base\tracks\road\wheel-1\grass-bw-w1.png"
  File "base\tracks\road\wheel-1\grass-grey-bw-w1.png"
  File "base\tracks\road\wheel-1\house10f.png"
  File "base\tracks\road\wheel-1\house10r.png"
  File "base\tracks\road\wheel-1\logo_cmyk.png"
  File "base\tracks\road\wheel-1\logo_flatspot.png"
  File "base\tracks\road\wheel-1\logo_trb2.png"
  File "base\tracks\road\wheel-1\mycast.png"
  File "base\tracks\road\wheel-1\PASS10.png"
  File "base\tracks\road\wheel-1\PASS3.png"
  File "base\tracks\road\wheel-1\PASS4.png"
  File "base\tracks\road\wheel-1\PDKKA13.png"
  File "base\tracks\road\wheel-1\pylon1.rgb"
  File "base\tracks\road\wheel-1\pylon2.rgb"
  File "base\tracks\road\wheel-1\pylon3.rgb"
  File "base\tracks\road\wheel-1\raceline.png"
  File "base\tracks\road\wheel-1\rock1-w1.png"
  File "base\tracks\road\wheel-1\sand-border-bw-w1.png"
  File "base\tracks\road\wheel-1\sand-bw-w1.png"
  File "base\tracks\road\wheel-1\shadow2.rgb"
  File "base\tracks\road\wheel-1\shadow3.png"
  File "base\tracks\road\wheel-1\tirewall.png"
  File "base\tracks\road\wheel-1\tree2_n.png"
  File "base\tracks\road\wheel-1\tree5_n.png"
  File "base\tracks\road\wheel-1\tree6_n.png"
  File "base\tracks\road\wheel-1\tree7_n.png"
  File "base\tracks\road\wheel-1\tree8_n.png"
  File "base\tracks\road\wheel-1\treeS3_n.png"
  File "base\tracks\road\wheel-1\treeUGLIES01_n.png"
  File "base\tracks\road\wheel-1\TRIBA08.png"
  File "base\tracks\road\wheel-1\TRIBA11.png"
  File "base\tracks\road\wheel-1\TRIBB01.png"
  File "base\tracks\road\wheel-1\TRIBB02.png"
  File "base\tracks\road\wheel-1\TRIBB03.png"
  File "base\tracks\road\wheel-1\truck_arbor_bt_n.png"
  File "base\tracks\road\wheel-1\truck_arbor_cylos_n.png"
  File "base\tracks\road\wheel-1\turn100.png"
  File "base\tracks\road\wheel-1\turn200.png"
  File "base\tracks\road\wheel-1\turn25.png"
  File "base\tracks\road\wheel-1\turn50.png"
  SetOutPath "$INSTDIR\tracks\road\wheel-2"
  File "base\tracks\road\wheel-2\asphalt-pit_n.png"
  File "base\tracks\road\wheel-2\asphalt-sidel_n.png"
  File "base\tracks\road\wheel-2\asphalt_mr-pitentry_n.png"
  File "base\tracks\road\wheel-2\asphalt_n.png"
  File "base\tracks\road\wheel-2\background.png"
  File "base\tracks\road\wheel-2\barr1_n.rgb"
  File "base\tracks\road\wheel-2\building1.png"
  File "base\tracks\road\wheel-2\building2.png"
  File "base\tracks\road\wheel-2\clkdtm.png"
  File "base\tracks\road\wheel-2\concdal.rgb"
  File "base\tracks\road\wheel-2\girder_tree_n.png"
  File "base\tracks\road\wheel-2\grass.png"
  File "base\tracks\road\wheel-2\readme.txt"
  File "base\tracks\road\wheel-2\rmbl.png"
  File "base\tracks\road\wheel-2\sand.png"
  File "base\tracks\road\wheel-2\sbridge2.png"
  File "base\tracks\road\wheel-2\shadow2.png"
  File "base\tracks\road\wheel-2\shadow2.rgb"
  File "base\tracks\road\wheel-2\sign1.png"
  File "base\tracks\road\wheel-2\sign2.png"
  File "base\tracks\road\wheel-2\sign3.png"
  File "base\tracks\road\wheel-2\swall2.png"
  File "base\tracks\road\wheel-2\texwheel.rgb"
  File "base\tracks\road\wheel-2\tirewall.png"
  File "base\tracks\road\wheel-2\torcs1.rgb"
  File "base\tracks\road\wheel-2\tr-barrier-tree_n.png"
  File "base\tracks\road\wheel-2\tr-barrier.png"
  File "base\tracks\road\wheel-2\tr-spec.png"
  File "base\tracks\road\wheel-2\treeg11_n.png"
  File "base\tracks\road\wheel-2\treeline.png"
  File "base\tracks\road\wheel-2\tree_n.png"
  File "base\tracks\road\wheel-2\truck0.rgb"
  File "base\tracks\road\wheel-2\truck_arbor_ctd_n.png"
  File "base\tracks\road\wheel-2\water_green2.png"
  File "base\tracks\road\wheel-2\wheel-2.acc"
  File "base\tracks\road\wheel-2\wheel-2.png"
  File "base\tracks\road\wheel-2\wheel-2.xml"
  File "base\tracks\road\wheel-2\wheel.png"
  File "base\tracks\road\wheel-2\raceline.png"
  
SetOutPath "$INSTDIR\tracks\road\brondehach"
  File "base\tracks\road\brondehach\01.png"
  File "base\tracks\road\brondehach\02.png"
  File "base\tracks\road\brondehach\ALAUBM.png"
  File "base\tracks\road\brondehach\ASSSEM3.png"
  File "base\tracks\road\brondehach\ASSSEM7.png"
  File "base\tracks\road\brondehach\AUDI01.png"
  File "base\tracks\road\brondehach\AUDI02.png"
  File "base\tracks\road\brondehach\background.png"
  File "base\tracks\road\brondehach\BMW01.png"
  File "base\tracks\road\brondehach\BMW02.png"
  File "base\tracks\road\brondehach\BRDG2AB.png"
  File "base\tracks\road\brondehach\BRIDGEAD.png"
  File "base\tracks\road\brondehach\brondehach.acc"
  File "base\tracks\road\brondehach\brondehach.png"
  File "base\tracks\road\brondehach\brondehach.xml"
  File "base\tracks\road\brondehach\BUS.png"
  File "base\tracks\road\brondehach\CAMPER01.png"
  File "base\tracks\road\brondehach\CAMPER02.png"
  File "base\tracks\road\brondehach\CAMPER3.png"
  File "base\tracks\road\brondehach\CAMPER4.png"
  File "base\tracks\road\brondehach\CAMPER41.png"
  File "base\tracks\road\brondehach\concrete2.png"
  File "base\tracks\road\brondehach\CONCRETW.png"
  File "base\tracks\road\brondehach\CONCSH01.png"
  File "base\tracks\road\brondehach\CONCSH02.png"
  File "base\tracks\road\brondehach\CWALLPT1.png"
  File "base\tracks\road\brondehach\CWALLPT2_arbor_n.png"
  File "base\tracks\road\brondehach\CWALLPT4.png"
  File "base\tracks\road\brondehach\DIST01.png"
  File "base\tracks\road\brondehach\DIST02.png"
  File "base\tracks\road\brondehach\DIST03.png"
  File "base\tracks\road\brondehach\DIST04.png"
  File "base\tracks\road\brondehach\FENCWIRE_arbor_n.png"
  File "base\tracks\road\brondehach\GARAGE01.png"
  File "base\tracks\road\brondehach\GARAGE02.png"
  File "base\tracks\road\brondehach\GRASS01.png"
  File "base\tracks\road\brondehach\GRASS02.png"
  File "base\tracks\road\brondehach\GRASS03.png"
  File "base\tracks\road\brondehach\GRASS04.png"
  File "base\tracks\road\brondehach\GRASS05.png"
  File "base\tracks\road\brondehach\GRASS06.png"
  File "base\tracks\road\brondehach\GRASS07.png"
  File "base\tracks\road\brondehach\GRASS08.png"
  File "base\tracks\road\brondehach\INFOMICH.png"
  File "base\tracks\road\brondehach\ISL1.png"
  File "base\tracks\road\brondehach\LAMAOP.png"
  File "base\tracks\road\brondehach\LANCIA01.png"
  File "base\tracks\road\brondehach\LANCIA02.png"
  File "base\tracks\road\brondehach\LOGOALP1.png"
  File "base\tracks\road\brondehach\LOGOCANO.png"
  File "base\tracks\road\brondehach\LOGODUN2.png"
  File "base\tracks\road\brondehach\LOGOFIRE.png"
  File "base\tracks\road\brondehach\LOGOHAN2.png"
  File "base\tracks\road\brondehach\LOGOHILL.png"
  File "base\tracks\road\brondehach\LOGOKAWA.png"
  File "base\tracks\road\brondehach\LOGOMBIL.png"
  File "base\tracks\road\brondehach\LOGOMON2.png"
  File "base\tracks\road\brondehach\LOGONGKB.png"
  File "base\tracks\road\brondehach\LOGOSH2.png"
  File "base\tracks\road\brondehach\LOGOSHLL.png"
  File "base\tracks\road\brondehach\LOGOYAM2.png"
  File "base\tracks\road\brondehach\MASE01.png"
  File "base\tracks\road\brondehach\MASE02.png"
  File "base\tracks\road\brondehach\MCN.png"
  File "base\tracks\road\brondehach\MOB1DUO.png"
  File "base\tracks\road\brondehach\OBJA01.png"
  File "base\tracks\road\brondehach\OBJA02.png"
  File "base\tracks\road\brondehach\OBJA03.png"
  File "base\tracks\road\brondehach\OBJA04.png"
  File "base\tracks\road\brondehach\OBJA05.png"
  File "base\tracks\road\brondehach\OBJA06.png"
  File "base\tracks\road\brondehach\OBJA07.png"
  File "base\tracks\road\brondehach\OBJA08.png"
  File "base\tracks\road\brondehach\OBJA09.png"
  File "base\tracks\road\brondehach\OBJA10.png"
  File "base\tracks\road\brondehach\OBJA11.png"
  File "base\tracks\road\brondehach\OBJA12.png"
  File "base\tracks\road\brondehach\OBJA13.png"
  File "base\tracks\road\brondehach\OBJA14.png"
  File "base\tracks\road\brondehach\OBJA15.png"
  File "base\tracks\road\brondehach\OBJA16.png"
  File "base\tracks\road\brondehach\OBJA17.png"
  File "base\tracks\road\brondehach\OBJA18.png"
  File "base\tracks\road\brondehach\OBJA19.png"
  File "base\tracks\road\brondehach\OBJA20.png"
  File "base\tracks\road\brondehach\OBJA21.png"
  File "base\tracks\road\brondehach\OBJA22.png"
  File "base\tracks\road\brondehach\OBJA24_arbor_n.png"
  File "base\tracks\road\brondehach\OPEL01.png"
  File "base\tracks\road\brondehach\OPEL02.png"
  File "base\tracks\road\brondehach\PALAZA01.png"
  File "base\tracks\road\brondehach\PALAZA02.png"
  File "base\tracks\road\brondehach\PALAZA03.png"
  File "base\tracks\road\brondehach\PALAZA04.png"
  File "base\tracks\road\brondehach\PALAZA05.png"
  File "base\tracks\road\brondehach\PALAZA06.png"
  File "base\tracks\road\brondehach\PALAZA07.png"
  File "base\tracks\road\brondehach\PALAZA09.png"
  File "base\tracks\road\brondehach\PALAZA10.png"
  File "base\tracks\road\brondehach\PALAZA11.png"
  File "base\tracks\road\brondehach\PALAZA12.png"
  File "base\tracks\road\brondehach\PALAZA13.png"
  File "base\tracks\road\brondehach\PALAZA16.png"
  File "base\tracks\road\brondehach\PALAZA17.png"
  File "base\tracks\road\brondehach\PALAZA22.png"
  File "base\tracks\road\brondehach\PALAZA23_arbor_n.png"
  File "base\tracks\road\brondehach\PALAZA24.png"
  File "base\tracks\road\brondehach\PALAZB01.png"
  File "base\tracks\road\brondehach\PALAZB02.png"
  File "base\tracks\road\brondehach\PALAZB03.png"
  File "base\tracks\road\brondehach\PALAZB04.png"
  File "base\tracks\road\brondehach\PALAZB06.png"
  File "base\tracks\road\brondehach\PALAZB07.png"
  File "base\tracks\road\brondehach\PALAZB08.png"
  File "base\tracks\road\brondehach\PALAZB11.png"
  File "base\tracks\road\brondehach\PALAZB12.png"
  File "base\tracks\road\brondehach\PALAZB13_arbor_n.png"
  File "base\tracks\road\brondehach\PALAZB14_arbor_n.png"
  File "base\tracks\road\brondehach\PALAZB15.png"
  File "base\tracks\road\brondehach\PALAZB16_arbor_n.png"
  File "base\tracks\road\brondehach\PALAZB17.png"
  File "base\tracks\road\brondehach\PALAZB18.png"
  File "base\tracks\road\brondehach\PALAZB19.png"
  File "base\tracks\road\brondehach\PDKKA01.png"
  File "base\tracks\road\brondehach\PDKKA01T.png"
  File "base\tracks\road\brondehach\PDKKA01Y.png"
  File "base\tracks\road\brondehach\PDKKA02.png"
  File "base\tracks\road\brondehach\PDKKA03.png"
  File "base\tracks\road\brondehach\PDKKA05.png"
  File "base\tracks\road\brondehach\PDKKA06.png"
  File "base\tracks\road\brondehach\PDKKA07.png"
  File "base\tracks\road\brondehach\PDKKA08.png"
  File "base\tracks\road\brondehach\PDKKA10.png"
  File "base\tracks\road\brondehach\PDKKA11.png"
  File "base\tracks\road\brondehach\PDKKA12.png"
  File "base\tracks\road\brondehach\PDKKA13.png"
  File "base\tracks\road\brondehach\PDKKA13b.png"
  File "base\tracks\road\brondehach\PDKKA14.png"
  File "base\tracks\road\brondehach\PDKKA15.png"
  File "base\tracks\road\brondehach\PDKKA18.png"
  File "base\tracks\road\brondehach\PDKKA19.png"
  File "base\tracks\road\brondehach\PDKKA20.png"
  File "base\tracks\road\brondehach\PDKKA21.png"
  File "base\tracks\road\brondehach\PDKKA22.png"
  File "base\tracks\road\brondehach\PDKKA23.png"
  File "base\tracks\road\brondehach\PDKKA24.png"
  File "base\tracks\road\brondehach\PDKKA25.png"
  File "base\tracks\road\brondehach\PDKKA9A.png"
  File "base\tracks\road\brondehach\RAX01.png"
  File "base\tracks\road\brondehach\readme.txt"
  File "base\tracks\road\brondehach\road01.png"
  File "base\tracks\road\brondehach\ROAD02.png"
  File "base\tracks\road\brondehach\ROAD05.png"
  File "base\tracks\road\brondehach\ROAD06.png"
  File "base\tracks\road\brondehach\road08.png"
  File "base\tracks\road\brondehach\roaddk.png"
  File "base\tracks\road\brondehach\roaddt.png"
  File "base\tracks\road\brondehach\ROADPARK.png"
  File "base\tracks\road\brondehach\ROADPIT4.png"
  File "base\tracks\road\brondehach\RSA01.png"
  File "base\tracks\road\brondehach\RSA02.png"
  File "base\tracks\road\brondehach\SAND01.png"
  File "base\tracks\road\brondehach\SAND02.png"
  File "base\tracks\road\brondehach\SEMA02.png"
  File "base\tracks\road\brondehach\SEMA03.png"
  File "base\tracks\road\brondehach\SEMA04.png"
  File "base\tracks\road\brondehach\shadow2.png"
  File "base\tracks\road\brondehach\shadow2.rgb"
  File "base\tracks\road\brondehach\STLIGHT.png"
  File "base\tracks\road\brondehach\STLINE.png"
  File "base\tracks\road\brondehach\TANKER.png"
  File "base\tracks\road\brondehach\TIREBLAK.png"
  File "base\tracks\road\brondehach\TIREBLAK2.png"
  File "base\tracks\road\brondehach\tr-asphalt.png"
  File "base\tracks\road\brondehach\tree1_n.png"
  File "base\tracks\road\brondehach\tree2_n.png"
  File "base\tracks\road\brondehach\treebit1_n.png"
  File "base\tracks\road\brondehach\treebit2_n.png"
  File "base\tracks\road\brondehach\treeq1.png"
  File "base\tracks\road\brondehach\treeq2_n.png"
  File "base\tracks\road\brondehach\treeUGLIES01_n.png"
  File "base\tracks\road\brondehach\treeUGLIES02_n.png"
  File "base\tracks\road\brondehach\treeUGLIES03_n.png"
  File "base\tracks\road\brondehach\TRETRNK.png"
  File "base\tracks\road\brondehach\TRIBA01.png"
  File "base\tracks\road\brondehach\TRIBA02.png"
  File "base\tracks\road\brondehach\TRIBA03.png"
  File "base\tracks\road\brondehach\TRIBA04.png"
  File "base\tracks\road\brondehach\TRIBA05.png"
  File "base\tracks\road\brondehach\TRIBA06_arbor_n.png"
  File "base\tracks\road\brondehach\TRIBA07_arbor_n.png"
  File "base\tracks\road\brondehach\TRIBA08.png"
  File "base\tracks\road\brondehach\TRIBA09_arbor_n.png"
  File "base\tracks\road\brondehach\TRIBA10.png"
  File "base\tracks\road\brondehach\TRIBA11.png"
  File "base\tracks\road\brondehach\TRIBA12.png"
  File "base\tracks\road\brondehach\TRIBA13.png"
  File "base\tracks\road\brondehach\TRIBA14.png"
  File "base\tracks\road\brondehach\TRIBA15.png"
  File "base\tracks\road\brondehach\TRIBA16.png"
  File "base\tracks\road\brondehach\TRIBA17_arbor_n.png"
  File "base\tracks\road\brondehach\TRIBB01.png"
  File "base\tracks\road\brondehach\TRIBB02.png"
  File "base\tracks\road\brondehach\TRIBB03.png"
  File "base\tracks\road\brondehach\tr-road1.png"
  File "base\tracks\road\brondehach\tr-road1-border.png"
  File "base\tracks\road\brondehach\tr-road1-pit.png"
  File "base\tracks\road\brondehach\TRUCK01.png"
  File "base\tracks\road\brondehach\TRUCK02.png"
  File "base\tracks\road\brondehach\TRUCK05.png"
  File "base\tracks\road\brondehach\TRUCK06.png"
  File "base\tracks\road\brondehach\TRUCK07.png"
  File "base\tracks\road\brondehach\TRUCK08.png"
  File "base\tracks\road\brondehach\TRUCK09.png"
  File "base\tracks\road\brondehach\TRUCK11.png"
  File "base\tracks\road\brondehach\TRUCK12.png"
  File "base\tracks\road\brondehach\TRUCK13.png"
  File "base\tracks\road\brondehach\wall.png"
  File "base\tracks\road\brondehach\WHEELS6.png"
  File "base\tracks\road\brondehach\XRW1.png"
  File "base\tracks\road\brondehach\XRW1SHD1.png"
  File "base\tracks\road\brondehach\raceline.png"

SetOutPath "$INSTDIR\tracks\road\corkscrew"
  File "base\tracks\road\corkscrew\01.png"
  File "base\tracks\road\corkscrew\02.png"
  File "base\tracks\road\corkscrew\64PASS1.png"
  File "base\tracks\road\corkscrew\64PASS6.png"
  File "base\tracks\road\corkscrew\64PASS9.png"
  File "base\tracks\road\corkscrew\ALFABLK.png"
  File "base\tracks\road\corkscrew\asphalt.png"
  File "base\tracks\road\corkscrew\asphalt2.png"
  File "base\tracks\road\corkscrew\asphalt-h.png"
  File "base\tracks\road\corkscrew\asphalt-he.png"
  File "base\tracks\road\corkscrew\asphalt-hs.png"
  File "base\tracks\road\corkscrew\asphalt-l.png"
  File "base\tracks\road\corkscrew\asphalt-le.png"
  File "base\tracks\road\corkscrew\asphalt-ls.png"
  File "base\tracks\road\corkscrew\asphdots_n.png"
  File "base\tracks\road\corkscrew\asphsand_n.png"
  File "base\tracks\road\corkscrew\asphside_n.png"
  File "base\tracks\road\corkscrew\background.png"
  File "base\tracks\road\corkscrew\back-sign.png"
  File "base\tracks\road\corkscrew\BAR1.png"
  File "base\tracks\road\corkscrew\BAR2.png"
  File "base\tracks\road\corkscrew\BAR3.png"
  File "base\tracks\road\corkscrew\BOX1.png"
  File "base\tracks\road\corkscrew\BUS.png"
  File "base\tracks\road\corkscrew\CAMP.png"
  File "base\tracks\road\corkscrew\CAMPER1.png"
  File "base\tracks\road\corkscrew\CAMPER2.png"
  File "base\tracks\road\corkscrew\CAMPER3.png"
  File "base\tracks\road\corkscrew\CAMPER4.png"
  File "base\tracks\road\corkscrew\CAR01.png"
  File "base\tracks\road\corkscrew\CAR02.png"
  File "base\tracks\road\corkscrew\CAR05.png"
  File "base\tracks\road\corkscrew\CAR06.png"
  File "base\tracks\road\corkscrew\CAR07.png"
  File "base\tracks\road\corkscrew\CAR08.png"
  File "base\tracks\road\corkscrew\CARS1.png"
  File "base\tracks\road\corkscrew\CARS2.png"
  File "base\tracks\road\corkscrew\CASA1.png"
  File "base\tracks\road\corkscrew\CASA2.png"
  File "base\tracks\road\corkscrew\CASOT1.png"
  File "base\tracks\road\corkscrew\CASOT2.png"
  File "base\tracks\road\corkscrew\clkdtm.png"
  File "base\tracks\road\corkscrew\concrete.png"
  File "base\tracks\road\corkscrew\concrete2.png"
  File "base\tracks\road\corkscrew\corkscrew.acc"
  File "base\tracks\road\corkscrew\corkscrew.png"
  File "base\tracks\road\corkscrew\corkscrew.xml"
  File "base\tracks\road\corkscrew\corkscrew_arbor.png"
  File "base\tracks\road\corkscrew\CROWD5.png"
  File "base\tracks\road\corkscrew\dekk01.png"
  File "base\tracks\road\corkscrew\dekk02.png"
  File "base\tracks\road\corkscrew\FURGONE.png"
  File "base\tracks\road\corkscrew\GARAGE1.png"
  File "base\tracks\road\corkscrew\GARAGE2.png"
  File "base\tracks\road\corkscrew\GARAGE3.png"
  File "base\tracks\road\corkscrew\grassclf.png"
  File "base\tracks\road\corkscrew\grassct.png"
  File "base\tracks\road\corkscrew\grasshil.png"
  File "base\tracks\road\corkscrew\grassnew.png"
  File "base\tracks\road\corkscrew\grasssnd.png"
  File "base\tracks\road\corkscrew\gravel.png"
  File "base\tracks\road\corkscrew\kilo.png"
  File "base\tracks\road\corkscrew\lgtgrn.png"
  File "base\tracks\road\corkscrew\lgtred.png"
  File "base\tracks\road\corkscrew\lgtyel.png"
  File "base\tracks\road\corkscrew\MASE01.png"
  File "base\tracks\road\corkscrew\MASE02.png"
  File "base\tracks\road\corkscrew\MONSTART.png"
  File "base\tracks\road\corkscrew\PAD1.png"
  File "base\tracks\road\corkscrew\PAD1a.png"
  File "base\tracks\road\corkscrew\PAD2.png"
  File "base\tracks\road\corkscrew\PAD5.png"
  File "base\tracks\road\corkscrew\PAD6.png"
  File "base\tracks\road\corkscrew\PAD8.png"
  File "base\tracks\road\corkscrew\PADWIN1.png"
  File "base\tracks\road\corkscrew\PADWIN2.png"
  File "base\tracks\road\corkscrew\PASS1.png"
  File "base\tracks\road\corkscrew\PASS10.png"
  File "base\tracks\road\corkscrew\PASS2.png"
  File "base\tracks\road\corkscrew\PASS3.png"
  File "base\tracks\road\corkscrew\PASS4.png"
  File "base\tracks\road\corkscrew\PASS7.png"
  File "base\tracks\road\corkscrew\PASS8.png"
  File "base\tracks\road\corkscrew\PEP1.png"
  File "base\tracks\road\corkscrew\pylon3.png"
  File "base\tracks\road\corkscrew\readme.txt"
  File "base\tracks\road\corkscrew\ROAD.png"
  File "base\tracks\road\corkscrew\ROAD4.png"
  File "base\tracks\road\corkscrew\ROAD7.png"
  File "base\tracks\road\corkscrew\roadA-pit.png"
  File "base\tracks\road\corkscrew\RSA3.png"
  File "base\tracks\road\corkscrew\RV1.png"
  File "base\tracks\road\corkscrew\RV2.png"
  File "base\tracks\road\corkscrew\RV3.png"
  File "base\tracks\road\corkscrew\RV4.png"
  File "base\tracks\road\corkscrew\RV5.png"
  File "base\tracks\road\corkscrew\RV6.png"
  File "base\tracks\road\corkscrew\sandgrvl.png"
  File "base\tracks\road\corkscrew\sand-new.png"
  File "base\tracks\road\corkscrew\sandwtr.png"
  File "base\tracks\road\corkscrew\shadow.png"
  File "base\tracks\road\corkscrew\shadow2.png"
  File "base\tracks\road\corkscrew\shadow2.rgb"
  File "base\tracks\road\corkscrew\STAGE2.png"
  File "base\tracks\road\corkscrew\TENT2_D.png"
  File "base\tracks\road\corkscrew\TENTA1.png"
  File "base\tracks\road\corkscrew\TENTA2.png"
  File "base\tracks\road\corkscrew\TENTA3.png"
  File "base\tracks\road\corkscrew\TENTA4.png"
  File "base\tracks\road\corkscrew\TENTA5.png"
  File "base\tracks\road\corkscrew\tentblue.png"
  File "base\tracks\road\corkscrew\TENTON3.png"
  File "base\tracks\road\corkscrew\TENTPEP1.png"
  File "base\tracks\road\corkscrew\TENTPEP2.png"
  File "base\tracks\road\corkscrew\tentred.png"
  File "base\tracks\road\corkscrew\texwheel.png"
  File "base\tracks\road\corkscrew\tileroof.png"
  File "base\tracks\road\corkscrew\TIREBLAK2.png"
  File "base\tracks\road\corkscrew\TOW1.png"
  File "base\tracks\road\corkscrew\TOWDISP3.png"
  File "base\tracks\road\corkscrew\TRAVE1.png"
  File "base\tracks\road\corkscrew\TRAVE3.png"
  File "base\tracks\road\corkscrew\TRAVE4.png"
  File "base\tracks\road\corkscrew\tr-barrier-arbor.png"
  File "base\tracks\road\corkscrew\tr-barrier-arbor-blue.png"
  File "base\tracks\road\corkscrew\tr-barrier-arbor-fence_n.png"
  File "base\tracks\road\corkscrew\tr-curb-wb-l.png"
  File "base\tracks\road\corkscrew\tr-curb-wb-l-o.png"
  File "base\tracks\road\corkscrew\tr-curb-wb-r.png"
  File "base\tracks\road\corkscrew\tr-curb-wb-r-o.png"
  File "base\tracks\road\corkscrew\tree_n.png"
  File "base\tracks\road\corkscrew\tree3_n.png"
  File "base\tracks\road\corkscrew\tree7_n.png"
  File "base\tracks\road\corkscrew\treeC3_n.png"
  File "base\tracks\road\corkscrew\treeC4_n.png"
  File "base\tracks\road\corkscrew\treeRNS2.png"
  File "base\tracks\road\corkscrew\treeRNS3.png"
  File "base\tracks\road\corkscrew\treeRNS4.png"
  File "base\tracks\road\corkscrew\treeRNS5.png"
  File "base\tracks\road\corkscrew\treeS3_n.png"
  File "base\tracks\road\corkscrew\treeSC_n.png"
  File "base\tracks\road\corkscrew\treeSC2_n.png"
  File "base\tracks\road\corkscrew\TRIB1.png"
  File "base\tracks\road\corkscrew\TRIB2.png"
  File "base\tracks\road\corkscrew\TRIB3.png"
  File "base\tracks\road\corkscrew\TRIB4.png"
  File "base\tracks\road\corkscrew\TRIB5.png"
  File "base\tracks\road\corkscrew\TRIB6.png"
  File "base\tracks\road\corkscrew\TRIB7.png"
  File "base\tracks\road\corkscrew\TRIB8.png"
  File "base\tracks\road\corkscrew\TRIB9.png"
  File "base\tracks\road\corkscrew\TRUCK01.png"
  File "base\tracks\road\corkscrew\TRUCK02.png"
  File "base\tracks\road\corkscrew\TRUCK03.png"
  File "base\tracks\road\corkscrew\TRUCK04.png"
  File "base\tracks\road\corkscrew\TRUCK05.png"
  File "base\tracks\road\corkscrew\TRUCK06.png"
  File "base\tracks\road\corkscrew\TRUCK07.png"
  File "base\tracks\road\corkscrew\TRUCK10.png"
  File "base\tracks\road\corkscrew\TRUCK11.png"
  File "base\tracks\road\corkscrew\TRUCK12.png"
  File "base\tracks\road\corkscrew\TRUCK13.png"
  File "base\tracks\road\corkscrew\turn100.png"
  File "base\tracks\road\corkscrew\turn150.png"
  File "base\tracks\road\corkscrew\turn50.png"
  File "base\tracks\road\corkscrew\water.png"

SetOutPath "$INSTDIR\tracks\road\hidden-valley"  
	File "base\tracks\road\hidden-valley\01.png"
	File "base\tracks\road\hidden-valley\02.png"
	File "base\tracks\road\hidden-valley\ALAUBM.png"
	File "base\tracks\road\hidden-valley\armco-left.png"
	File "base\tracks\road\hidden-valley\armco-right.png"
	File "base\tracks\road\hidden-valley\armco.png"
	File "base\tracks\road\hidden-valley\armcogrille_tree_n.png"
	File "base\tracks\road\hidden-valley\background.png"
	File "base\tracks\road\hidden-valley\BLBDBK.png"
	File "base\tracks\road\hidden-valley\BRIDGEAD.png"
	File "base\tracks\road\hidden-valley\BTOWB.png"
	File "base\tracks\road\hidden-valley\BUS.png"
	File "base\tracks\road\hidden-valley\CAMPER01.png"
	File "base\tracks\road\hidden-valley\CAMPER02.png"
	File "base\tracks\road\hidden-valley\CAMPER3.png"
	File "base\tracks\road\hidden-valley\CAMPER4.png"
	File "base\tracks\road\hidden-valley\CAMPER41.png"
	File "base\tracks\road\hidden-valley\CAR01.png"
	File "base\tracks\road\hidden-valley\CAR02.png"
	File "base\tracks\road\hidden-valley\CAR05.png"
	File "base\tracks\road\hidden-valley\CAR06.png"
	File "base\tracks\road\hidden-valley\CAR07.png"
	File "base\tracks\road\hidden-valley\CAR08.png"
	File "base\tracks\road\hidden-valley\carpark.png"
	File "base\tracks\road\hidden-valley\CMNTA.png"
	File "base\tracks\road\hidden-valley\CMNTB.png"
	File "base\tracks\road\hidden-valley\CMNTBB.png"
	File "base\tracks\road\hidden-valley\concrete-wall1.png"
	File "base\tracks\road\hidden-valley\CONCRETW.png"
	File "base\tracks\road\hidden-valley\CONCSH01.png"
	File "base\tracks\road\hidden-valley\CONCSH02.png"
	File "base\tracks\road\hidden-valley\CONCTP.png"
	File "base\tracks\road\hidden-valley\dekk01.png"
	File "base\tracks\road\hidden-valley\DIST01.png"
	File "base\tracks\road\hidden-valley\DIST02.png"
	File "base\tracks\road\hidden-valley\DIST03.png"
	File "base\tracks\road\hidden-valley\DIST04.png"
	File "base\tracks\road\hidden-valley\FNCEB.png"
	File "base\tracks\road\hidden-valley\GBtree_n.png"
	File "base\tracks\road\hidden-valley\GCtree_n.png"
	File "base\tracks\road\hidden-valley\GDtree_n.png"
	File "base\tracks\road\hidden-valley\GEtree_n.png"
	File "base\tracks\road\hidden-valley\GFtree_n.png"
	File "base\tracks\road\hidden-valley\GGtree.png"
	File "base\tracks\road\hidden-valley\grass-underlay.png"
	File "base\tracks\road\hidden-valley\GRASS.png"
	File "base\tracks\road\hidden-valley\GRtree_n.png"
	File "base\tracks\road\hidden-valley\GSPAtree.png"
	File "base\tracks\road\hidden-valley\GSSOLID.png"
	File "base\tracks\road\hidden-valley\GSUNDER.png"
	File "base\tracks\road\hidden-valley\hidden-valley.acc"
	File "base\tracks\road\hidden-valley\hidden-valley.png"
	File "base\tracks\road\hidden-valley\hidden-valley.xml"
	File "base\tracks\road\hidden-valley\LAMAOP.png"
	File "base\tracks\road\hidden-valley\LOGOBRDG.png"
	File "base\tracks\road\hidden-valley\LOGOCAMP.png"
	File "base\tracks\road\hidden-valley\LOGODD.png"
	File "base\tracks\road\hidden-valley\LOGOFSTN.png"
	File "base\tracks\road\hidden-valley\LOGOGFLG.png"
	File "base\tracks\road\hidden-valley\LOGOHYMIE.png"
	File "base\tracks\road\hidden-valley\LOGOITAL.png"
	File "base\tracks\road\hidden-valley\LOGOJEDI.png"
	File "base\tracks\road\hidden-valley\LOGOSIEGER.png"
	File "base\tracks\road\hidden-valley\LOGOSOFTENG.png"
	File "base\tracks\road\hidden-valley\LOGOUSR.png"
	File "base\tracks\road\hidden-valley\LOGOWR.png"
	File "base\tracks\road\hidden-valley\MASE01.png"
	File "base\tracks\road\hidden-valley\MASE02.png"
	File "base\tracks\road\hidden-valley\OBJA09.png"
	File "base\tracks\road\hidden-valley\OBJA11.png"
	File "base\tracks\road\hidden-valley\OBJA13.png"
	File "base\tracks\road\hidden-valley\OBJA24_arbor_n.png"
	File "base\tracks\road\hidden-valley\PALAZA01.png"
	File "base\tracks\road\hidden-valley\PALAZA02.png"
	File "base\tracks\road\hidden-valley\PALAZA03.png"
	File "base\tracks\road\hidden-valley\PALAZA04.png"
	File "base\tracks\road\hidden-valley\PALAZA05.png"
	File "base\tracks\road\hidden-valley\PALAZA06.png"
	File "base\tracks\road\hidden-valley\PALAZA07.png"
	File "base\tracks\road\hidden-valley\PALAZA09.png"
	File "base\tracks\road\hidden-valley\PALAZA10.png"
	File "base\tracks\road\hidden-valley\PALAZA11.png"
	File "base\tracks\road\hidden-valley\PALAZA12.png"
	File "base\tracks\road\hidden-valley\PALAZA13.png"
	File "base\tracks\road\hidden-valley\PALAZA16.png"
	File "base\tracks\road\hidden-valley\PALAZA17.png"
	File "base\tracks\road\hidden-valley\PALAZA22.png"
	File "base\tracks\road\hidden-valley\PALAZA23_arbor_n.png"
	File "base\tracks\road\hidden-valley\PALAZA24.png"
	File "base\tracks\road\hidden-valley\PDKKA13.png"
	File "base\tracks\road\hidden-valley\PDKKA13b.png"
	File "base\tracks\road\hidden-valley\PDKKA14.png"
	File "base\tracks\road\hidden-valley\PDtree_n.png"
	File "base\tracks\road\hidden-valley\PITWB.png"
	File "base\tracks\road\hidden-valley\POLEA.png"
	File "base\tracks\road\hidden-valley\POLLOL.png"
	File "base\tracks\road\hidden-valley\RA4BRIG5.png"
	File "base\tracks\road\hidden-valley\raceline-clean.png"
	File "base\tracks\road\hidden-valley\raceline-trans.png"
	File "base\tracks\road\hidden-valley\raceline.png"
	File "base\tracks\road\hidden-valley\readme.txt"
	File "base\tracks\road\hidden-valley\REF.png"
	File "base\tracks\road\hidden-valley\rk_tree_2_n.png"
	File "base\tracks\road\hidden-valley\ROAD05.png"
	File "base\tracks\road\hidden-valley\roadgras.png"
	File "base\tracks\road\hidden-valley\ROADPL_n.png"
	File "base\tracks\road\hidden-valley\roadsand.png"
	File "base\tracks\road\hidden-valley\ROAD_LINE_n.png"
	File "base\tracks\road\hidden-valley\ROAD_n.png"
	File "base\tracks\road\hidden-valley\ROAD_PIT.png"
	File "base\tracks\road\hidden-valley\ROAD_PIT_ENTRYEXIT_n.png"
	File "base\tracks\road\hidden-valley\ROAD_PIT_ENTRYEXIT_SIDE_n.png"
	File "base\tracks\road\hidden-valley\ROAD_PIT_n.png"
	File "base\tracks\road\hidden-valley\RSA02.png"
	File "base\tracks\road\hidden-valley\ruudskog_arbor.png"
	File "base\tracks\road\hidden-valley\SAND02.png"
	File "base\tracks\road\hidden-valley\SEMA02.png"
	File "base\tracks\road\hidden-valley\shadow-terrain.png"
	File "base\tracks\road\hidden-valley\shadow.png"
	File "base\tracks\road\hidden-valley\shadow2.rgb"
	File "base\tracks\road\hidden-valley\STAIRS.png"
	File "base\tracks\road\hidden-valley\STAIRSD.png"
	File "base\tracks\road\hidden-valley\TENTD.png"
	File "base\tracks\road\hidden-valley\TENTH.png"
	File "base\tracks\road\hidden-valley\TIME1A.png"
	File "base\tracks\road\hidden-valley\TIME1B.png"
	File "base\tracks\road\hidden-valley\TIME2B.png"
	File "base\tracks\road\hidden-valley\tirewall-left.png"
	File "base\tracks\road\hidden-valley\tirewall-right.png"
	File "base\tracks\road\hidden-valley\tirewall.png"
	File "base\tracks\road\hidden-valley\TOPCROWD.png"
	File "base\tracks\road\hidden-valley\tr-barrier-tree.png"
	File "base\tracks\road\hidden-valley\trans-roadsandgrass.png"
	File "base\tracks\road\hidden-valley\trans-sandgrass.png"
	File "base\tracks\road\hidden-valley\tree-fir_n.png"
	File "base\tracks\road\hidden-valley\tree-pine1_n.png"
	File "base\tracks\road\hidden-valley\treeline_n.png"
	File "base\tracks\road\hidden-valley\TreeRNS3.png"
	File "base\tracks\road\hidden-valley\TreeRNS4.png"
	File "base\tracks\road\hidden-valley\TreeRNS5.png"
	File "base\tracks\road\hidden-valley\treeUGLIES01_n.png"
	File "base\tracks\road\hidden-valley\treeUGLIES02_n.png"
	File "base\tracks\road\hidden-valley\TRIBA08.png"
	File "base\tracks\road\hidden-valley\TRIBA09_arbor_n.png"
	File "base\tracks\road\hidden-valley\TRIBA11.png"
	File "base\tracks\road\hidden-valley\TRIBB01.png"
	File "base\tracks\road\hidden-valley\TRIBB02.png"
	File "base\tracks\road\hidden-valley\TRIBB03.png"
	File "base\tracks\road\hidden-valley\TRKJUM.png"
	File "base\tracks\road\hidden-valley\TRKJUMA.png"
	File "base\tracks\road\hidden-valley\TRKJUMB.png"
	File "base\tracks\road\hidden-valley\TRKJUMC.png"
	File "base\tracks\road\hidden-valley\WHEELS6.png"
	File "base\tracks\road\hidden-valley\ZBRID.png"
	File "base\tracks\road\hidden-valley\ZPIT.png"
	File "base\tracks\road\hidden-valley\ZPIT3.png"


  SetOutPath "$INSTDIR\doc\faq"
  File "base\doc\faq\faq.html"

  SetOutPath "$INSTDIR\doc\userman"
  File "base\doc\userman\how_to_drive.html"

  SetOutPath "$INSTDIR\doc\userman\images"
  File "base\doc\userman\images\torcs-1.jpg"
  File "base\doc\userman\images\torcs-10.jpg"
  File "base\doc\userman\images\torcs-11.jpg"
  File "base\doc\userman\images\torcs-12.jpg"
  File "base\doc\userman\images\torcs-13.jpg"
  File "base\doc\userman\images\torcs-14.jpg"
  File "base\doc\userman\images\torcs-2.jpg"
  File "base\doc\userman\images\torcs-20.jpg"
  File "base\doc\userman\images\torcs-21.jpg"
  File "base\doc\userman\images\torcs-22.jpg"
  File "base\doc\userman\images\torcs-23.jpg"
  File "base\doc\userman\images\torcs-24.jpg"
  File "base\doc\userman\images\torcs-3.jpg"
  File "base\doc\userman\images\torcs-30.jpg"
  File "base\doc\userman\images\torcs-31.jpg"
  File "base\doc\userman\images\torcs-32.jpg"
  File "base\doc\userman\images\torcs-33.jpg"
  File "base\doc\userman\images\torcs-34.jpg"
  File "base\doc\userman\images\torcs-35.jpg"
  File "base\doc\userman\images\torcs-36.jpg"
  File "base\doc\userman\images\torcs-37.jpg"
  File "base\doc\userman\images\torcs-4.jpg"
  File "base\doc\userman\images\torcs-40.jpg"
  File "base\doc\userman\images\torcs-41.jpg"
  File "base\doc\userman\images\torcs-42.jpg"
  File "base\doc\userman\images\torcs-43.jpg"
  File "base\doc\userman\images\torcs-44.jpg"
  File "base\doc\userman\images\torcs-5.jpg"
  File "base\doc\userman\images\torcs-6.jpg"
  File "base\doc\userman\images\torcs-7.jpg"
  File "base\doc\userman\images\torcs-8.jpg"
  File "base\doc\userman\images\torcs-9.jpg"

  SetOutPath "$INSTDIR"
  File "base\txml.dll"
  File "base\wtorcs.exe"

  CreateDirectory "$SMPROGRAMS\TORCS"
  CreateShortCut "$SMPROGRAMS\TORCS\TORCS - The Open Racing Car Simulator.lnk" "$INSTDIR\wtorcs.exe"

  CreateShortCut "$SMPROGRAMS\TORCS\TORCS User Manual.lnk" "$INSTDIR\doc\userman\how_to_drive.html"
  CreateShortCut "$SMPROGRAMS\TORCS\Frequently Asked Questions.lnk" "$INSTDIR\doc\faq\faq.html"

  CreateShortCut "$DESKTOP\TORCS - The Open Racing Car Simulator.lnk" "$INSTDIR\wtorcs.exe"
  CreateDirectory "$INSTDIR\results"
  CreateDirectory "$INSTDIR\results\champ"
  CreateDirectory "$INSTDIR\results\dtmrace"
  CreateDirectory "$INSTDIR\results\endrace"
  CreateDirectory "$INSTDIR\results\ncrace"
  CreateDirectory "$INSTDIR\results\practice"
  CreateDirectory "$INSTDIR\results\quickrace"
SectionEnd

Section "Trackeditor and Tools" SEC02
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "base\accc.exe"
  File "base\nfsperf.exe"
  File "base\nfs2ac.exe"
  File "base\trackgen.exe"


; trackeditor files to install
  File "base\trackeditor.bat"

  SetOutPath "$INSTDIR\trackeditor\doc"
  File "base\trackeditor\doc\miniHowTo.html"
  File "base\trackeditor\doc\miniHowTo_html_e23635.png"
  File "base\trackeditor\doc\miniHowTo_html_m16f0000f.jpg"
  File "base\trackeditor\doc\miniHowTo_html_m51961386.png"
  File "base\trackeditor\doc\snapshot1.png"
  File "base\trackeditor\doc\snapshot10.png"
  File "base\trackeditor\doc\snapshot2.png"
  File "base\trackeditor\doc\snapshot3.png"
  File "base\trackeditor\doc\snapshot4.png"
  File "base\trackeditor\doc\snapshot5.png"
  File "base\trackeditor\doc\snapshot6.png"
  File "base\trackeditor\doc\snapshot7.png"
  File "base\trackeditor\doc\snapshot8.png"
  File "base\trackeditor\doc\snapshot9.png"

  SetOutPath "$INSTDIR\trackeditor"
  File "base\trackeditor\icon.png"
  
  SetOutPath "$INSTDIR\trackeditor\lib"
  File "base\trackeditor\lib\bsh-2.0b2.jar"
  File "base\trackeditor\lib\jdom.jar"
  File "base\trackeditor\lib\looks-1.2.2.jar"
  File "base\trackeditor\lib\trackeditor-0.6.2c.jar"
  File "base\trackeditor\lib\xercesImpl.jar"

  SetOutPath "$INSTDIR"
  CreateShortCut "$SMPROGRAMS\TORCS\Track Editor.lnk" "$INSTDIR\trackeditor.bat"
  CreateShortCut "$SMPROGRAMS\TORCS\Track Editor Manual.lnk" "$INSTDIR\trackeditor\doc\miniHowTo.html"

SectionEnd

Section "Rally Cars" SEC03
  SetOverwrite try
  SetOutPath "$INSTDIR\cars\pw-206wrc"
  File "base\cars\pw-206wrc\pw-206wrc-lod1.acc"
  File "base\cars\pw-206wrc\pw-206wrc-lod2.acc"
  File "base\cars\pw-206wrc\pw-206wrc.acc"
  File "base\cars\pw-206wrc\pw-206wrc.rgb"
  File "base\cars\pw-206wrc\pw-206wrc.xml"
  File "base\cars\pw-206wrc\readme.txt"
  File "base\cars\pw-206wrc\shadow.rgb"
  File "base\cars\pw-206wrc\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\pw-306wrc"
  File "base\cars\pw-306wrc\pw-306wrc-lod1.acc"
  File "base\cars\pw-306wrc\pw-306wrc-lod2.acc"
  File "base\cars\pw-306wrc\pw-306wrc.acc"
  File "base\cars\pw-306wrc\pw-306wrc.rgb"
  File "base\cars\pw-306wrc\pw-306wrc.xml"
  File "base\cars\pw-306wrc\readme.txt"
  File "base\cars\pw-306wrc\shadow.rgb"
  File "base\cars\pw-306wrc\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\pw-corollawrc"
  File "base\cars\pw-corollawrc\pw-corollawrc-lod1.acc"
  File "base\cars\pw-corollawrc\pw-corollawrc-lod2.acc"
  File "base\cars\pw-corollawrc\pw-corollawrc.acc"
  File "base\cars\pw-corollawrc\pw-corollawrc.rgb"
  File "base\cars\pw-corollawrc\pw-corollawrc.xml"
  File "base\cars\pw-corollawrc\readme.txt"
  File "base\cars\pw-corollawrc\shadow.rgb"
  File "base\cars\pw-corollawrc\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\pw-evoviwrc"
  File "base\cars\pw-evoviwrc\pw-evoviwrc-lod1.acc"
  File "base\cars\pw-evoviwrc\pw-evoviwrc-lod2.acc"
  File "base\cars\pw-evoviwrc\pw-evoviwrc.acc"
  File "base\cars\pw-evoviwrc\pw-evoviwrc.rgb"
  File "base\cars\pw-evoviwrc\pw-evoviwrc.xml"
  File "base\cars\pw-evoviwrc\readme.txt"
  File "base\cars\pw-evoviwrc\shadow.rgb"
  File "base\cars\pw-evoviwrc\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\pw-focuswrc"
  File "base\cars\pw-focuswrc\pw-focuswrc-lod1.acc"
  File "base\cars\pw-focuswrc\pw-focuswrc-lod2.acc"
  File "base\cars\pw-focuswrc\pw-focuswrc.acc"
  File "base\cars\pw-focuswrc\pw-focuswrc.rgb"
  File "base\cars\pw-focuswrc\pw-focuswrc.xml"
  File "base\cars\pw-focuswrc\readme.txt"
  File "base\cars\pw-focuswrc\shadow.rgb"
  File "base\cars\pw-focuswrc\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\pw-imprezawrc"
  File "base\cars\pw-imprezawrc\pw-imprezawrc-lod1.acc"
  File "base\cars\pw-imprezawrc\pw-imprezawrc-lod2.acc"
  File "base\cars\pw-imprezawrc\pw-imprezawrc.acc"
  File "base\cars\pw-imprezawrc\pw-imprezawrc.rgb"
  File "base\cars\pw-imprezawrc\pw-imprezawrc.xml"
  File "base\cars\pw-imprezawrc\readme.txt"
  File "base\cars\pw-imprezawrc\shadow.rgb"
  File "base\cars\pw-imprezawrc\tex-wheel.rgb"
SectionEnd

Section "Classic Cars" SEC04
  SetOutPath "$INSTDIR\cars\kc-2000gt"
  File "base\cars\kc-2000gt\kc-2000gt-lod1.acc"
  File "base\cars\kc-2000gt\kc-2000gt-lod2.acc"
  File "base\cars\kc-2000gt\kc-2000gt-lod3.acc"
  File "base\cars\kc-2000gt\kc-2000gt.acc"
  File "base\cars\kc-2000gt\kc-2000gt.rgb"
  File "base\cars\kc-2000gt\kc-2000gt.xml"
  File "base\cars\kc-2000gt\readme.txt"
  File "base\cars\kc-2000gt\shadow.rgb"
  File "base\cars\kc-2000gt\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-5300gt"
  File "base\cars\kc-5300gt\kc-5300gt-lod1.acc"
  File "base\cars\kc-5300gt\kc-5300gt-lod2.acc"
  File "base\cars\kc-5300gt\kc-5300gt-lod3.acc"
  File "base\cars\kc-5300gt\kc-5300gt.acc"
  File "base\cars\kc-5300gt\kc-5300gt.rgb"
  File "base\cars\kc-5300gt\kc-5300gt.xml"
  File "base\cars\kc-5300gt\kmh1.rgb"
  File "base\cars\kc-5300gt\readme.txt"
  File "base\cars\kc-5300gt\rpm1.rgb"
  File "base\cars\kc-5300gt\shadow.rgb"
  File "base\cars\kc-5300gt\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-a110"
  File "base\cars\kc-a110\kc-a110-lod1.acc"
  File "base\cars\kc-a110\kc-a110-lod2.acc"
  File "base\cars\kc-a110\kc-a110-lod3.acc"
  File "base\cars\kc-a110\kc-a110.acc"
  File "base\cars\kc-a110\kc-a110.rgb"
  File "base\cars\kc-a110\kc-a110.xml"
  File "base\cars\kc-a110\readme.txt"
  File "base\cars\kc-a110\shadow.rgb"
  File "base\cars\kc-a110\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-alfatz2"
  File "base\cars\kc-alfatz2\kc-alfatz2-lod1.acc"
  File "base\cars\kc-alfatz2\kc-alfatz2-lod2.acc"
  File "base\cars\kc-alfatz2\kc-alfatz2-lod3.acc"
  File "base\cars\kc-alfatz2\kc-alfatz2.acc"
  File "base\cars\kc-alfatz2\kc-alfatz2.rgb"
  File "base\cars\kc-alfatz2\kc-alfatz2.xml"
  File "base\cars\kc-alfatz2\kmh1.rgb"
  File "base\cars\kc-alfatz2\readme.txt"
  File "base\cars\kc-alfatz2\rpm1.rgb"
  File "base\cars\kc-alfatz2\shadow.rgb"
  File "base\cars\kc-alfatz2\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-bigh"
  File "base\cars\kc-bigh\kc-bigh-lod1.acc"
  File "base\cars\kc-bigh\kc-bigh-lod2.acc"
  File "base\cars\kc-bigh\kc-bigh-lod3.acc"
  File "base\cars\kc-bigh\kc-bigh.acc"
  File "base\cars\kc-bigh\kc-bigh.rgb"
  File "base\cars\kc-bigh\kc-bigh.xml"
  File "base\cars\kc-bigh\readme.txt"
  File "base\cars\kc-bigh\shadow.rgb"
  File "base\cars\kc-bigh\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-cobra"
  File "base\cars\kc-cobra\kc-cobra-lod1.acc"
  File "base\cars\kc-cobra\kc-cobra-lod2.acc"
  File "base\cars\kc-cobra\kc-cobra-lod3.acc"
  File "base\cars\kc-cobra\kc-cobra.acc"
  File "base\cars\kc-cobra\kc-cobra.rgb"
  File "base\cars\kc-cobra\kc-cobra.xml"
  File "base\cars\kc-cobra\readme.txt"
  File "base\cars\kc-cobra\shadow.rgb"
  File "base\cars\kc-cobra\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-coda"
  File "base\cars\kc-coda\kc-coda-lod1.acc"
  File "base\cars\kc-coda\kc-coda-lod2.acc"
  File "base\cars\kc-coda\kc-coda-lod3.acc"
  File "base\cars\kc-coda\kc-coda.acc"
  File "base\cars\kc-coda\kc-coda.rgb"
  File "base\cars\kc-coda\kc-coda.xml"
  File "base\cars\kc-coda\readme.txt"
  File "base\cars\kc-coda\shadow.rgb"
  File "base\cars\kc-coda\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-conrero"
  File "base\cars\kc-conrero\kc-conrero-lod1.acc"
  File "base\cars\kc-conrero\kc-conrero-lod2.acc"
  File "base\cars\kc-conrero\kc-conrero-lod3.acc"
  File "base\cars\kc-conrero\kc-conrero.acc"
  File "base\cars\kc-conrero\kc-conrero.rgb"
  File "base\cars\kc-conrero\kc-conrero.xml"
  File "base\cars\kc-conrero\kmh1.rgb"
  File "base\cars\kc-conrero\readme.txt"
  File "base\cars\kc-conrero\rpm1.rgb"
  File "base\cars\kc-conrero\shadow.rgb"
  File "base\cars\kc-conrero\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-corvette-ttop"
  File "base\cars\kc-corvette-ttop\kc-corvette-ttop-lod1.acc"
  File "base\cars\kc-corvette-ttop\kc-corvette-ttop-lod2.acc"
  File "base\cars\kc-corvette-ttop\kc-corvette-ttop-lod3.acc"
  File "base\cars\kc-corvette-ttop\kc-corvette-ttop.acc"
  File "base\cars\kc-corvette-ttop\kc-corvette-ttop.rgb"
  File "base\cars\kc-corvette-ttop\kc-corvette-ttop.xml"
  File "base\cars\kc-corvette-ttop\kmh1.rgb"
  File "base\cars\kc-corvette-ttop\readme.txt"
  File "base\cars\kc-corvette-ttop\rpm1.rgb"
  File "base\cars\kc-corvette-ttop\shadow.rgb"
  File "base\cars\kc-corvette-ttop\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-daytona"
  File "base\cars\kc-daytona\kc-daytona-lod1.acc"
  File "base\cars\kc-daytona\kc-daytona-lod2.acc"
  File "base\cars\kc-daytona\kc-daytona-lod3.acc"
  File "base\cars\kc-daytona\kc-daytona.acc"
  File "base\cars\kc-daytona\kc-daytona.rgb"
  File "base\cars\kc-daytona\kc-daytona.xml"
  File "base\cars\kc-daytona\kmh1.rgb"
  File "base\cars\kc-daytona\readme.txt"
  File "base\cars\kc-daytona\rpm1.rgb"
  File "base\cars\kc-daytona\shadow.rgb"
  File "base\cars\kc-daytona\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-db4z"
  File "base\cars\kc-db4z\kc-db4z-lod1.acc"
  File "base\cars\kc-db4z\kc-db4z-lod2.acc"
  File "base\cars\kc-db4z\kc-db4z-lod3.acc"
  File "base\cars\kc-db4z\kc-db4z.acc"
  File "base\cars\kc-db4z\kc-db4z.rgb"
  File "base\cars\kc-db4z\kc-db4z.xml"
  File "base\cars\kc-db4z\readme.txt"
  File "base\cars\kc-db4z\shadow.rgb"
  File "base\cars\kc-db4z\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-dbs"
  File "base\cars\kc-dbs\kc-dbs-lod1.acc"
  File "base\cars\kc-dbs\kc-dbs-lod2.acc"
  File "base\cars\kc-dbs\kc-dbs.acc"
  File "base\cars\kc-dbs\kc-dbs.rgb"
  File "base\cars\kc-dbs\kc-dbs.xml"
  File "base\cars\kc-dbs\readme.txt"
  File "base\cars\kc-dbs\shadow.rgb"
  File "base\cars\kc-dbs\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-dino"
  File "base\cars\kc-dino\kc-dino-lod1.acc"
  File "base\cars\kc-dino\kc-dino-lod2.acc"
  File "base\cars\kc-dino\kc-dino.acc"
  File "base\cars\kc-dino\kc-dino.rgb"
  File "base\cars\kc-dino\kc-dino.xml"
  File "base\cars\kc-dino\kmh1.rgb"
  File "base\cars\kc-dino\readme.txt"
  File "base\cars\kc-dino\rpm1.rgb"
  File "base\cars\kc-dino\shadow.rgb"
  File "base\cars\kc-dino\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-ghibli"
  File "base\cars\kc-ghibli\kc-ghibli-lod1.acc"
  File "base\cars\kc-ghibli\kc-ghibli-lod2.acc"
  File "base\cars\kc-ghibli\kc-ghibli-lod3.acc"
  File "base\cars\kc-ghibli\kc-ghibli.acc"
  File "base\cars\kc-ghibli\kc-ghibli.rgb"
  File "base\cars\kc-ghibli\kc-ghibli.xml"
  File "base\cars\kc-ghibli\readme.txt"
  File "base\cars\kc-ghibli\shadow.rgb"
  File "base\cars\kc-ghibli\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-giulietta"
  File "base\cars\kc-giulietta\kc-giulietta-lod1.acc"
  File "base\cars\kc-giulietta\kc-giulietta-lod2.acc"
  File "base\cars\kc-giulietta\kc-giulietta-lod3.acc"
  File "base\cars\kc-giulietta\kc-giulietta-lod4.acc"
  File "base\cars\kc-giulietta\kc-giulietta.acc"
  File "base\cars\kc-giulietta\kc-giulietta.rgb"
  File "base\cars\kc-giulietta\kc-giulietta.xml"
  File "base\cars\kc-giulietta\readme.txt"
  File "base\cars\kc-giulietta\shadow.rgb"
  File "base\cars\kc-giulietta\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-grifo"
  File "base\cars\kc-grifo\kc-grifo-lod1.acc"
  File "base\cars\kc-grifo\kc-grifo-lod2.acc"
  File "base\cars\kc-grifo\kc-grifo-lod3.acc"
  File "base\cars\kc-grifo\kc-grifo-lod4.acc"
  File "base\cars\kc-grifo\kc-grifo.acc"
  File "base\cars\kc-grifo\kc-grifo.rgb"
  File "base\cars\kc-grifo\kc-grifo.xml"
  File "base\cars\kc-grifo\kmh1.rgb"
  File "base\cars\kc-grifo\readme.txt"
  File "base\cars\kc-grifo\rpm1.rgb"
  File "base\cars\kc-grifo\shadow.rgb"
  File "base\cars\kc-grifo\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-gt40"
  File "base\cars\kc-gt40\gt40.acc"
  File "base\cars\kc-gt40\kc-gt40-lod1.acc"
  File "base\cars\kc-gt40\kc-gt40-lod2.acc"
  File "base\cars\kc-gt40\kc-gt40-lod3.acc"
  File "base\cars\kc-gt40\kc-gt40.acc"
  File "base\cars\kc-gt40\kc-gt40.rgb"
  File "base\cars\kc-gt40\kc-gt40.xml"
  File "base\cars\kc-gt40\kmh1.rgb"
  File "base\cars\kc-gt40\readme.txt"
  File "base\cars\kc-gt40\rpm1.rgb"
  File "base\cars\kc-gt40\shadow.rgb"
  File "base\cars\kc-gt40\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-gto"
  File "base\cars\kc-gto\kc-gto-lod1.acc"
  File "base\cars\kc-gto\kc-gto-lod2.acc"
  File "base\cars\kc-gto\kc-gto-lod3.acc"
  File "base\cars\kc-gto\kc-gto-lod4.acc"
  File "base\cars\kc-gto\kc-gto.acc"
  File "base\cars\kc-gto\kc-gto.rgb"
  File "base\cars\kc-gto\kc-gto.xml"
  File "base\cars\kc-gto\kmh1.rgb"
  File "base\cars\kc-gto\readme.txt"
  File "base\cars\kc-gto\rpm1.rgb"
  File "base\cars\kc-gto\shadow.rgb"
  File "base\cars\kc-gto\tex-wheel.rgb"
  SetOutPath "$INSTDIR\cars\kc-p4"
  File "base\cars\kc-p4\kc-p4-lod1.acc"
  File "base\cars\kc-p4\kc-p4-lod2.acc"
  File "base\cars\kc-p4\kc-p4-lod3.acc"
  File "base\cars\kc-p4\kc-p4.acc"
  File "base\cars\kc-p4\kc-p4.rgb"
  File "base\cars\kc-p4\kc-p4.xml"
  File "base\cars\kc-p4\readme.txt"
  File "base\cars\kc-p4\shadow.rgb"
  File "base\cars\kc-p4\tex-wheel.rgb"
SectionEnd

Section "Stripe " SEC05
  SetOverwrite ifnewer
  SetOutPath "$INSTDIR"
  File "base\stripe.exe"
SectionEnd


Section -AdditionalIcons
  SetOutPath $INSTDIR
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\TORCS\TORCS Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  
#  WriteIniStr "$INSTDIR\trb.url" "InternetShortcut" "URL" "http://www.berniw.org/trb"
#  CreateShortCut "$SMPROGRAMS\TORCS\TORCS Racing Board.lnk" "$INSTDIR\trb.url"

#  WriteIniStr "$INSTDIR\trackgen.url" "InternetShortcut" "URL" "http://trackgen.pierlucalanzi.net"
#  CreateShortCut "$SMPROGRAMS\TORCS\Online track generator.lnk" "$INSTDIR\trackgen.url"

  WriteIniStr "$INSTDIR\videos.url" "InternetShortcut" "URL" "http://www.youtube.com/user/berniwtorcs/videos?view=0"
  CreateShortCut "$SMPROGRAMS\TORCS\Videos.lnk" "$INSTDIR\videos.url"

  CreateShortCut "$SMPROGRAMS\TORCS\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\wtorcs.exe"
  WriteRegDword HKLM "${PRODUCT_DIR_REGKEY}" "VersionMajor" "${VER_MAJOR}"
  WriteRegDword HKLM "${PRODUCT_DIR_REGKEY}" "VersionMinor" "${VER_MINOR}"
  WriteRegDword HKLM "${PRODUCT_DIR_REGKEY}" "VersionRevision" "${VER_REVISION}"
  WriteRegDword HKLM "${PRODUCT_DIR_REGKEY}" "VersionDate" "${VER_RELDATE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\wtorcs.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} "TORCS base system, contains the application, cars, tracks and opponents."
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} "Track editor and tools, for track and car creation."
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC03} "Rally cars, read the readme.txt in the directory of the car for licensing details (not free in GPL sense)."
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC04} "Classic cars, read the readme.txt in the directory of the car for licensing details (not free in GPL sense)."
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC05} "Stripe utility, required by some tools, used for car and advanced track creation, see README for licensing details (not free in GPL sense)."
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) wurde erfolgreich deinstalliert."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Mchten Sie $(^Name) und alle seinen Komponenten deinstallieren?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$SMPROGRAMS\TORCS\Track Editor.lnk"
  Delete "$SMPROGRAMS\TORCS\Track Editor Manual.lnk"
  
  Delete "$SMPROGRAMS\TORCS\TORCS User Manual.lnk"
  Delete "$SMPROGRAMS\TORCS\Frequently Asked Questions.lnk"

  Delete "$SMPROGRAMS\TORCS\Uninstall.lnk"
  Delete "$SMPROGRAMS\TORCS\TORCS Website.lnk"
  Delete "$SMPROGRAMS\TORCS\TORCS Racing Board.lnk"
  Delete "$DESKTOP\TORCS - The Open Racing Car Simulator.lnk"
  Delete "$SMPROGRAMS\TORCS\TORCS - The Open Racing Car Simulator.lnk"

#  Delete "$SMPROGRAMS\TORCS\Online track generator.lnk"
  Delete "$SMPROGRAMS\TORCS\Videos.lnk"

  RMDir "$SMPROGRAMS\TORCS"


  RMDir /r "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd


;--------------------------------
;Installer Functions, derived from makensis.nsi

Function .onInit

  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "torcs.ini"

FunctionEnd


Function PageReinstall

  ReadRegStr $R0 HKLM "${PRODUCT_DIR_REGKEY}" ""

  StrCmp $R0 "" 0 other_version_present
    Abort

  other_version_present:

  ;Detect version
    ReadRegDWORD $R0 HKLM "${PRODUCT_DIR_REGKEY}" "VersionMajor"
    IntCmp $R0 ${VER_MAJOR} minor_check new_version older_version
  minor_check:
    ReadRegDWORD $R0 HKLM "${PRODUCT_DIR_REGKEY}" "VersionMinor"
    IntCmp $R0 ${VER_MINOR} revision_check new_version older_version
  revision_check:
    ReadRegDWORD $R0 HKLM "${PRODUCT_DIR_REGKEY}" "VersionRevision"
    IntCmp $R0 ${VER_REVISION} build_check new_version older_version
  build_check:
    ReadRegDWORD $R0 HKLM "${PRODUCT_DIR_REGKEY}" "VersionDate"
    IntCmp $R0 ${VER_RELDATE} same_version new_version older_version

  new_version:

   !insertmacro MUI_INSTALLOPTIONS_WRITE "torcs.ini" "Field 1" "Text" "An older version of TORCS is installed on your system. It is recommended that you uninstall the current version before installing. Select the operation you want to perform and click Next to continue."
   !insertmacro MUI_INSTALLOPTIONS_WRITE "torcs.ini" "Field 2" "Text" "Uninstall before installing"
   !insertmacro MUI_INSTALLOPTIONS_WRITE "torcs.ini" "Field 3" "Text" "Do not uninstall"
   !insertmacro MUI_HEADER_TEXT "Already Installed" "Choose how you want to install TORCS."
   StrCpy $R0 "1"
   Goto reinst_start

  older_version:

   !insertmacro MUI_INSTALLOPTIONS_WRITE "torcs.ini" "Field 1" "Text" "A newer version of TORCS is already installed! It is not recommended that you install an older version. If you really want to install this older version, it's better to uninstall the current version first. Select the operation you want to perform and click Next to continue."
   !insertmacro MUI_INSTALLOPTIONS_WRITE "torcs.ini" "Field 2" "Text" "Uninstall before installing"
   !insertmacro MUI_INSTALLOPTIONS_WRITE "torcs.ini" "Field 3" "Text" "Do not uninstall"
   !insertmacro MUI_HEADER_TEXT "Already Installed" "Choose how you want to install TORCS."
   StrCpy $R0 "1"
   Goto reinst_start

  same_version:

   !insertmacro MUI_INSTALLOPTIONS_WRITE "torcs.ini" "Field 1" "Text" "TORCS ${PRODUCT_VERSION} is already installed. Select the operation you want to perform and click Next to continue."
   !insertmacro MUI_INSTALLOPTIONS_WRITE "torcs.ini" "Field 2" "Text" "Add/Reinstall components"
   !insertmacro MUI_INSTALLOPTIONS_WRITE "torcs.ini" "Field 3" "Text" "Uninstall TORCS"
   !insertmacro MUI_HEADER_TEXT "Already Installed" "Choose the maintenance option to perform."
   StrCpy $R0 "2"

  reinst_start:

  !insertmacro MUI_INSTALLOPTIONS_DISPLAY "torcs.ini"

FunctionEnd



Function PageLeaveReinstall

  !insertmacro MUI_INSTALLOPTIONS_READ $R1 "torcs.ini" "Field 2" "State"

  StrCmp $R0 "1" 0 +2
    StrCmp $R1 "1" reinst_uninstall reinst_done

  StrCmp $R0 "2" 0 +3
    StrCmp $R1 "1" reinst_done reinst_uninstall

  reinst_uninstall:
  ReadRegStr $R1 ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString"

  ;Run uninstaller
  HideWindow

    ClearErrors
    ExecWait '$R1 _?=$INSTDIR'

    IfErrors no_remove_uninstaller
    IfFileExists "$INSTDIR\wtorcs.exe" no_remove_uninstaller

      Delete $R1
      RMDir $INSTDIR

    no_remove_uninstaller:

  StrCmp $R0 "2" 0 +2
    Quit

  BringToFront

  reinst_done:

FunctionEnd




