/***************************************************************************\
|*									   *|
|*  pieces3.c:	A version of Tetris to run on ordinary terminals,	   *|
|*		(ie., not needing a workstation, so should available	   *|
|*		to peasant Newwords+ users.  This module contains the	   *|
|*		definitions of the pieces.				   *|
|*									   *|
|*  Author:	Mike Taylor (mirk@uk.co.ssl)				   *|
|*  Started:	Fri May 26 12:26:05 BST 1989				   *|
|*									   *|
\***************************************************************************/

#include "tt.h"
#include "pieces.h"

/*-------------------------------------------------------------------------*/

struct piece pieces3[] = {
  { "[]", 1,			/* L-shape */
      {
	{{-1,0}, {0,0}, {0,-1}},
	{{1,0}, {0,0}, {0,-1}},
	{{1,0}, {0,0}, {0,1}},
	{{-1,0}, {0,0}, {0,1}},
      }
  },


  { "<>", 2,			/* Long piece */
      {
	{{0,-1}, {0,0}, {0,1}},
	{{-1,0}, {0,0}, {1,0}},
	{{0,1}, {0,0}, {0,-1}},
	{{1,0}, {0,0}, {-1,0}},
      }
  },

  { "%%", 3,			/* Bent piece */
      {
	{{-1,0}, {0,0}, {1,-1}},
	{{0,-1}, {0,0}, {1,1}},
	{{1,0}, {0,0}, {-1,1}},
	{{0,1}, {0,0}, {-1,-1}},
      }
  },

  { "@@", 3,			/* Backwards bent piece */
      {
	{{-1,-1}, {0,0}, {1,0}},
	{{1,-1}, {0,0}, {0,1}},
	{{1,1}, {0,0}, {-1,0}},
	{{-1,1}, {0,0}, {0,-1}},
      }
  },

  { "##", 4,			/* Diagonal piece */
      {
	{{1,-1}, {0,0}, {-1,1}},
	{{-1,-1}, {0,0}, {1,1}},
	{{-1,1}, {0,0}, {1,-1}},
	{{1,1}, {0,0}, {-1,-1}},
      }
  },

  { "{}", 5,			/* Angle piece */
      {
	{{-1,1}, {0,0}, {1,1}},
	{{-1,-1}, {0,0}, {-1,1}},
	{{1,-1}, {0,0}, {-1,-1}},
	{{1,1}, {0,0}, {1,-1}},
      }
  }
};

/*-------------------------------------------------------------------------*/
