/***************************************************************************\
|*                                                                         *|
|*  pieces.c:	A version of Tetris to run on ordinary terminals,	   *|
|*		(ie., not needing a workstation, so should available	   *|
|*		to peasant Newwords+ users.  This module contains the	   *|
|*		definitions of the pieces.				   *|
|*                                                                         *|
|*  Author:	Mike Taylor (mirk@uk.ac.warwick.cs)			   *|
|*  Started:	Fri May 26 12:26:05 BST 1989				   *|
|*                                                                         *|
\***************************************************************************/

#include "tt.h"
#include "pieces.h"

/*-------------------------------------------------------------------------*/

/* Labels used :  [] {} () 00 UU && %% $$ ## @@ QQ OO 88 WW EE HH AA <>    */

struct piece pieces5[] = {
  { "&&", 1,			/* Long piece */
      {
	{{-2,0}, {-1,0}, {0,0}, {1,0}, {2,0}},
	{{0,-2}, {0,-1}, {0,0}, {0,1}, {0,2}},
	{{-2,0}, {-1,0}, {0,0}, {1,0}, {2,0}},
	{{0,-2}, {0,-1}, {0,0}, {0,1}, {0,2}}
      }
  },

  { "HH", 1,			/* L-shaped piece */
      {
	{{-1,-1}, {-1,0}, {-1,1}, {0,1}, {1,1}},
	{{-1,-1}, {0,-1}, {1,-1}, {-1,0}, {-1,1}},
	{{-1,-1}, {0,-1}, {1,-1}, {1,0}, {1,1}},
	{{1,-1}, {1,0}, {-1,1}, {0,1}, {1,1}}
      }
  },

  { "%%", 2,			/* Tall L-shaped piece */
      {
	{{0,-1}, {0,0}, {0,1}, {0,2}, {1,2}},
	{{-2,0}, {-1,0}, {0,0}, {1,0}, {-2,1}},
	{{-1,-2}, {0,-2}, {0,-1}, {0,0}, {0,1}},
	{{2,-1}, {-1,0}, {0,0}, {1,0}, {2,0}}
      }
  },

  { "$$", 2,			/* Back Tall L-shaped piece */
      {
	{{1,-1}, {1,0}, {1,1}, {0,2}, {1,2}},
	{{-2,0}, {-2,1}, {-1,1}, {0,1}, {1,1}},
	{{-1,-2}, {0,-2}, {-1,-1}, {-1,0}, {-1,1}},
	{{-1,-1}, {0,-1}, {1,-1}, {2,-1}, {2,0}}
      }
  },

  { "@@", 3,			/* P-shaped piece */
      {
	{{0,-1}, {1,-1}, {0,0}, {1,0}, {0,1}},
	{{-1,0}, {0,0}, {1,0}, {0,1}, {1,1}},
	{{0,-1}, {-1,0}, {0,0}, {-1,1}, {0,1}},
	{{-1,-1}, {0,-1}, {-1,0}, {0,0}, {1,0}}
      }
  },

  { "##", 3,			/* Back P-shaped piece */
      {
	{{0,-1}, {0,0}, {1,0}, {0,1}, {1,1}},
	{{-1,0}, {0,0}, {1,0}, {-1,1}, {0,1}},
	{{-1,-1}, {0,-1}, {-1,0}, {0,0}, {0,1}},
	{{0,-1}, {1,-1}, {-1,0}, {0,0}, {1,0}}
      }
  },

  { "<>", 3,			/* Right Half-cross-shaped piece */
      {
	{{0,-1}, {0,0}, {1,0}, {0,1}, {0,2}},
	{{-2,0}, {-1,0}, {0,0}, {1,0}, {0,1}},
	{{0,-2}, {0,-1}, {-1,0}, {0,0}, {0,1}},
	{{0,-1}, {-1,0}, {0,0}, {1,0}, {2,0}}
      }
  },

  { "UU", 3,			/* Left Half-cross-shaped piece */
      {
	{{0,-1}, {0,0}, {0,1}, {1,1}, {0,2}},
	{{-2,0}, {-1,0}, {0,0}, {1,0}, {-1,1}},
	{{0,-2}, {-1,-1}, {0,-1}, {0,0}, {0,1}},
	{{1,-1}, {-1,0}, {0,0}, {1,0}, {2,0}}
      }
  },

  { "[]", 4,			/* Squiggle shaped-piece */
      {
	{{0,-1}, {0,0}, {1,0}, {1,1}, {1,2}},
	{{0,0}, {1,0}, {-2,1}, {-1,1}, {0,1}},
	{{-1,-2}, {-1,-1}, {-1,0}, {0,0}, {0,1}},
	{{0,-1}, {1,-1}, {2,-1}, {-1,0}, {0,0}}
      }
  },

  { "{}", 4,			/* Back Squiggle-shaped piece */
      {
	{{1,-1}, {1,0}, {0,1}, {1,1}, {0,2}},
	{{-2,0}, {-1,0}, {-1,1}, {0,1}, {1,1}},
	{{0,-2}, {-1,-1}, {0,-1}, {-1,0}, {-1,1}},
	{{-1,-1}, {0,-1}, {1,-1}, {1,0}, {2,0}}
      }
  },

  { "00", 4,			/* C-shaped piece */
      {
	{{0,-1}, {1,-1}, {0,0}, {0,1}, {1,1}},
	{{-1,0}, {0,0}, {1,0}, {-1,1}, {1,1}},
	{{-1,-1}, {0,-1}, {0,0}, {-1,1}, {0,1}},
	{{-1,-1}, {1,-1}, {-1,0}, {0,0}, {1,0}}
      }
  },

  { "WW", 4,			/* T-shaped piece */
      {
	{{-1,-1}, {0,-1}, {1,-1}, {0,0}, {0,1}},
	{{1,-1}, {-1,0}, {0,0}, {1,0}, {1,1}},
	{{0,-1}, {0,0}, {-1,1}, {0,1}, {1,1}},
	{{-1,-1}, {-1,0}, {0,0}, {1,0}, {-1,1}}
      }
  },

  { "()", 5,			/* Steps-shaped piece */
      {
	{{0,-1}, {1,-1}, {-1,0}, {0,0}, {-1,1}},
	{{-1,-1}, {0,-1}, {0,0}, {1,0}, {1,1}},
	{{1,-1}, {0,0}, {1,0}, {-1,1}, {0,1}},
	{{-1,-1}, {-1,0}, {0,0}, {0,1}, {1,1}}
      }
  },

  { "QQ", 5,			/* +-shaped piece */
      {
	{{0,-1}, {-1,0}, {0,0}, {1,0}, {0,1}},
	{{0,-1}, {-1,0}, {0,0}, {1,0}, {0,1}},
	{{0,-1}, {-1,0}, {0,0}, {1,0}, {0,1}},
	{{0,-1}, {-1,0}, {0,0}, {1,0}, {0,1}}
      }
  },

  { "AA", 5,			/* S-shaped piece */
      {
	{{0,-1}, {1,-1}, {0,0}, {-1,1}, {0,1}},
	{{-1,-1}, {-1,0}, {0,0}, {1,0}, {1,1}},
	{{0,-1}, {1,-1}, {0,0}, {-1,1}, {0,1}},
	{{-1,-1}, {-1,0}, {0,0}, {1,0}, {1,1}}
      }
  },

  { "EE", 5,			/* Back S-shaped piece */
      {
	{{-1,-1}, {0,-1}, {0,0}, {0,1}, {1,1}},
	{{1,-1}, {-1,0}, {0,0}, {1,0}, {-1,1}},
 	{{-1,-1}, {0,-1}, {0,0}, {0,1}, {1,1}},
	{{1,-1}, {-1,0}, {0,0}, {1,0}, {-1,1}}
      }
  },

  { "88", 6,			/* Sea Horse-shaped piece */
      {
	{{0,-1}, {1,-1}, {-1,0}, {0,0}, {0,1}},
	{{0,-1}, {-1,0}, {0,0}, {1,0}, {1,1}},
	{{0,-1}, {0,0}, {1,0}, {-1,1}, {0,1}},
	{{-1,-1}, {-1,0}, {0,0}, {1,0}, {0,1}}
      }
  },

  { "OO", 6,			/* Back Sea Horse-shaped piece */
      {
	{{-1,-1}, {0,-1}, {0,0}, {1,0}, {0,1}},
	{{1,-1}, {-1,0}, {0,0}, {1,0}, {0,1}},
	{{0,-1}, {-1,0}, {0,0}, {0,1}, {1,1}},
	{{0,-1}, {-1,0}, {0,0}, {1,0}, {-1,1}}
      }
  }
};

/*-------------------------------------------------------------------------*/
