![01Yuji_title](https://user-images.githubusercontent.com/57783612/78629155-2dcb0800-78d1-11ea-8f96-867eaab4d39f.png)

[English](https://github.com/Kinutafontfactory/Yuji/blob/master/README.md)

# 佑字（ユウジ）

『佑字』は、書家・片岡佑之によって揮毫された原字を書体化した、5種類のフォントのシリーズです。【肅・舞・朴】3種類の日本語フォントと、【灯・曙】2種類の変体仮名フォント(古い形の仮名)があります。

## ライセンス

### フォントソフトウェアライセンス

このリポジトリで提供されるフォントソフトウェアは [SIL Open Font License, Version 1.1](https://scripts.sil.org/cms/scripts/page.php?site_id=nrsi&id=OFL) で利用できます。

## フォントのダウンロード（TTF）

* [最新リリース](https://github.com/Kinutafontfactory/Yuji/tree/master/fonts/ttf)

### 佑字シリーズの漢字について

漢字の揮毫にあたっては、書体字典の楷書体を参考にしつつも、識別の必要性などから明朝体の点画等を取り入れたものなどがあります。

### 佑字【肅】（ユウジ【シュク】）

伝統と格式を感じさせつつ、親しみやすさがあります。一般に広く受け入れられるデザインです。漢字と一部記号は舞と朴と共通です。

#### グリフセット・キャラクターセット・対応字形

 - Adobe Standard
   - [Adobe-Japan 1-3](https://github.com/adobe-type-tools/Adobe-Japan1)
     - 未収容CID一覧：99-107, 109-121, 123-230, 323, 325, 423-502, 514, 599-632, 8009-8010, 8015, 8057, 8059-8060, 8091, 8102-8111, 8152-8153, 8155-8157, 8159-8164, 8166-8182, 8184-8185, 8187-8190, 8192-8196, 8205, 8210, 8215-8218, 8224, 8227-8228, 8230-8263, 8268-8269, 8271-8283, 8324-8326, 8718-8719, 8818-8826, 8828-8840, 8842-8949, 9042, 9044-9083, 9263-9264, 9275-9779, 12870
   - JIS2004例字形対応
 - [GF Latin Core](https://github.com/googlefonts/gftools/tree/main/Lib/gftools/encodings/GF%20Glyph%20Sets#gf-latin-core)

### 佑字【舞】（ユウジ【マイ】）

自由で奔放で情緒的な美しさを表現しています。ラテンアルファベットは仮名の筆致に合わせて揮毫しました。

#### グリフセット・キャラクターセット・対応字形

 - 佑字【肅】と同じ
   - 漢字と一部記号は佑字【肅】と共通のものを収録しています。

### 佑字【朴】（ユウジ【ボク】）

あたらしさとたのしさを感じるデザインです。素朴さと温もりを合わせもっています。

#### グリフセット・キャラクターセット・対応字形

 - 佑字【肅】と同じ
   - 漢字と一部記号は佑字【肅】と共通のものを収録しています。

### 佑字【灯】（ユウジ【アカリ】）
### 佑字【曙】（ユウジ【アケボノ】）

現在のひらがなは1900年に定められたもので、それ以外を変体仮名と称されました。灯と曙は、いくつかある変体仮名のうち、2種類の変体仮名を揮毫したものです。変体仮名にカタカナはありません。ラテンアルファベットは時代感を合わせるために大文字のみのデザインとなっています。小文字はスモールキャップになっています。

#### グリフセット・キャラクターセット・対応字形

  - 「あ `U+3042` 」から「ん `U+3093` 」のうち拗音・促音を除く平仮名の文字コードへ対応する音の変体仮名字形を収録
  - [GF Latin Core](https://github.com/googlefonts/gftools/tree/main/Lib/gftools/encodings/GF%20Glyph%20Sets#gf-latin-core)

## フォントをビルドする

### 要件

バイナリフォントファイルをソースからビルドするには、`fontTools`、`glyphsLib`、`ufo2ft`、`ufoLib2`の各ライブラリが必要となります。

## フォントのビルド方法

ビルドプロセスの詳細については、`build.py`を参照してください。

## ご意見・ご提案など

ご意見・ご提案等がございましたら、砧書体制作所 佑字 プロジェクト管理者の [kiryumi](mailto:kinutaff@moji-sekkei.jp?subject=[GitHub]%20Yuji) までお送りください。検討させていただきます。

## さらに詳しい情報

佑字のデザインと開発の詳細については、 [砧書体制作所 佑字 制作話](http://www.moji-sekkei.jp/yuji3.html) を参照してください。
