.\# roff document
.\# DO NOT MODIFY THIS FILE! It was generated by md2roff
.do mso man.tmac
.TH NOTES 1 2023-09-10 "1.6" "User Commands"
.SH NAME
notes - manages note files.
.PP
.SH SYNOPSIS
\fBnotes\fR [\fB-s\fR \fIsection\fR] \fB-a\fR[\fB!\fR][\fIe\fR] \fIname\fR [\fIfile\fR ...][\fB-\fR] \fB-a\fR[\fB!\fR]\fB+\fR[\fIe\fR] \fIname\fR [\fIfile\fR ...][\fB-\fR] \fB-e\fR[\fIa\fR] {\fIname\fR|\fIpattern\fR} \fB-v\fR[\fIa\fR] {\fIname\fR|\fIpattern\fR} \fB-p\fR[\fIa\fR] {\fIname\fR|\fIpattern\fR} \fB-l\fR [\fIpattern\fR] \fB-f\fR \fIpattern\fR \fB-d\fR[\fIa\fR] {\fIname\fR|\fIpattern\fR} \fB-r\fR \fIoldname\fR \fInewname\fR \fB-c\fR \fIrcfile\fR
.PP
.SH DESCRIPTION
The notes-files are stored in a user-defined directory with optional subdirectories. The subdirectories in the application are named \fIsections\fP. Normally this directory is ‘\f[CR]~/.notes\fP’ or ‘\f[CR]~/Nextcloud/Notes\fP’ if there is \fBNextcloud\fP. It can be specified in the configuration file. The files can be plain text, markdown or anything else that can configured by the \fIrule\fP command in the configuration file. If the \fInote\fP is ‘\f[CR]-\fP’ then it reads from \fBstdin\fP.
.PP
Running program without arguments, enters in TUI mode (\fBncurses\fP interface).
.PP
The program was designed to behave as the ‘\f[CR]man\fP’ command:
.in +4n
.EX
# show page(s) of section (i.e. subdirectory) 'unix'
# whose title begins with 'sig11'
$ notes -s unix sig11

# search and show notes for a title with patterns
$ notes '*sig*'
.EE
.in
.SS Naming
Notes naming used in forms, a) just title, b) section/title, c) title.type, d) section/title.type. We can edit, view, move, rename, etc by using any of these forms.
.PP
.SH OPTIONS
.PP
.TP
\fB\fR\fB-a\fR[\fB!\fR], \fB--add\fR[\fB!\fR]
Creates a new note file. If file extension is not specified then the default will be used (see
.BR notesrc (5))
. If additional files are specified in the command line, their contents will be inserted into the new note. Use it with ‘\f[CR]-e\fP’ to invoke the editor or ‘\f[CR]-\fP’ to get input from \fBstdin\fP. If the name is already used in this section, then an error will be issued; use ‘\f[CR]!\fP’ option to replace the existing file, or set the clobber variable to \fIfalse\fP in the configuration file.
.PP
.in +4n
.EX
# example 1: cat yyy zzz > xxx
$ notes -a xxx yyy zzz

# example 2:
$ cat ~/.notesrc | notes -a! notesrc -
.EE
.in
.TP
\fB\fR\fB-a\fR[\fB!\fR]\fB+\fR, \fB--append\fR[\fB!\fR]
Same as ‘\f[CR]-a\fP’ but instead of overwriting, the new note is appended to the file. If the name does not exist, then an error will be issued; use ‘\f[CR]!\fP’ option to create it, or set the clobber variable to \fIfalse\fP in the configuration file.
.PP
.TP
\fB\fR\fB-v\fR, \fB--view\fR
Shows the \fInote\fP with the default \fB$PAGER\fP if one is not specified in the configuration file.
.PP
.in +4n
.EX
$ cat -v about-groff
.EE
.in
.TP
\fB\fR\fB-p\fR, \fB--print\fR
Same as ‘\f[CR]-v\fP’ but writes the contents to \fBstdout\fP.
.PP
.TP
\fB\fR\fB-e\fR, \fB--edit\fR
Loads the \fInote\fP to the default \fB$EDITOR\fP if one is not specified in the configuration file. Also, it can be used with ‘\f[CR]--add/--append\fP’ if it is next to it.
.PP
.TP
\fB\fR\fB-l\fR, \fB--list\fR
Displays the notes names that match \fIpattern\fP.
.PP
.TP
\fB\fR\fB-f\fR, \fB--files\fR
Same as ‘\f[CR]-l\fP’ but prints out the \fIfull-path filenames\fP.
.PP
.TP
\fB\fR\fB-d\fR, \fB--delete\fR
Deletes a note.
.PP
.TP
\fB\fR\fB-r\fR, \fB--rename\fR
Renames and/or moves a note. A second parameter is required to specify the new name. If file extension is specified in the new name, then it will use it. \fIrename\fP can also change the section if separated by '/' before the name, e.g., ‘\f[CR]section3/new-name\fP’.
.PP
.TP
\fB\fR\fB-a\fR, \fB--all\fR
Displays all notes that were found; it works together with ‘\f[CR]-v\fP’, ‘\f[CR]-p\fP’, ‘\f[CR]-e\fP’, and ‘\f[CR]-d\fP’. Do not use it as first option because it means ‘\f[CR]--add\fP’.
.PP
.TP
\fB\fR\fB-h\fR, \fB--help\fR
Displays a short help text and exits.
.PP
.TP
\fB\fR\fB-c\fR, \fB--rcfile\fR
Read this \fIrcfile\fP for setting notes options, instead of reading the default user's \fInotesrc\fP file.
.PP
.TP
\fB\fR\fB--version\fR
Displays the program version, copyright and license information and exits.
.PP
.TP
\fB\fR\fB--onstart\fR
Executes the command defined by ‘\f[CR]onstart\fP’ in the configuration file and returns its exit code. This option is useful when custom synchronization is needed.
.PP
.TP
\fB\fR\fB--onexit\fR
Executes the command defined by ‘\f[CR]onexit\fP’ in the configuration file and returns its exit code. This option is useful when custom synchronization is needed.
.PP
.SH ENVIRONMENT
The \fBSHELL\fP, \fBEDITOR\fP and \fBPAGER\fP environment variables are used.
.PP
.TP
\fBNOTESDIR\fR
The directory of notes. Usually used to pass this information to shell.
.PP
.TP
\fBNOTESFILES\fR
The list of selected files to process. Usually used to pass this information to shell.
.PP
.TP
\fBNOTESPAGER\fR
If set, the default pager for notes.
.PP
.TP
\fBNOTESEDITOR\fR
If set, the default editor for notes.
.PP
.TP
\fBBACKUPDIR\fR
If set, the default backup directory.
.PP
.SH FILES
When ‘\f[CR]--rcfile\fP’ is given, \fBnotes\fP will read the specified file for setting its options and key bindings. Without that option, \fBnotes\fP will read the user's \fInotesrc\fP (if it exists), either ‘\f[CR]$XDG_CONFIG_HOME/notes/notesrc\fP’ or ‘\f[CR]~/.config/notes/notesrc\fP’ or ‘\f[CR]~/.notesrc\fP’, whichever is encountered first. See
.BR notesrc (5).
.PP
.SH COPYRIGHT
Copyright © 2020-2022 Nicholas Christopoulos.
.PP
License GPLv3+: GNU GPL version 3 or later
.UR https://gnu.org/licenses/gpl.html
.UE .
This is free software: you are free to change and redistribute it. There is NO WARRANTY, to the extent permitted by law.
.PP
.SH HOMEPAGE
.UR https://codeberg.org/nereusx/notes
Homepage
.UE .
.PP
.SH AUTHOR
Written by Nicholas Christopoulos
.MT nereus@freemail.gr
.ME .
.PP
.SH SEE ALSO
.BR notesrc (5).
.PP
.PP
