# Audible

[![image](https://img.shields.io/pypi/v/audible.svg)](https://pypi.org/project/audible/)
[![image](https://img.shields.io/pypi/l/audible.svg)](https://pypi.org/project/audible/)
[![image](https://img.shields.io/pypi/pyversions/audible.svg)](https://pypi.org/project/audible/)
[![image](https://img.shields.io/pypi/status/audible.svg)](https://pypi.org/project/audible/)
[![image](https://img.shields.io/pypi/wheel/audible.svg)](https://pypi.org/project/audible/)
[![Travis](https://img.shields.io/travis/mkb79/audible/master.svg?logo=travis)](https://travis-ci.org/mkb79/audible)
[![CodeFactor](https://www.codefactor.io/repository/github/mkb79/audible/badge)](https://www.codefactor.io/repository/github/mkb79/audible)
[![image](https://img.shields.io/pypi/dm/audible.svg)](https://pypi.org/project/audible/)

**Audible is a Python low-level interface to communicate with the non-publicly
[Audible](<https://en.wikipedia.org/wiki/Audible_(service)>) API.**

It enables Python developers to create there own Audible services.
Asynchronous communication with the Audible API is supported.

For a basic command line interface take a look at my
[audible-cli](https://github.com/mkb79/audible-cli) package. This package
supports:

- downloading audiobooks (aax/aaxc), cover, PDF and chapter files
- export library to [csv](https://en.wikipedia.org/wiki/Comma-separated_values)
  files
- get activation bytes
- add own plugin commands

## Requirements

Python >= 3.8

## Installation

`pip install audible`

## Read the Doc

The documentation can be found at [Read the Docs](https://audible.readthedocs.io/en/latest)

## Contributing

Contributions are very welcome.
To learn more, see the [Contributor Guide].

## License

Distributed under the terms of the [AGPL-3.0][license],
_Audible_ is free and open source software.

## Issues

If you encounter any problems,
please [file an issue] along with a detailed description.

## Credits

Thanks a lot JetBrains for supporting me with a free [license](https://www.jetbrains.com/community/opensource/#support)
This project was generated from [@cjolowicz]'s [Hypermodern Python Cookiecutter] template.

[@cjolowicz]: https://github.com/cjolowicz
[pypi]: https://pypi.org/
[hypermodern python cookiecutter]: https://github.com/cjolowicz/cookiecutter-hypermodern-python
[file an issue]: https://github.com/mkb79/Audible/issues
[pip]: https://pip.pypa.io/
[audible]: https://github.com/mkb79/Audible
[pipx]: https://pypa.github.io/pipx/

<!-- github-only -->

[license]: https://github.com/mkb79/Audible/blob/main/LICENSE
[contributor guide]: https://github.com/mkb79/Audible/blob/main/CONTRIBUTING.md
