"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertYargsToUserInput = convertYargsToUserInput;
exports.convertConfigToUserInput = convertConfigToUserInput;
// @ts-ignore TS6133
function convertYargsToUserInput(args) {
    const globalOptions = {
        app: args.app,
        build: args.build,
        context: args.context,
        plugin: args.plugin,
        trace: args.trace,
        strict: args.strict,
        lookups: args.lookups,
        ignoreErrors: args.ignoreErrors,
        json: args.json,
        verbose: args.verbose,
        debug: args.debug,
        profile: args.profile,
        proxy: args.proxy,
        caBundlePath: args.caBundlePath,
        ec2creds: args.ec2creds,
        versionReporting: args.versionReporting,
        pathMetadata: args.pathMetadata,
        assetMetadata: args.assetMetadata,
        roleArn: args.roleArn,
        staging: args.staging,
        output: args.output,
        notices: args.notices,
        noColor: args.noColor,
        ci: args.ci,
        unstable: args.unstable,
        telemetryFile: args.telemetryFile,
        yes: args.yes,
    };
    let commandOptions;
    switch (args._[0]) {
        case 'list':
        case 'ls':
            commandOptions = {
                long: args.long,
                showDependencies: args.showDependencies,
                STACKS: args.STACKS,
            };
            break;
        case 'synth':
        case 'synthesize':
            commandOptions = {
                exclusively: args.exclusively,
                validation: args.validation,
                quiet: args.quiet,
                STACKS: args.STACKS,
            };
            break;
        case 'bootstrap':
            commandOptions = {
                bootstrapBucketName: args.bootstrapBucketName,
                bootstrapKmsKeyId: args.bootstrapKmsKeyId,
                examplePermissionsBoundary: args.examplePermissionsBoundary,
                customPermissionsBoundary: args.customPermissionsBoundary,
                bootstrapCustomerKey: args.bootstrapCustomerKey,
                qualifier: args.qualifier,
                publicAccessBlockConfiguration: args.publicAccessBlockConfiguration,
                denyExternalId: args.denyExternalId,
                tags: args.tags,
                execute: args.execute,
                trust: args.trust,
                trustForLookup: args.trustForLookup,
                untrust: args.untrust,
                cloudformationExecutionPolicies: args.cloudformationExecutionPolicies,
                force: args.force,
                terminationProtection: args.terminationProtection,
                showTemplate: args.showTemplate,
                toolkitStackName: args.toolkitStackName,
                template: args.template,
                previousParameters: args.previousParameters,
                ENVIRONMENTS: args.ENVIRONMENTS,
            };
            break;
        case 'gc':
            commandOptions = {
                action: args.action,
                type: args.type,
                rollbackBufferDays: args.rollbackBufferDays,
                createdBufferDays: args.createdBufferDays,
                confirm: args.confirm,
                toolkitStackName: args.toolkitStackName,
                bootstrapStackName: args.bootstrapStackName,
                ENVIRONMENTS: args.ENVIRONMENTS,
            };
            break;
        case 'flags':
            commandOptions = {
                value: args.value,
                set: args.set,
                all: args.all,
                unconfigured: args.unconfigured,
                recommended: args.recommended,
                default: args.default,
                interactive: args.interactive,
                safe: args.safe,
                concurrency: args.concurrency,
                FLAGNAME: args.FLAGNAME,
            };
            break;
        case 'deploy':
            commandOptions = {
                all: args.all,
                buildExclude: args.buildExclude,
                exclusively: args.exclusively,
                requireApproval: args.requireApproval,
                notificationArns: args.notificationArns,
                tags: args.tags,
                execute: args.execute,
                changeSetName: args.changeSetName,
                method: args.method,
                importExistingResources: args.importExistingResources,
                force: args.force,
                parameters: args.parameters,
                outputsFile: args.outputsFile,
                previousParameters: args.previousParameters,
                toolkitStackName: args.toolkitStackName,
                progress: args.progress,
                rollback: args.rollback,
                hotswap: args.hotswap,
                hotswapFallback: args.hotswapFallback,
                hotswapEcsMinimumHealthyPercent: args.hotswapEcsMinimumHealthyPercent,
                hotswapEcsMaximumHealthyPercent: args.hotswapEcsMaximumHealthyPercent,
                hotswapEcsStabilizationTimeoutSeconds: args.hotswapEcsStabilizationTimeoutSeconds,
                watch: args.watch,
                logs: args.logs,
                concurrency: args.concurrency,
                assetParallelism: args.assetParallelism,
                assetPrebuild: args.assetPrebuild,
                ignoreNoStacks: args.ignoreNoStacks,
                STACKS: args.STACKS,
            };
            break;
        case 'rollback':
            commandOptions = {
                all: args.all,
                toolkitStackName: args.toolkitStackName,
                force: args.force,
                validateBootstrapVersion: args.validateBootstrapVersion,
                orphan: args.orphan,
                STACKS: args.STACKS,
            };
            break;
        case 'import':
            commandOptions = {
                execute: args.execute,
                changeSetName: args.changeSetName,
                toolkitStackName: args.toolkitStackName,
                rollback: args.rollback,
                force: args.force,
                recordResourceMapping: args.recordResourceMapping,
                resourceMapping: args.resourceMapping,
                STACK: args.STACK,
            };
            break;
        case 'watch':
            commandOptions = {
                buildExclude: args.buildExclude,
                exclusively: args.exclusively,
                changeSetName: args.changeSetName,
                force: args.force,
                toolkitStackName: args.toolkitStackName,
                progress: args.progress,
                rollback: args.rollback,
                hotswap: args.hotswap,
                hotswapFallback: args.hotswapFallback,
                hotswapEcsMinimumHealthyPercent: args.hotswapEcsMinimumHealthyPercent,
                hotswapEcsMaximumHealthyPercent: args.hotswapEcsMaximumHealthyPercent,
                hotswapEcsStabilizationTimeoutSeconds: args.hotswapEcsStabilizationTimeoutSeconds,
                logs: args.logs,
                concurrency: args.concurrency,
                STACKS: args.STACKS,
            };
            break;
        case 'destroy':
            commandOptions = {
                all: args.all,
                exclusively: args.exclusively,
                force: args.force,
                STACKS: args.STACKS,
            };
            break;
        case 'diff':
            commandOptions = {
                exclusively: args.exclusively,
                contextLines: args.contextLines,
                template: args.template,
                strict: args.strict,
                securityOnly: args.securityOnly,
                fail: args.fail,
                processed: args.processed,
                quiet: args.quiet,
                changeSet: args.changeSet,
                importExistingResources: args.importExistingResources,
                includeMoves: args.includeMoves,
                STACKS: args.STACKS,
            };
            break;
        case 'drift':
            commandOptions = {
                fail: args.fail,
                STACKS: args.STACKS,
            };
            break;
        case 'metadata':
            commandOptions = {
                STACK: args.STACK,
            };
            break;
        case 'acknowledge':
        case 'ack':
            commandOptions = {
                ID: args.ID,
            };
            break;
        case 'notices':
            commandOptions = {
                unacknowledged: args.unacknowledged,
            };
            break;
        case 'init':
            commandOptions = {
                language: args.language,
                list: args.list,
                generateOnly: args.generateOnly,
                libVersion: args.libVersion,
                fromPath: args.fromPath,
                templatePath: args.templatePath,
                packageManager: args.packageManager,
                projectName: args.projectName,
                TEMPLATE: args.TEMPLATE,
            };
            break;
        case 'migrate':
            commandOptions = {
                stackName: args.stackName,
                language: args.language,
                account: args.account,
                region: args.region,
                fromPath: args.fromPath,
                fromStack: args.fromStack,
                outputPath: args.outputPath,
                fromScan: args.fromScan,
                filter: args.filter,
                compress: args.compress,
            };
            break;
        case 'context':
            commandOptions = {
                reset: args.reset,
                force: args.force,
                clear: args.clear,
            };
            break;
        case 'docs':
        case 'doc':
            commandOptions = {
                browser: args.browser,
            };
            break;
        case 'doctor':
            commandOptions = {};
            break;
        case 'refactor':
            commandOptions = {
                additionalStackName: args.additionalStackName,
                dryRun: args.dryRun,
                overrideFile: args.overrideFile,
                revert: args.revert,
                force: args.force,
                STACKS: args.STACKS,
            };
            break;
        case 'cli-telemetry':
            commandOptions = {
                enable: args.enable,
                disable: args.disable,
                status: args.status,
            };
            break;
    }
    const userInput = {
        command: args._[0],
        globalOptions,
        [args._[0]]: commandOptions,
    };
    return userInput;
}
// @ts-ignore TS6133
function convertConfigToUserInput(config) {
    const globalOptions = {
        app: config.app,
        build: config.build,
        context: config.context,
        plugin: config.plugin,
        trace: config.trace,
        strict: config.strict,
        lookups: config.lookups,
        ignoreErrors: config.ignoreErrors,
        json: config.json,
        verbose: config.verbose,
        debug: config.debug,
        profile: config.profile,
        proxy: config.proxy,
        caBundlePath: config.caBundlePath,
        ec2creds: config.ec2creds,
        versionReporting: config.versionReporting,
        pathMetadata: config.pathMetadata,
        assetMetadata: config.assetMetadata,
        roleArn: config.roleArn,
        staging: config.staging,
        output: config.output,
        notices: config.notices,
        noColor: config.noColor,
        ci: config.ci,
        unstable: config.unstable,
        telemetryFile: config.telemetryFile,
        yes: config.yes,
    };
    const listOptions = {
        long: config.list?.long,
        showDependencies: config.list?.showDependencies,
    };
    const synthOptions = {
        exclusively: config.synth?.exclusively,
        validation: config.synth?.validation,
        quiet: config.synth?.quiet,
    };
    const bootstrapOptions = {
        bootstrapBucketName: config.bootstrap?.bootstrapBucketName,
        bootstrapKmsKeyId: config.bootstrap?.bootstrapKmsKeyId,
        examplePermissionsBoundary: config.bootstrap?.examplePermissionsBoundary,
        customPermissionsBoundary: config.bootstrap?.customPermissionsBoundary,
        bootstrapCustomerKey: config.bootstrap?.bootstrapCustomerKey,
        qualifier: config.bootstrap?.qualifier,
        publicAccessBlockConfiguration: config.bootstrap?.publicAccessBlockConfiguration,
        denyExternalId: config.bootstrap?.denyExternalId,
        tags: config.bootstrap?.tags,
        execute: config.bootstrap?.execute,
        trust: config.bootstrap?.trust,
        trustForLookup: config.bootstrap?.trustForLookup,
        untrust: config.bootstrap?.untrust,
        cloudformationExecutionPolicies: config.bootstrap?.cloudformationExecutionPolicies,
        force: config.bootstrap?.force,
        terminationProtection: config.bootstrap?.terminationProtection,
        showTemplate: config.bootstrap?.showTemplate,
        toolkitStackName: config.bootstrap?.toolkitStackName,
        template: config.bootstrap?.template,
        previousParameters: config.bootstrap?.previousParameters,
    };
    const gcOptions = {
        action: config.gc?.action,
        type: config.gc?.type,
        rollbackBufferDays: config.gc?.rollbackBufferDays,
        createdBufferDays: config.gc?.createdBufferDays,
        confirm: config.gc?.confirm,
        toolkitStackName: config.gc?.toolkitStackName,
        bootstrapStackName: config.gc?.bootstrapStackName,
    };
    const flagsOptions = {
        value: config.flags?.value,
        set: config.flags?.set,
        all: config.flags?.all,
        unconfigured: config.flags?.unconfigured,
        recommended: config.flags?.recommended,
        default: config.flags?.default,
        interactive: config.flags?.interactive,
        safe: config.flags?.safe,
        concurrency: config.flags?.concurrency,
    };
    const deployOptions = {
        all: config.deploy?.all,
        buildExclude: config.deploy?.buildExclude,
        exclusively: config.deploy?.exclusively,
        requireApproval: config.deploy?.requireApproval,
        notificationArns: config.deploy?.notificationArns,
        tags: config.deploy?.tags,
        execute: config.deploy?.execute,
        changeSetName: config.deploy?.changeSetName,
        method: config.deploy?.method,
        importExistingResources: config.deploy?.importExistingResources,
        force: config.deploy?.force,
        parameters: config.deploy?.parameters,
        outputsFile: config.deploy?.outputsFile,
        previousParameters: config.deploy?.previousParameters,
        toolkitStackName: config.deploy?.toolkitStackName,
        progress: config.deploy?.progress,
        rollback: config.deploy?.rollback,
        hotswap: config.deploy?.hotswap,
        hotswapFallback: config.deploy?.hotswapFallback,
        hotswapEcsMinimumHealthyPercent: config.deploy?.hotswapEcsMinimumHealthyPercent,
        hotswapEcsMaximumHealthyPercent: config.deploy?.hotswapEcsMaximumHealthyPercent,
        hotswapEcsStabilizationTimeoutSeconds: config.deploy?.hotswapEcsStabilizationTimeoutSeconds,
        watch: config.deploy?.watch,
        logs: config.deploy?.logs,
        concurrency: config.deploy?.concurrency,
        assetParallelism: config.deploy?.assetParallelism,
        assetPrebuild: config.deploy?.assetPrebuild,
        ignoreNoStacks: config.deploy?.ignoreNoStacks,
    };
    const rollbackOptions = {
        all: config.rollback?.all,
        toolkitStackName: config.rollback?.toolkitStackName,
        force: config.rollback?.force,
        validateBootstrapVersion: config.rollback?.validateBootstrapVersion,
        orphan: config.rollback?.orphan,
    };
    const importOptions = {
        execute: config.import?.execute,
        changeSetName: config.import?.changeSetName,
        toolkitStackName: config.import?.toolkitStackName,
        rollback: config.import?.rollback,
        force: config.import?.force,
        recordResourceMapping: config.import?.recordResourceMapping,
        resourceMapping: config.import?.resourceMapping,
    };
    const watchOptions = {
        buildExclude: config.watch?.buildExclude,
        exclusively: config.watch?.exclusively,
        changeSetName: config.watch?.changeSetName,
        force: config.watch?.force,
        toolkitStackName: config.watch?.toolkitStackName,
        progress: config.watch?.progress,
        rollback: config.watch?.rollback,
        hotswap: config.watch?.hotswap,
        hotswapFallback: config.watch?.hotswapFallback,
        hotswapEcsMinimumHealthyPercent: config.watch?.hotswapEcsMinimumHealthyPercent,
        hotswapEcsMaximumHealthyPercent: config.watch?.hotswapEcsMaximumHealthyPercent,
        hotswapEcsStabilizationTimeoutSeconds: config.watch?.hotswapEcsStabilizationTimeoutSeconds,
        logs: config.watch?.logs,
        concurrency: config.watch?.concurrency,
    };
    const destroyOptions = {
        all: config.destroy?.all,
        exclusively: config.destroy?.exclusively,
        force: config.destroy?.force,
    };
    const diffOptions = {
        exclusively: config.diff?.exclusively,
        contextLines: config.diff?.contextLines,
        template: config.diff?.template,
        strict: config.diff?.strict,
        securityOnly: config.diff?.securityOnly,
        fail: config.diff?.fail,
        processed: config.diff?.processed,
        quiet: config.diff?.quiet,
        changeSet: config.diff?.changeSet,
        importExistingResources: config.diff?.importExistingResources,
        includeMoves: config.diff?.includeMoves,
    };
    const driftOptions = {
        fail: config.drift?.fail,
    };
    const metadataOptions = {};
    const acknowledgeOptions = {};
    const noticesOptions = {
        unacknowledged: config.notices?.unacknowledged,
    };
    const initOptions = {
        language: config.init?.language,
        list: config.init?.list,
        generateOnly: config.init?.generateOnly,
        libVersion: config.init?.libVersion,
        fromPath: config.init?.fromPath,
        templatePath: config.init?.templatePath,
        packageManager: config.init?.packageManager,
        projectName: config.init?.projectName,
    };
    const migrateOptions = {
        stackName: config.migrate?.stackName,
        language: config.migrate?.language,
        account: config.migrate?.account,
        region: config.migrate?.region,
        fromPath: config.migrate?.fromPath,
        fromStack: config.migrate?.fromStack,
        outputPath: config.migrate?.outputPath,
        fromScan: config.migrate?.fromScan,
        filter: config.migrate?.filter,
        compress: config.migrate?.compress,
    };
    const contextOptions = {
        reset: config.context?.reset,
        force: config.context?.force,
        clear: config.context?.clear,
    };
    const docsOptions = {
        browser: config.docs?.browser,
    };
    const doctorOptions = {};
    const refactorOptions = {
        additionalStackName: config.refactor?.additionalStackName,
        dryRun: config.refactor?.dryRun,
        overrideFile: config.refactor?.overrideFile,
        revert: config.refactor?.revert,
        force: config.refactor?.force,
    };
    const cliTelemetryOptions = {
        enable: config.cliTelemetry?.enable,
        disable: config.cliTelemetry?.disable,
        status: config.cliTelemetry?.status,
    };
    const userInput = {
        globalOptions,
        list: listOptions,
        synth: synthOptions,
        bootstrap: bootstrapOptions,
        gc: gcOptions,
        flags: flagsOptions,
        deploy: deployOptions,
        rollback: rollbackOptions,
        import: importOptions,
        watch: watchOptions,
        destroy: destroyOptions,
        diff: diffOptions,
        drift: driftOptions,
        metadata: metadataOptions,
        acknowledge: acknowledgeOptions,
        notices: noticesOptions,
        init: initOptions,
        migrate: migrateOptions,
        context: contextOptions,
        docs: docsOptions,
        doctor: doctorOptions,
        refactor: refactorOptions,
        cliTelemetry: cliTelemetryOptions,
    };
    return userInput;
}
//# sourceMappingURL=data:application/json;base64,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