import type { FeatureFlag, Toolkit } from '@aws-cdk/toolkit-lib';
import type { FlagOperationsParams } from './types';
import type { IoHelper } from '../../api-private';
export declare class FlagCommandHandler {
    private readonly flags;
    private readonly router;
    private readonly options;
    private readonly ioHelper;
    /** Main component that sets up all flag operation components */
    constructor(flagData: FeatureFlag[], ioHelper: IoHelper, options: FlagOperationsParams, toolkit: Toolkit, cliContextValues?: Record<string, any>);
    /** Main entry point that processes the flags command */
    processFlagsCommand(): Promise<void>;
}
