#include <array>
#include <string_view>

#include "src/tmc/eventdb.hh"

namespace redsea::tmc {

// https://wiki.openstreetmap.org/wiki/TMC/Event_Code_List

// clang-format off
const std::array<std::string_view, 1553> tmc_raw_data_events{
  "Code;Description;Description with Q;N;Q;T;D;U;C;R",
  "1;traffic problem;;;0;D;1;U;1;A50",
  "2;queuing traffic. Danger of stationary traffic;queuing traffic with average speeds (Q). Danger of stationary traffic;;4;D;1;U;1;A2.A1D",
  "11;overheight warning system triggered;;;0;(D);1;U;4;B50",
  "12;accident, traffic being directed around accident area;(Q) accidents, traffic being directed around accident area;;0;D;1;U;3;B1.Z95",
  "16;closed, rescue and recovery work in progress;;;0;D;1;U;5;C1.Z42",
  "20;service area overcrowded, drive to another service area;;;0;D;1;;9;C58",
  "22;service area, fuel station closed;;;0;L;1;;9;C51",
  "23;service area, restaurant closed;;;0;L;1;;9;C52",
  "24;bridge closed;;;0;L;1;U;9;C53",
  "25;tunnel closed;;;0;L;1;U;9;C54",
  "26;bridge blocked;;;0;D;1;U;6;C55",
  "27;tunnel blocked;;;0;D;1;U;6;C56",
  "28;road closed intermittently;;;0;D;1;U;9;C57",
  "36;fuel station reopened;;;0;(D);1;;9;C88",
  "37;restaurant reopened;;;0;(D);1;;9;C89",
  "39;reopening of bridge expected;reopening of bridge expected (Q);F;7;L;2;;39;",
  "40;smog alert ended;;;0;(L);2;;9;L96",
  "41;overtaking lane closed;(Q) overtaking lanes closed;;0;L;1;;5;D50",
  "42;overtaking lane blocked;(Q) overtaking lanes blocked;;0;D;1;U;5;D51",
  "51;roadworks, overtaking lane closed;roadworks, (Q) overtaking lanes closed;;0;L;1;;5;E1.D50",
  "52;roadworks on the hard shoulder;(Q) sets of roadworks on the hard shoulder;;0;L;1;;11;E11.Z146",
  "53;roadworks in the emergency lane;(Q) sets of roadworks in the emergency lane;;0;L;1;;11;E11.Z147",
  "55;traffic problem expected;;F;0;D;1;;2;A50E",
  "56;traffic congestion expected;;F;0;D;1;U;2;A9E",
  "57;normal traffic expected;;F;0;D;1;;2;A96E",
  "61;object on roadway {something that does not neccessarily block the road or part of it};(Q) objects on roadway {something that does not neccessarily block the road or part of it};;0;D;1;U;12;F27",
  "62;burst pipe;(Q) burst pipes;;0;D;2;;12;F51",
  "63;object on the road. Danger;(Q) objects on the road. Danger;;0;D;1;U;12;F27.Z91",
  "64;burst pipe. Danger;;;0;D;2;U;12;F28.Z91",
  "70;traffic congestion, average speed of 10 km/h;;;0;D;1;U;1;A910",
  "71;traffic congestion, average speed of 20 km/h;;;0;D;1;U;1;A920",
  "72;traffic congestion, average speed of 30 km/h;;;0;D;1;U;1;A930",
  "73;traffic congestion, average speed of 40 km/h;;;0;D;1;U;1;A940",
  "74;traffic congestion, average speed of 50 km/h;;;0;D;1;;1;A950",
  "75;traffic congestion, average speed of 60 km/h;;;0;D;1;;1;A960",
  "76;traffic congestion, average speed of 70 km/h;;;0;D;1;;1;A970",
  "80;heavy traffic has to be expected;;F;0;L;1;;32;A4F",
  "81;traffic congestion has to be expected;;F;0;L;1;U;32;A9F",
  "82;roadworks. Heavy traffic has to be expected;(Q) sets of roadworks. Heavy traffic has to be expected;F;0;L;1;;32;E1.A4F",
  "83;closed ahead. Heavy traffic expected;;F;0;L;1;U;32;C3.A4F",
  "84;major event. Heavy traffic has to be expected;;F;0;L;1;;32;P1.A4F",
  "85;sports meeting. Heavy traffic has to be expected;;F;0;L;1;;32;P2.A4F",
  "86;fair. Heavy traffic has to be expected;;F;0;L;1;;32;P6.A4F",
  "87;evacuation. Heavy traffic has to be expected;;F;0;L;1;;32;P49.A4F",
  "88;traffic congestion forecast withdrawn;;F;0;(L);1;;32;A96F",
  "89;message cancelled;;S;0;;0;;32;",
  "91;delays for cars;delays (Q) for cars;;5;D;1;;20;Q1.Z71",
  "101;stationary traffic;;;0;D;1;U;1;A1",
  "102;stationary traffic for 1 km;;;0;D;1;U;1;A101",
  "103;stationary traffic for 2 km;;;0;D;1;U;1;A102",
  "104;stationary traffic for 4 km;;;0;D;1;U;1;A104",
  "105;stationary traffic for 6 km;;;0;D;1;U;1;A106",
  "106;stationary traffic for 10 km;;;0;D;1;U;1;A110",
  "107;stationary traffic expected;;F;0;D;1;U;2;A1E",
  "108;queuing traffic;queuing traffic with average speeds (Q);;4;D;1;U;1;A2",
  "109;queuing traffic for 1 km;queuing traffic for 1 km with average speeds (Q);;4;D;1;U;1;A201",
  "110;queuing traffic for 2 km;queuing traffic for 2 km with average speeds (Q);;4;D;1;U;1;A202",
  "111;queuing traffic for 4 km;queuing traffic for 4 km with average speeds (Q);;4;D;1;U;1;A204",
  "112;queuing traffic for 6 km;queuing traffic for 6 km with average speeds (Q);;4;D;1;U;1;A206",
  "113;queuing traffic for 10 km;queuing traffic for 10 km with average speeds (Q);;4;D;1;U;1;A210",
  "114;queuing traffic expected;;F;0;D;1;U;2;A2E",
  "115;slow traffic;slow traffic with average speeds (Q);;4;D;1;U;1;A3",
  "116;slow traffic for 1 km;slow traffic for 1 km with average speeds (Q);;4;D;1;U;1;A301",
  "117;slow traffic for 2 km;slow traffic for 2 km with average speeds (Q);;4;D;1;U;1;A302",
  "118;slow traffic for 4 km;slow traffic for 4 km with average speeds (Q);;4;D;1;U;1;A304",
  "119;slow traffic for 6 km;slow traffic for 6 km with average speeds (Q);;4;D;1;U;1;A306",
  "120;slow traffic for 10 km;slow traffic for 10 km with average speeds (Q);;4;D;1;U;1;A310",
  "121;slow traffic expected;;F;0;D;1;U;2;A3E",
  "122;heavy traffic;heavy traffic with average speeds (Q);;4;D;1;;1;A4",
  "123;heavy traffic expected;;F;0;D;1;;2;A4E",
  "124;traffic flowing freely;traffic flowing freely with average speeds (Q);;4;(D);1;;1;A5",
  "125;traffic building up;traffic building up with average speeds (Q);;4;D;1;;1;A6",
  "126;no problems to report;;;0;(D);1;;1;A97",
  "127;traffic congestion cleared;;;0;(D);1;;1;A98",
  "128;message cancelled;;S;0;;0;;1;",
  "129;stationary traffic for 3 km;;;0;D;1;U;1;A103",
  "130;danger of stationary traffic;;;0;D;1;U;1;A1D",
  "131;queuing traffic for 3 km;queuing traffic for 3 km with average speeds (Q);;4;D;1;U;1;A203",
  "132;danger of queuing traffic;danger of queuing traffic with average speeds (Q);;4;D;1;U;1;A2D",
  "133;long queues;long queues with average speeds (Q);;4;D;1;U;1;A7",
  "134;slow traffic for 3 km;slow traffic for 3 km with average speeds (Q);;4;D;1;U;1;A303",
  "135;traffic easing;;;0;(D);1;;1;A8",
  "136;traffic congestion;traffic congestion with average speeds (Q);;4;D;1;;1;A9",
  "137;traffic lighter than normal;traffic lighter than normal with average speeds (Q);;4;D;1;;1;A10",
  "138;queuing traffic. Approach with care;queuing traffic with average speeds (Q). Approach with care;;4;D;1;U;1;A2.Z112",
  "139;queuing traffic around a bend in the road;;;0;D;1;U;1;A2.Z165",
  "140;queuing traffic over the crest of a hill;;;0;D;1;U;1;A2.Z166",
  "141;all accidents cleared, no problems to report;;;0;(D);1;;3;B95",
  "142;traffic heavier than normal;traffic heavier than normal with average speeds (Q);;4;D;1;;1;A11",
  "143;traffic very much heavier than normal;traffic very much heavier than normal with average speeds (Q);;4;D;1;;1;A12",
  "200;multi vehicle pile up. Delays;multi vehicle pile up. Delays (Q);;5;D;1;U;20;B3.Q1",
  "201;accident;(Q) accidents;;0;(D);1;;3;B1",
  "202;serious accident;(Q) serious accidents;;0;(D);1;U;3;B2",
  "203;multi-vehicle accident;multi-vehicle accident involving (Q) vehicles;;0;(D);1;U;3;B3",
  "204;accident involving heavy lorr(y/ies);accident involving a/(Q) heavy lorr(y/ies);;0;(D);1;U;3;B4",
  "205;accident involving hazardous materials;(Q) accidents involving hazardous materials;;0;(D);1;U;3;B5",
  "206;fuel spillage accident;(Q) fuel spillage accidents;;0;(D);1;U;3;B6",
  "207;chemical spillage accident;(Q) chemical spillage accidents;;0;(D);1;U;3;B7",
  "208;vehicles slowing to look at accident;vehicles slowing to look at (Q) accidents;;0;(D);1;;1;B8",
  "209;accident in the opposing lanes;(Q) accidents in the opposing lanes;;0;(D);1;;3;B1.Z32",
  "210;shed load;(Q) shed loads;;0;D;1;;12;B10",
  "211;broken down vehicle;(Q) broken down vehicles;;0;(D);1;;4;B11",
  "212;broken down heavy lorr(y/ies);(Q) broken down heavy lorr(y/ies);;0;(D);1;;4;B12",
  "213;vehicle fire;(Q) vehicle fires;;0;(D);1;;3;B13",
  "214;incident;(Q) incidents;;0;(D);1;;4;B14",
  "215;accident. Stationary traffic;(Q) accidents. Stationary traffic;;0;D;1;U;1;B1.A1",
  "216;accident. Stationary traffic for 1 km;(Q) accidents. Stationary traffic for 1 km;;0;D;1;U;1;B1.A101",
  "217;accident. Stationary traffic for 2 km;(Q) accidents. Stationary traffic for 2 km;;0;D;1;U;1;B1.A102",
  "218;accident. Stationary traffic for 4 km;(Q) accidents. Stationary traffic for 4 km;;0;D;1;U;1;B1.A104",
  "219;accident. Stationary traffic for 6 km;(Q) accidents. Stationary traffic for 6 km;;0;D;1;U;1;B1.A106",
  "220;accident. Stationary traffic for 10 km;(Q) accidents. Stationary traffic for 10 km;;0;D;1;U;1;B1.A110",
  "221;accident. Danger of stationary traffic;(Q) accidents. Danger of stationary traffic;;0;D;1;U;1;B1.A1D",
  "222;accident. Queuing traffic;(Q) accidents. Queuing traffic;;0;D;1;U;1;B1.A2",
  "223;accident. Queuing traffic for 1 km;(Q) accidents. Queuing traffic for 1 km;;0;D;1;U;1;B1.A201",
  "224;accident. Queuing traffic for 2 km;(Q) accidents. Queuing traffic for 2 km;;0;D;1;U;1;B1.A202",
  "225;accident. Queuing traffic for 4 km;(Q) accidents. Queuing traffic for 4 km;;0;D;1;U;1;B1.A204",
  "226;accident. Queuing traffic for 6 km;(Q) accidents. Queuing traffic for 6 km;;0;D;1;U;1;B1.A206",
  "227;accident. Queuing traffic for 10 km;(Q) accidents. Queuing traffic for 10 km;;0;D;1;U;1;B1.A210",
  "228;accident. Danger of queuing traffic;(Q) accidents. Danger of queuing traffic;;0;D;1;U;1;B1.A2D",
  "229;accident. Slow traffic;(Q) accidents. Slow traffic;;0;D;1;U;1;B1.A3",
  "230;accident. Slow traffic for 1 km;(Q) accidents. Slow traffic for 1 km;;0;D;1;U;1;B1.A301",
  "231;accident. Slow traffic for 2 km;(Q) accidents. Slow traffic for 2 km;;0;D;1;U;1;B1.A302",
  "232;accident. Slow traffic for 4 km;(Q) accidents. Slow traffic for 4 km;;0;D;1;U;1;B1.A304",
  "233;accident. Slow traffic for 6 km;(Q) accidents. Slow traffic for 6 km;;0;D;1;U;1;B1.A306",
  "234;accident. Slow traffic for 10 km;(Q) accidents. Slow traffic for 10 km;;0;D;1;U;1;B1.A310",
  "235;accident. Slow traffic expected;(Q) accidents. Slow traffic expected;F;0;D;1;U;2;B1.A3E",
  "236;accident. Heavy traffic;(Q) accidents. Heavy traffic;;0;D;1;;1;B1.A4",
  "237;accident. Heavy traffic expected;(Q) accidents. Heavy traffic expected;F;0;D;1;;2;B1.A4E",
  "238;accident. Traffic flowing freely;(Q) accidents. Traffic flowing freely;;0;(D);1;;1;B1.A5",
  "239;accident. Traffic building up;(Q) accidents. Traffic building up;;0;D;1;;1;B1.A6",
  "240;road closed due to accident;road closed due to (Q) accidents;;0;D;1;U;5;B1.C1",
  "241;accident. Right lane blocked;(Q) accidents. Right lane blocked;;0;D;1;U;5;B1.D8",
  "242;accident. Centre lane blocked;(Q) accidents. Centre lane blocked;;0;D;1;U;5;B1.D9",
  "243;accident. Left lane blocked;(Q) accidents. Left lane blocked;;0;D;1;U;5;B1.D10",
  "244;accident. Hard shoulder blocked;(Q) accidents. Hard shoulder blocked;;0;D;1;U;5;B1.D11",
  "245;accident. Two lanes blocked;(Q) accidents. Two lanes blocked;;0;D;1;U;5;B1.D12",
  "246;accident. Three lanes blocked;(Q) accidents. Three lanes blocked;;0;D;1;U;5;B1.D13",
  "247;accident. Delays;accident. Delays (Q);;5;D;1;;20;B1.Q1",
  "248;accident. Delays expected;accident. Delays (Q) expected;F;5;D;1;;20;B1.Q1E",
  "249;accident. Long delays;accident. Long delays (Q);;5;D;1;U;20;B1.Q2",
  "250;vehicles slowing to look at accident. Stationary traffic;vehicles slowing to look at (Q) accidents. Stationary traffic;;0;D;1;U;1;B8.A1",
  "251;vehicles slowing to look at accident. Stationary traffic for 1 km;vehicles slowing to look at (Q) accidents. Stationary traffic for 1 km;;0;D;1;U;1;B8.A101",
  "252;vehicles slowing to look at accident. Stationary traffic for 2 km;vehicles slowing to look at (Q) accidents. Stationary traffic for 2 km;;0;D;1;U;1;B8.A102",
  "253;vehicles slowing to look at accident. Stationary traffic for 4 km;vehicles slowing to look at (Q) accidents. Stationary traffic for 4 km;;0;D;1;U;1;B8.A104",
  "254;vehicles slowing to look at accident. Stationary traffic for 6 km;vehicles slowing to look at (Q) accidents. Stationary traffic for 6 km;;0;D;1;U;1;B8.A106",
  "255;vehicles slowing to look at accident. Stationary traffic for 10 km;vehicles slowing to look at (Q) accidents. Stationary traffic for 10 km;;0;D;1;U;1;B8.A110",
  "256;vehicles slowing to look at accident. Danger of stationary traffic;vehicles slowing to look at (Q) accidents. Danger of stationary traffic;;0;D;1;U;1;B8.A1D",
  "257;vehicles slowing to look at accident. Queuing traffic;vehicles slowing to look at (Q) accidents. Queuing traffic;;0;D;1;U;1;B8.A2",
  "258;vehicles slowing to look at accident. Queuing traffic for 1 km;vehicles slowing to look at (Q) accidents. Queuing traffic for 1 km;;0;D;1;U;1;B8.A201",
  "259;vehicles slowing to look at accident. Queuing traffic for 2 km;vehicles slowing to look at (Q) accidents. Queuing traffic for 2 km;;0;D;1;U;1;B8.A202",
  "260;vehicles slowing to look at accident. Queuing traffic for 4 km;vehicles slowing to look at (Q) accidents. Queuing traffic for 4 km;;0;D;1;U;1;B8.A204",
  "261;vehicles slowing to look at accident. Queuing traffic for 6 km;vehicles slowing to look at (Q) accidents. Queuing traffic for 6 km;;0;D;1;U;1;B8.A206",
  "262;vehicles slowing to look at accident. Queuing traffic for 10 km;vehicles slowing to look at (Q) accidents. Queuing traffic for 10 km;;0;D;1;U;1;B8.A210",
  "263;vehicles slowing to look at accident. Danger of queuing traffic;vehicles slowing to look at (Q) accidents. Danger of queuing traffic;;0;D;1;U;1;B8.A2D",
  "264;vehicles slowing to look at accident. Slow traffic;vehicles slowing to look at (Q) accidents. Slow traffic;;0;D;1;U;1;B8.A3",
  "265;vehicles slowing to look at accident. Slow traffic for 1 km;vehicles slowing to look at (Q) accidents. Slow traffic for 1 km;;0;D;1;U;1;B8.A301",
  "266;vehicles slowing to look at accident. Slow traffic for 2 km;vehicles slowing to look at (Q) accidents. Slow traffic for 2 km;;0;D;1;U;1;B8.A302",
  "267;vehicles slowing to look at accident. Slow traffic for 4 km;vehicles slowing to look at (Q) accidents. Slow traffic for 4 km;;0;D;1;U;1;B8.A304",
  "268;vehicles slowing to look at accident. Slow traffic for 6 km;vehicles slowing to look at (Q) accidents. Slow traffic for 6 km;;0;D;1;U;1;B8.A306",
  "269;vehicles slowing to look at accident. Slow traffic for 10 km;vehicles slowing to look at (Q) accidents. Slow traffic for 10 km;;0;D;1;U;1;B8.A310",
  "270;vehicles slowing to look at accident. Slow traffic expected;vehicles slowing to look at (Q) accidents. Slow traffic expected;F;0;D;1;U;2;B8.A3E",
  "271;vehicles slowing to look at accident. Heavy traffic;vehicles slowing to look at (Q) accidents. Heavy traffic;;0;D;1;;1;B8.A4",
  "272;vehicles slowing to look at accident. Heavy traffic expected;vehicles slowing to look at (Q) accidents. Heavy traffic expected;F;0;D;1;;2;B8.A4E",
  "274;vehicles slowing to look at accident. Traffic building up;vehicles slowing to look at (Q) accidents. Traffic building up;;0;D;1;;1;B8.A6",
  "275;vehicles slowing to look at accident. Delays;vehicles slowing to look at accident. Delays (Q);;5;D;1;U;20;B8.Q1",
  "276;vehicles slowing to look at accident. Delays expected;vehicles slowing to look at accident. Delays (Q) expected;F;5;D;1;U;20;B8.Q1E",
  "277;vehicles slowing to look at accident. Long delays;vehicles slowing to look at accident. Long delays (Q);;5;D;1;U;20;B8.Q2",
  "278;shed load. Stationary traffic;(Q) shed loads. Stationary traffic;;0;D;1;U;1;B10.A1",
  "279;shed load. Stationary traffic for 1 km;(Q) shed loads. Stationary traffic for 1 km;;0;D;1;U;1;B10.A101",
  "280;shed load. Stationary traffic for 2 km;(Q) shed loads. Stationary traffic for 2 km;;0;D;1;U;1;B10.A102",
  "281;shed load. Stationary traffic for 4 km;(Q) shed loads. Stationary traffic for 4 km;;0;D;1;U;1;B10.A104",
  "282;shed load. Stationary traffic for 6 km;(Q) shed loads. Stationary traffic for 6 km;;0;D;1;U;1;B10.A106",
  "283;shed load. Stationary traffic for 10 km;(Q) shed loads. Stationary traffic for 10 km;;0;D;1;U;1;B10.A110",
  "284;shed load. Danger of stationary traffic;(Q) shed loads. Danger of stationary traffic;;0;D;1;U;1;B10.A1D",
  "285;shed load. Queuing traffic;(Q) shed loads. Queuing traffic;;0;D;1;U;1;B10.A2",
  "286;shed load. Queuing traffic for 1 km;(Q) shed loads. Queuing traffic for 1 km;;0;D;1;U;1;B10.A201",
  "287;shed load. Queuing traffic for 2 km;(Q) shed loads. Queuing traffic for 2 km;;0;D;1;U;1;B10.A202",
  "288;shed load. Queuing traffic for 4 km;(Q) shed loads. Queuing traffic for 4 km;;0;D;1;U;1;B10.A204",
  "289;shed load. Queuing traffic for 6 km;(Q) shed loads. Queuing traffic for 6 km;;0;D;1;U;1;B10.A206",
  "290;shed load. Queuing traffic for 10 km;(Q) shed loads. Queuing traffic for 10 km;;0;D;1;U;1;B10.A210",
  "291;shed load. Danger of queuing traffic;(Q) shed loads. Danger of queuing traffic;;0;D;1;U;1;B10.A2D",
  "292;shed load. Slow traffic;(Q) shed loads. Slow traffic;;0;D;1;U;1;B10.A3",
  "293;shed load. Slow traffic for 1 km;(Q) shed loads. Slow traffic for 1 km;;0;D;1;U;1;B10.A301",
  "294;shed load. Slow traffic for 2 km;(Q) shed loads. Slow traffic for 2 km;;0;D;1;U;1;B10.A302",
  "295;shed load. Slow traffic for 4 km;(Q) shed loads. Slow traffic for 4 km;;0;D;1;U;1;B10.A304",
  "296;shed load. Slow traffic for 6 km;(Q) shed loads. Slow traffic for 6 km;;0;D;1;U;1;B10.A306",
  "297;shed load. Slow traffic for 10 km;(Q) shed loads. Slow traffic for 10 km;;0;D;1;U;1;B10.A310",
  "298;shed load. Slow traffic expected;(Q) shed loads. Slow traffic expected;F;0;D;1;U;2;B10.A3E",
  "299;shed load. Heavy traffic;(Q) shed loads. Heavy traffic;;0;D;1;;1;B10.A4",
  "300;shed load. Heavy traffic expected;(Q) shed loads. Heavy traffic expected;F;0;D;1;;2;B10.A4E",
  "301;shed load. Traffic flowing freely;(Q) shed loads. Traffic flowing freely;;0;(D);1;;1;B10.A5",
  "302;shed load. Traffic building up;(Q) shed loads. Traffic building up;;0;D;1;;1;B10.A6",
  "303;blocked by shed load;blocked by (Q) shed loads;;0;D;1;U;5;B10.C2",
  "304;shed load. Right lane blocked;(Q) shed loads. Right lane blocked;;0;D;1;U;5;B10.D8",
  "305;shed load. Centre lane blocked;(Q) shed loads. Centre lane blocked;;0;D;1;U;5;B10.D9",
  "306;shed load. Left lane blocked;(Q) shed loads. Left lane blocked;;0;D;1;U;5;B10.D10",
  "307;shed load. Hard shoulder blocked;(Q) shed loads. Hard shoulder blocked;;0;D;1;U;5;B10.D11",
  "308;shed load. Two lanes blocked;(Q) shed loads. Two lanes blocked;;0;D;1;U;5;B10.D12",
  "309;shed load. Three lanes blocked;(Q) shed loads. Three lanes blocked;;0;D;1;U;5;B10.D13",
  "310;shed load. Delays;shed load. Delays (Q);;5;D;1;;20;B10.Q1",
  "311;shed load. Delays expected;shed load. Delays (Q) expected;F;5;D;1;;20;B10.Q1E",
  "312;shed load. Long delays;shed load. Long delays (Q);;5;D;1;U;20;B10.Q2",
  "313;broken down vehicle. Stationary traffic;(Q) broken down vehicles. Stationary traffic;;0;D;1;U;1;B11.A1",
  "314;broken down vehicle. Danger of stationary traffic;(Q) broken down vehicles. Danger of stationary traffic;;0;D;1;U;1;B11.A1D",
  "315;broken down vehicle. Queuing traffic;(Q) broken down vehicles. Queuing traffic;;0;D;1;U;1;B11.A2",
  "316;broken down vehicle. Danger of queuing traffic;(Q) broken down vehicles. Danger of queuing traffic;;0;D;1;U;1;B11.A2D",
  "317;broken down vehicle. Slow traffic;(Q) broken down vehicles. Slow traffic;;0;D;1;U;1;B11.A3",
  "318;broken down vehicle. Slow traffic expected;(Q) broken down vehicles. Slow traffic expected;F;0;D;1;U;2;B11.A3E",
  "319;broken down vehicle. Heavy traffic;(Q) broken down vehicles. Heavy traffic;;0;D;1;;1;B11.A4",
  "320;broken down vehicle. Heavy traffic expected;(Q) broken down vehicles. Heavy traffic expected;F;0;D;1;;2;B11.A4E",
  "321;broken down vehicle. Traffic flowing freely;(Q) broken down vehicles. Traffic flowing freely;;0;(D);1;;1;B11.A5",
  "322;broken down vehicle.Traffic building up;(Q) broken down vehicles.Traffic building up;;0;D;1;;1;B11.A6",
  "323;blocked by broken down vehicle.;blocked by (Q) broken down vehicles.;;0;D;1;U;5;B11.C2",
  "324;broken down vehicle. Right lane blocked;(Q) broken down vehicles. Right lane blocked;;0;D;1;U;5;B11.D8",
  "325;broken down vehicle. Centre lane blocked;(Q) broken down vehicles. Centre lane blocked;;0;D;1;U;5;B11.D9",
  "326;broken down vehicle. Left lane blocked;(Q) broken down vehicles. Left lane blocked;;0;D;1;U;5;B11.D10",
  "327;broken down vehicle. Hard shoulder blocked;(Q) broken down vehicles. Hard shoulder blocked;;0;D;1;U;5;B11.D11",
  "328;broken down vehicle. Two lanes blocked;(Q) broken down vehicles. Two lanes blocked;;0;D;1;U;5;B11.D12",
  "329;broken down vehicle. Three lanes blocked;(Q) broken down vehicles. Three lanes blocked;;0;D;1;U;5;B11.D13",
  "330;broken down vehicle. Delays;broken down vehicle. Delays (Q);;5;D;1;;20;B11.Q1",
  "331;broken down vehicle. Delays expected;broken down vehicle. Delays (Q) expected;F;5;D;1;;20;B11.Q1E",
  "332;broken down vehicle. Long delays;broken down vehicle. Long delays (Q);;5;D;1;U;20;B11.Q2",
  "333;accident cleared;;;0;(D);1;;3;B98",
  "334;message cancelled;;S;0;;0;;3;",
  "335;accident involving bus(es);accident involving a/(Q) bus(es);;0;(D);1;U;3;B9",
  "336;oil spillage accident;(Q) oil spillage accidents;;0;(D);1;U;3;B15",
  "337;overturned vehicle;(Q) overturned vehicles;;0;(D);1;;3;B16",
  "338;overturned heavy lorr(y/ies);(Q) overturned heavy lorr(y/ies);;0;(D);1;U;3;B17",
  "339;jackknifed trailer;(Q) jackknifed trailers;;0;(D);1;U;3;B18",
  "340;jackknifed caravan;(Q) jackknifed caravans;;0;(D);1;U;3;B19",
  "341;jackknifed articulated lorr(y/ies);(Q) jackknifed articulated lorr(y/ies);;0;(D);1;U;3;B20",
  "342;vehicle spun around;(Q) vehicles spun around;;0;(D);1;;3;B21",
  "343;earlier accident;(Q) earlier accidents;;0;(D);1;;3;B22",
  "344;accident investigation work;;;0;D;1;;3;B23",
  "345;secondary accident;(Q) secondary accidents;;0;(D);1;;3;B24",
  "346;broken down bus(es);(Q) broken down bus(es);;0;(D);1;;4;B25",
  "347;overheight vehicle;(Q) overheight vehicles;;0;D;1;;24;B26",
  "348;accident. Stationary traffic for 3 km;(Q) accidents. Stationary traffic for 3 km;;0;D;1;U;1;B1.A103",
  "349;accident. Queuing traffic for 3 km;(Q) accidents. Queuing traffic for 3 km;;0;D;1;U;1;B1.A203",
  "350;accident. Slow traffic for 3 km;(Q) accidents. Slow traffic for 3 km;;0;D;1;U;1;B1.A303",
  "351;accident in roadworks area;(Q) accidents in roadworks area;;0;(D);1;U;3;B1.Z241",
  "352;vehicles slowing to look at accident. Stationary traffic for 3 km;vehicles slowing to look at (Q) accidents. Stationary traffic for 3 km;;0;D;1;U;1;B8.A103",
  "353;vehicles slowing to look at accident. Queuing traffic for 3 km;vehicles slowing to look at (Q) accidents. Queuing traffic for 3 km;;0;D;1;U;1;B8.A203",
  "354;vehicles slowing to look at accident. Slow traffic for 3 km;vehicles slowing to look at (Q) accidents. Slow traffic for 3 km;;0;D;1;U;1;B8.A303",
  "355;vehicles slowing to look at accident. Danger;vehicles slowing to look at (Q) accidents. Danger;;0;(D);1;U;1;B8.Z91",
  "356;shed load. Stationary traffic for 3 km;(Q) shed loads. Stationary traffic for 3 km;;0;D;1;U;1;B10.A103",
  "357;shed load. Queuing traffic for 3 km;(Q) shed loads. Queuing traffic for 3 km;;0;D;1;U;1;B10.A203",
  "358;shed load. Slow traffic for 3 km;(Q) shed loads. Slow traffic for 3 km;;0;D;1;U;1;B10.A303",
  "359;shed load. Danger;(Q) shed loads. Danger;;0;D;1;U;12;B10.Z91",
  "360;overturned vehicle. Stationary traffic;(Q) overturned vehicles. Stationary traffic;;0;D;1;U;1;B16.A1",
  "361;overturned vehicle. Danger of stationary traffic;(Q) overturned vehicles. Danger of stationary traffic;;0;D;1;U;1;B16.A1D",
  "362;overturned vehicle. Queuing traffic;(Q) overturned vehicles. Queuing traffic;;0;D;1;U;1;B16.A2",
  "363;overturned vehicle. Danger of queuing traffic;(Q) overturned vehicles. Danger of queuing traffic;;0;D;1;U;1;B16.A2D",
  "364;overturned vehicle. Slow traffic;(Q) overturned vehicles. Slow traffic;;0;D;1;U;1;B16.A3",
  "365;overturned vehicle. Slow traffic expected;(Q) overturned vehicles. Slow traffic expected;F;0;D;1;U;2;B16.A3E",
  "366;overturned vehicle. Heavy traffic;(Q) overturned vehicles. Heavy traffic;;0;D;1;;1;B16.A4",
  "367;overturned vehicle. Heavy traffic expected;(Q) overturned vehicles. Heavy traffic expected;F;0;D;1;;2;B16.A4E",
  "368;overturned vehicle. Traffic building up;(Q) overturned vehicles. Traffic building up;;0;D;1;;1;B16.A6",
  "369;blocked by overturned vehicle;blocked by (Q) overturned vehicles;;0;D;1;U;5;B16.C2",
  "370;overturned vehicle. Right lane blocked;(Q) overturned vehicles. Right lane blocked;;0;D;1;U;5;B16.D8",
  "371;overturned vehicle. Centre lane blocked;(Q) overturned vehicles. Centre lane blocked;;0;D;1;U;5;B16.D9",
  "372;overturned vehicle. Left lane blocked;(Q) overturned vehicles. Left lane blocked;;0;D;1;U;5;B16.D10",
  "373;overturned vehicle. Two lanes blocked;(Q) overturned vehicles. Two lanes blocked;;0;D;1;U;5;B16.D12",
  "374;overturned vehicle. Three lanes blocked;(Q) overturned vehicles. Three lanes blocked;;0;D;1;U;5;B16.D13",
  "375;overturned vehicle. Delays;overturned vehicle. Delays (Q);;5;D;1;;20;B16.Q1",
  "376;overturned vehicle. Delays expected;overturned vehicle. Delays (Q) expected;F;5;D;1;;20;B16.Q1E",
  "377;overturned vehicle. Long delays;overturned vehicle. Long delays (Q);;5;D;1;U;20;B16.Q2",
  "378;overturned vehicle. Danger;(Q) overturned vehicles. Danger;;0;(D);1;U;3;B16.Z91",
  "379;Stationary traffic due to earlier accident;Stationary traffic due to (Q) earlier accidents;;0;D;1;U;1;B22.A1",
  "380;Danger of stationary traffic due to earlier accident;Danger of stationary traffic due to (Q) earlier accidents;;0;D;1;U;1;B22.A1D",
  "381;Queuing traffic due to earlier accident;Queuing traffic due to (Q) earlier accidents;;0;D;1;U;1;B22.A2",
  "382;Danger of queuing traffic due to earlier accident;Danger of queuing traffic due to (Q) earlier accidents;;0;D;1;U;1;B22.A2D",
  "383;Slow traffic due to earlier accident;Slow traffic due to (Q) earlier accidents;;0;D;1;U;1;B22.A3",
  "385;Heavy traffic due to earlier accident;Heavy traffic due to (Q) earlier accidents;;0;D;1;;1;B22.A4",
  "387;Traffic building up due to earlier accident;Traffic building up due to (Q) earlier accidents;;0;D;1;;1;B22.A6",
  "388;Delays due to earlier accident;Delays (Q) due to earlier accident;;5;D;1;;20;B22.Q1",
  "390;Long delays due to earlier accident;Long delays (Q) due to earlier accident;;5;D;1;U;20;B22.Q2",
  "391;accident investigation work. Danger;;;0;D;1;U;3;B23.Z91",
  "392;secondary accident. Danger;(Q) secondary accidents. Danger;;0;(D);1;U;3;B24.Z91",
  "393;broken down vehicle. Danger;(Q) broken down vehicles. Danger;;0;(D);1;U;4;B11.Z91",
  "394;broken down heavy lorr(y/ies). Danger;(Q) broken down heavy lorr(y/ies). Danger;;0;(D);1;U;4;B12.Z91",
  "395;road cleared;;;0;(D);1;;4;B96",
  "396;incident cleared;;;0;(D);1;;4;B97",
  "397;rescue and recovery work in progress;;;0;D;1;U;4;F29",
  "399;message cancelled;;S;0;;0;;8;",
  "401;closed;;;0;L;1;U;5;C1",
  "402;blocked;;;0;D;1;U;5;C2",
  "403;closed for heavy vehicles;closed for heavy vehicles over (Q);;8;L;1;U;9;C1.Z8",
  "404;no through traffic for heavy lorries;no through traffic for heavy lorries over (Q);;8;L;1;U;9;C 5.Z78",
  "405;no through traffic;;;0;L;1;U;9;C5",
  "406;entry slip road closed;(Q) th entry slip road closed;;0;L;1;U;8;C6",
  "407;exit slip road closed;(Q) th exit slip road closed;;0;L;1;U;7;C7",
  "408;slip roads closed;;;0;L;1;U;7;C8",
  "409;slip road restrictions;;;0;L;1;;7;C9",
  "410;closed ahead. Stationary traffic;;;0;D;1;U;1;C3.A1",
  "411;closed ahead. Stationary traffic for 1 km;;;0;D;1;U;1;C3.A101",
  "412;closed ahead. Stationary traffic for 2 km;;;0;D;1;U;1;C3.A102",
  "413;closed ahead. Stationary traffic for 4 km;;;0;D;1;U;1;C3.A104",
  "414;closed ahead. Stationary traffic for 6 km;;;0;D;1;U;1;C3.A106",
  "415;closed ahead. Stationary traffic for 10 km;;;0;D;1;U;1;C3.A110",
  "416;closed ahead. Danger of stationary traffic;;;0;D;1;U;1;C3.A1D",
  "417;closed ahead. Queuing traffic;closed ahead. Queuing traffic;;0;D;1;U;1;C3.A2",
  "418;closed ahead. Queuing traffic for 1 km;closed ahead. Queuing traffic for 1 km;;0;D;1;U;1;C3.A201",
  "419;closed ahead. Queuing traffic for 2 km;closed ahead. Queuing traffic for 2 km;;0;D;1;U;1;C3.A202",
  "420;closed ahead. Queuing traffic for 4 km;closed ahead. Queuing traffic for 4 km;;0;D;1;U;1;C3.A204",
  "421;closed ahead. Queuing traffic for 6 km;closed ahead. Queuing traffic for 6 km;;0;D;1;U;1;C3.A206",
  "422;closed ahead. Queuing traffic for 10 km;closed ahead. Queuing traffic for 10 km;;0;D;1;U;1;C3.A210",
  "423;closed ahead. Danger of queuing traffic;;;0;D;1;U;1;C3.A2D",
  "424;closed ahead. Slow traffic;;;0;D;1;U;1;C3.A3",
  "425;closed ahead. Slow traffic for 1 km;;;0;D;1;U;1;C3.A301",
  "426;closed ahead. Slow traffic for 2 km;;;0;D;1;U;1;C3.A302",
  "427;closed ahead. Slow traffic for 4 km;;;0;D;1;U;1;C3.A304",
  "428;closed ahead. Slow traffic for 6 km;;;0;D;1;U;1;C3.A306",
  "429;closed ahead. Slow traffic for 10 km;;;0;D;1;U;1;C3.A310",
  "430;closed ahead. Slow traffic expected;;F;0;D;1;U;2;C3.A3E",
  "431;closed ahead. Heavy traffic;;;0;D;1;U;1;C3.A4",
  "432;closed ahead. Heavy traffic expected;;F;0;D;1;U;2;C3.A4E",
  "433;closed ahead. Traffic flowing freely;;;0;(D);1;U;1;C3.A5",
  "434;closed ahead. Traffic building up;;;0;D;1;U;1;C3.A6",
  "435;closed ahead. Delays;closed ahead. Delays (Q);;5;D;1;U;20;C3.Q1",
  "436;closed ahead. Delays expected;closed ahead. Delays (Q) expected;F;5;D;1;U;20;C3.Q1E",
  "437;closed ahead. Long delays;closed ahead. Long delays (Q);;5;D;1;U;20;C3.Q2",
  "438;blocked ahead. Stationary traffic;;;0;D;1;U;1;C4.A1",
  "439;blocked ahead. Stationary traffic for 1 km;;;0;D;1;U;1;C4.A101",
  "440;blocked ahead. Stationary traffic for 2 km;;;0;D;1;U;1;C4.A102",
  "441;blocked ahead. Stationary traffic for 4 km;;;0;D;1;U;1;C4.A104",
  "442;blocked ahead. Stationary traffic for 6 km;;;0;D;1;U;1;C4.A106",
  "443;blocked ahead. Stationary traffic for 10 km;;;0;D;1;U;1;C4.A110",
  "444;blocked ahead. Danger of stationary traffic;;;0;D;1;U;1;C4.A1D",
  "445;blocked ahead. Queuing traffic;blocked ahead. Queuing traffic;;0;D;1;U;1;C4.A2",
  "446;blocked ahead. Queuing traffic for 1 km;blocked ahead. Queuing traffic for 1 km;;0;D;1;U;1;C4.A201",
  "447;blocked ahead. Queuing traffic for 2 km;blocked ahead. Queuing traffic for 2 km;;0;D;1;U;1;C4.A202",
  "448;blocked ahead. Queuing traffic for 4 km;blocked ahead. Queuing traffic for 4 km;;0;D;1;U;1;C24.A204",
  "449;blocked ahead. Queuing traffic for 6 km;blocked ahead. Queuing traffic for 6 km;;0;D;1;U;1;C4.A206",
  "450;blocked ahead. Queuing traffic for 10 km;blocked ahead. Queuing traffic for 10 km;;0;D;1;U;1;C4.A210",
  "451;blocked ahead. Danger of queuing traffic;;;0;D;1;U;1;C4.A2D",
  "452;blocked ahead. Slow traffic;;;0;D;1;U;1;C4.A3",
  "453;blocked ahead. Slow traffic for 1 km;;;0;D;1;U;1;C4.A301",
  "454;blocked ahead. Slow traffic for 2 km;;;0;D;1;U;1;C4.A302",
  "455;blocked ahead. Slow traffic for 4 km;;;0;D;1;U;1;C4.A304",
  "456;blocked ahead. Slow traffic for 6 km;;;0;D;1;U;1;C4.A306",
  "457;blocked ahead. Slow traffic for 10 km;;;0;D;1;U;1;C4.A310",
  "458;blocked ahead. Slow traffic expected;;F;0;D;1;U;2;C4.A3E",
  "459;blocked ahead. Heavy traffic;;;0;D;1;U;1;C4.A4",
  "460;blocked ahead. Heavy traffic expected;;F;0;D;1;U;2;C4.A4E",
  "461;blocked ahead. Traffic flowing freely;;;0;(D);1;U;1;C4.A5",
  "462;blocked ahead. Traffic building up;;;0;D;1;U;1;C4.A6",
  "463;blocked ahead. Delays;blocked ahead. Delays (Q);;5;D;1;U;20;C4.Q1",
  "464;blocked ahead. Delays expected;blocked ahead. Delays (Q) expected;F;5;D;1;U;20;C4.Q1E",
  "465;blocked ahead. Long delays;blocked ahead. Long delays (Q);;5;D;1;U;20;C4.Q2",
  "466;slip roads reopened;;;0;(L);1;;7;C97",
  "467;reopened;;;0;(D);1;;5;C98",
  "468;message cancelled;;S;0;;0;;9;",
  "469;closed ahead;;;0;L;1;U;9;C3",
  "470;blocked ahead;;;0;D;1;U;9;C4",
  "471;entry slip road closed;(Q) entry slip roads closed;;0;L;1;U;8;C10",
  "472;entry slip road blocked;(Q) th entry slip road blocked;;0;D;1;U;8;C11",
  "473;entry blocked;;;0;D;1;U;8;C12",
  "474;exit slip road closed;(Q) exit slip roads closed;;0;L;1;U;7;C13",
  "475;exit slip road blocked;(Q) th exit slip road blocked;;0;D;1;U;7;C14",
  "476;exit blocked;;;0;D;1;U;7;C15",
  "477;slip roads blocked;;;0;D;1;U;7;C16",
  "478;connecting carriageway closed;;;0;L;1;U;7;C17",
  "479;parallel carriageway closed;;;0;L;1;U;6;C18",
  "480;right-hand parallel carriageway closed;;;0;L;1;U;6;C19",
  "481;left-hand parallel carriageway closed;;;0;L;1;U;6;C20",
  "482;express lanes closed;;;0;L;1;U;6;C21",
  "483;through traffic lanes closed;;;0;L;1;U;6;C22",
  "484;local lanes closed;;;0;L;1;U;6;C23",
  "485;connecting carriageway blocked;;;0;D;1;U;7;C24",
  "486;parallel carriageway blocked;;;0;D;1;U;6;C25",
  "487;right-hand parallel carriageway blocked;;;0;D;1;U;6;C26",
  "488;left-hand parallel carriageway blocked;;;0;D;1;U;6;C27",
  "489;express lanes blocked;;;0;D;1;U;6;C28",
  "490;through traffic lanes blocked;;;0;D;1;U;6;C29",
  "491;local lanes blocked;;;0;D;1;U;6;C30",
  "492;no motor vehicles;;;0;L;2;U;9;C31",
  "493;restrictions;;;0;L;1;;9;C32",
  "494;closed for heavy lorries;closed for heavy lorries over (Q);;8;L;1;U;9;C1.Z78",
  "495;closed ahead. Stationary traffic for 3 km;;;0;D;1;U;1;C3.A103",
  "496;closed ahead. Queuing traffic for 3 km;closed ahead. Queuing traffic for 3 km;;0;D;1;U;1;C3.A203",
  "497;closed ahead. Slow traffic for 3 km;;;0;D;1;U;1;C3.A303",
  "498;blocked ahead. Stationary traffic for 3 km;;;0;D;1;U;1;C4.A103",
  "499;blocked ahead. Queuing traffic for 3 km;blocked ahead. Queuing traffic for 3 km;;0;D;1;U;1;C4.A203",
  "500;lane closed;(Q) lanes closed;;0;L;1;;5;D1",
  "501;right lane closed;(Q) right lanes closed;;0;L;1;;5;D2",
  "502;centre lane closed;(Q) centre lanes closed;;0;L;1;;5;D3",
  "503;left lane closed;(Q) left lanes closed;;0;L;1;;5;D4",
  "504;hard shoulder closed;;;0;L;1;;5;D5",
  "505;two lanes closed;;;0;L;1;;5;D6",
  "506;three lanes closed;;;0;L;1;;5;D7",
  "507;right lane blocked;(Q) right lanes blocked;;0;D;1;U;5;D8",
  "508;centre lane blocked;(Q) centre lanes blocked;;0;D;1;U;5;D9",
  "509;left lane blocked;(Q) left lanes blocked;;0;D;1;U;5;D10",
  "510;hard shoulder blocked;;;0;D;1;;5;D11",
  "511;two lanes blocked;;;0;D;1;U;5;D12",
  "512;three lanes blocked;;;0;D;1;U;5;D13",
  "513;single alternate line traffic;;;0;L;2;;5;E14",
  "514;carriageway reduced to one lane;carriageway reduced from (Q) lanes to one lane;;0;L;1;;5;D15",
  "515;carriageway reduced to two lanes;carriageway reduced from (Q) lanes to two lanes;;0;L;1;;5;D16",
  "516;carriageway reduced to three lanes;carriageway reduced from (Q) lanes to three lanes;;0;L;1;;5;D17",
  "517;contraflow;;;0;L;2;;5;D18",
  "518;narrow lanes;;;0;L;1;;5;D19",
  "519;contraflow with narrow lanes;;;0;L;2;;5;D18.D19",
  "520;lane blocked;(Q) lanes blocked;;0;D;1;U;5;D21",
  "521;lanes closed. Stationary traffic;(Q) lanes closed. Stationary traffic;;0;D;1;U;1;D1.A1",
  "522;lanes closed. Stationary traffic for 1 km;(Q) lanes closed. Stationary traffic for 1 km;;0;D;1;U;1;D1.A101",
  "523;lanes closed. Stationary traffic for 2 km;(Q) lanes closed. Stationary traffic for 2 km;;0;D;1;U;1;D1.A102",
  "524;lanes closed. Stationary traffic for 4 km;(Q) lanes closed. Stationary traffic for 4 km;;0;D;1;U;1;D1.A104",
  "525;lanes closed. Stationary traffic for 6 km;(Q) lanes closed. Stationary traffic for 6 km;;0;D;1;U;1;D1.A106",
  "526;lanes closed. Stationary traffic for 10 km;(Q) lanes closed. Stationary traffic for 10 km;;0;D;1;U;1;D1.A110",
  "527;lanes closed. Danger of stationary traffic;(Q) lanes closed. Danger of stationary traffic;;0;D;1;U;1;D1.A1D",
  "528;lanes closed. Queuing traffic;(Q) lanes closed. Queuing traffic;;0;D;1;U;1;D1.A2",
  "529;lanes closed. Queuing traffic for 1 km;(Q) lanes closed. Queuing traffic for 1 km;;0;D;1;U;1;D1.A201",
  "530;lanes closed. Queuing traffic for 2 km;(Q) lanes closed. Queuing traffic for 2 km;;0;D;1;U;1;D1.A202",
  "531;lanes closed. Queuing traffic for 4 km;(Q) lanes closed. Queuing traffic for 4 km;;0;D;1;U;1;D1.A204",
  "532;lanes closed. Queuing traffic for 6 km;(Q) lanes closed. Queuing traffic for 6 km;;0;D;1;U;1;D1.A206",
  "533;lanes closed. Queuing traffic for 10 km;(Q) lanes closed. Queuing traffic for 10 km;;0;D;1;U;1;D1.A210",
  "534;lanes closed. Danger of queuing traffic;(Q) lanes closed. Danger of queuing traffic;;0;D;1;U;1;D1.A2D",
  "535;lanes closed. Slow traffic;(Q) lanes closed. Slow traffic;;0;D;1;U;1;D1.A3",
  "536;lanes closed. Slow traffic for 1 km;(Q) lanes closed. Slow traffic for 1 km;;0;D;1;U;1;D1.A301",
  "537;lanes closed. Slow traffic for 2 km;(Q) lanes closed. Slow traffic for 2 km;;0;D;1;U;1;D1.A302",
  "538;lanes closed. Slow traffic for 4 km;(Q) lanes closed. Slow traffic for 4 km;;0;D;1;U;1;D1.A304",
  "539;lanes closed. Slow traffic for 6 km;(Q) lanes closed. Slow traffic for 6 km;;0;D;1;U;1;D1.A306",
  "540;lanes closed. Slow traffic for 10 km;(Q) lanes closed. Slow traffic for 10 km;;0;D;1;U;1;D1.A310",
  "541;lanes closed. Slow traffic expected;(Q) lanes closed. Slow traffic expected;F;0;D;1;U;2;D1.A3E",
  "542;lanes closed. Heavy traffic;(Q) lanes closed. Heavy traffic;;0;D;1;;1;D1.A4",
  "543;lanes closed. Heavy traffic expected;(Q) lanes closed. Heavy traffic expected;F;0;D;1;;2;D1.A4E",
  "544;lanes closed. Traffic flowing freely;(Q)lanes closed. Traffic flowing freely;;0;(D);1;;1;D1.A5",
  "545;lanes closed. Traffic building up;(Q)lanes closed. Traffic building up;;0;D;1;;1;D1.A6",
  "546;carriageway reduced to one lane. Stationary traffic;carriageway reduced from (Q) lanes to one lane. Stationary traffic;;0;D;1;U;1;D15.A1",
  "547;carriageway reduced to one lane. Danger of stationary traffic;carriageway reduced from (Q) lanes to one lane. Danger of stationary traffic;;0;D;1;U;1;D15.A1D",
  "548;carriageway reduced to one lane. Queuing traffic;carriageway reduced from (Q) lanes to one lane. Queuing traffic;;0;D;1;U;1;D15.A2",
  "549;carriageway reduced to one lane. Danger of queuing traffic;carriageway reduced from (Q) lanes to one lane. Danger of queuing traffic;;0;D;1;U;1;D15.A2D",
  "550;carriageway reduced to one lane. Slow traffic;carriageway reduced from (Q) lanes to one lane. Slow traffic;;0;D;1;U;1;D15.A3",
  "551;carriageway reduced to one lane. Slow traffic expected;carriageway reduced from (Q) lanes to one lane. Slow traffic expected;F;0;D;1;U;2;D15.A3E",
  "552;carriageway reduced to one lane. Heavy traffic;carriageway reduced from (Q) lanes to one lane. Heavy traffic;;0;D;1;;1;D15.A4",
  "553;carriageway reduced to one lane. Heavy traffic expected;carriageway reduced from (Q) lanes to one lane. Heavy traffic expected;F;0;D;1;;2;D15.A4E",
  "554;carriageway reduced to one lane. Traffic flowing freely;carriageway reduced from (Q) lanes to one lane. Traffic flowing freely;;0;(D);1;;1;D15.A5",
  "555;carriageway reduced to one lane. Traffic building up;carriageway reduced from (Q) lanes to one lane. Traffic building up;;0;D;1;;1;D15.A6",
  "556;carriageway reduced to two lanes. Stationary traffic;carriageway reduced from (Q) lanes to two lanes. Stationary traffic;;0;D;1;U;1;D16.A1",
  "557;carriageway reduced to two lanes. Danger of stationary traffic;carriageway reduced from (Q) lanes to two lanes. Danger of stationary traffic;;0;D;1;U;1;D16.A1D",
  "558;carriageway reduced to two lanes. Queuing traffic;carriageway reduced from (Q) lanes to two lanes. Queuing traffic;;0;D;1;U;1;D16.A2",
  "559;carriageway reduced to two lanes. Danger of queuing traffic;carriageway reduced from (Q) lanes to two lanes. Danger of queuing traffic;;0;D;1;U;1;D16.A2D",
  "560;carriageway reduced to two lanes. Slow traffic;carriageway reduced from (Q) lanes to two lanes. Slow traffic;;0;D;1;U;1;D16.A3",
  "561;carriageway reduced to two lanes. Slow traffic expected;carriageway reduced from (Q) lanes to two lanes. Slow traffic expected;F;0;D;1;U;2;D16.A3E",
  "562;carriageway reduced to two lanes. Heavy traffic;carriageway reduced from (Q) lanes to two lanes. Heavy traffic;;0;D;1;;1;D16.A4",
  "563;carriageway reduced to two lanes. Heavy traffic expected;carriageway reduced from (Q) lanes to two lanes. Heavy traffic expected;F;0;D;1;;2;D16.A4E",
  "564;carriageway reduced to two lanes. Traffic flowing freely;carriageway reduced from (Q) lanes to two lanes. Traffic flowing freely;;0;(D);1;;1;D16.A5",
  "565;carriageway reduced to two lanes. Traffic building up;carriageway reduced from (Q) lanes to two lanes. Traffic building up;;0;D;1;;1;D16.A6",
  "566;carriageway reduced to three lanes. Stationary traffic;carriageway reduced from (Q) lanes to three lanes. Stationary traffic;;0;D;1;U;1;D17.A1",
  "567;carriageway reduced to three lanes. Danger of stationary traffic;carriageway reduced from (Q) lanes to three lanes. Danger of stationary traffic;;0;D;1;U;1;D17.A1D",
  "568;carriageway reduced to three lanes. Queuing traffic;carriageway reduced from (Q) lanes to three lanes. Queuing traffic;;0;D;1;U;1;D17.A2",
  "569;carriageway reduced to three lanes. Danger of queuing traffic;carriageway reduced from (Q) lanes to three lanes. Danger of queuing traffic;;0;D;1;U;1;D17.A2D",
  "570;carriageway reduced to three lanes. Slow traffic;carriageway reduced from (Q) lanes to three lanes. Slow traffic;;0;D;1;U;1;D17.A3",
  "571;carriageway reduced to three lanes. Slow traffic expected;carriageway reduced from (Q) lanes to three lanes. Slow traffic expected;F;0;D;1;U;2;D17.A3E",
  "572;carriageway reduced to three lanes. Heavy traffic;carriageway reduced from (Q) lanes to three lanes. Heavy traffic;;0;D;1;;1;D17.A4",
  "573;carriageway reduced to three lanes. Heavy traffic expected;carriageway reduced from (Q) lanes to three lanes. Heavy traffic expected;F;0;D;1;;2;D17.A4E",
  "574;carriageway reduced to three lanes. Traffic flowing freely;carriageway reduced from (Q) lanes to three lanes. Traffic flowing freely;;0;(D);1;;1;D17.A5",
  "575;carriageway reduced to three lanes. Traffic building up;carriageway reduced from (Q) lanes to three lanes. Traffic building up;;0;D;1;;1;D17.A6",
  "576;contraflow. Stationary traffic;;;0;D;1;U;1;D18.A1",
  "577;contraflow. Stationary traffic for 1 km;;;0;D;1;U;1;D18.A101",
  "578;contraflow. Stationary traffic for 2 km;;;0;D;1;U;1;D18.A102",
  "579;contraflow. Stationary traffic for 4 km;;;0;D;1;U;1;D18.A104",
  "580;contraflow. Stationary traffic for 6 km;;;0;D;1;U;1;D18.A106",
  "581;contraflow. Stationary traffic for 10 km;;;0;D;1;U;1;D18.A110",
  "582;contraflow. Danger of stationary traffic;;;0;D;1;U;1;D18.A1D",
  "583;contraflow. Queuing traffic;contraflow. Queuing traffic;;0;D;1;U;1;D18.A2",
  "584;contraflow. Queuing traffic for 1 km;contraflow. Queuing traffic for 1 km;;0;D;1;U;1;D18.A201",
  "585;contraflow. Queuing traffic for 2 km;contraflow. Queuing traffic for 2 km;;0;D;1;U;1;D18.A202",
  "586;contraflow. Queuing traffic for 4 km;contraflow. Queuing traffic for 4 km;;0;D;1;U;1;D18.A204",
  "587;contraflow. Queuing traffic for 6 km;contraflow. Queuing traffic for 6 km;;0;D;1;U;1;D18.A206",
  "588;contraflow. Queuing traffic for 10 km;contraflow. Queuing traffic for 10 km;;0;D;1;U;1;D18.A210",
  "589;contraflow. Danger of queuing traffic;;;0;D;1;U;1;D18.A2D",
  "590;contraflow. Slow traffic;;;0;D;1;U;1;D18.A3",
  "591;contraflow. Slow traffic for 1 km;;;0;D;1;U;1;D18.A301",
  "592;contraflow. Slow traffic for 2 km;;;0;D;1;U;1;D18.A302",
  "593;contraflow. Slow traffic for 4 km;;;0;D;1;U;1;D18.A304",
  "594;contraflow. Slow traffic for 6 km;;;0;D;1;U;1;D18.A306",
  "595;contraflow. Slow traffic for 10 km;;;0;D;1;U;1;D18.A310",
  "596;contraflow. Slow traffic expected;;F;0;D;1;U;2;D18.A3E",
  "597;contraflow. Heavy traffic;;;0;D;1;;1;D18.A4",
  "598;contraflow. Heavy traffic expected;;F;0;D;1;;2;D18.A4E",
  "599;contraflow. Traffic flowing freely;;;0;(D);1;;1;D18.A5",
  "600;contraflow. Traffic building up;;;0;D;1;;1;D18.A6",
  "601;contraflow. Carriageway reduced to one lane;contraflow. Carriageway reduced from (Q) lanes to one lane;;0;L;1;;5;D18.D15",
  "602;contraflow. Carriageway reduced to two lanes;contraflow. Carriageway reduced from (Q) lanes to two lanes;;0;L;1;;5;D18.D16",
  "603;contraflow. Carriageway reduced to three lanes;contraflow. Carriageway reduced from (Q) lanes to three lanes;;0;L;1;;5;D18.D17",
  "604;narrow lanes. Stationary traffic;;;0;D;1;U;1;D19.A1",
  "605;narrow lanes. Danger of stationary traffic;;;0;D;1;U;1;D19.A1D",
  "606;narrow lanes. Queuing traffic;narrow lanes. Queuing traffic;;0;D;1;U;1;D19.A2",
  "607;narrow lanes. Danger of queuing traffic;;;0;D;1;U;1;D19.A2D",
  "608;narrow lanes. Slow traffic;;;0;D;1;U;1;D19.A3",
  "609;narrow lanes. Slow traffic expected;;F;0;D;1;U;2;D19.A3E",
  "610;narrow lanes. Heavy traffic;;;0;D;1;;1;D19.A4",
  "611;narrow lanes. Heavy traffic expected;;F;0;D;1;;2;D19.A4E",
  "612;narrow lanes. Traffic flowing freely;;;0;(D);1;;1;D19.A5",
  "613;narrow lanes. Traffic building up;;;0;D;1;;1;D19.A6",
  "614;contraflow with narrow lanes. Stationary traffic;;;0;D;1;U;1;D18.D19.A1",
  "615;contraflow with narrow lanes. Stationary traffic. Danger of stationary traffic;;;0;D;1;U;1;D18.D19.A1D",
  "616;contraflow with narrow lanes. Queuing traffic;contraflow with narrow lanes. Queuing traffic;;0;D;1;U;1;D18.D19.A2",
  "617;contraflow with narrow lanes. Danger of queuing traffic;;;0;D;1;U;1;D18.D19.A2D",
  "618;contraflow with narrow lanes. Slow traffic;;;0;D;1;U;1;D18.D19.A3",
  "619;contraflow with narrow lanes. Slow traffic expected;;F;0;D;1;U;2;D18.D19.A3E",
  "620;contraflow with narrow lanes. Heavy traffic;;;0;D;1;;1;D18.D19.A4",
  "621;contraflow with narrow lanes. Heavy traffic expected;;F;0;D;1;;2;D18.D19.A4E",
  "622;contraflow with narrow lanes. Traffic flowing freely;;;0;(D);1;;1;D18.D19.A5",
  "623;contraflow with narrow lanes. Traffic building up;;;0;D;1;;1;D18.D19.A6",
  "624;lane closures removed;;;0;(L);1;;5;D98",
  "625;message cancelled;;S;0;;0;;5;",
  "626;blocked ahead. Slow traffic for 3 km;;;0;D;1;U;1;C4.A303",
  "627;no motor vehicles without catalytic converters;;;0;L;2;U;9;C90.Z73",
  "628;no motor vehicles with even-numbered registration plates;;;0;L;2;U;9;C31.Z84",
  "629;no motor vehicles with odd-numbered registration plates;;;0;L;2;U;9;C31.Z85",
  "630;open;;;0;L;1;;5;C90",
  "631;road cleared;;;0;(D);1;;5;C91",
  "632;entry reopened;;;0;(L);1;;8;C92",
  "633;exit reopened;;;0;(L);1;;7;C93",
  "634;all carriageways reopened;;;0;(L);1;;6;C94",
  "635;motor vehicle restrictions lifted;;;0;(L);2;;9;C95",
  "636;traffic restrictions lifted {reopened for all traffic};;;0;(L);2;;9;C96",
  "637;emergency lane closed;;;0;L;1;;5;D14",
  "638;turning lane closed;;;0;L;1;;5;D20",
  "639;crawler lane closed;;;0;L;1;;5;D22",
  "640;slow vehicle lane closed;;;0;L;1;;5;D23",
  "641;one lane closed;;;0;L;1;;5;D24",
  "642;emergency lane blocked;;;0;D;1;;5;D25",
  "643;turning lane blocked;;;0;D;1;;5;D26",
  "644;crawler lane blocked;;;0;D;1;;5;D27",
  "645;slow vehicle lane blocked;;;0;D;1;;5;D28",
  "646;one lane blocked;;;0;D;1;U;5;D29",
  "647;carpool lane in operation;(Q) person carpool lane in operation;;0;L;1;;10;D30",
  "648;carpool lane closed;(Q) person carpool lane closed;;0;L;1;U;10;D31",
  "649;carpool lane blocked;(Q) person carpool lane blocked;;0;D;1;U;10;D32",
  "650;carpool restrictions changed;carpool restrictions changed to (Q) persons per vehicle;;0;L;1;U;10;D33",
  "651;lanes closed. Stationary traffic for 3 km;(Q) lanes closed. Stationary traffic for 3 km;;0;D;1;U;1;D1.A103",
  "652;lanes closed. Queuing traffic for 3 km;(Q) lanes closed. Queuing traffic for 3 km;;0;D;1;U;1;D1.A203",
  "653;lanes closed. Slow traffic for 3 km;(Q) lanes closed. Slow traffic for 3 km;;0;D;1;U;1;D1.A303",
  "654;contraflow. Stationary traffic for 3 km;;;0;D;1;U;1;D18.A103",
  "655;contraflow. Queuing traffic for 3 km;contraflow. Queuing traffic for 3 km;;0;D;1;U;1;D18.A203",
  "656;contraflow. Slow traffic for 3 km;;;0;D;1;U;1;D18.A303",
  "657;lane blockages cleared;;;0;(D);1;;5;D94",
  "658;contraflow removed;;;0;(L);1;;5;D96",
  "659;carpool restrictions lifted;(Q) person carpool restrictions lifted;;0;D;1;;10;D95",
  "660;lane restrictions lifted;;;0;(L);1;;9;D97",
  "661;use of hard shoulder allowed;;;0;D;1;;9;D34",
  "662;normal lane regulations restored;;;0;(D);1;;9;D93",
  "663;all carriageways cleared;;;0;(L);1;;6;C86",
  "664;carriageway closed;;;0;L;1;;5;C34",
  "665;both directions closed;;;0;L;2;;5;C35",
  "666;intermittent short term closures;;;0;D;2;U;5;",
  "671;bus lane available for carpools;bus lane available for carpools with at least (Q) occupants;;0;L;1;;10;D35",
  "672;message cancelled;;S;0;;0;;6;",
  "673;message cancelled;;S;0;;0;;7;",
  "675;salting vehicles;(Q) salting vehicles;;0;D;1;;23;Rnn",
  "676;bus lane blocked;;;0;D;1;U;6;D41",
  "678;heavy vehicle lane closed;;;0;L;1;;5;D44",
  "679;heavy vehicle lane blocked;;;0;D;1;U;5;D45",
  "680;reopened for through traffic;;;0;(L);1;;9;C87",
  "681;snowploughs;(Q) snowploughs;F;0;D;1;U;23;R9",
  "701;roadworks;(Q) sets of roadworks;;0;L;1;;11;E1",
  "702;major roadworks;(Q) sets of major roadworks;;0;L;1;;11;E2",
  "703;maintenance work;(Q) sets of maintenance work;;0;D;1;;11;E3",
  "704;resurfacing work;(Q) sections of resurfacing work;;0;L;1;;11;E4",
  "705;central reservation work;(Q) sets of central reservation work;;0;L;1;;11;E5",
  "706;road marking work;(Q) sets of road marking work;;0;D;1;;13;E6",
  "707;bridge maintenance work;bridge maintenance work at (Q) bridges;;0;L;1;;11;E7",
  "708;temporary traffic lights;(Q) sets of temporary traffic lights;;0;L;2;;11;E8",
  "709;blasting work;(Q) sections of blasting work;;0;L;2;;11;E9",
  "710;roadworks. Stationary traffic;(Q) sets of roadworks. Stationary traffic;;0;D;1;U;1;E1.A1",
  "711;roadworks. Stationary traffic for 1 km;(Q) sets of roadworks. Stationary traffic for 1 km;;0;D;1;U;1;E1.A101",
  "712;roadworks. Stationary traffic for 2 km;(Q) sets of roadworks. Stationary traffic for 2 km;;0;D;1;U;1;E1.A102",
  "713;roadworks. Stationary traffic for 4 km;(Q) sets of roadworks. Stationary traffic for 4 km;;0;D;1;U;1;E1.A104",
  "714;roadworks. Stationary traffic for 6 km;(Q) sets of roadworks. Stationary traffic for 6 km;;0;D;1;U;1;E1.A106",
  "715;roadworks. Stationary traffic for 10 km;(Q) sets of roadworks. Stationary traffic for 10 km;;0;D;1;U;1;E1.A110",
  "716;roadworks. Danger of stationary traffic;(Q) sets of roadworks. Danger of stationary traffic;;0;D;1;U;1;E1.A1D",
  "717;roadworks. Queuing traffic;(Q) sets of roadworks. Queuing traffic;;0;D;1;U;1;E1.A2",
  "718;roadworks. Queuing traffic for 1 km;(Q) sets of roadworks. Queuing traffic for 1 km;;0;D;1;U;1;E1.A201",
  "719;roadworks. Queuing traffic for 2 km;(Q) sets of roadworks. Queuing traffic for 2 km;;0;D;1;U;1;E1.A202",
  "720;roadworks. Queuing traffic for 4 km;(Q) sets of roadworks. Queuing traffic for 4 km;;0;D;1;U;1;E1.A204",
  "721;roadworks. Queuing traffic for 6 km;(Q) sets of roadworks. Queuing traffic for 6 km;;0;D;1;U;1;E1.A206",
  "722;roadworks. Queuing traffic for 10 km;(Q) sets of roadworks. Queuing traffic for 10 km;;0;D;1;U;1;E1.A210",
  "723;roadworks. Danger of queuing traffic;(Q) sets of roadworks. Danger of queuing traffic;;0;D;1;U;1;E1.A2D",
  "724;roadworks. Slow traffic;(Q) sets of roadworks. Slow traffic;;0;D;1;U;1;E1.A3",
  "725;roadworks. Slow traffic for 1 km;(Q) sets of roadworks. Slow traffic for 1 km;;0;D;1;U;1;E1.A301",
  "726;roadworks. Slow traffic for 2 km;(Q) sets of roadworks. Slow traffic for 2 km;;0;D;1;U;1;E1.A302",
  "727;roadworks. Slow traffic for 4 km;(Q) sets of roadworks. Slow traffic for 4 km;;0;D;1;U;1;E1.A304",
  "728;roadworks. Slow traffic for 6 km;(Q) sets of roadworks. Slow traffic for 6 km;;0;D;1;U;1;E1.A306",
  "729;roadworks. Slow traffic for 10 km;(Q) sets of roadworks. Slow traffic for 10 km;;0;D;1;U;1;E1.A310",
  "730;roadworks. Slow traffic expected;(Q) sets of roadworks. Slow traffic expected;F;0;D;1;U;2;E1.A3E",
  "731;roadworks. Heavy traffic;(Q) sets of roadworks. Heavy traffic;;0;D;1;;1;E1.A4",
  "732;roadworks. Heavy traffic expected;(Q) sets of roadworks. Heavy traffic expected;F;0;D;1;;2;E1.A4E",
  "733;roadworks. Traffic flowing freely;(Q) sets of roadworks. Traffic flowing freely;;0;(D);1;;1;E1.A5",
  "734;roadworks. Traffic building up;(Q) sets of roadworks. Traffic building up;;0;D;1;;1;E1.A6",
  "735;closed due to roadworks;closed due to (Q) sets of roadworks;;0;L;1;U;5;E1.C1",
  "736;roadworks. Right lane closed;(Q) sets of roadworks. Right lane closed;;0;L;1;;5;E1.D2",
  "737;roadworks. Centre lane closed;(Q) sets of roadworks. Centre lane closed;;0;L;1;;5;E1.D3",
  "738;roadworks. Left lane closed;(Q) sets of roadworks. Left lane closed;;0;L;1;;5;E1.D4",
  "739;roadworks. Hard shoulder closed;(Q) sets of roadworks. Hard shoulder closed;;0;L;1;;5;E1.D5",
  "740;roadworks. Two lanes closed;(Q) sets of roadworks. Two lanes closed;;0;L;1;;5;E1.D6",
  "741;roadworks. Three lanes closed;(Q) sets of roadworks. Three lanes closed;;0;L;1;;5;E1.D7",
  "742;roadworks. Single alternate line traffic;(Q) sets of roadworks. Single alternate line traffic;;0;L;2;;5;E1.E14",
  "743;roadworks. Carriageway reduced to one lane;roadworks. Carriageway reduced from (Q) lanes to one lane;;0;L;1;;5;E1.D15",
  "744;roadworks. Carriageway reduced to two lanes;roadworks. Carriageway reduced from (Q) lanes to two lanes;;0;L;1;;5;E1.D16",
  "745;roadworks. Carriageway reduced to three lanes;roadworks. Carriageway reduced from (Q) lanes to three lanes;;0;L;1;;5;E1.D17",
  "746;roadworks. Contraflow;(Q) sets of roadworks. Contraflow;;0;L;2;;5;E1.D18",
  "747;roadworks. Delays;roadworks. Delays (Q);;5;D;1;;20;E1.Q1",
  "748;roadworks. Delays expected;roadworks. Delays (Q) expected;F;5;D;1;;20;E1.Q1E",
  "749;roadworks. Long delays;roadworks. Long delays (Q);;5;D;1;U;20;E1.Q2",
  "750;resurfacing work. Stationary traffic;(Q) sections of resurfacing work. Stationary traffic;;0;D;1;U;1;E4.A1",
  "751;resurfacing work. Stationary traffic for 1 km;(Q) sections of resurfacing work. Stationary traffic for 1 km;;0;D;1;U;1;E4.A101",
  "752;resurfacing work. Stationary traffic for 2 km;(Q) sections of resurfacing work. Stationary traffic for 2 km;;0;D;1;U;1;E4.A102",
  "753;resurfacing work. Stationary traffic for 4 km;(Q) sections of resurfacing work. Stationary traffic for 4 km;;0;D;1;U;1;E4.A104",
  "754;resurfacing work. Stationary traffic for 6 km;(Q) sections of resurfacing work. Stationary traffic for 6 km;;0;D;1;U;1;E4.A106",
  "755;resurfacing work. Stationary traffic for 10 km;(Q) sections of resurfacing work. Stationary traffic for 10 km;;0;D;1;U;1;E4.A110",
  "756;resurfacing work. Danger of stationary traffic;(Q) sections of resurfacing work. Danger of stationary traffic;;0;D;1;U;1;E4.A1D",
  "757;resurfacing work. Queuing traffic;(Q) sections of resurfacing work. Queuing traffic;;0;D;1;U;1;E4.A2",
  "758;resurfacing work. Queuing traffic for 1 km;(Q) sections of resurfacing work. Queuing traffic for 1 km;;0;D;1;U;1;E4.A201",
  "759;resurfacing work. Queuing traffic for 2 km;(Q) sections of resurfacing work. Queuing traffic for 2 km;;0;D;1;U;1;E4.A202",
  "760;resurfacing work. Queuing traffic for 4 km;(Q) sections of resurfacing work. Queuing traffic for 4 km;;0;D;1;U;1;E4.A204",
  "761;resurfacing work. Queuing traffic for 6 km;(Q) sections of resurfacing work. Queuing traffic for 6 km;;0;D;1;U;1;E4.A206",
  "762;resurfacing work. Queuing traffic for 10 km;(Q) sections of resurfacing work. Queuing traffic for 10 km;;0;D;1;U;1;E4.A210",
  "763;resurfacing work. Danger of queuing traffic;(Q) sections of resurfacing work. Danger of queuing traffic;;0;D;1;U;1;E4.A2D",
  "764;resurfacing work. Slow traffic;(Q) sections of resurfacing work. Slow traffic;;0;D;1;U;1;E4.A3",
  "765;resurfacing work. Slow traffic for 1 km;(Q) sections of resurfacing work. Slow traffic for 1 km;;0;D;1;U;1;E4.A301",
  "766;resurfacing work. Slow traffic for 2 km;(Q) sections of resurfacing work. Slow traffic for 2 km;;0;D;1;U;1;E4.A302",
  "767;resurfacing work. Slow traffic for 4 km;(Q) sections of resurfacing work. Slow traffic for 4 km;;0;D;1;U;1;E4.A304",
  "768;resurfacing work. Slow traffic for 6 km;(Q) sections of resurfacing work. Slow traffic for 6 km;;0;D;1;U;1;E4.A306",
  "769;resurfacing work. Slow traffic for 10 km;(Q) sections of resurfacing work. Slow traffic for 10 km;;0;D;1;U;1;E4.A310",
  "770;resurfacing work. Slow traffic expected;(Q) sections of resurfacing work. Slow traffic expected;F;0;D;1;U;2;E4.A3E",
  "771;resurfacing work. Heavy traffic;(Q) sections of resurfacing work. Heavy traffic;;0;D;1;;1;E4.A4",
  "772;resurfacing work. Heavy traffic expected;(Q) sections of resurfacing work. Heavy traffic expected;F;0;D;1;;2;E4.A4E",
  "773;resurfacing work. Traffic flowing freely;(Q) sections of resurfacing work. Traffic flowing freely;;0;(D);1;;1;E4.A5",
  "774;resurfacing work. Traffic building up;(Q) sections of resurfacing work. Traffic building up;;0;D;1;;1;E4.A6",
  "775;resurfacing work. Single alternate line traffic;(Q) sections of resurfacing work. Single alternate line traffic;;0;L;2;;5;E4.E14",
  "776;resurfacing work. Carriageway reduced to one lane;resurfacing work. Carriageway reduced from (Q) lanes to one lane;;0;L;1;;5;E4.D15",
  "777;resurfacing work. Carriageway reduced to two lanes;resurfacing work. Carriageway reduced from (Q) lanes to two lanes;;0;L;1;;5;E4.D16",
  "778;resurfacing work. Carriageway reduced to three lanes;resurfacing work. Carriageway reduced from (Q) lanes to three lanes;;0;L;1;;5;E4.D17",
  "779;resurfacing work. Contraflow;(Q) sections of resurfacing work. Contraflow;;0;L;2;;5;E4.D18",
  "780;resurfacing work. Delays;resurfacing work. Delays (Q);;5;D;1;;20;E4.Q1",
  "781;resurfacing work. Delays expected;resurfacing work. Delays (Q) expected;F;5;D;1;;20;E4.Q1E",
  "782;resurfacing work. Long delays;resurfacing work. Long delays (Q);;5;D;1;U;20;E4.Q2",
  "783;road marking work. Stationary traffic;(Q) sets of road marking work. Stationary traffic;;0;D;1;U;1;E6.A1",
  "784;road marking work. Danger of stationary traffic;(Q) sets of road marking work. Danger of stationary traffic;;0;D;1;U;1;E6.A1D",
  "785;road marking work. Queuing traffic;(Q) sets of road marking work. Queuing traffic;;0;D;1;U;1;E6.A2",
  "786;road marking work. Danger of queuing traffic;(Q) sets of road marking work. Danger of queuing traffic;;0;D;1;U;1;E6.A2D",
  "787;road marking work. Slow traffic;(Q) sets of road marking work. Slow traffic;;0;D;1;U;1;E6.A3",
  "788;road marking work. Slow traffic expected;(Q) sets of road marking work. Slow traffic expected;F;0;D;1;U;2;E6.A3E",
  "789;road marking work. Heavy traffic;(Q) sets of road marking work. Heavy traffic;;0;D;1;;1;E6.A4",
  "790;road marking work. Heavy traffic expected;(Q) sets of road marking work. Heavy traffic expected;F;0;D;1;;2;E6.A4E",
  "791;road marking work. Traffic flowing freely;(Q) sets of road marking work. Traffic flowing freely;;0;(D);1;;1;E6.A5",
  "792;road marking work. Traffic building up;(Q) sets of road marking work. Traffic building up;;0;D;1;;1;E6.A6",
  "793;road marking work. Right lane closed;(Q) sets of road marking work. Right lane closed;;0;D;1;;5;E6.D2",
  "794;road marking work. Centre lane closed;(Q) sets of road marking work. Centre lane closed;;0;D;1;;5;E6.D3",
  "795;road marking work. Left lane closed;(Q) sets of road marking work. Left lane closed;;0;D;1;;5;E6.D4",
  "796;road marking work. Hard shoulder closed;(Q) sets of road marking work. Hard shoulder closed;;0;D;1;;5;E6.D5",
  "797;road marking work. Two lanes closed;(Q) sets of road marking work. Two lanes closed;;0;D;1;;5;E6.D6",
  "798;road marking work. Three lanes closed;(Q) sets of road marking work. Three lanes closed;;0;D;1;;5;E6.D7",
  "799;closed for bridge demolition work;closed for bridge demolition work at (Q) bridges;;0;L;2;U;5;E13.C1",
  "800;roadworks cleared;;;0;(L);1;;11;E98",
  "801;message cancelled;;S;0;;0;;11;",
  "802;long-term roadworks;(Q) sets of long-term roadworks;;0;L;1;;11;E10",
  "803;construction work;(Q) sets of construction work;;0;L;1;;11;E11",
  "804;slow moving maintenance vehicles;(Q) sets of slow moving maintenance vehicles;;0;D;1;U;23;E12",
  "805;bridge demolition work;bridge demolition work at (Q) bridges;;0;L;1;U;11;E13",
  "806;water main work;(Q) sets of water main work;;0;L;2;;11;E15",
  "807;gas main work;(Q) sets of gas main work;;0;L;2;;11;E16",
  "808;work on buried cables;(Q) sets of work on buried cables;;0;L;2;;11;E17",
  "809;work on buried services;(Q) sets of work on buried services;;0;L;2;;11;E18",
  "810;new roadworks layout;;;0;(L);2;;11;E19",
  "811;new road layout;;;0;(L);2;;11;E20",
  "812;roadworks. Stationary traffic for 3 km;(Q) sets of roadworks. Stationary traffic for 3 km;;0;D;1;U;1;E1.A103",
  "813;roadworks. Queuing traffic for 3 km;(Q) sets of roadworks. Queuing traffic for 3 km;;0;D;1;U;1;E1.A203",
  "814;roadworks. Slow traffic for 3 km;(Q) sets of roadworks. Slow traffic for 3 km;;0;D;1;U;1;E1.A303",
  "815;roadworks during the day time;(Q) sets of roadworks during the day time;;0;L;1;;11;E1.Z214",
  "816;roadworks during off-peak periods;(Q) sets of roadworks during off-peak periods;;0;L;1;;11;E1.Z215",
  "817;roadworks during the night;(Q) sets of roadworks during the night;;0;L;1;;11;E1.Z216",
  "818;resurfacing work. Stationary traffic for 3 km;(Q) sections of resurfacing work. Stationary traffic for 3 km;;0;D;1;U;1;E4.A103",
  "819;resurfacing work. Queuing traffic for 3 km;(Q) sections of resurfacing work. Queuing traffic for 3 km;;0;D;1;U;1;E4.A203",
  "820;resurfacing work. Slow traffic for 3 km;(Q) sections of resurfacing work. Slow traffic for 3 km;;0;D;1;U;1;E4.A303",
  "821;resurfacing work during the day time;(Q) sets of resurfacing work during the day time;;0;L;1;;11;E4.Z214",
  "822;resurfacing work during off-peak periods;(Q) sets of resurfacing work during off-peak periods;;0;L;1;;11;E4.Z215",
  "823;resurfacing work during the night;(Q) sets of resurfacing work during the night;;0;L;1;;11;E4.Z216",
  "824;road marking work. Danger;(Q) sets of road marking work. Danger;;0;D;1;U;13;E6.Z91",
  "825;slow moving maintenance vehicles. Stationary traffic;(Q) sets of slow moving maintenance vehicles. Stationary traffic;;0;D;1;U;1;E12.A1",
  "826;slow moving maintenance vehicles. Danger of stationary traffic;(Q) sets of slow moving maintenance vehicles. Danger of stationary traffic;;0;D;1;U;1;E12.A1D",
  "827;slow moving maintenance vehicles. Queuing traffic;(Q) sets of slow moving maintenance vehicles. Queuing traffic;;0;D;1;U;1;E12.A2",
  "828;slow moving maintenance vehicles. Danger of queuing traffic;(Q) sets of slow moving maintenance vehicles. Danger of queuing traffic;;0;D;1;U;1;E12.A2D",
  "829;slow moving maintenance vehicles. Slow traffic;(Q) sets of slow moving maintenance vehicles. Slow traffic;;0;D;1;U;1;E12.A3",
  "830;slow moving maintenance vehicles. Slow traffic expected;(Q) sets of slow moving maintenance vehicles. Slow traffic expected;F;0;D;1;U;2;E12.A3E",
  "831;slow moving maintenance vehicles. Heavy traffic;(Q) sets of slow moving maintenance vehicles. Heavy traffic;;0;D;1;U;1;E12.A4",
  "832;slow moving maintenance vehicles. Heavy traffic expected;(Q) sets of slow moving maintenance vehicles. Heavy traffic expected;F;0;D;1;U;2;E12.A4E",
  "833;slow moving maintenance vehicles. Traffic flowing freely;(Q) sets of slow moving maintenance vehicles. Traffic flowing freely;;0;(D);1;U;1;E12.A5",
  "834;slow moving maintenance vehicles. Traffic building up;(Q) sets of slow moving maintenance vehicles. Traffic building up;;0;D;1;U;1;E12.A6",
  "835;slow moving maintenance vehicles. Right lane closed;(Q) sets of slow moving maintenance vehicles. Right lane closed;;0;D;1;U;5;E12.D2",
  "836;slow moving maintenance vehicles. Centre lane closed;(Q) sets of slow moving maintenance vehicles. Centre lane closed;;0;D;1;U;5;E12.D3",
  "837;slow moving maintenance vehicles. Left lane closed;(Q) sets of slow moving maintenance vehicles. Left lane closed;;0;D;1;U;5;E12.D4",
  "838;slow moving maintenance vehicles. Two lanes closed;(Q) sets of slow moving maintenance vehicles. Two lanes closed;;0;D;1;U;5;E12.D6",
  "839;slow moving maintenance vehicles. Three lanes closed;(Q) sets of slow moving maintenance vehicles. Three lanes closed;;0;D;1;U;5;E12.D7",
  "840;water main work. Delays;water main work. Delays (Q);;5;D;1;;20;E15.Q1",
  "841;water main work. Delays expected;water main work. Delays (Q) expected;F;5;D;1;;20;E15.Q1E",
  "842;water main work. Long delays;water main work. Long delays (Q);;5;D;1;U;20;E15.Q2",
  "843;gas main work. Delays;gas main work. Delays (Q);;5;D;1;;20;E16.Q1",
  "844;gas main work. Delays expected;gas main work. Delays (Q) expected;F;5;D;1;;20;E16.Q1E",
  "845;gas main work. Long delays;gas main work. Long delays (Q);;5;D;1;U;20;E16.Q2",
  "846;work on buried cables. Delays;work on buried cables. Delays (Q);;5;D;1;;20;E17.Q1",
  "847;work on buried cables. Delays expected;work on buried cables. Delays (Q) expected;F;5;D;1;;20;E17.Q1E",
  "848;work on buried cables. Long delays;work on buried cables. Long delays (Q);;5;D;1;U;20;E17.Q2",
  "849;work on buried services. Delays;work on buried services. Delays (Q);;5;D;1;;20;E18.Q1",
  "850;work on buried services. Delays expected;work on buried services. Delays (Q) expected;F;5;D;1;;20;E18.Q1E",
  "851;work on buried services. Long delays;work on buried services. Long delays (Q);;5;D;1;U;20;E18.Q2",
  "852;construction traffic merging;;;0;D;1;U;13;E21",
  "853;roadwork clearance in progress;;;0;(L);1;;11;E22",
  "854;maintenance work cleared;;;0;(D);1;;11;E97",
  "855;road layout unchanged;;;0;(L);2;;11;E95",
  "856;construction traffic merging. Danger;;;0;D;1;U;13;E21.Z91",
  "857;unprotected accident area;(Q) unprotected accident areas;;0;D;1;;13;B30",
  "858;danger of unprotected accident area;danger of (Q) unprotected accident areas;;0;D;1;U;13;B30D",
  "859;unlit vehicle on the road;(Q) unlit vehicles on the road;;0;D;1;;13;R10",
  "860;danger of unlit vehicle on the road;danger of (Q) unlit vehicles on the road;;0;D;1;U;13;R10D",
  "861;snow and ice debris;;;0;L;2;;13;G29",
  "862;danger of snow and ice debris;;;0;L;2;U;13;G29D",
  "897;people throwing objects onto the road. Danger;;;0;D;2;X;13;81D",
  "898;obstruction warning withdrawn;;;0;(L);2;;12;F95",
  "899;clearance work in progress, road free again;;;0;(D);2;;12;F96",
  "900;flooding expected;;F;0;D;2;U;12;F5E",
  "901;obstruction on roadway {something that does block the road or part of it};(Q) obstructions on roadway {something that does block the road or part of it};;0;D;1;U;12;F1",
  "902;obstructions on the road. Danger;(Q) obstructions on the road. Danger;;0;D;1;U;12;F1.Z91",
  "903;spillage on the road;;;0;(D);1;;12;F2",
  "904;storm damage;;;0;D;2;;12;F3",
  "905;fallen trees;(Q) fallen trees;;0;D;1;;12;F4",
  "906;fallen trees. Danger;(Q) fallen trees. Danger;;0;D;1;U;12;F4.Z91",
  "907;flooding;;;0;L;2;;12;F5",
  "908;flooding. Danger;;;0;L;2;U;12;F5.Z91",
  "909;flash floods;;;0;D;2;U;12;F6",
  "910;danger of flash floods;;;0;D;2;U;12;F6D",
  "911;avalanches;;;0;L;2;;12;F7",
  "912;avalanche risk;;;0;L;2;;12;F7D",
  "913;rockfalls;;;0;L;2;;12;F8",
  "914;landslips;;;0;L;2;;12;F9",
  "915;earthquake damage;;;0;L;2;;12;F10",
  "916;road surface in poor condition;;;0;L;2;;14;G27",
  "917;subsidence;;;0;L;1;;12;F12",
  "918;collapsed sewer;(Q) collapsed sewers;;0;L;2;;12;F13",
  "919;burst water main;;;0;D;2;;12;F14",
  "920;gas leak;;;0;D;2;;12;F15",
  "921;serious fire;;;0;D;2;;12;F16",
  "922;animals on roadway;;;0;D;0;;13;F17",
  "923;animals on the road. Danger;;;0;(D);2;U;13;F17.Z91",
  "924;clearance work;;;0;D;1;;4;F18",
  "925;blocked by storm damage;;;0;D;1;U;5;F23.C2",
  "926;blocked by fallen trees;blocked by (Q) fallen trees;;0;D;1;U;5;F4.C2",
  "927;fallen tree. Passable with care;(Q) fallen trees. Passable with care;;0;D;1;U;12;F4.G20",
  "928;flooding. Stationary traffic;;;0;D;1;U;1;F5.A1",
  "929;flooding. Danger of stationary traffic;;;0;D;1;U;1;F5.A1D",
  "930;flooding. Queuing traffic;flooding. Queuing traffic;;0;D;1;U;1;F5.A2",
  "931;flooding. Danger of queuing traffic;;;0;D;1;U;1;F5.A2D",
  "932;flooding. Slow traffic;;;0;D;1;U;1;F5.A3",
  "933;flooding. Slow traffic expected;;F;0;D;1;U;2;F5.A3E",
  "934;flooding. Heavy traffic;;;0;D;1;;1;F5.A4",
  "935;flooding. Heavy traffic expected;;F;0;D;1;;2;F5.A4E",
  "936;flooding. Traffic flowing freely;;;0;(D);1;;1;F5.A5",
  "937;flooding. Traffic building up;;;0;D;1;;1;F5.A6",
  "938;closed due to flooding;;;0;L;2;U;9;F5.C1",
  "939;flooding. Delays;flooding. Delays (Q);;5;D;1;;20;F5.Q1",
  "940;flooding. Delays expected;flooding. Delays (Q) expected;F;5;D;1;U;20;F5.Q1E",
  "941;flooding. Long delays;flooding. Long delays (Q);;5;L;1;U;20;F5.Q2",
  "942;flooding. Passable with care;;;0;L;2;;12;F5.G20",
  "943;closed due to avalanches;;;0;L;2;U;9;F7.C1",
  "944;avalanches. Passable with care;avalanches. Passable with care above (Q) hundred metres;;0;L;2;;12;F7.G20",
  "945;closed due to rockfalls;;;0;L;2;U;9;F8.C1",
  "946;rockfalls. Passable with care;;;0;L;2;;12;F8.G20",
  "947;road closed due to landslips;;;0;L;2;U;5;F9.C1",
  "948;landslips. Passable with care;;;0;L;2;;12;F9.G20",
  "949;closed due to subsidence;;;0;L;1;U;9;F12.C1",
  "950;subsidence. Single alternate line traffic;;;0;L;2;;12;F12.E14",
  "951;subsidence. Carriageway reduced to one lane;subsidence. Carriageway reduced from (Q) lanes to one lane;;0;L;1;;5;F12.D15",
  "952;subsidence. Carriageway reduced to two lanes;subsidence. Carriageway reduced from (Q) lanes to two lanes;;0;L;1;;5;F12.D16",
  "953;subsidence. Carriageway reduced to three lanes;subsidence. Carriageway reduced from (Q) lanes to three lanes;;0;L;1;;5;F12.D17",
  "954;subsidence. Contraflow in operation;;;0;L;2;;5;F12.D18",
  "955;subsidence. Passable with care;;;0;L;1;;12;F12.G20",
  "956;closed due to sewer collapse;;;0;L;1;U;5;F13.C1",
  "957;road closed due to burst water main;;;0;D;1;U;5;F14.C1",
  "958;burst water main. Delays;burst water main. Delays (Q);;5;D;1;;20;F14.Q1",
  "959;burst water main. Delays expected;burst water main. Delays (Q) expected;F;5;D;1;;20;F14.Q1E",
  "960;burst water main. Long delays;burst water main. Long delays (Q);;5;D;1;U;20;F14.Q2",
  "961;closed due to gas leak;;;0;D;2;U;5;F15.C1",
  "962;gas leak. Delays;gas leak. Delays (Q);;5;D;1;;20;F15.Q1",
  "963;gas leak. Delays expected;gas leak. Delays (Q) expected;F;5;D;1;;20;F15.Q1E",
  "964;gas leak. Long delays;gas leak. Long delays (Q);;5;D;1;U;20;F15.Q2",
  "965;closed due to serious fire;;;0;D;2;U;5;F16.C1",
  "966;serious fire. Delays;serious fire. Delays (Q);;5;D;1;;20;F16.Q1",
  "967;serious fire. Delays expected;serious fire. Delays (Q) expected;F;5;D;1;U;20;F16.Q1E",
  "968;serious fire. Long delays;serious fire. Long delays (Q);;5;D;1;U;20;F16.Q2",
  "969;closed for clearance work;;;0;D;1;U;5;F18.C1",
  "970;road free again;;;0;(L);2;;12;F98",
  "971;message cancelled;;S;0;;0;;12;",
  "972;storm damage expected;;F;0;D;2;;12;F3E",
  "973;fallen power cables;;;0;D;2;;12;F19",
  "974;sewer overflow;;;0;L;2;;12;F20",
  "975;ice build-up;;;0;L;2;;12;F21",
  "976;mud slide;;;0;L;2;;12;F22",
  "977;grass fire;;;0;D;2;;12;F23",
  "978;air crash;;;0;L;2;U;12;F24",
  "979;rail crash;;;0;D;2;U;12;F25",
  "980;blocked by obstruction on the road;blocked by (Q) obstructions on the road;;0;D;1;U;5;F1.C2",
  "981;obstructions on the road. Passable with care;(Q) obstructions on the road. Passable with care;;0;D;1;U;12;F1.G20",
  "982;blocked due to spillage on roadway;;;0;D;1;U;5;F2.C2",
  "983;spillage on the road. Passable with care;;;0;D;1;U;12;F2.G20",
  "984;spillage on the road. Danger;;;0;(D);1;U;12;F2.Z91",
  "985;storm damage. Passable with care;;;0;D;2;U;12;F3.G20",
  "986;storm damage. Danger;;;0;D;2;U;12;F3.Z91",
  "987;blocked by fallen power cables;;;0;D;2;U;5;F19.C2",
  "988;fallen power cables. Passable with care;;;0;D;1;U;12;F19.G20",
  "989;fallen power cables. Danger;;;0;D;2;U;12;F19.Z91",
  "990;sewer overflow. Danger;;;0;L;2;U;12;F20.Z91",
  "991;flash floods. Danger;;;0;D;2;U;12;F6.Z91",
  "992;avalanches. Danger;;;0;L;2;U;12;F7.Z91",
  "993;closed due to avalanche risk;;;0;L;2;U;9;F7D.C1",
  "994;avalanche risk. Danger;;;0;L;2;U;12;F7D.Z91",
  "995;closed due to ice build-up;;;0;L;2;U;9;F21.C1",
  "996;ice build-up. Passable with care;ice build-up. Passable with care above (Q) hundred metres;;0;L;2;U;12;F21.G20",
  "997;ice build-up. Single alternate traffic;;;0;L;2;U;12;F21.E14",
  "998;rockfalls. Danger;;;0;L;2;U;12;F8.Z91",
  "999;landslips. Danger;;;0;L;2;U;12;F9.Z91",
  "1000;earthquake damage. Danger;;;0;L;2;U;12;F10.Z91",
  "1001;hazardous driving conditions;hazardous driving conditions above (Q) hundred metres;;0;D;2;U;14;G1",
  "1002;danger of aquaplaning;;;0;D;2;U;14;G2D",
  "1003;slippery road;slippery road above (Q) hundred metres;;0;L;2;U;14;G3",
  "1004;mud on road;;;0;L;2;;14;G4",
  "1005;leaves on road;;;0;L;2;;14;G5",
  "1006;ice;ice above (Q) hundred metres;;0;L;2;;14;G6",
  "1007;danger of ice;danger of ice above (Q) hundred metres;;0;L;2;;14;G6D",
  "1008;black ice;black ice above (Q) hundred metres;;0;L;2;U;14;G7",
  "1009;freezing rain;freezing rain above (Q) hundred metres;;0;D;2;U;14;G8",
  "1010;wet and icy roads;wet and icy roads above (Q) hundred metres;;0;L;2;U;14;G9",
  "1011;slush;slush above (Q) hundred metres;;0;D;2;;14;G10",
  "1012;snow on the road;snow on the road above (Q) hundred metres;;0;L;2;;14;G11",
  "1013;packed snow;packed snow above (Q) hundred metres;;0;L;2;;14;G12",
  "1014;fresh snow;fresh snow above (Q) hundred metres;;0;L;2;U;14;G13",
  "1015;deep snow;deep snow above (Q) hundred metres;;0;L;2;;14;G14",
  "1016;snow drifts;snow drifts above (Q) hundred metres;;0;L;2;;14;G15",
  "1017;slippery due to spillage on roadway;;;0;L;1;;14;G3.F2",
  "1018;slippery road due to snow;slippery road above (Q) hundred metres due to snow;;0;L;2;;14;G3.G11",
  "1019;slippery road due to frost;slippery road above (Q) hundred metres due to frost;;0;D;2;U;14;G3.H10",
  "1020;road blocked by snow;road blocked by snow above (Q) hundred metres;;0;L;2;U;14;G11.C2",
  "1021;snow on the road. Carriageway reduced to one lane;snow on the road. Carriageway reduced from (Q) lanes to one lane;;0;D;1;U;5;G11.D15",
  "1022;snow on the road. Carriageway reduced to two lanes;snow on the road. Carriageway reduced from (Q) lanes to two lanes;;0;D;1;;5;G11.D16",
  "1023;snow on the road. Carriageway reduced to three lanes;snow on the road. Carriageway reduced from (Q) lanes to three lanes;;0;D;1;;5;G11.D17",
  "1024;conditions of road surface improved;;;0;(D);1;;14;G98",
  "1025;message cancelled;;S;0;;0;;14;",
  "1026;subsidence. Danger;;;0;L;1;U;12;F12.Z91",
  "1027;sewer collapse. Delays;sewer collapse. Delays (Q);;5;D;1;;20;F13.Q1",
  "1028;sewer collapse. Delays expected;sewer collapse. Delays (Q) expected;F;5;D;1;;20;F13.Q1E",
  "1029;sewer collapse. Long delays;sewer collapse. Long delays (Q);;5;D;1;U;20;F13.Q2",
  "1030;sewer collapse. Danger;;;0;L;2;U;12;F13.Z91",
  "1031;burst water main. Danger;;;0;D;2;U;12;F14.Z91",
  "1032;gas leak. Danger;;;0;D;2;U;12;F15.Z91",
  "1033;serious fire. Danger;;;0;D;2;U;12;F16.Z91",
  "1034;clearance work. Danger;;;0;D;1;U;4;F18.Z91",
  "1035;impassable;impassable above (Q) hundred metres;;0;D;2;U;14;G16",
  "1036;almost impassable;almost impassable above (Q) hundred metres;;0;D;2;U;14;G17",
  "1037;extremely hazardous driving conditions;extremely hazardous driving conditions above (Q) hundred metres;;0;D;2;U;14;G18",
  "1038;difficult driving conditions;difficult driving conditions above (Q) hundred metres;;0;D;2;U;14;G19",
  "1039;passable with care;passable with care up to (Q) hundred metres;;0;D;2;;14;G20",
  "1040;passable;passable up to (Q) hundred metres;;0;D;2;;14;G21",
  "1041;surface water hazard;;;0;D;2;;14;G22",
  "1042;loose sand on road;;;0;L;2;;14;G23",
  "1043;loose chippings;;;0;L;2;;14;G24",
  "1044;oil on road;;;0;L;1;;14;G25",
  "1045;petrol on road;;;0;D;1;;14;G26",
  "1046;ice expected;ice expected above (Q) hundred metres;F;0;L;2;;34;G6F",
  "1047;icy patches;icy patches above (Q) hundred metres;;0;L;2;U;14;G28",
  "1048;danger of icy patches;danger of icy patches above (Q) hundred metres;;0;L;2;U;14;G28D",
  "1049;icy patches expected;icy patches expected above (Q) hundred metres;F;0;L;2;U;34;G28F",
  "1050;danger of black ice;danger of black ice above (Q) hundred metres;;0;L;2;U;14;G7D",
  "1051;black ice expected;black ice expected above (Q) hundred metres;F;0;L;2;U;34;G7F",
  "1052;freezing rain expected;freezing rain expected above (Q) hundred metres;F;0;L;2;U;34;G8F",
  "1053;snow drifts expected;snow drifts expected above (Q) hundred metres;F;0;L;2;;34;G15F",
  "1054;slippery due to loose sand on roadway;;;0;L;2;;14;G3.G23",
  "1055;mud on road. Danger;;;0;L;2;U;14;G4.Z91",
  "1056;loose chippings. Danger;;;0;L;2;U;14;G24.Z91",
  "1057;oil on road. Danger;;;0;L;1;U;14;G25.Z91",
  "1058;petrol on road. Danger;;;0;D;1;U;14;G26.Z91",
  "1059;road surface in poor condition. Danger;;;0;L;2;U;14;G27.Z91",
  "1060;icy patches on bridges;icy patches above (Q) hundred metres on bridges;;0;L;2;U;14;G28.Z48",
  "1061;danger of icy patches on bridges;danger of icy patches above (Q) hundred metres on bridges;;0;L;2;U;14;G28D.Z48",
  "1062;icy patches on bridges, in shaded areas and on slip roads;icy patches above (Q) hundred metres on bridges, in shaded areas and on slip roads;;0;L;2;U;14;G28.Z48.Z49.Z162",
  "1063;impassable for heavy vehicles;impassable for heavy vehicles over (Q);;8;D;2;U;14;G16.Z8",
  "1064;impassable for vehicles with trailers;impassable above (Q) hundred metres for vehicles with trailers;;0;D;2;U;14;G16.Z77",
  "1065;driving conditions improved;;;0;(L);2;;14;G96",
  "1066;rescue and recovery work in progress. Danger;;;0;D;1;U;4;F29.Z91",
  "1067;large animals on roadway;;;0;D;2;;13;F26",
  "1068;herds of animals on roadway;;;0;D;2;;13;F30",
  "1069;skid hazard reduced;;;0;(L);2;;14;G97",
  "1070;snow cleared;;;0;(L);2;;14;G95",
  "1071;road conditions forecast withdrawn;;F;0;(L);2;;34;G99F",
  "1072;message cancelled;;S;0;;0;;34;",
  "1073;extremely hazardous driving conditions expected;extremely hazardous driving conditions expected above (Q) hundred meters;F;0;D;2;U;14;G18E",
  "1074;freezing rain expected;freezing rain expected above (Q) hundred metres;F;0;D;2;U;14;G8E",
  "1075;danger of road being blocked by snow;danger of road being blocked by snow above (Q) hundred metres;F;0;L;2;U;14;G11.C2E",
  "1079;temperature falling rapidly;temperature falling rapidly to (Q);;6;L;2;;15;M10",
  "1080;extreme heat;extreme heat up to (Q);;6;L;2;;15;M14",
  "1081;extreme cold;extreme cold of (Q);;6;L;2;;15;M21",
  "1082;less extreme temperatures;;;0;L;2;;15;M22",
  "1083;current temperature;current temperature (Q);;6;L;2;;15;M11",
  "1084;house fire;;;0;D;2;;12;F97",
  "1085;forest fire;;;0;L;2;U;12;Fnn",
  "1086;vehicle stuck under bridge;;;0;D;2;;12;F101",
  "1090;volcano eruption warning;;;0;L;2;U;12;Fnn",
  "1101;heavy snowfall;heavy snowfall (Q);;10;D;2;U;16;H1",
  "1102;heavy snowfall. Visibility reduced to <30 m;heavy snowfall (Q). Visibility reduced to <30 m;;10;D;2;U;16;H1.L803",
  "1103;heavy snowfall. Visibility reduced to <50 m;heavy snowfall (Q). Visibility reduced to <50 m;;10;D;2;U;16;H1.L805",
  "1104;snowfall;snowfall (Q);;10;D;2;U;16;H2",
  "1105;snowfall. Visibility reduced to <100 m;snowfall (Q). Visibility reduced to <100 m;;10;D;2;;16;H210.L810",
  "1106;hail;hail. Visibility reduced to (Q);;2;D;2;;16;H3",
  "1107;sleet;sleet. Visibility reduced to (Q);;2;D;2;;16;H4",
  "1108;thunderstorms;thunderstorms. Visibility reduced to (Q);;2;D;2;;16;H5",
  "1109;heavy rain;heavy rain (Q);;10;D;2;;16;H6",
  "1110;heavy rain. Visibility reduced to <30 m;heavy rain (Q). Visibility reduced to <30 m;;10;D;2;U;16;H6.L803",
  "1111;heavy rain. Visibility reduced to <50 m;heavy rain (Q). Visibility reduced to <50 m;;10;D;2;;16;H6.L805",
  "1112;rain;rain (Q);;10;D;2;;16;H7",
  "1113;rain. Visibility reduced to <100 m;rain (Q). Visibility reduced to <100 m;;10;D;2;;16;H7.L810",
  "1114;showers;showers. Visibility reduced to (Q);;2;D;2;;16;H8",
  "1115;heavy frost;;;0;L;2;;15;H9",
  "1116;frost;;;0;L;2;;15;H10",
  "1117;overcast weather;(Q) probability of overcast weather;F;3;L;2;;33;H11F",
  "1118;mostly cloudy;(Q) probability of mostly cloudy;F;3;L;2;;33;H12F",
  "1119;partly cloudy;(Q) probability of partly cloudy;F;3;L;2;;33;H13F",
  "1120;sunny periods;(Q) probability of sunny periods;F;3;L;2;;33;H14F",
  "1121;clear weather;(Q) probability of clear weather;F;3;L;2;;33;H15F",
  "1122;sunny weather;(Q) probability of sunny weather;F;3;L;2;;33;H16F",
  "1123;mostly dry weather;(Q) probability of mostly dry weather;F;3;L;2;;33;H17F",
  "1124;dry weather;(Q) probability of dry weather;F;3;L;2;;33;H18F",
  "1125;sunny periods and with showers;sunny periods and with (Q) probability of showers;F;3;L;2;;33;H14F.H8F",
  "1126;weather situation improved;;;0;(D);2;;16;H98",
  "1127;message cancelled;;S;0;;0;;15;",
  "1128;winter storm;winter storm. Visibility reduced to (Q);;2;D;2;U;16;H19",
  "1129;winter storm;(Q) probability of winter storm;F;3;L;2;U;33;H19F",
  "1130;blizzard;blizzard. Visibility reduced to (Q);;2;D;2;U;16;H20",
  "1131;blizzard;(Q) probability of blizzard;F;3;L;2;U;33;H20F",
  "1132;damaging hail;damaging hail. Visibility reduced to (Q);;2;D;2;U;16;H21",
  "1133;damaging hail;(Q) probability of damaging hail;F;3;L;2;U;33;H21F",
  "1134;heavy snowfall. Visibility reduced;heavy snowfall. Visibility reduced to (Q);;2;D;2;U;16;H1.L8",
  "1135;snowfall. Visibility reduced;snowfall. Visibility reduced to (Q);;2;D;2;;16;H2.L8",
  "1136;heavy rain. Visibility reduced;heavy rain. Visibility reduced to (Q);;2;D;2;;16;H6.L8",
  "1137;rain. Visibility reduced;rain. Visibility reduced to (Q);;2;D;2;;16;H7.L8",
  "1138;severe weather warnings cancelled;;F;0;(L);2;;33;H97F",
  "1139;message cancelled;;S;0;;0;;33;",
  "1140;weather forecast withdrawn;;F;0;(L);2;;33;H95F",
  "1141;fog forecast withdrawn;;F;0;(L);2;;33;H96F",
  "1143;slippery road expected;slippery road expected above (Q) hundred metres;F;0;L;2;;34;G3F",
  "1151;heavy snowfall;(Q) probability of heavy snowfall;F;3;L;2;U;33;H1F",
  "1152;snowfall;(Q) probability of snowfall;F;3;L;2;;33;H2F",
  "1153;hail;(Q) probability of hail;F;3;L;2;;33;H3F",
  "1154;sleet;(Q) probability of sleet;F;3;L;2;;33;H4F",
  "1155;thunderstorms;(Q) probability of thunderstorms;F;3;L;2;;33;H5F",
  "1156;heavy rain;(Q) probability of heavy rain;F;3;L;2;;33;H6F",
  "1157;rain;(Q) probability of rain;F;3;L;2;;33;H7F",
  "1158;showers;(Q) probability of showers;F;3;L;2;;33;H8F",
  "1159;heavy frost;(Q) probability of heavy frost;F;3;L;2;;33;H9F",
  "1160;frost;(Q) probability of frost;F;3;L;2;;33;H10F",
  "1165;rain changing to snow;;;0;L;2;;14;G80",
  "1166;snow changing to rain;;;0;L;2;;14;G81",
  "1170;heavy snowfall expected;heavy snowfall (Q) expected;F;10;D;2;U;16;H1E",
  "1171;heavy rain expected;heavy rain (Q) expected;F;10;D;2;U;16;H6E",
  "1172;weather expected to improve;;F;0;D;2;;16;H95E",
  "1173;blizzard expected;blizzard with visibility reduced to (Q) expected;F;2;D;2;U;16;H20E",
  "1174;damaging hail expected;damaging hail with visibility reduced to (Q) expected;F;2;D;2;U;16;H21E",
  "1175;reduced visibility expected;reduced visibility to (Q) expected;F;2;D;2;;16;L8E",
  "1176;freezing fog expected. Danger of slippery roads;freezing fog expected with visibility reduced to (Q). Danger of slippery roads;F;2;D;2;U;16;L4E.G3D",
  "1177;dense fog expected;dense fog with visibility reduced to (Q) expected;F;2;D;2;U;16;L1E",
  "1178;patchy fog expected;patchy fog with visibility reduced to (Q) expected;F;2;D;2;U;16;L3E",
  "1179;visibility expected to improve;;F;0;D;2;;16;L98E",
  "1180;adverse weather warning withdrawn;;;0;(L);2;;16;H99",
  "1190;severe smog;;;0;L;2;;17;L23",
  "1191;severe exhaust pollution;;;0;L;2;;17;L24",
  "1201;tornadoes;;;0;D;2;U;17;J1",
  "1202;hurricane force winds;hurricane force winds (Q);;4;L;2;U;17;J2",
  "1203;gales;gales (Q);;4;L;2;U;17;J3",
  "1204;storm force winds;storm force winds (Q);;4;L;2;U;17;J4",
  "1205;strong winds;strong winds (Q);;4;L;2;;17;J5",
  "1206;moderate winds;moderate winds (Q);F;4;L;2;;36;J6F",
  "1207;light winds;light winds (Q);F;4;L;2;;36;J7F",
  "1208;calm weather;;F;0;L;2;;36;J8F",
  "1209;gusty winds;gusty winds (Q);;4;L;2;;17;J9",
  "1210;crosswinds;crosswinds (Q);;4;L;2;;17;J10",
  "1211;strong winds affecting high-sided vehicles;strong winds (Q) affecting high-sided vehicles;;4;L;2;;17;J5.Z81",
  "1212;closed for high-sided vehicles due to strong winds;closed for high-sided vehicles due to strong winds (Q);;4;L;2;U;9;J5.C1.Z81",
  "1213;strong winds easing;;;0;(L);2;;17;J98",
  "1214;message cancelled;;S;0;;0;;17;",
  "1215;restrictions for high-sided vehicles lifted;;;0;(L);2;U;9;J97",
  "1216;tornado watch cancelled;;F;0;(L);2;;36;J97F",
  "1217;tornado warning ended;;;0;(D);2;U;17;J96",
  "1218;wind forecast withdrawn;;F;0;(L);2;;36;J98F",
  "1219;message cancelled;;S;0;;0;;36;",
  "1251;tornadoes;(Q) probability of tornadoes;F;3;L;2;U;36;J1F",
  "1252;hurricane force winds;hurricane force winds (Q);F;4;L;2;U;36;J2F",
  "1253;gales;gales (Q);F;4;L;2;U;36;J3F",
  "1254;storm force winds;storm force winds (Q);F;4;L;2;;36;J4F",
  "1255;strong winds;strong winds (Q);F;4;L;2;;36;J5F",
  "1256;strong wind forecast withdrawn;;F;0;(L);2;;36;J94F",
  "1300;snowfall and fog expected;snowfall and fog. Visibility reduced to (Q) expected;F;2;L;2;U;33;L2.H2F",
  "1301;dense fog;dense fog. Visibility reduced to (Q);;2;D;2;U;16;L1",
  "1302;dense fog. Visibility reduced to <30 m;;;0;D;2;U;16;L1.L803",
  "1303;dense fog. Visibility reduced to <50 m;;;0;D;2;U;16;L1.L805",
  "1304;fog;fog. Visibility reduced to (Q);;2;D;2;U;16;L2",
  "1305;fog. Visibility reduced to <100 m;;;0;D;2;;16;L2.L810",
  "1306;fog;(Q) probability of fog;F;3;L;2;;33;L2F",
  "1307;patchy fog;patchy fog. Visibility reduced to (Q);;2;D;2;U;16;L3",
  "1308;freezing fog;freezing fog. Visibility reduced to (Q);;2;D;2;U;16;L4",
  "1309;smoke hazard;smoke hazard. Visibility reduced to (Q);;2;D;2;;16;L5",
  "1310;blowing dust;blowing dust. Visibility reduced to (Q);;2;D;2;;16;L6",
  "1311;severe exhaust pollution;(Q) probability of severe exhaust pollution;F;3;L;2;;35;L7F",
  "1312;snowfall and fog;snowfall and fog. Visibility reduced to (Q);;2;D;2;U;16;L2.H2",
  "1313;visibility improved;;;0;(L);2;;16;L98",
  "1314;message cancelled;;S;0;;0;;16;",
  "1315;dense fog;(Q) probability of dense fog;F;3;L;2;U;33;L1F",
  "1316;patchy fog;(Q) probability of patchy fog;F;3;L;2;;33;L3F",
  "1317;freezing fog;(Q) probability of freezing fog;F;3;L;2;U;33;L4F",
  "1318;visibility reduced;visibility reduced to (Q);;2;D;2;;16;L8",
  "1319;visibility reduced to <30 m;;;0;D;2;U;16;L803",
  "1320;visibility reduced to <50 m;;;0;D;2;U;16;L805",
  "1321;visibility reduced to <100 m;;;0;D;2;;16;L810",
  "1322;white out;white out. Visibility reduced to (Q);;2;D;2;U;16;L9",
  "1323;blowing snow;blowing snow. Visibility reduced to (Q);;2;D;2;;16;L10",
  "1324;spray hazard;spray hazard. Visibility reduced to (Q);;2;D;2;;16;L11",
  "1325;low sun glare;;;0;D;1;;16;L12",
  "1326;sandstorms;sandstorms. Visibility reduced to (Q);;2;D;2;U;16;L13",
  "1327;sandstorms;(Q) probability of sandstorms;F;3;L;2;U;33;L13F",
  "1328;air quality: good;(Q) probability of air quality: good;F;3;L;2;;35;L14F",
  "1329;air quality: fair;(Q) probability of air quality: fair;F;3;L;2;;35;L15F",
  "1330;air quality: poor;(Q) probability of air quality: poor;F;3;L;2;;35;L16F",
  "1331;air quality: very poor;(Q) probability of air quality: very poor;F;3;L;2;;35;L17F",
  "1332;smog alert;;;0;L;2;;9;L18",
  "1333;smog;(Q) probability of smog;F;3;L;2;;35;L18F",
  "1334;pollen count: high;(Q) probability of pollen count: high;F;3;L;2;;35;L19F",
  "1335;pollen count: medium;(Q) probability of pollen count: medium;F;3;L;2;;35;L20F",
  "1336;pollen count: low;(Q) probability of pollen count: low;F;3;L;2;;35;L21F",
  "1337;freezing fog. Slippery roads;freezing fog. Visibility reduced to (Q). Slippery roads;;2;D;2;U;16;L4.G3",
  "1338;no motor vehicles due to smog alert;;;0;L;2;U;9;L18.C31",
  "1339;air quality improved;;F;0;(L);2;;35;L97F",
  "1340;swarms of insects;swarms of insects. Visibility reduced to (Q);;2;D;2;;16;L22",
  "1345;fog clearing;;;0;(D);2;;16;L95",
  "1346;fog forecast withdrawn;;;0;(D);2;;16;L94",
  "1351;maximum temperature;maximum temperature of (Q);F;6;L;2;;37;M1F",
  "1352;hot,;hot, maximum temperature (Q);F;6;L;2;;37;M2F",
  "1353;warm,;warm, maximum temperature (Q);F;6;L;2;;37;M3F",
  "1354;mild,;mild, maximum temperature (Q);F;6;L;2;;37;M4F",
  "1355;cool,;cool, maximum temperature (Q);F;6;L;2;;37;M5F",
  "1356;cold,;cold, maximum temperature (Q);F;6;L;2;;37;M6F",
  "1357;very cold,;very cold, maximum temperature (Q);F;6;L;2;;37;M7F",
  "1358;message cancelled;;S;0;;0;;37;",
  "1359;temperature rising;temperature rising to (Q);F;6;L;2;;37;M8F",
  "1360;temperature falling rapidly;temperature falling rapidly to (Q);F;6;L;2;;37;M10F",
  "1361;temperature;temperature (Q);F;6;L;2;;37;M11F",
  "1362;effective temperature, with wind chill;effective temperature, with wind chill (Q);F;6;L;2;;37;M12F",
  "1364;extreme heat;extreme heat up to (Q);F;6;L;2;;37;M14F",
  "1365;extreme cold;extreme cold of (Q);F;6;L;2;;37;M21F",
  "1401;minimum temperature;minimum temperature of (Q);F;6;L;2;;37;M9F",
  "1402;very warm;very warm minimum temperature (Q);F;6;L;2;;37;M15F",
  "1403;warm;warm minimum temperature (Q);F;6;L;2;;37;M16F",
  "1404;mild;mild minimum temperature (Q);F;6;L;2;;37;M17F",
  "1405;cool;cool minimum temperature (Q);F;6;L;2;;37;M18F",
  "1406;cold;cold minimum temperature (Q);F;6;L;2;;37;M19F",
  "1407;very cold;very cold minimum temperature (Q);F;6;L;2;;37;M20F",
  "1408;less extreme temperatures expected;;F;0;L;2;;37;M22F",
  "1449;emergency training in progress;;;0;D;2;;18;P58",
  "1450;international sports meeting;;;0;L;2;;18;P17",
  "1451;match;;;0;D;2;;18;P18",
  "1452;tournament;;;0;L;2;;18;P19",
  "1453;athletics meeting;;;0;D;2;;18;P20",
  "1454;ball game;;;0;D;2;;18;P21",
  "1455;boxing tournament;;;0;D;2;;18;P22",
  "1456;bull fight;;;0;D;2;;18;P23",
  "1457;cricket match;;;0;D;2;;18;P24",
  "1458;cycle race;;;0;D;2;;18;P25",
  "1459;football match;;;0;D;2;;18;P26",
  "1460;golf tournament;;;0;D;2;;18;P27",
  "1461;marathon;;;0;D;2;;18;P28",
  "1462;race meeting;;;0;D;2;;18;P29",
  "1463;rugby match;;;0;D;2;;18;P30",
  "1464;show jumping;;;0;D;2;;18;P31",
  "1465;tennis tournament;;;0;D;2;;18;P32",
  "1466;water sports meeting;;;0;D;2;;18;P33",
  "1467;winter sports meeting;;;0;D;2;;18;P34",
  "1468;funfair;;;0;D;2;;18;P35",
  "1469;trade fair;;;0;L;2;;18;P36",
  "1470;procession;;;0;D;2;;18;P37",
  "1471;sightseers obstructing access;;;0;D;2;U;13;P38",
  "1472;people on roadway;;;0;D;2;;13;P39",
  "1473;children on roadway;;;0;D;2;;13;P40",
  "1474;cyclists on roadway;;;0;D;2;;13;P41",
  "1475;strike;;;0;L;2;U;18;P42",
  "1476;security incident;;;0;D;2;U;19;P43",
  "1477;police checkpoint;;;0;L;2;;19;P44",
  "1478;terrorist incident;;;0;L;2;U;19;P45",
  "1479;gunfire on roadway, danger;;;0;(D);2;X;19;P46D",
  "1480;civil emergency;;;0;D;2;U;19;P47",
  "1481;air raid, danger;;;0;(D);2;X;19;P48D",
  "1482;people on roadway. Danger;;;0;D;2;U;13;P39.Z91",
  "1483;children on roadway. Danger;;;0;D;2;U;13;P40.Z91",
  "1484;cyclists on roadway. Danger;;;0;D;2;U;13;P41.Z91",
  "1485;closed due to security incident;;;0;D;2;U;9;P43.C1",
  "1486;security incident. Delays;security incident. Delays (Q);;5;D;1;U;20;P43.Q1",
  "1487;security incident. Delays expected;security incident. Delays (Q) expected;F;5;D;1;U;20;P43.Q1E",
  "1488;security incident. Long delays;security incident. Long delays (Q);;5;L;1;U;20;P43.Q2",
  "1489;police checkpoint. Delays;police checkpoint. Delays (Q);;5;D;1;;20;P44.Q1",
  "1490;police checkpoint. Delays expected;police checkpoint. Delays (Q) expected;F;5;D;1;;20;P44.Q1E",
  "1491;police checkpoint. Long delays;police checkpoint. Long delays (Q);;5;L;1;U;20;P44.Q2",
  "1492;security alert withdrawn;;;0;(D);2;;19;P97",
  "1493;sports traffic cleared;;;0;(D);2;;18;P92",
  "1494;evacuation;;;0;D;2;U;19;P49",
  "1495;evacuation. Heavy traffic;;;0;D;1;;1;P49.A4",
  "1496;traffic disruption cleared;;;0;(D);2;;18;P93",
  "1497;military training in progress;;;0;D;2;;18;P57",
  "1498;police activity ongoing;;;0;D;1;U;13;Pnn",
  "1499;medical emergency ongoing;;;0;D;1;U;13;Pnn",
  "1500;child abduction in progress;;;0;D;2;X;19;Pnn",
  "1501;major event;;;0;L;2;;18;P1",
  "1502;sports event meeting;;;0;D;2;;18;P2",
  "1503;show;;;0;D;2;;18;P3",
  "1504;festival;;;0;D;2;;18;P4",
  "1505;exhibition;;;0;L;2;;18;P5",
  "1506;fair;;;0;D;2;;18;P6",
  "1507;market;;;0;D;2;;18;P7",
  "1508;ceremonial event;;;0;D;2;;18;P8",
  "1509;state occasion;;;0;D;2;;18;P9",
  "1510;parade;;;0;D;2;;18;P10",
  "1511;crowd;;;0;D;2;;18;P11",
  "1512;march;;;0;D;2;;18;P12",
  "1513;demonstration;;;0;D;2;;18;P13",
  "1514;public disturbance;;;0;D;2;U;18;P14",
  "1515;security alert;;;0;D;2;;19;P15",
  "1516;bomb alert;;;0;D;2;U;19;P16",
  "1517;major event. Stationary traffic;;;0;D;1;U;1;P1.A1",
  "1518;major event. Danger of stationary traffic;;;0;D;1;U;1;P1.A1D",
  "1519;major event. Queuing traffic;major event. Queuing traffic;;0;D;1;U;1;P1.A2",
  "1520;major event. Danger of queuing traffic;;;0;D;1;U;1;P1.A2D",
  "1521;major event. Slow traffic;;;0;D;1;U;1;P1.A3",
  "1522;major event. Slow traffic expected;;F;0;D;1;U;2;P1.A3E",
  "1523;major event. Heavy traffic;;;0;D;1;;1;P1.A4",
  "1524;major event. Heavy traffic expected;;F;0;D;1;;2;P1.A4E",
  "1525;major event. Traffic flowing freely;;;0;(D);1;;1;P1.A5",
  "1526;major event. Traffic building up;;;0;D;1;;1;P1.A6",
  "1527;closed due to major event;;;0;D;1;U;9;P1.C1",
  "1528;major event. Delays;major event. Delays (Q);;5;D;1;;20;P1.Q1",
  "1529;major event. Delays expected;major event. Delays (Q) expected;F;5;D;1;U;20;P1.Q1E",
  "1530;major event. Long delays;major event. Long delays (Q);;5;L;1;U;20;P1.Q2",
  "1531;sports meeting. Stationary traffic;;;0;D;1;U;1;P2.A1",
  "1532;sports meeting. Danger of stationary traffic;;;0;D;1;U;1;P2.A1D",
  "1533;sports meeting. Queuing traffic;sports meeting. Queuing traffic;;0;D;1;U;1;P2.A2",
  "1534;sports meeting. Danger of queuing traffic;;;0;D;1;U;1;P2.A2D",
  "1535;sports meeting. Slow traffic;;;0;D;1;U;1;P2.A3",
  "1536;sports meeting. Slow traffic expected;;F;0;D;1;U;2;P2.A3E",
  "1537;sports meeting. Heavy traffic;;;0;D;1;;1;P2.A4",
  "1538;sports meeting. Heavy traffic expected;;F;0;D;1;;2;P2.A4E",
  "1539;sports meeting. Traffic flowing freely;;;0;(D);1;;1;P2.A5",
  "1540;sports meeting. Traffic building up;;;0;D;1;;1;P2.A6",
  "1541;closed due to sports meeting;;;0;D;1;U;9;P2.C1",
  "1542;sports meeting. Delays;sports meeting. Delays (Q);;5;D;1;;20;P2.Q1",
  "1543;sports meeting. Delays expected;sports meeting. Delays (Q) expected;F;5;D;1;;20;P2.Q1E",
  "1544;sports meeting. Long delays;sports meeting. Long delays (Q);;5;D;1;U;20;P2.Q2",
  "1545;fair. Stationary traffic;;;0;D;1;U;1;P6.A1",
  "1546;fair. Danger of stationary traffic;;;0;D;1;U;1;P6.A1D",
  "1547;fair. Queuing traffic;fair. Queuing traffic;;0;D;1;U;1;P6.A2",
  "1548;fair. Danger of queuing traffic;;;0;D;1;U;1;P6.A2D",
  "1549;fair. Slow traffic;;;0;D;1;U;1;P6.A3",
  "1550;fair. Slow traffic expected;;F;0;D;1;U;2;P6.A3E",
  "1551;fair. Heavy traffic;;;0;D;1;;1;P6.A4",
  "1552;fair. Heavy traffic expected;;F;0;D;1;;2;P6.A4E",
  "1553;fair. Traffic flowing freely;;;0;(D);1;;1;P6.A5",
  "1554;fair. Traffic building up;;;0;D;1;;1;P6.A6",
  "1555;closed due to fair;;;0;D;1;U;9;P6.C1",
  "1556;fair. Delays;fair. Delays (Q);;5;D;1;;20;P6.Q1",
  "1557;fair. Delays expected;fair. Delays (Q) expected;F;5;D;1;;20;P6.Q1E",
  "1558;fair. Long delays;fair. Long delays (Q);;5;D;1;U;20;P6.Q2",
  "1559;closed due to parade;;;0;D;1;U;9;P10.C1",
  "1560;parade. Delays;parade. Delays (Q);;5;D;1;;20;P10.Q1",
  "1561;parade. Delays expected;parade. Delays (Q) expected;F;5;D;1;U;20;P10.Q1E",
  "1562;parade. Long delays;parade. Long delays (Q);;5;D;1;U;20;P10.Q2",
  "1563;closed due to strike;;;0;D;1;U;9;P42.C1",
  "1564;strike. Delays;strike. Delays (Q);;5;D;1;U;20;P42.Q1",
  "1565;strike. Delays expected;strike. Delays (Q) expected;F;5;D;1;U;20;P42.Q1E",
  "1566;strike. Long delays;strike. Long delays (Q);;5;L;1;U;20;P42.Q2",
  "1567;closed due to demonstration;;;0;D;1;U;9;P13.C1",
  "1568;demonstration. Delays;demonstration. Delays (Q);;5;D;1;;20;P13.Q1",
  "1569;demonstration. Delays expected;demonstration. Delays (Q) expected;F;5;D;1;U;20;P13.Q1E",
  "1570;demonstration. Long delays;demonstration. Long delays (Q);;5;D;1;U;20;P13.Q2",
  "1571;security alert. Stationary traffic;;;0;D;1;U;1;P15.A1",
  "1572;security alert. Danger of stationary traffic;;;0;D;1;U;1;P15.A1D",
  "1573;security alert. Queuing traffic;security alert. Queuing traffic;;0;D;1;U;1;P15.A2",
  "1574;security alert. Danger of queuing traffic;;;0;D;1;U;1;P15.A2D",
  "1575;security alert. Slow traffic;;;0;D;1;U;1;P15.A3",
  "1576;security alert. Slow traffic expected;;F;0;D;1;U;2;P15.A3E",
  "1577;security alert. Heavy traffic;;;0;D;1;;1;P15.A4",
  "1578;security alert. Heavy traffic expected;;F;0;D;1;;2;P15.A4E",
  "1579;security alert. Traffic building up;;;0;D;1;;1;P15.A6",
  "1580;closed due to security alert;;;0;D;1;U;9;P15.C1",
  "1581;security alert. Delays;security alert. Delays (Q);;5;D;1;;20;P15.Q1",
  "1582;security alert. Delays expected;security alert. Delays (Q) expected;F;5;D;1;;20;P15.Q1E",
  "1583;security alert. Long delays;security alert. Long delays (Q);;5;D;1;U;20;P15.Q2",
  "1584;traffic has returned to normal;;;0;(D);1;;1;P98",
  "1585;message cancelled;;S;0;;0;;18;",
  "1586;security alert. Traffic flowing freely;;;0;(D);1;;1;P15.A5",
  "1587;air raid warning cancelled;;;0;(D);2;;19;P95",
  "1588;civil emergency cancelled;;;0;(L);2;;19;P96",
  "1589;message cancelled;;S;0;;0;;2;",
  "1590;several major events;;;0;L;2;;18;P50",
  "1591;information about major event no longer valid;;;0;(L);2;;18;P91",
  "1592;automobile race;;;0;D;2;;18;P51",
  "1593;baseball game;;;0;D;2;;18;P52",
  "1594;basketball game;;;0;D;2;;18;P53",
  "1595;boat race;;;0;D;2;;18;P54",
  "1596;concert;;;0;D;2;;18;P55",
  "1597;hockey game;;;0;D;2;;18;P56",
  "1601;delays;delays (Q);;5;D;1;;20;Q1",
  "1602;delays up to 15 minutes;;;0;D;1;;20;Q1(15)",
  "1603;delays up to 30 minutes;;;0;D;1;;20;Q1(30)",
  "1604;delays up to one hour;;;0;D;1;;20;Q101",
  "1605;delays up to two hours;;;0;D;1;U;20;Q102",
  "1606;delays of several hours;;;0;D;1;U;20;Q199",
  "1607;delays expected;delays (Q) expected;F;5;D;1;;20;Q1E",
  "1608;long delays;long delays (Q);;5;D;1;U;20;Q2",
  "1609;delays for heavy vehicles;delays (Q) for heavy vehicles;;5;D;1;;20;Q1.Z8",
  "1610;delays up to 15 minutes for heavy lorr(y/ies);;;0;D;1;;20;Q1(15).Z78",
  "1611;delays up to 30 minutes for heavy lorr(y/ies);;;0;D;1;;20;Q1(30).Z78",
  "1612;delays up to one hour for heavy lorr(y/ies);;;0;D;1;;20;Q101.Z78",
  "1613;delays up to two hours for heavy lorr(y/ies);;;0;D;1;U;20;Q102.Z78",
  "1614;delays of several hours for heavy lorr(y/ies);;;0;D;1;U;20;Q199.Z78",
  "1615;service suspended;service suspended until (Q);;7;L;1;U;21;Q4",
  "1616;service withdrawn;(Q) service withdrawn;;7;L;1;;21;Q5",
  "1617;service fully booked;(Q) services fully booked;;7;L;1;;21;Q6",
  "1618;service fully booked for heavy vehicles;(Q) services fully booked for heavy vehicles;;7;L;1;;21;Q6.Z8",
  "1619;normal services resumed;;;0;(L);2;;21;Q98",
  "1620;message cancelled;;S;0;;0;;20;",
  "1621;delays up to 5 minutes;;;0;D;1;;20;Q1(5)",
  "1622;delays up to 10 minutes;;;0;D;1;;20;Q1(10)",
  "1623;delays up to 20 minutes;;;0;D;1;;20;Q1(20)",
  "1624;delays up to 25 minutes;;;0;D;1;;20;Q1(25)",
  "1625;delays up to 40 minutes;;;0;D;1;;20;Q1(40)",
  "1626;delays up to 50 minutes;;;0;D;1;;20;Q1(50)",
  "1627;delays up to 90 minutes;;;0;D;1;U;20;Q1(90)",
  "1628;delays up to three hours;;;0;D;1;U;20;Q103",
  "1629;delays up to four hours;;;0;L;1;U;20;Q104",
  "1630;delays up to five hours;;;0;L;1;U;20;Q105",
  "1631;very long delays;very long delays (Q);;5;L;1;U;20;Q3",
  "1632;delays of uncertain duration;;;0;D;1;;20;Q7",
  "1633;delayed until further notice;;;0;(D);1;;21;Q8",
  "1634;cancellations;;;0;D;1;;21;Q9",
  "1635;park and ride service not operating;park and ride service not operating until (Q);;7;D;2;U;21;Q12",
  "1636;special public transport services operating;special public transport services operating until (Q);;7;D;2;;21;Q13",
  "1637;normal services not operating;normal services not operating until (Q);;7;D;2;U;21;Q14",
  "1638;rail services not operating;rail services not operating until (Q);;7;D;2;U;21;Q15",
  "1639;bus services not operating;bus services not operating until (Q);;7;D;2;U;21;Q16",
  "1640;shuttle service operating;shuttle service operating until (Q);;7;D;2;;21;Q17",
  "1641;free shuttle service operating;free shuttle service operating until (Q);;7;D;2;;21;Q18",
  "1642;delays for heavy lorr(y/ies);delays (Q) for heavy lorr(y/ies);;5;D;1;;20;Q1.Z78",
  "1643;delays for buses;delays (Q) for buses;;5;D;1;;20;Q1.Z79",
  "1644;service fully booked for heavy lorr(y/ies);(Q) services fully booked for heavy lorr(y/ies);;7;L;1;;21;Q6.Z78",
  "1645;service fully booked for buses;(Q) services fully booked for buses;;7;L;1;;21;Q6.Z79",
  "1646;next departure for heavy lorr(y/ies);next departure (Q) for heavy lorr(y/ies);F;7;D;1;;22;Q10.Z78",
  "1647;next departure for buses;next departure (Q) for buses;F;7;D;1;;22;Q10.Z79",
  "1648;delays cleared;;;0;(D);1;;20;Q97",
  "1649;rapid transit service not operating;rapid transit service not operating until (Q);;7;D;2;U;21;Q20",
  "1650;delays possible;delays (Q) possible;F;5;D;1;;20;Q21E",
  "1651;underground service not operating;underground service not operating until (Q);;7;D;2;U;21;Q19",
  "1652;cancellations expected;;F;0;D;1;;21;Q9E",
  "1653;long delays expected;;F;0;D;1;U;20;Q23E",
  "1654;very long delays expected;;F;0;L;1;U;20;Q25E",
  "1655;all services fully booked;all services fully booked until (Q);;7;L;1;U;21;Q6A",
  "1656;next arrival;next arrival (Q);F;7;D;1;;22;Q10A",
  "1657;rail services irregular. Delays;rail services irregular. Delays (Q);;5;D;2;;21;Q26",
  "1658;bus services irregular. Delays;bus services irregular. Delays (Q);;5;D;2;;21;Q27",
  "1659;underground services irregular;;;0;D;2;;21;Q28",
  "1660;normal public transport services resumed;;;0;(L);2;;21;Q96",
  "1661;ferry service not operating;ferry service not operating until (Q);;7;D;2;U;21;Q30",
  "1662;park and ride trip time;park and ride trip time (Q);;5;D;1;;22;Q29",
  "1663;delay expected to be cleared;;F;0;D;1;;20;Q95",
  "1664;demonstration by vehicles;;;0;D;1;;18;P59",
  "1680;delays have to be expected;delays (Q) have to be expected;F;5;L;1;;38;Q1F",
  "1681;delays of several hours have to be expected;;F;0;L;1;U;38;Q199F",
  "1682;closed ahead. Delays have to be expected;closed ahead. Delays (Q) have to be expected;F;5;L;1;U;38;C3.Q1F",
  "1683;roadworks. Delays have to be expected;roadworks. Delays (Q) have to be expected;F;5;L;1;;38;E1.Q1F",
  "1684;flooding. Delays have to be expected;flooding. Delays (Q) have to be expected;F;5;L;1;U;38;F5.Q1F",
  "1685;major event. Delays have to be expected;major event. Delays (Q) have to be expected;F;5;L;1;U;38;P1.Q1F",
  "1686;strike. Delays have to be expected;strike. Delays (Q) have to be expected;F;5;L;1;U;38;P42.Q1F",
  "1687;delays of several hours for heavy lorries have to be expected;;F;0;L;1;U;38;Q199.Z78F",
  "1688;long delays have to be expected;;F;0;L;1;U;38;Q23F",
  "1689;very long delays have to be expected;;F;0;L;1;U;38;Q25F",
  "1690;delay forecast withdrawn;;F;0;(L);2;;38;Q97F",
  "1691;message cancelled;;S;0;;0;;38;",
  "1695;current trip time;current trip time (Q);;5;D;1;;22;Q32",
  "1696;expected trip time;expected trip time (Q);F;5;D;1;;22;Q33",
  "1700;slow moving maintenance vehicle;(Q) slow moving maintenance vehicles;;0;D;1;U;12;R9D",
  "1701;vehicle on wrong carriageway;(Q) vehicles on wrong carriageway;;0;(D);2;X;23;R1",
  "1702;dangerous vehicle warning cleared;;;0;(D);2;U;23;R98",
  "1703;message cancelled;;S;0;;0;;23;",
  "1704;reckless driver;(Q) reckless drivers;;0;(D);1;U;23;R2",
  "1705;prohibited vehicle on the roadway;(Q) prohibited vehicles on the roadway;;0;D;1;U;23;R3",
  "1706;emergency vehicles;(Q) emergency vehicles;;0;D;1;U;23;R4",
  "1707;high-speed emergency vehicles;(Q) high-speed emergency vehicles;;0;D;1;X;23;R5",
  "1708;high-speed chase;high-speed chase involving (Q) vehicles;;0;(D);1;X;23;R6",
  "1709;spillage occurring from moving vehicle;;;0;D;1;U;12;R7",
  "1710;objects falling from moving vehicle;;;0;(D);1;U;23;R8",
  "1711;emergency vehicle warning cleared;;;0;(D);1;U;23;R96",
  "1712;road cleared;;;0;(D);1;;12;R97",
  "1720;rail services irregular;;;0;D;2;;21;Q31",
  "1721;public transport services not operating;;;0;D;2;U;21;Q34",
  "1731;abnormal load, danger;(Q) abnormal loads, danger;;0;D;1;U;24;S1D",
  "1732;wide load, danger;(Q) wide loads, danger;;0;D;1;U;24;S2D",
  "1733;long load, danger;(Q) long loads, danger;;0;D;1;U;24;S3D",
  "1734;slow vehicle, danger;(Q) slow vehicles, danger;;0;D;1;U;24;S4D",
  "1735;track-laying vehicle, danger;(Q) track-laying vehicles, danger;;0;D;1;U;24;S6D",
  "1736;vehicle carrying hazardous materials. Danger;(Q) vehicles carrying hazardous materials. Danger;;0;D;1;U;23;S7.Z91",
  "1737;convoy, danger;(Q) convoys, danger;;0;D;1;U;24;S5D",
  "1738;military convoy, danger;(Q) military convoys, danger;;0;D;1;U;24;S8D",
  "1739;overheight load, danger;(Q) overheight loads, danger;;0;D;1;U;24;S50D",
  "1740;abnormal load causing slow traffic. Delays;abnormal load causing slow traffic. Delays (Q);;5;D;1;U;20;S1.A3.Q1",
  "1741;convoy causing slow traffic. Delays;convoy causing slow traffic. Delays (Q);;5;D;1;U;20;S8.A3.Q1",
  "1751;abnormal load;(Q) abnormal loads;;0;D;1;;24;S1",
  "1752;wide load;(Q) wide loads;;0;D;1;;24;S2",
  "1753;long load;(Q) long loads;;0;D;1;;24;S3",
  "1754;slow vehicle;(Q) slow vehicles;;0;D;1;;24;S4",
  "1755;convoy;(Q) convoys;;0;D;1;;24;S5",
  "1756;abnormal load. Delays;abnormal load. Delays (Q);;5;D;1;U;20;S1.Q1",
  "1757;abnormal load. Delays expected;abnormal load. Delays (Q) expected;F;5;D;1;;20;S1.Q1E",
  "1758;abnormal load. Long delays;abnormal load. Long delays (Q);;5;D;1;U;20;S1.Q2",
  "1759;convoy causing delays;convoy causing delays (Q);;5;D;1;;20;S5.Q1",
  "1760;convoy. Delays expected;convoy. Delays (Q) expected;F;5;D;1;;20;S5.Q1E",
  "1761;convoy causing long delays;convoy causing long delays (Q);;5;D;1;U;20;S5.Q2",
  "1762;exceptional load warning cleared;;;0;(D);1;;24;S98",
  "1763;message cancelled;;S;0;;0;;24;",
  "1764;track-laying vehicle;(Q) track-laying vehicles;;0;D;1;;24;S6",
  "1765;vehicle carrying hazardous materials;(Q) vehicles carrying hazardous materials;;0;D;1;;23;S7",
  "1766;military convoy;(Q) military convoys;;0;D;1;;24;S8",
  "1767;abnormal load. No overtaking;(Q) abnormal loads. No overtaking;;0;D;1;U;24;S1.Z17",
  "1768;Vehicles carrying hazardous materials have to stop at next safe place!;;;0;D;1;U;23;S7.Z128",
  "1769;hazardous load warning cleared;;;0;(D);1;;23;S96",
  "1770;convoy cleared;;;0;(D);1;;24;S97",
  "1771;warning cleared;;;0;(D);1;;13;F99",
  "1780;cancellations have to be expected;;F;0;L;1;;39;Q9F",
  "1781;all services fully booked;all services fully booked until (Q);F;7;L;1;U;39;Q6F",
  "1782;park and ride service will not be operating;park and ride service will not be operating until (Q);F;7;L;2;U;39;Q12F",
  "1783;normal services will not be operating;normal services will not be operating until (Q);F;7;L;2;U;39;Q14F",
  "1784;rail services will not be operating;rail services will not be operating until (Q);F;7;L;2;U;39;Q15F",
  "1785;rapid transit service will not be operating;rapid transit service will not be operating until (Q);F;7;L;2;U;39;Q20F",
  "1786;underground service will not be operating;underground service will not be operating until (Q);F;7;L;2;U;39;Q19F",
  "1787;public transport will be on strike;;F;0;L;2;U;39;Q22F",
  "1788;ferry service will not be operating;ferry service will not be operating until (Q);F;7;L;2;U;39;Q30F",
  "1789;normal services expected;;F;0;L;2;;39;Q98F",
  "1790;message cancelled;;S;0;;0;;39;",
  "1801;lane control signs not working;;;0;D;1;U;25;T1",
  "1802;emergency telephones not working;;;0;D;2;;25;T2",
  "1803;emergency telephone number not working;;;0;D;2;;25;T3",
  "1804;traffic lights not working;(Q) sets of traffic lights not working;;0;D;2;;25;T4",
  "1805;traffic lights working incorrectly;(Q) sets of traffic lights working incorrectly;;0;D;2;U;25;T5",
  "1806;level crossing failure;;;0;D;2;;25;T6",
  "1807;traffic lights not working. Stationary traffic;(Q) sets of traffic lights not working. Stationary traffic;;0;D;1;U;1;T4.A1",
  "1808;traffic lights not working. Danger of stationary traffic;(Q) sets of traffic lights not working. Danger of stationary traffic;;0;D;1;U;1;T4.A1D",
  "1809;traffic lights not working. Queuing traffic;(Q) sets of traffic lights not working. Queuing traffic;;0;D;1;U;1;T4.A2",
  "1810;traffic lights not working. Danger of queuing traffic;(Q) sets of traffic lights not working. Danger of queuing traffic;;0;D;1;U;1;T4.A2D",
  "1811;traffic lights not working. Slow traffic;(Q) sets of traffic lights not working. Slow traffic;;0;D;1;U;1;T4.A3",
  "1812;traffic lights not working. Slow traffic expected;(Q) sets of traffic lights not working. Slow traffic expected;F;0;D;1;U;2;T4.A3E",
  "1813;traffic lights not working. Heavy traffic;(Q) sets of traffic lights not working. Heavy traffic;;0;D;1;;1;T4.A4",
  "1814;traffic lights not working. Heavy traffic expected;(Q) sets of traffic lights not working. Heavy traffic expected;F;0;D;1;;2;T4.A4E",
  "1815;traffic lights not working. Traffic flowing freely;(Q) sets of traffic lights not working. Traffic flowing freely;;0;(D);1;;1;T4.A5",
  "1816;traffic lights not working. Traffic building up;(Q) sets of traffic lights not working. Traffic building up;;0;D;1;;1;T4.A6",
  "1817;traffic lights not working. Delays;traffic lights not working. Delays (Q);;5;D;1;;20;T4.Q1",
  "1818;traffic lights not working. Delays expected;traffic lights not working. Delays (Q) expected;F;5;D;1;;20;T4.Q1E",
  "1819;traffic lights not working. Long delays;traffic lights not working. Long delays (Q);;5;D;1;U;20;T4.Q2",
  "1820;level crossing failure. Stationary traffic;;;0;D;1;U;1;T6.A1",
  "1821;level crossing failure. Danger of stationary traffic;;;0;D;1;U;1;T6.A1D",
  "1822;level crossing failure. Queuing traffic;level crossing failure. Queuing traffic;;0;D;1;U;1;T6.A2",
  "1823;level crossing failure. Danger of queuing traffic;;;0;D;1;U;1;T6.A2D",
  "1824;level crossing failure. Slow traffic;;;0;D;1;U;1;T6.A3",
  "1825;level crossing failure. Slow traffic expected;;F;0;D;1;U;2;T6.A3E",
  "1826;level crossing failure. Heavy traffic;;;0;D;1;;1;T6.A4",
  "1827;level crossing failure. Heavy traffic expected;;F;0;D;1;;2;T6.A4E",
  "1828;level crossing failure. Traffic flowing freely;;;0;(D);1;;1;T6.A5",
  "1829;level crossing failure. Traffic building up;;;0;D;1;;1;T6.A6",
  "1830;level crossing failure. Delays;level crossing failure. Delays (Q);;5;D;1;;20;T6.Q1",
  "1831;level crossing failure. Delays expected;level crossing failure. Delays (Q) expected;F;5;D;1;;20;T6.Q1E",
  "1832;level crossing failure. Long delays;level crossing failure. Long delays (Q);;5;D;1;U;20;T6.Q2",
  "1833;electronic signs repaired;;;0;(D);2;;25;T95",
  "1834;emergency call facilities restored;;;0;(D);2;;25;T96",
  "1835;traffic signals repaired;;;0;(D);2;;25;T97",
  "1836;level crossing now working normally;;;0;(D);2;;25;T98",
  "1837;message cancelled;;S;0;;0;;25;",
  "1838;lane control signs working incorrectly;;;0;D;1;U;25;T7",
  "1839;lane control signs operating;;;0;D;1;;25;T8",
  "1840;variable message signs not working;;;0;D;1;;25;T9",
  "1841;variable message signs working incorrectly;;;0;D;1;U;25;T10",
  "1842;variable message signs operating;;;0;D;1;;25;T11",
  "1843;ramp control signals not working;(Q) sets of ramp control signals not working;;0;D;1;;25;T12",
  "1844;ramp control signals working incorrectly;(Q) sets of ramp control signals working incorrectly;;0;D;1;;25;T13",
  "1845;temporary traffic lights not working;(Q) sets of temporary traffic lights not working;;0;D;2;;25;T14",
  "1846;temporary traffic lights working incorrectly;(Q) sets of temporary traffic lights working incorrectly;;0;D;2;U;25;T15",
  "1847;traffic signal control computer not working;;;0;D;2;;25;T16",
  "1848;traffic signal timings changed;;;0;L;2;U;25;T17",
  "1849;tunnel ventilation not working;;;0;D;2;U;25;T18",
  "1850;lane control signs not working. Danger;;;0;D;1;U;25;T1.Z91",
  "1851;temporary width limit;temporary width limit (Q);;9;(L);1;;26;U1",
  "1852;temporary width limit lifted;;;0;(L);1;;26;U98",
  "1854;traffic regulations have been changed;;;0;(L);2;;9;U6",
  "1855;less than 50 parking spaces available;;;0;(D);2;;28;X550",
  "1856;no parking information available;no parking information available until (Q);;7;(D);2;;28;X98",
  "1857;message cancelled;;S;0;;0;;26;",
  "1858;Snowplough. Delays;Snowplough. Delays (Q);;5;D;1;;20;R9.Q1E",
  "1861;temporary height limit;temporary height limit (Q);;9;(L);1;;26;U2",
  "1862;temporary height limit lifted;;;0;(L);1;;26;U95",
  "1863;automatic payment lanes not working;(Q) automatic payment lanes not working;;0;D;1;;25;Tnn",
  "1864;lane control signs working incorrectly. Danger;;;0;D;1;U;25;T7.Z91",
  "1865;emergency telephones out of order. Extra police patrols in operation;;;0;D;2;;25;T2.Z41",
  "1866;emergency telephones out of order. In emergency, wait for police patrol;;;0;D;2;U;25;T2.Z126",
  "1867;traffic lights not working. Danger;(Q) sets of traffic lights not working. Danger;;0;D;2;U;25;T4.Z91",
  "1868;traffic lights working incorrectly. Delays;traffic lights working incorrectly. Delays (Q);;5;D;1;;20;T5.Q1",
  "1869;traffic lights working incorrectly. Delays expected;traffic lights working incorrectly. Delays (Q) expected;F;5;D;1;;20;T5.Q1E",
  "1870;traffic lights working incorrectly. Long delays;traffic lights working incorrectly. Long delays (Q);;5;D;1;U;20;T5.Q2",
  "1871;temporary axle load limit;temporary axle load limit (Q);;8;(L);2;;26;U4",
  "1872;temporary gross weight limit;temporary gross weight limit (Q);;8;(L);2;;26;U5",
  "1873;temporary gross weight limit lifted;;;0;(L);2;;26;U97",
  "1874;temporary axle weight limit lifted;;;0;(L);2;;26;U94",
  "1875;traffic lights working incorrectly. Danger;(Q) sets of traffic lights working incorrectly. Danger;;0;D;2;U;25;T5.Z91",
  "1876;temporary traffic lights not working. Delays;temporary traffic lights not working. Delays (Q);;5;D;1;;20;T14.Q1",
  "1877;temporary traffic lights not working. Delays expected;temporary traffic lights not working. Delays (Q) expected;F;5;D;1;;20;T14.Q1E",
  "1878;temporary traffic lights not working. Long delays;temporary traffic lights not working. Long delays (Q);;5;D;1;U;20;T14.Q2",
  "1879;temporary traffic lights not working. Danger;(Q) sets of temporary traffic lights not working. Danger;;0;D;2;U;25;T14.Z91",
  "1880;traffic signal control computer not working. Delays;traffic signal control computer not working. Delays (Q);;5;D;1;;20;T16.Q1",
  "1881;temporary length limit;temporary length limit (Q);;9;(L);2;;26;U3",
  "1882;temporary length limit lifted;;;0;(L);2;;26;U96",
  "1883;message cancelled;;S;0;;0;;27;",
  "1884;traffic signal control computer not working. Delays expected;traffic signal control computer not working. Delays (Q) expected;F;5;D;1;;20;T16.Q1E",
  "1885;traffic signal control computer not working. Long delays;traffic signal control computer not working. Long delays (Q);;5;D;1;U;20;T16.Q2",
  "1886;normal parking restrictions lifted;;;0;D;2;;27;X1",
  "1887;special parking restrictions in force;;;0;L;2;;27;X2",
  "1888;10% full;;;0;(D);2;;28;X310",
  "1889;20% full;;;0;(D);2;;28;X320",
  "1890;30% full;;;0;(D);2;;28;X330",
  "1891;40% full;;;0;(D);2;;28;X340",
  "1892;50% full;;;0;(D);2;;28;X350",
  "1893;60% full;;;0;(D);2;;28;X360",
  "1894;70% full;;;0;(D);2;;28;X370",
  "1895;80% full;;;0;(D);2;;28;X380",
  "1896;90% full;;;0;(D);2;;28;X390",
  "1897;less than 10 parking spaces available;;;0;(D);2;;28;X510",
  "1898;less than 20 parking spaces available;;;0;(D);2;;28;X520",
  "1899;less than 30 parking spaces available;;;0;(D);2;;28;X530",
  "1900;less than 40 parking spaces available;;;0;(D);2;;28;X540",
  "1901;next departure;next departure (Q);F;7;D;1;;22;Q10E",
  "1902;next departure for heavy vehicles;next departure (Q) for heavy vehicles;F;7;D;1;;22;Q10.Z8",
  "1903;car park full;car park (Q) full;;3;D;2;U;28;X3",
  "1904;all car parks full;all car parks (Q) full;;3;(D);2;U;28;X4",
  "1905;less than car parking spaces available;less than (Q) car parking spaces available;;1;(D);2;;28;X5",
  "1906;park and ride service operating;park and ride service operating until (Q);;7;D;2;;21;Q11",
  "1907;(null event) {no event description, but location etc. given in message};;;0;D;1;;31;Y7",
  "1908;switch your car radio;switch your car radio to (Q);;11;(D);2;U;29;Y8",
  "1909;alarm call: important new information on this frequency follows now in normal programme;;S;0;(D);1;;29;Y9",
  "1910;alarm set: new information will be broadcast between these times in normal programme;;S;0;(L);1;;29;Y10",
  "1911;message cancelled;;S;0;;0;;29;",
  "1913;switch your car radio;switch your car radio to (Q);;12;(D);2;U;29;Y1",
  "1914;no information available;no information available until (Q);;7;D;2;;30;Y2",
  "1915;this message is for test purposes only, please ignore;this message is for test purposes only number (Q), please ignore;;0;(D);1;;31;Y3",
  "1916;no information available due to technical problems;no information available until (Q) due to technical problems;;7;D;2;;30;Y2.Z175",
  "1917;automatic toll system not working, pay manually;;;0;D;1;;25;Tnn",
  "1918;full;;;0;(D);2;U;28;X300",
  "1920;only a few parking spaces available;;;0;(D);2;;28;X41",
  "1921;parking spaces available;(Q) parking spaces available;;1;(D);2;;28;X42",
  "1922;expect car park to be full;;F;0;D;2;;28;X3E",
  "1923;expect no parking spaces available;;F;0;D;2;U;28;X40E",
  "1924;multi story car parks full;;;0;D;2;;28;X45",
  "1925;no problems to report with park and ride services;;;0;(D);2;;28;X82",
  "1926;no parking spaces available;;;0;D;2;U;28;X40",
  "1927;no parking;no parking until (Q);;7;D;2;;27;X6",
  "1928;special parking restrictions lifted;;;0;(L);2;;27;X97",
  "1929;urgent information will be given on normal programme broadcasts;urgent information will be given at (Q) on normal programme broadcasts;F;7;D;2;U;29;Y12E",
  "1930;this TMC-service is not active;this TMC-service is not active until (Q);;7;D;2;;30;Y13",
  "1931;detailed information will be given on normal programme broadcasts;detailed information will be given at (Q) on normal programme broadcasts;F;7;D;2;U;29;Y29E",
  "1932;detailed information is provided by another TMC service;;;0;D;2;U;30;Y30",
  "1934;no park and ride information available;no park and ride information available until (Q);;7;D;2;;28;X85",
  "1938;park and ride information service resumed;;;0;(D);2;;28;X95",
  "1939;travel information telephone service availiable;;;0;D;2;;30;",
  "1940;additional regional information is provided by another TMC service;;;0;(L);2;;30;Y14",
  "1941;additional local information is provided by another TMC service;;;0;(L);2;;30;Y15",
  "1942;additional public transport information is provided by another TMC service;;;0;(L);2;;30;Y16",
  "1943;national traffic information is provided by another TMC service;;;0;(L);2;;30;Y17",
  "1944;this service provides major road information;;;0;(L);2;;30;Y18",
  "1945;this service provides regional travel information;;;0;(L);2;;30;Y19",
  "1946;this service provides local travel information;;;0;(L);2;;30;Y20",
  "1947;no detailed regional information provided by this service;;;0;L;2;;30;Y21",
  "1948;no detailed local information provided by this service;;;0;L;2;;30;Y22",
  "1949;no cross-border information provided by this service;;;0;L;2;;30;Y23",
  "1950;information restricted to this area;;;0;L;2;;30;Y24",
  "1951;no new traffic information available;no new traffic information available until (Q);;7;D;2;;30;Y25",
  "1952;no public transport information available;;;0;D;2;;30;Y26",
  "1953;this TMC-service is being suspended;this TMC-service is being suspended at (Q);;7;D;2;;30;Y27",
  "1954;active TMC-service will resume;active TMC-service will resume at (Q);F;7;D;2;;30;Y28E",
  "1955;reference to audio programmes no longer valid;;;0;(D);2;;29;Y95",
  "1956;reference to other TMC services no longer valid;;;0;(D);2;;30;Y96",
  "1957;previous announcement about this or other TMC services no longer valid;;;0;(D);2;;30;Y97",
  "1961;allow emergency vehicles to pass in the carpool lane;;;0;(D);1;U;9;D53",
  "1962;carpool lane available for all vehicles;;;0;L;1;;10;D38",
  "1963;police directing traffic via the carpool lane;;;0;(D);1;;10;D54",
  "1964;rail information service not available;;;0;D;2;;30;Y4",
  "1965;rail information service resumed;;;0;D;2;;30;Y49",
  "1966;rapid transit information service not available;;;0;D;2;;30;Y5",
  "1967;rapid transit information service resumed;;;0;D;2;;30;Y59",
  "1971;police directing traffic;;;0;(D);1;;9;U7",
  "1972;buslane available for all vehicles;;;0;L;1;;9;D62",
  "1973;police directing traffic via the buslane;;;0;(D);1;U;9;D63",
  "1974;allow emergency vehicles to pass;;;0;(D);1;U;9;U8",
  "1975;overtaking prohibited for heavy vehicles;overtaking prohibited for heavy vehicles over (Q);;8;D;1;U;9;U103",
  "1976;overtaking prohibited;;;0;D;1;;9;U10",
  "1977;allow emergency vehicles to pass in the heavy vehicle lane;;;0;(D);1;U;9;D67",
  "1978;heavy vehicle lane available for all vehicles;;;0;L;1;;9;D46",
  "1979;police directing traffic via the heavy vehicle lane;;;0;(D);1;;9;D68",
  "1980;overtaking prohibited for heavy lorries;overtaking prohibited for heavy lorries over (Q);;8;D;1;;9;U101",
  "1981;drivers of heavy lorries are recommended to stop at next safe place;drivers of heavy lorries over (Q) are recommended to stop at next safe place;;8;D;2;U;9;U102",
  "1982;buslane closed;;;0;L;1;;6;D40",
  "1983;power failure;;;0;D;2;;25;T99",
  "1985;overtaking restriction lifted;;;0;D;1;;9;U93",
  "1986;Low Emission Zone restriction in force;;;0;L;2;;9;C36",
  "1990;car park closed;car park closed until (Q);;7;D;2;;28;X700",
  "1991;danger of waiting vehicles on roadway;;;0;D;1;U;13;R11",
  "1993;number of parking spaces decreasing;;;0;D;2;;28;X31",
  "1994;number of parking spaces constant;;;0;D;2;;28;X32",
  "1995;number of parking spaces increasing;;;0;D;2;;28;X33",
  "1998;dangerous situation on exit slip road;;;0;D;1;U;7;F32",
  "1999;dangerous situation on entry slip road;;;0;D;1;U;8;F31",
  "2000;closed due to smog alert;closed due to smog alert until (Q);;7;L;2;U;9;L30",
  "2006;closed for vehicles with less than three occupants {not valid for lorries};;;0;L;1;U;10;L37",
  "2007;closed for vehicles with only one occupant {not valid for lorries};;;0;L;1;U;10;L38",
  "2013;service area busy;;;0;D;1;;9;C59",
  "2021;service not operating, substitute service available;;;0;D;2;;21;Q21",
  "2022;public transport strike;;;0;D;2;U;21;Q22",
  "2028;message cancelled;;S;0;;0;;4;",
  "2029;message cancelled;;S;0;;0;;10;",
  "2030;message cancelled;;S;0;;0;;13;F99",
  "2032;message cancelled;;S;0;;0;;35;",
  "2033;message cancelled;;S;0;;0;;19;",
  "2034;message cancelled;;S;0;;0;;21;",
  "2035;message cancelled;;S;0;;0;;22;",
  "2038;message cancelled;;S;0;;0;;28;",
  "2039;message cancelled;;S;0;;0;;30;",
  "2040;message cancelled;;S;0;;0;;31;",
  "2041;nothing to report;;S;0;(D);2;;31;Y11",
  "2042;ice build-up on cable structure;;;0;D;2;U;13;Hnn",
  "2043;road salted;;;0;D;1;;14;Gnn",
  "2044;danger of snow patches;;;0;D;2;U;14;GnnD",
  "2045;snow patches;;;0;D;2;U;14;Gnn",
  "2046;Convoy service required due to bad weather;;;0;D;2;U;9;Unn",
  "2047;(null message) {completely silent message, see protocol, sect. 3.5.4};;S;0;(D);2;;31;Y11" };

const std::array<std::string_view, 233> tmc_raw_data_suppl{
  "1;heavy lorries are recommended to avoid the area",
  "2;follow signs",
  "3;follow diversion signs",
  "4;diversion in operation",
  "5;no suitable diversion available",
  "6;diversion is no longer recommended",
  "7;for exceptional loads only",
  "8;for heavy vehicles only",
  "9;for cars and light vehicles only",
  "10;snowploughs in use",
  "11;gritting vehicles in use",
  "12;drive carefully",
  "13;keep your distance",
  "14;observe signals",
  "15;overtake with care",
  "16;cross junction with care",
  "17;no overtaking",
  "18;use headlights",
  "19;use fog lights",
  "20;do not leave your vehicle",
  "21;switch off engine",
  "22;close all windows. Turn off heater and vents",
  "23;test your brakes",
  "24;winter equipment recommended",
  "25;snow chains recommended",
  "26;snow chains mandatory",
  "27;keep to the left",
  "28;keep to the right",
  "29;use hard shoulder as lane",
  "30;do not drive on the hard shoulder",
  "31;in the opposite direction",
  "32;in the opposing lanes",
  "33;in the overtaking lane",
  "34;in the crawler lane",
  "35;in the right lane",
  "36;in the middle lane",
  "37;in the left lane",
  "38;on the roadway",
  "39;police directing traffic",
  "40;police in attendance",
  "41;extra police patrols in operation",
  "42;rescue and recovery work in progress",
  "43;look out for flagman",
  "44;why not park-and-ride?",
  "45;why not try public transport?",
  "46;only travel if absolutely necessary",
  "47;increased risk of accident",
  "48;on bridges",
  "49;in shaded areas",
  "50;entering or leaving tunnels",
  "51;winter closure",
  "52;batch service in progress",
  "53;the north",
  "54;the north-east",
  "55;the east",
  "56;the south-east",
  "57;the south",
  "58;the south-west",
  "59;the west",
  "60;the north-west",
  "61;follow special diversion markers",
  "62;do not follow diversion signs",
  "63;follow local diversion",
  "64;compulsory diversion in operation",
  "65;for petrol-engined vehicles only",
  "66;for diesel-engined vehicles only",
  "67;for LPG vehicles only",
  "68;local drivers are recommended to avoid the area",
  "69;for 4-wheel-drive with snow tyres or chains only",
  "70;in the median",
  "71;for cars only",
  "72;for light vehicles only",
  "73;for vehicles with catalytic converters",
  "74;for vehicles without catalytic converters",
  "75;for cars with trailers only",
  "76;for cars with caravans only",
  "77;for vehicles with trailers only",
  "78;for heavy lorries only",
  "79;for buses only",
  "80;for articulated vehicles only",
  "81;for high-sided vehicles only",
  "82;for hazardous loads only",
  "83;for abnormal loads only",
  "84;with even-numbered registration plates",
  "85;with odd-numbered registration plates",
  "86;for all vehicles",
  "88;for through traffic",
  "89;for rail services",
  "90;on the underground",
  "91;danger",
  "92;repairs in progress",
  "93;pilot car in operation",
  "94;emergency vehicles at scene",
  "95;traffic being directed around accident area",
  "96;danger of explosion",
  "97;danger of fire",
  "98;radiation hazard",
  "99;toxic leak",
  "100;firemen directing traffic",
  "101;police speed checks in operation",
  "102;mandatory speed limit in force",
  "103;speed limit in force for heavy vehicles",
  "104;reduce your speed",
  "105;observe speed limits",
  "106;observe recommended speed",
  "107;snow chains required",
  "108;snow chains or tyres reqired",
  "109;helicopter rescue in progress",
  "110;several accidents have taken place",
  "111;drive with extreme caution",
  "112;approach with care",
  "113;increase normal following distance",
  "114;do not allow unnecessary gaps",
  "115;follow the vehicle in front, smoothly",
  "116;do not slow down unneccessarily",
  "117;observe signs",
  "118;use hazard warning lights",
  "119;no smoking",
  "120;no naked flames",
  "121;switch off mobile phones and two-way radios",
  "122;allow emergency vehicles to pass",
  "123;clear a lane for emergency vehicles",
  "124;pull over to the edge of the roadway",
  "125;wait for escort vehicle",
  "126;in emergency, wait for police patrol",
  "128;stop at next safe place",
  "129;clear a lane for snowploughs and gritting vehicles",
  "131;use right lane",
  "132;use left lane",
  "133;heavy vehicles use right lane",
  "134;heavy vehicles use left lane",
  "136;stop at next service area",
  "141;on the right",
  "142;in the centre",
  "143;on the left",
  "144;in the bus lane",
  "145;in the carpool lane",
  "146;on the hard shoulder",
  "147;in the emergency lane",
  "148;on the opposite carriageway",
  "149;in the heavy vehicle lane",
  "150;in the local lane",
  "151;due to heat",
  "152;due to frost",
  "153;for ferry service",
  "154;for roads in",
  "155;in the through traffic lane",
  "156;in the express lane",
  "157;in the connecting carriageway",
  "158;in the parallel carriageway",
  "159;in the right-hand parallel carriageway",
  "160;in the left-hand parallel carriageway",
  "161;in tunnels",
  "162;on slip roads",
  "163;at high altitudes",
  "164;in low-lying areas",
  "165;around a bend in the road",
  "166;over the crest of a hill",
  "167;in the city centre",
  "168;in the inner city area",
  "169;in the slow vehicle lane",
  "170;in the turning lane",
  "171;due to an earlier accident",
  "172;due to shear weight of traffic",
  "173;due to large numbers of visitors",
  "174;due to holiday traffic",
  "175;due to technical problems",
  "176;towards town",
  "177;from town",
  "178;on entry into the country",
  "179;on leaving the country",
  "180;do not throw out any burning objects",
  "181;traffic wardens directing traffic",
  "185;due to falling ice",
  "191;snow tyres recommended",
  "192;snow tyres mandatory",
  "195;use through traffic lanes",
  "196;use local traffic lanes",
  "197;use left-hand parallel carriageway",
  "198;use right-hand parallel carriageway",
  "199;use heavy vehicle lane",
  "200;due to an earlier incident",
  "201;why not ride share?",
  "202;is this your no-ride day?",
  "203;due to an earlier event",
  "204;please use rail service",
  "205;please use underground service",
  "206;please use tram service",
  "207;please use bus service",
  "208;for a limited time",
  "209;your parking ticket covers the return ride",
  "210;avoid the rush hour",
  "211;for holiday traffic",
  "212;for residents",
  "213;several times",
  "214;during the day time",
  "215;during off-peak periods",
  "216;during the night",
  "217;until further notice",
  "218;for arrivals",
  "219;for departures",
  "220;access only",
  "221;only",
  "222;except",
  "223;for long distance traffic",
  "224;for local traffic",
  "225;for regional traffic",
  "226;unconfirmed report",
  "227;on manual payment lanes",
  "231;sorry for any delay",
  "232;for roads leading towards",
  "233;for roads from",
  "234;we are grateful for your cooperation",
  "235;Traffic queue length decreasing at an average rate of 10 km/hr",
  "236;Traffic queue length decreasing at an average rate of 20 km/hr",
  "237;Traffic queue length decreasing at an average rate of 30 km/hr",
  "238;Traffic queue length decreasing at an average rate of 40 km/hr",
  "239;leave your vehicle. Proceed to next save place",
  "240;for visitors",
  "241;in the roadworks area",
  "242;from",
  "243;to",
  "244;in",
  "245;Traffic queue length increasing",
  "246;Traffic queue length increasing at an average rate of 10 km/hr",
  "247;Traffic queue length increasing at an average rate of 20 km/hr",
  "248;Traffic queue length increasing at an average rate of 30 km/hr",
  "249;Traffic queue length increasing at an average rate of 40 km/hr",
  "250;very frequent service",
  "251;frequent service",
  "252;fairly frequent service",
  "253;regular service",
  "255;Traffic queue length decreasing" };
// clang-format on

}  // namespace redsea::tmc
