# Motivation
<!-- Briefly explain what the change is about and why it is desirable. -->

# Context
<!-- Provide context. Reference open issues if available. -->

<!-- Non-trivial change: Briefly outline the implementation strategy. -->

<!-- Invasive change: Discuss alternative designs or approaches you considered. -->

<!-- Large change: Provide instructions to reviewers how to read the diff. -->

# Checklist for maintainers

<!-- Contributors: please leave this as is -->

Maintainers: tick if completed or explain if not relevant

 - [ ] agreed on idea
 - [ ] agreed on implementation strategy
 - [ ] tests, as appropriate
   - functional tests - `tests/**.sh`
   - unit tests - `src/*/tests`
   - integration tests - `tests/nixos/*`
 - [ ] documentation in the manual
 - [ ] documentation in the internal API docs
 - [ ] code and comments are self-explanatory
 - [ ] commit message explains why the change was made
 - [ ] new feature or incompatible change: updated release notes

# Priorities

Add :+1: to [pull requests you find important](https://github.com/NixOS/nix/pulls?q=is%3Aopen+sort%3Areactions-%2B1-desc).
