#ifndef IFACESMAP_H
#define IFACESMAP_H

#include <string>
#include <vector>

#include "main.h"
#include "aux.h"

using namespace aux;

class Iface
{
    friend class IfacesMap;
    public:
        Iface(int, std::string); // ifr_ifindex, ifr_name
        ~Iface();
    private:
        int Index;
        std::string Name;
        bool Controlled;
        bool DNShapeMethodSafe;
        bool HtbDNWrapperClass;
        unsigned int Speed;
        unsigned int FallbackRate;
        std::vector <std::string> Sections;
        unsigned int SectionsSpeedSum;
        EnumTcFilterType TcFilterType;
};

class IfacesMap
{
    public:
        IfacesMap();
        ~IfacesMap();
        int index(std::string);
        bool isValidSysDev(std::string);
        void setAsControlled(std::string);
        void setDNShapeMethodSafe(std::string, bool);
        bool isDNShapeMethodSafe(std::string);
        void setHtbDNWrapperClass(std::string, bool);
        void setSpeed(std::string, unsigned int);
        unsigned int speed(std::string dev);
        void setFallbackRate(std::string, unsigned int);
        void addSection(std::string, std::string);
        bool isInSections(std::string, std::string); 
        int addToSectionsSpeedSum(std::string, unsigned int);
        void setTcFilterType(std::string, EnumTcFilterType);
        EnumTcFilterType tcFilterType(std::string);
        int initHtbOnControlled();
        int endUpHtbFallbackOnControlled();
        unsigned int htbFallbackId();
        unsigned int htbDNWrapperId();
    private:
        int ifaceNum(std::string);
        unsigned int HtbFallbackId; 
        unsigned int HtbDNWrapperId;  
        std::vector <Iface *> SysNetDevices;
};

#endif

