/*
 *      NiceShaper - Dynamic Traffic Management
 *
 *      Copyright 2004 Mariusz Jedwabny <mariusz@jedwabny.net>
 *
 *      This file is subject to the terms and conditions of the GNU General Public
 *      License.  See the file COPYING in the main directory of this archive for
 *      more details.
 */

#include "net.h"

#include <string>
#include <vector>

#include "main.h"
#include "aux.h"
#include "log.h"
#include "sys.h"
#include "tests.h"

using std::string;
using std::vector;

using namespace aux;

NsNet::NsNet(std::string ipt_my_chain)
{
    IptMyChain = ipt_my_chain;
    IptApplied = false;
    Match = "";
    IptMyParent = "";
}

NsNet::~NsNet()
{
    string buf;

    if (IptApplied) {
        buf = "iptables -t mangle -D " + IptMyParent + " " + IptMatch + " -j " + IptMyChain;
        sys->ipt(buf);
    }
}

int NsNet::init(string buf)
{
    unsigned int n;

    n=1;
    while (awk(buf, ++n).size()) {
        if (n >= 3) Match += " ";
        Match += awk(buf, n);
    }
    Match = trim_strict(Match);

    if (gen_ipt_filter(Match, IptMatch) == -1) {
        log.error( 18, Match);
        return -1;
    }

    return 0;
}

int NsNet::iptInit(bool apply, string ipt_my_parent_mode, string ipt_my_parent, vector <string> &ipt_rules)
{
    string buf;

    IptMyParent = ipt_my_parent;

    buf = " " + ipt_my_parent_mode + " " + IptMyParent + "  " + IptMatch + " -j " + IptMyChain;

    if (!apply) ipt_rules.push_back (buf);
    else sys->ipt ("iptables -t mangle " + buf);

    IptApplied = true;

    return 0;
}
