#ifndef TALK_H
#define TALK_H

#include <string>
#include <vector>

class Talk
{
    public:
        Talk();
        ~Talk();
        // Init communication
        int sendInitStatusError(int pipe_write);
        int sendInitStatusOk(int pipe_write);
        int getInitStatus(int pipe_read);
        // Synchronization
        int sendContinue(int pipe_write);
        int sendFatalError(int pipe_write);
        int waitForContinue(int pipe_read);
        // Sending datas
        int sendMsg(int pipe_write, std::string);
        int getMsg(int pipe_read, std::string &);
        int sendMsgv(int pipe_write, std::vector <std::string> &);
        int getMsgv(int pipe_read, std::vector <std::string> &);                            
    private:
        static const char PROTO_BASE = 32; // message lenght = VAR - PROTO_BASE
        static const char PROTO_INIT_ACK = 31; // - child init acknowledge
        static const char PROTO_INIT_NAK = 30; // - child init failed
        static const char PROTO_MSG_ACK = 29; // - acknowledge 
        static const char PROTO_MSG_NAK = 28; // - have problems 
        static const char PROTO_MSG_EOT = 27; // - end of transmission
        static const int MAX_MESSAGE_SIZE = 128 - PROTO_BASE;
};

#endif
