// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        v3.15.6
// source: tfstackdata1.proto

package tfstackdata1

import (
	planproto "github.com/hashicorp/terraform/internal/plans/planproto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type StateResourceInstanceObjectV1_Status int32

const (
	StateResourceInstanceObjectV1_UNKNOWN StateResourceInstanceObjectV1_Status = 0
	StateResourceInstanceObjectV1_READY   StateResourceInstanceObjectV1_Status = 1
	StateResourceInstanceObjectV1_DAMAGED StateResourceInstanceObjectV1_Status = 2 // (formerly known as "tainted")
)

// Enum value maps for StateResourceInstanceObjectV1_Status.
var (
	StateResourceInstanceObjectV1_Status_name = map[int32]string{
		0: "UNKNOWN",
		1: "READY",
		2: "DAMAGED",
	}
	StateResourceInstanceObjectV1_Status_value = map[string]int32{
		"UNKNOWN": 0,
		"READY":   1,
		"DAMAGED": 2,
	}
)

func (x StateResourceInstanceObjectV1_Status) Enum() *StateResourceInstanceObjectV1_Status {
	p := new(StateResourceInstanceObjectV1_Status)
	*p = x
	return p
}

func (x StateResourceInstanceObjectV1_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StateResourceInstanceObjectV1_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_tfstackdata1_proto_enumTypes[0].Descriptor()
}

func (StateResourceInstanceObjectV1_Status) Type() protoreflect.EnumType {
	return &file_tfstackdata1_proto_enumTypes[0]
}

func (x StateResourceInstanceObjectV1_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StateResourceInstanceObjectV1_Status.Descriptor instead.
func (StateResourceInstanceObjectV1_Status) EnumDescriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{14, 0}
}

// Appears early in a raw plan sequence to capture some metadata that we need
// to process subsequent messages, or to abort if we're being asked to decode
// a plan created by a different version of Terraform.
type PlanHeader struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The canonical version string for the version of Terraform that created
	// the plan sequence that this message belongs to.
	//
	// The raw plan sequence loader will fail if it finds a message of this
	// type with a version string that disagrees with the version of Terraform
	// decoding the message, because we always expect plans to be applied by
	// the same version of Terraform that created them.
	TerraformVersion string `protobuf:"bytes,1,opt,name=terraform_version,json=terraformVersion,proto3" json:"terraform_version,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *PlanHeader) Reset() {
	*x = PlanHeader{}
	mi := &file_tfstackdata1_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanHeader) ProtoMessage() {}

func (x *PlanHeader) ProtoReflect() protoreflect.Message {
	mi := &file_tfstackdata1_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanHeader.ProtoReflect.Descriptor instead.
func (*PlanHeader) Descriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{0}
}

func (x *PlanHeader) GetTerraformVersion() string {
	if x != nil {
		return x.TerraformVersion
	}
	return ""
}

// Captures one element from the raw prior state that was provided when
// creating the plan. A valid plan includes a copy of its entire prior state
// represented as zero or more messages of this type, which we then interpret
// as a map from key to raw during load.
type PlanPriorStateElem struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Key           string                 `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Raw           *anypb.Any             `protobuf:"bytes,2,opt,name=raw,proto3" json:"raw,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlanPriorStateElem) Reset() {
	*x = PlanPriorStateElem{}
	mi := &file_tfstackdata1_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanPriorStateElem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanPriorStateElem) ProtoMessage() {}

func (x *PlanPriorStateElem) ProtoReflect() protoreflect.Message {
	mi := &file_tfstackdata1_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanPriorStateElem.ProtoReflect.Descriptor instead.
func (*PlanPriorStateElem) Descriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{1}
}

func (x *PlanPriorStateElem) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *PlanPriorStateElem) GetRaw() *anypb.Any {
	if x != nil {
		return x.Raw
	}
	return nil
}

// Confirms whether the overall plan whose raw plan sequence includes this
// message is complete enough and valid enough to be applied.
//
// If a the sequence of raw plan messages includes multiple messages of this
// type then the one with the latest position in the list "wins" during
// decoding of the overall sequence, although in practice there isn't yet
// any clear reason to include more than one instance of this message type in a
// plan.
type PlanApplyable struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Applyable     bool                   `protobuf:"varint,1,opt,name=applyable,proto3" json:"applyable,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlanApplyable) Reset() {
	*x = PlanApplyable{}
	mi := &file_tfstackdata1_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanApplyable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanApplyable) ProtoMessage() {}

func (x *PlanApplyable) ProtoReflect() protoreflect.Message {
	mi := &file_tfstackdata1_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanApplyable.ProtoReflect.Descriptor instead.
func (*PlanApplyable) Descriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{2}
}

func (x *PlanApplyable) GetApplyable() bool {
	if x != nil {
		return x.Applyable
	}
	return false
}

// Records the plan timestamp to be used for all components and the stacks language.
type PlanTimestamp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PlanTimestamp string                 `protobuf:"bytes,1,opt,name=plan_timestamp,json=planTimestamp,proto3" json:"plan_timestamp,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlanTimestamp) Reset() {
	*x = PlanTimestamp{}
	mi := &file_tfstackdata1_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanTimestamp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanTimestamp) ProtoMessage() {}

func (x *PlanTimestamp) ProtoReflect() protoreflect.Message {
	mi := &file_tfstackdata1_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanTimestamp.ProtoReflect.Descriptor instead.
func (*PlanTimestamp) Descriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{3}
}

func (x *PlanTimestamp) GetPlanTimestamp() string {
	if x != nil {
		return x.PlanTimestamp
	}
	return ""
}

// Records the value of one of the main stack's input values during planning.
//
// These values get fixed during the plan phase so that we can ensure that we
// use identical values when subsequently applying the plan.
type PlanRootInputValue struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	Name            string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value           *DynamicValue          `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	RequiredOnApply bool                   `protobuf:"varint,3,opt,name=required_on_apply,json=requiredOnApply,proto3" json:"required_on_apply,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *PlanRootInputValue) Reset() {
	*x = PlanRootInputValue{}
	mi := &file_tfstackdata1_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanRootInputValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanRootInputValue) ProtoMessage() {}

func (x *PlanRootInputValue) ProtoReflect() protoreflect.Message {
	mi := &file_tfstackdata1_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanRootInputValue.ProtoReflect.Descriptor instead.
func (*PlanRootInputValue) Descriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{4}
}

func (x *PlanRootInputValue) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PlanRootInputValue) GetValue() *DynamicValue {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *PlanRootInputValue) GetRequiredOnApply() bool {
	if x != nil {
		return x.RequiredOnApply
	}
	return false
}

// Records that a root input variable should be deleted by the apply operation.
type DeletedRootInputVariable struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeletedRootInputVariable) Reset() {
	*x = DeletedRootInputVariable{}
	mi := &file_tfstackdata1_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletedRootInputVariable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletedRootInputVariable) ProtoMessage() {}

func (x *DeletedRootInputVariable) ProtoReflect() protoreflect.Message {
	mi := &file_tfstackdata1_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletedRootInputVariable.ProtoReflect.Descriptor instead.
func (*DeletedRootInputVariable) Descriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{5}
}

func (x *DeletedRootInputVariable) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Records that a root output should be deleted by the apply operation.
type DeletedRootOutputValue struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeletedRootOutputValue) Reset() {
	*x = DeletedRootOutputValue{}
	mi := &file_tfstackdata1_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletedRootOutputValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletedRootOutputValue) ProtoMessage() {}

func (x *DeletedRootOutputValue) ProtoReflect() protoreflect.Message {
	mi := &file_tfstackdata1_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletedRootOutputValue.ProtoReflect.Descriptor instead.
func (*DeletedRootOutputValue) Descriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{6}
}

func (x *DeletedRootOutputValue) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Records that a component should just be deleted from the state.
type DeletedComponent struct {
	state                 protoimpl.MessageState `protogen:"open.v1"`
	ComponentInstanceAddr string                 `protobuf:"bytes,1,opt,name=component_instance_addr,json=componentInstanceAddr,proto3" json:"component_instance_addr,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *DeletedComponent) Reset() {
	*x = DeletedComponent{}
	mi := &file_tfstackdata1_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletedComponent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletedComponent) ProtoMessage() {}

func (x *DeletedComponent) ProtoReflect() protoreflect.Message {
	mi := &file_tfstackdata1_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletedComponent.ProtoReflect.Descriptor instead.
func (*DeletedComponent) Descriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{7}
}

func (x *DeletedComponent) GetComponentInstanceAddr() string {
	if x != nil {
		return x.ComponentInstanceAddr
	}
	return ""
}

// FunctionResults stores a record of the results of provider functions
// that were called during the planning phase. This is used to ensure that the
// same results are returned during the apply phase.
type FunctionResults struct {
	state           protoimpl.MessageState        `protogen:"open.v1"`
	FunctionResults []*planproto.FunctionCallHash `protobuf:"bytes,1,rep,name=function_results,json=functionResults,proto3" json:"function_results,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *FunctionResults) Reset() {
	*x = FunctionResults{}
	mi := &file_tfstackdata1_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FunctionResults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionResults) ProtoMessage() {}

func (x *FunctionResults) ProtoReflect() protoreflect.Message {
	mi := &file_tfstackdata1_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionResults.ProtoReflect.Descriptor instead.
func (*FunctionResults) Descriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{8}
}

func (x *FunctionResults) GetFunctionResults() []*planproto.FunctionCallHash {
	if x != nil {
		return x.FunctionResults
	}
	return nil
}

// Represents the existence of a particular component instance, and so must
// always appear before any messages representing objects that belong to that
// component instance.
//
// This message type exists to avoid the ambiguity between a component instance
// existing with zero resource instances inside vs. a component instance
// not existing at all.
type PlanComponentInstance struct {
	state                 protoimpl.MessageState `protogen:"open.v1"`
	ComponentInstanceAddr string                 `protobuf:"bytes,1,opt,name=component_instance_addr,json=componentInstanceAddr,proto3" json:"component_instance_addr,omitempty"`
	// plan_timestamp records the time when the plan for this component
	// instance was created, exclusively for making sure that the
	// "plantimestamp" function can return the same value during the apply
	// phase. It must not be used for any other purpose.
	PlanTimestamp string `protobuf:"bytes,2,opt,name=plan_timestamp,json=planTimestamp,proto3" json:"plan_timestamp,omitempty"`
	// Captures an approximation of the input values for this component with
	// as much detail as we knew during the planning phase. This might
	// contain unknown values as placeholders for values that won't be
	// determined until the apply phase, so this isn't usable directly as
	// the input to subsequently applying the component plan but the final
	// input values should be a valid concretization of what's described here.
	PlannedInputValues map[string]*DynamicValue `protobuf:"bytes,3,rep,name=planned_input_values,json=plannedInputValues,proto3" json:"planned_input_values,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The action planned for the component as a whole.
	//
	// This does not directly incorporate actions planned for resource
	// instances within this component instance, but does capture a sense
	// of the overall action being taken for this particular component
	// instance.
	//
	// The currently-possible values are:
	//   - CREATE and UPDATE both describe applying a "normal" plan, where
	//     CREATE additionally represents that the component instance
	//     did not previously exist.
	//   - READ describes a refresh-only plan. This is currently possible only
	//     if the overall stack plan is refresh-only.
	//   - DELETE describes applying a destroy plan, with the intent of
	//     deleting all remote objects currently bound to resource instances
	//     in this component instance.
	//
	// The value recorded here is used to achieve a few variations needed in
	// the apply phase.
	PlannedAction planproto.Action `protobuf:"varint,4,opt,name=planned_action,json=plannedAction,proto3,enum=tfplan.Action" json:"planned_action,omitempty"`
	// The mode that was used to plan this component.
	//
	// This is used to determine the behavior of the apply phase for this
	// component instance.
	//
	// Ideally, we wouldn't need to include this at all as the plan should
	// contain everything we need without a general mode. However, this is
	// not currently the case. See context_apply.go:332 for more details.
	// TODO: Remove this once walkDestroy has been properly audited.
	Mode planproto.Mode `protobuf:"varint,10,opt,name=mode,proto3,enum=tfplan.Mode" json:"mode,omitempty"`
	// The appliability flag decided by the modules runtime for this component's
	// plan. See the docs for plans.Plan.Applyable for details on what this
	// represents. (It's here largely just so that we can repopulate it
	// faithfully when we rebuild a plans.Plan object at apply time.)
	PlanApplyable bool `protobuf:"varint,7,opt,name=plan_applyable,json=planApplyable,proto3" json:"plan_applyable,omitempty"`
	// The completion flag decided by the modules runtime for this component's
	// plan. See the docs for plans.Plan.Complete for details on what this
	// represents. (It's here largely just so that we can repopulate it
	// faithfully when we rebuild a plans.Plan object at apply time.)
	PlanComplete bool `protobuf:"varint,8,opt,name=plan_complete,json=planComplete,proto3" json:"plan_complete,omitempty"`
	// A list of absolute component addresses that this component
	// instance depends on according to the configuration the plan was
	// created from. (These are components rather than component instances
	// because the stacks language evaluation model uses components as the
	// most specific granularity for dependency resolution.)
	//
	// Applying this component instance's plan must wait until any
	// CREATE or UPDATE plans for any of the listed component instances have
	// completed successfully. Additionally, if any of the component instances
	// listed here have DELETE plans then this component instance must also
	// have a DELETE plan and the upstream DELETE must wait until this one
	// has completed.
	//
	// A component instance plan that is not DELETE cannot depend on another
	// component instance that is not also DELETE, since that would imply that
	// this component instance's configuration refers to a component that isn't
	// declared, which should therefore have failed validation.
	DependsOnComponentAddrs []string `protobuf:"bytes,5,rep,name=depends_on_component_addrs,json=dependsOnComponentAddrs,proto3" json:"depends_on_component_addrs,omitempty"`
	// Captures an approximation of the output values for this component with
	// as much detail as we knew during the planning phase.
	//
	// For any planned action other than DELETE this might contain unknown
	// values as placeholders for values that won't be determined until the
	// apply phase
	//
	// For a DELETE plan the values should always be known because they are
	// based on the prior state for the component, before it has been destroyed.
	// The apply phase should use these values to build the representation of
	// the component instance as an expression, because for DELETE any
	// dependent objects must also be pending DELETE and their delete must
	// happen before this instance is destroyed.
	PlannedOutputValues map[string]*DynamicValue `protobuf:"bytes,6,rep,name=planned_output_values,json=plannedOutputValues,proto3" json:"planned_output_values,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// A list of check results for this component instance, as produced by
	// the modules runtime during the planning phase. The apply expects to
	// update check results which were unknown during planning to reflect
	// the actual results from the apply phase.
	PlannedCheckResults []*planproto.CheckResults `protobuf:"bytes,9,rep,name=planned_check_results,json=plannedCheckResults,proto3" json:"planned_check_results,omitempty"`
	// The set of provider function results that were produced during the
	// planning phase for this component instance. These results are used
	// to ensure that the same results are returned during the apply phase.
	FunctionResults []*planproto.FunctionCallHash `protobuf:"bytes,11,rep,name=function_results,json=functionResults,proto3" json:"function_results,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *PlanComponentInstance) Reset() {
	*x = PlanComponentInstance{}
	mi := &file_tfstackdata1_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanComponentInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanComponentInstance) ProtoMessage() {}

func (x *PlanComponentInstance) ProtoReflect() protoreflect.Message {
	mi := &file_tfstackdata1_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanComponentInstance.ProtoReflect.Descriptor instead.
func (*PlanComponentInstance) Descriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{9}
}

func (x *PlanComponentInstance) GetComponentInstanceAddr() string {
	if x != nil {
		return x.ComponentInstanceAddr
	}
	return ""
}

func (x *PlanComponentInstance) GetPlanTimestamp() string {
	if x != nil {
		return x.PlanTimestamp
	}
	return ""
}

func (x *PlanComponentInstance) GetPlannedInputValues() map[string]*DynamicValue {
	if x != nil {
		return x.PlannedInputValues
	}
	return nil
}

func (x *PlanComponentInstance) GetPlannedAction() planproto.Action {
	if x != nil {
		return x.PlannedAction
	}
	return planproto.Action(0)
}

func (x *PlanComponentInstance) GetMode() planproto.Mode {
	if x != nil {
		return x.Mode
	}
	return planproto.Mode(0)
}

func (x *PlanComponentInstance) GetPlanApplyable() bool {
	if x != nil {
		return x.PlanApplyable
	}
	return false
}

func (x *PlanComponentInstance) GetPlanComplete() bool {
	if x != nil {
		return x.PlanComplete
	}
	return false
}

func (x *PlanComponentInstance) GetDependsOnComponentAddrs() []string {
	if x != nil {
		return x.DependsOnComponentAddrs
	}
	return nil
}

func (x *PlanComponentInstance) GetPlannedOutputValues() map[string]*DynamicValue {
	if x != nil {
		return x.PlannedOutputValues
	}
	return nil
}

func (x *PlanComponentInstance) GetPlannedCheckResults() []*planproto.CheckResults {
	if x != nil {
		return x.PlannedCheckResults
	}
	return nil
}

func (x *PlanComponentInstance) GetFunctionResults() []*planproto.FunctionCallHash {
	if x != nil {
		return x.FunctionResults
	}
	return nil
}

// Represents a planned change to a particular resource instance within a
// particular component instance.
type PlanResourceInstanceChangePlanned struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The same string must previously have been announced with a
	// PlanComponentInstance message, or the overall plan sequence is invalid.
	ComponentInstanceAddr string `protobuf:"bytes,1,opt,name=component_instance_addr,json=componentInstanceAddr,proto3" json:"component_instance_addr,omitempty"`
	ResourceInstanceAddr  string `protobuf:"bytes,4,opt,name=resource_instance_addr,json=resourceInstanceAddr,proto3" json:"resource_instance_addr,omitempty"`
	DeposedKey            string `protobuf:"bytes,5,opt,name=deposed_key,json=deposedKey,proto3" json:"deposed_key,omitempty"`
	// The address of the provider configuration that planned this change,
	// or that produced the prior state for messages where "change" is
	// unpopulated. This is a module-centric view relative to the root module
	// of the component identified in component_instance_addr.
	ProviderConfigAddr string `protobuf:"bytes,6,opt,name=provider_config_addr,json=providerConfigAddr,proto3" json:"provider_config_addr,omitempty"`
	// Description of the planned change in the standard "tfplan" (planproto)
	// format.
	Change *planproto.ResourceInstanceChange `protobuf:"bytes,2,opt,name=change,proto3" json:"change,omitempty"`
	// A snapshot of the "prior state", which is the result of upgrading and
	// refreshing the previous run's state.
	//
	// The very first action on applying this plan should be to update the
	// raw state for the resource instance to match this value, since
	// the main apply phase for each component instance assumes that the
	// prior state has already been updated to match the "old" value from
	// the "change" message.
	PriorState    *StateResourceInstanceObjectV1 `protobuf:"bytes,3,opt,name=prior_state,json=priorState,proto3" json:"prior_state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlanResourceInstanceChangePlanned) Reset() {
	*x = PlanResourceInstanceChangePlanned{}
	mi := &file_tfstackdata1_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanResourceInstanceChangePlanned) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanResourceInstanceChangePlanned) ProtoMessage() {}

func (x *PlanResourceInstanceChangePlanned) ProtoReflect() protoreflect.Message {
	mi := &file_tfstackdata1_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanResourceInstanceChangePlanned.ProtoReflect.Descriptor instead.
func (*PlanResourceInstanceChangePlanned) Descriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{10}
}

func (x *PlanResourceInstanceChangePlanned) GetComponentInstanceAddr() string {
	if x != nil {
		return x.ComponentInstanceAddr
	}
	return ""
}

func (x *PlanResourceInstanceChangePlanned) GetResourceInstanceAddr() string {
	if x != nil {
		return x.ResourceInstanceAddr
	}
	return ""
}

func (x *PlanResourceInstanceChangePlanned) GetDeposedKey() string {
	if x != nil {
		return x.DeposedKey
	}
	return ""
}

func (x *PlanResourceInstanceChangePlanned) GetProviderConfigAddr() string {
	if x != nil {
		return x.ProviderConfigAddr
	}
	return ""
}

func (x *PlanResourceInstanceChangePlanned) GetChange() *planproto.ResourceInstanceChange {
	if x != nil {
		return x.Change
	}
	return nil
}

func (x *PlanResourceInstanceChangePlanned) GetPriorState() *StateResourceInstanceObjectV1 {
	if x != nil {
		return x.PriorState
	}
	return nil
}

// Represents a deferred change to a particular resource instance within a
// particular component instance.
type PlanDeferredResourceInstanceChange struct {
	state         protoimpl.MessageState             `protogen:"open.v1"`
	Deferred      *planproto.Deferred                `protobuf:"bytes,1,opt,name=deferred,proto3" json:"deferred,omitempty"`
	Change        *PlanResourceInstanceChangePlanned `protobuf:"bytes,2,opt,name=change,proto3" json:"change,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlanDeferredResourceInstanceChange) Reset() {
	*x = PlanDeferredResourceInstanceChange{}
	mi := &file_tfstackdata1_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanDeferredResourceInstanceChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanDeferredResourceInstanceChange) ProtoMessage() {}

func (x *PlanDeferredResourceInstanceChange) ProtoReflect() protoreflect.Message {
	mi := &file_tfstackdata1_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanDeferredResourceInstanceChange.ProtoReflect.Descriptor instead.
func (*PlanDeferredResourceInstanceChange) Descriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{11}
}

func (x *PlanDeferredResourceInstanceChange) GetDeferred() *planproto.Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

func (x *PlanDeferredResourceInstanceChange) GetChange() *PlanResourceInstanceChangePlanned {
	if x != nil {
		return x.Change
	}
	return nil
}

// Represents that we need to emit "delete" requests for one or more raw
// state and/or state description objects during the apply phase.
//
// This situation arises if the previous state (given as input to the apply
// phase) contains keys that are of a type unrecognized by the current
// version of Terraform and that are marked as "discard if unrecognized",
// suggesting that their content is likely to become somehow invalid if
// other parts of the state were to get updated.
type PlanDiscardStateMapKeys struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// A set of keys to delete from the "raw state".
	RawStateKeys []string `protobuf:"bytes,1,rep,name=raw_state_keys,json=rawStateKeys,proto3" json:"raw_state_keys,omitempty"`
	// A set of keys to delete from the "state description".
	DescriptionKeys []string `protobuf:"bytes,2,rep,name=description_keys,json=descriptionKeys,proto3" json:"description_keys,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *PlanDiscardStateMapKeys) Reset() {
	*x = PlanDiscardStateMapKeys{}
	mi := &file_tfstackdata1_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanDiscardStateMapKeys) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanDiscardStateMapKeys) ProtoMessage() {}

func (x *PlanDiscardStateMapKeys) ProtoReflect() protoreflect.Message {
	mi := &file_tfstackdata1_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanDiscardStateMapKeys.ProtoReflect.Descriptor instead.
func (*PlanDiscardStateMapKeys) Descriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{12}
}

func (x *PlanDiscardStateMapKeys) GetRawStateKeys() []string {
	if x != nil {
		return x.RawStateKeys
	}
	return nil
}

func (x *PlanDiscardStateMapKeys) GetDescriptionKeys() []string {
	if x != nil {
		return x.DescriptionKeys
	}
	return nil
}

// Represents the existence of a particular component instance.
//
// This is here mainly to remove the ambiguity between a component instance that
// exists but contains no resource instances vs. a component instance that
// doesn't exist at all.
//
// Because the state map is updated on a per-element basis rather than
// atomically, it's possible that the state map might contain resource instances
// which belong to a component instance that is not tracked by a message of
// this type. In that case, the state loader will just assume an implied
// message of this type with a matching component instance address and with
// all other fields unset.
type StateComponentInstanceV1 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The component instance's output values as reported from the most recent
	// apply action. We retain this only so that we have some values to use
	// in cases where the values in the configuration are unavailable or
	// insufficient, such as when we're making a destroy-mode plan and therefore
	// the desired state would be for the component instance to cease existing
	// but yet we still need to have _some_ output values to use when planning
	// and applying other component instances that refer to this one.
	OutputValues map[string]*DynamicValue `protobuf:"bytes,1,rep,name=output_values,json=outputValues,proto3" json:"output_values,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The input variables for this component instance as reported from the
	// most recent apply action. We retain this only for usage within removed
	// blocks, where we need to know the input variables to be able to plan
	// and apply the destroy action without asking the user to resupply or
	// remember them.
	InputVariables map[string]*DynamicValue `protobuf:"bytes,2,rep,name=input_variables,json=inputVariables,proto3" json:"input_variables,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The absolute configuration addresses of components that this component
	// instance depended on when it was created. We preserve this information
	// to help with plan and apply ordering during destroy plans or for removed
	// blocks.
	DependencyAddrs []string `protobuf:"bytes,3,rep,name=dependency_addrs,json=dependencyAddrs,proto3" json:"dependency_addrs,omitempty"`
	// The absolute configuration addresses of components that depended on this
	// component instance when it was created. We preserve this information
	// to help with plan and apply ordering during destroy plans or for removed
	// blocks.
	DependentAddrs []string `protobuf:"bytes,4,rep,name=dependent_addrs,json=dependentAddrs,proto3" json:"dependent_addrs,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *StateComponentInstanceV1) Reset() {
	*x = StateComponentInstanceV1{}
	mi := &file_tfstackdata1_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StateComponentInstanceV1) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateComponentInstanceV1) ProtoMessage() {}

func (x *StateComponentInstanceV1) ProtoReflect() protoreflect.Message {
	mi := &file_tfstackdata1_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateComponentInstanceV1.ProtoReflect.Descriptor instead.
func (*StateComponentInstanceV1) Descriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{13}
}

func (x *StateComponentInstanceV1) GetOutputValues() map[string]*DynamicValue {
	if x != nil {
		return x.OutputValues
	}
	return nil
}

func (x *StateComponentInstanceV1) GetInputVariables() map[string]*DynamicValue {
	if x != nil {
		return x.InputVariables
	}
	return nil
}

func (x *StateComponentInstanceV1) GetDependencyAddrs() []string {
	if x != nil {
		return x.DependencyAddrs
	}
	return nil
}

func (x *StateComponentInstanceV1) GetDependentAddrs() []string {
	if x != nil {
		return x.DependentAddrs
	}
	return nil
}

// Represents the existence of a particular resource instance object in a
// particular component instance.
//
// A resource instance message object should typically be accompanied by a
// StateComponentInstanceV1 (or later version) that represents the existence
// of the component itself, but for robustness we tolerate the absense of
// such a message and just assume that all of its fields (other than the
// component instance address) are unset.
type StateResourceInstanceObjectV1 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// value_json is a JSON representation of the object value representing
	// this resource instance object.
	//
	// This is JSON-serialized rather than MessagePack serialized (as we do
	// for everything else in this format and in the RPC API) because
	// the provider protocol only supports legacy flatmap and JSON as input
	// to the state upgrade process, and we won't be able to transcode from
	// MessagePack to JSON once we decode this because we won't know the
	// schema that the value was encoded with.
	//
	// This is a pragmatic exception for this particular quirk of Terraform's
	// provider API design. Other parts of this format and associated protocol
	// should use tfplan.DynamicValue and MessagePack encoding for consistency.
	ValueJson           []byte                               `protobuf:"bytes,1,opt,name=value_json,json=valueJson,proto3" json:"value_json,omitempty"`
	SensitivePaths      []*planproto.Path                    `protobuf:"bytes,2,rep,name=sensitive_paths,json=sensitivePaths,proto3" json:"sensitive_paths,omitempty"`
	SchemaVersion       uint64                               `protobuf:"varint,3,opt,name=schema_version,json=schemaVersion,proto3" json:"schema_version,omitempty"`
	Status              StateResourceInstanceObjectV1_Status `protobuf:"varint,4,opt,name=status,proto3,enum=tfstackdata1.StateResourceInstanceObjectV1_Status" json:"status,omitempty"`
	Dependencies        []string                             `protobuf:"bytes,5,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
	CreateBeforeDestroy bool                                 `protobuf:"varint,6,opt,name=create_before_destroy,json=createBeforeDestroy,proto3" json:"create_before_destroy,omitempty"`
	ProviderConfigAddr  string                               `protobuf:"bytes,7,opt,name=provider_config_addr,json=providerConfigAddr,proto3" json:"provider_config_addr,omitempty"`
	// provider_specific_data is arbitrary bytes produced by the provider
	// in its apply response which we preserve and pass back to it in any
	// subsequent plan operation.
	ProviderSpecificData []byte `protobuf:"bytes,8,opt,name=provider_specific_data,json=providerSpecificData,proto3" json:"provider_specific_data,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *StateResourceInstanceObjectV1) Reset() {
	*x = StateResourceInstanceObjectV1{}
	mi := &file_tfstackdata1_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StateResourceInstanceObjectV1) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateResourceInstanceObjectV1) ProtoMessage() {}

func (x *StateResourceInstanceObjectV1) ProtoReflect() protoreflect.Message {
	mi := &file_tfstackdata1_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateResourceInstanceObjectV1.ProtoReflect.Descriptor instead.
func (*StateResourceInstanceObjectV1) Descriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{14}
}

func (x *StateResourceInstanceObjectV1) GetValueJson() []byte {
	if x != nil {
		return x.ValueJson
	}
	return nil
}

func (x *StateResourceInstanceObjectV1) GetSensitivePaths() []*planproto.Path {
	if x != nil {
		return x.SensitivePaths
	}
	return nil
}

func (x *StateResourceInstanceObjectV1) GetSchemaVersion() uint64 {
	if x != nil {
		return x.SchemaVersion
	}
	return 0
}

func (x *StateResourceInstanceObjectV1) GetStatus() StateResourceInstanceObjectV1_Status {
	if x != nil {
		return x.Status
	}
	return StateResourceInstanceObjectV1_UNKNOWN
}

func (x *StateResourceInstanceObjectV1) GetDependencies() []string {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *StateResourceInstanceObjectV1) GetCreateBeforeDestroy() bool {
	if x != nil {
		return x.CreateBeforeDestroy
	}
	return false
}

func (x *StateResourceInstanceObjectV1) GetProviderConfigAddr() string {
	if x != nil {
		return x.ProviderConfigAddr
	}
	return ""
}

func (x *StateResourceInstanceObjectV1) GetProviderSpecificData() []byte {
	if x != nil {
		return x.ProviderSpecificData
	}
	return nil
}

type DynamicValue struct {
	state          protoimpl.MessageState  `protogen:"open.v1"`
	Value          *planproto.DynamicValue `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	SensitivePaths []*planproto.Path       `protobuf:"bytes,2,rep,name=sensitive_paths,json=sensitivePaths,proto3" json:"sensitive_paths,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *DynamicValue) Reset() {
	*x = DynamicValue{}
	mi := &file_tfstackdata1_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DynamicValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicValue) ProtoMessage() {}

func (x *DynamicValue) ProtoReflect() protoreflect.Message {
	mi := &file_tfstackdata1_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicValue.ProtoReflect.Descriptor instead.
func (*DynamicValue) Descriptor() ([]byte, []int) {
	return file_tfstackdata1_proto_rawDescGZIP(), []int{15}
}

func (x *DynamicValue) GetValue() *planproto.DynamicValue {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DynamicValue) GetSensitivePaths() []*planproto.Path {
	if x != nil {
		return x.SensitivePaths
	}
	return nil
}

var File_tfstackdata1_proto protoreflect.FileDescriptor

var file_tfstackdata1_proto_rawDesc = string([]byte{
	0x0a, 0x12, 0x74, 0x66, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x61, 0x74, 0x61, 0x31, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0c, 0x74, 0x66, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x61, 0x74,
	0x61, 0x31, 0x1a, 0x0e, 0x70, 0x6c, 0x61, 0x6e, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x39, 0x0a,
	0x0a, 0x50, 0x6c, 0x61, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x11, 0x74,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x4e, 0x0a, 0x12, 0x50, 0x6c, 0x61, 0x6e,
	0x50, 0x72, 0x69, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x45, 0x6c, 0x65, 0x6d, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x26, 0x0a, 0x03, 0x72, 0x61, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x41, 0x6e, 0x79, 0x52, 0x03, 0x72, 0x61, 0x77, 0x22, 0x2d, 0x0a, 0x0d, 0x50, 0x6c, 0x61, 0x6e,
	0x41, 0x70, 0x70, 0x6c, 0x79, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x70, 0x70,
	0x6c, 0x79, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x61, 0x70,
	0x70, 0x6c, 0x79, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x36, 0x0a, 0x0d, 0x50, 0x6c, 0x61, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x6c, 0x61, 0x6e,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x70, 0x6c, 0x61, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22,
	0x86, 0x01, 0x0a, 0x12, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x6f, 0x6f, 0x74, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x74, 0x66, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x64, 0x61, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2a, 0x0a, 0x11,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6f, 0x6e, 0x5f, 0x61, 0x70, 0x70, 0x6c,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x64, 0x4f, 0x6e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x22, 0x2e, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x52, 0x6f, 0x6f, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x72, 0x69,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x2c, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x52, 0x6f, 0x6f, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x4a, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x36, 0x0a, 0x17, 0x63, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x63, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x64,
	0x64, 0x72, 0x22, 0x56, 0x0a, 0x0f, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x43, 0x0a, 0x10, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x18, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x48, 0x61, 0x73, 0x68, 0x52, 0x0f, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x8f, 0x07, 0x0a, 0x15, 0x50,
	0x6c, 0x61, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e,
	0x74, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x12, 0x25, 0x0a, 0x0e,
	0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x6c, 0x61, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x12, 0x6d, 0x0a, 0x14, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x74, 0x66, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x61, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x12,
	0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x12, 0x35, 0x0a, 0x0e, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0e, 0x2e, 0x74, 0x66, 0x70,
	0x6c, 0x61, 0x6e, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x70, 0x6c, 0x61, 0x6e,
	0x6e, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x04, 0x6d, 0x6f, 0x64,
	0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0c, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x70,
	0x6c, 0x61, 0x6e, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0d, 0x70, 0x6c, 0x61, 0x6e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x61, 0x62,
	0x6c, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x70, 0x6c, 0x61, 0x6e, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x1a, 0x64, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x73, 0x5f, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f,
	0x61, 0x64, 0x64, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x17, 0x64, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x73, 0x4f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x41,
	0x64, 0x64, 0x72, 0x73, 0x12, 0x70, 0x0a, 0x15, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x74, 0x66, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x61, 0x74,
	0x61, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x13, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x15, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65,
	0x64, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x13, 0x70, 0x6c, 0x61,
	0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x12, 0x43, 0x0a, 0x10, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x66, 0x70,
	0x6c, 0x61, 0x6e, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c,
	0x48, 0x61, 0x73, 0x68, 0x52, 0x0f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x1a, 0x61, 0x0a, 0x17, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x30, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x74, 0x66, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x61, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x62, 0x0a, 0x18, 0x50, 0x6c, 0x61, 0x6e,
	0x6e, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x30, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x74, 0x66, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64,
	0x61, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xea, 0x02, 0x0a,
	0x21, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x6e,
	0x65, 0x64, 0x12, 0x36, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x15, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x12, 0x34, 0x0a, 0x16, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x61, 0x64, 0x64, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72,
	0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x65, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x4b, 0x65,
	0x79, 0x12, 0x30, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x12, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x41,
	0x64, 0x64, 0x72, 0x12, 0x36, 0x0a, 0x06, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x52, 0x06, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x4c, 0x0a, 0x0b, 0x70,
	0x72, 0x69, 0x6f, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x74, 0x66, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x61, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x56, 0x31, 0x52, 0x0a, 0x70,
	0x72, 0x69, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x9b, 0x01, 0x0a, 0x22, 0x50, 0x6c,
	0x61, 0x6e, 0x44, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x2c, 0x0a, 0x08, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x10, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x44, 0x65, 0x66, 0x65,
	0x72, 0x72, 0x65, 0x64, 0x52, 0x08, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x12, 0x47,
	0x0a, 0x06, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x74, 0x66, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x61, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x6c,
	0x61, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x52,
	0x06, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x6a, 0x0a, 0x17, 0x50, 0x6c, 0x61, 0x6e, 0x44,
	0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x4b, 0x65,
	0x79, 0x73, 0x12, 0x24, 0x0a, 0x0e, 0x72, 0x61, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f,
	0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x61, 0x77, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b,
	0x65, 0x79, 0x73, 0x22, 0xee, 0x03, 0x0a, 0x18, 0x53, 0x74, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x31,
	0x12, 0x5d, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x74, 0x66, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x64, 0x61, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x31, 0x2e,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0x63, 0x0a, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x74, 0x66, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x64, 0x61, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x31,
	0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f,
	0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x41, 0x64, 0x64, 0x72, 0x73, 0x12,
	0x27, 0x0a, 0x0f, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64,
	0x65, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x72, 0x73, 0x1a, 0x5b, 0x0a, 0x11, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x30, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x74, 0x66, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x61, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x79,
	0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x5d, 0x0a, 0x13, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x30,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x74, 0x66, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x61, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x79, 0x6e,
	0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0xd7, 0x03, 0x0a, 0x1d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x56, 0x31, 0x12, 0x1d, 0x0a, 0x0a, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f,
	0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x4a, 0x73, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x0f, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0c,
	0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x52, 0x0e, 0x73, 0x65,
	0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x50, 0x61, 0x74, 0x68, 0x73, 0x12, 0x25, 0x0a, 0x0e,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x0d, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x74, 0x66, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x61, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x56, 0x31,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x22, 0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x69, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x62, 0x65,
	0x66, 0x6f, 0x72, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x13, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65,
	0x44, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x12, 0x30, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x41, 0x64, 0x64, 0x72, 0x12, 0x34, 0x0a, 0x16, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x14, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x44, 0x61, 0x74, 0x61, 0x22,
	0x2d, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10,
	0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x41, 0x4d, 0x41, 0x47, 0x45, 0x44, 0x10, 0x02, 0x22, 0x71,
	0x0a, 0x0c, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2a,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x35, 0x0a, 0x0f, 0x73, 0x65,
	0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x50, 0x61, 0x74,
	0x68, 0x52, 0x0e, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x50, 0x61, 0x74, 0x68,
	0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_tfstackdata1_proto_rawDescOnce sync.Once
	file_tfstackdata1_proto_rawDescData []byte
)

func file_tfstackdata1_proto_rawDescGZIP() []byte {
	file_tfstackdata1_proto_rawDescOnce.Do(func() {
		file_tfstackdata1_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_tfstackdata1_proto_rawDesc), len(file_tfstackdata1_proto_rawDesc)))
	})
	return file_tfstackdata1_proto_rawDescData
}

var file_tfstackdata1_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_tfstackdata1_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_tfstackdata1_proto_goTypes = []any{
	(StateResourceInstanceObjectV1_Status)(0),  // 0: tfstackdata1.StateResourceInstanceObjectV1.Status
	(*PlanHeader)(nil),                         // 1: tfstackdata1.PlanHeader
	(*PlanPriorStateElem)(nil),                 // 2: tfstackdata1.PlanPriorStateElem
	(*PlanApplyable)(nil),                      // 3: tfstackdata1.PlanApplyable
	(*PlanTimestamp)(nil),                      // 4: tfstackdata1.PlanTimestamp
	(*PlanRootInputValue)(nil),                 // 5: tfstackdata1.PlanRootInputValue
	(*DeletedRootInputVariable)(nil),           // 6: tfstackdata1.DeletedRootInputVariable
	(*DeletedRootOutputValue)(nil),             // 7: tfstackdata1.DeletedRootOutputValue
	(*DeletedComponent)(nil),                   // 8: tfstackdata1.DeletedComponent
	(*FunctionResults)(nil),                    // 9: tfstackdata1.FunctionResults
	(*PlanComponentInstance)(nil),              // 10: tfstackdata1.PlanComponentInstance
	(*PlanResourceInstanceChangePlanned)(nil),  // 11: tfstackdata1.PlanResourceInstanceChangePlanned
	(*PlanDeferredResourceInstanceChange)(nil), // 12: tfstackdata1.PlanDeferredResourceInstanceChange
	(*PlanDiscardStateMapKeys)(nil),            // 13: tfstackdata1.PlanDiscardStateMapKeys
	(*StateComponentInstanceV1)(nil),           // 14: tfstackdata1.StateComponentInstanceV1
	(*StateResourceInstanceObjectV1)(nil),      // 15: tfstackdata1.StateResourceInstanceObjectV1
	(*DynamicValue)(nil),                       // 16: tfstackdata1.DynamicValue
	nil,                                        // 17: tfstackdata1.PlanComponentInstance.PlannedInputValuesEntry
	nil,                                        // 18: tfstackdata1.PlanComponentInstance.PlannedOutputValuesEntry
	nil,                                        // 19: tfstackdata1.StateComponentInstanceV1.OutputValuesEntry
	nil,                                        // 20: tfstackdata1.StateComponentInstanceV1.InputVariablesEntry
	(*anypb.Any)(nil),                          // 21: google.protobuf.Any
	(*planproto.FunctionCallHash)(nil),         // 22: tfplan.FunctionCallHash
	(planproto.Action)(0),                      // 23: tfplan.Action
	(planproto.Mode)(0),                        // 24: tfplan.Mode
	(*planproto.CheckResults)(nil),             // 25: tfplan.CheckResults
	(*planproto.ResourceInstanceChange)(nil),   // 26: tfplan.ResourceInstanceChange
	(*planproto.Deferred)(nil),                 // 27: tfplan.Deferred
	(*planproto.Path)(nil),                     // 28: tfplan.Path
	(*planproto.DynamicValue)(nil),             // 29: tfplan.DynamicValue
}
var file_tfstackdata1_proto_depIdxs = []int32{
	21, // 0: tfstackdata1.PlanPriorStateElem.raw:type_name -> google.protobuf.Any
	16, // 1: tfstackdata1.PlanRootInputValue.value:type_name -> tfstackdata1.DynamicValue
	22, // 2: tfstackdata1.FunctionResults.function_results:type_name -> tfplan.FunctionCallHash
	17, // 3: tfstackdata1.PlanComponentInstance.planned_input_values:type_name -> tfstackdata1.PlanComponentInstance.PlannedInputValuesEntry
	23, // 4: tfstackdata1.PlanComponentInstance.planned_action:type_name -> tfplan.Action
	24, // 5: tfstackdata1.PlanComponentInstance.mode:type_name -> tfplan.Mode
	18, // 6: tfstackdata1.PlanComponentInstance.planned_output_values:type_name -> tfstackdata1.PlanComponentInstance.PlannedOutputValuesEntry
	25, // 7: tfstackdata1.PlanComponentInstance.planned_check_results:type_name -> tfplan.CheckResults
	22, // 8: tfstackdata1.PlanComponentInstance.function_results:type_name -> tfplan.FunctionCallHash
	26, // 9: tfstackdata1.PlanResourceInstanceChangePlanned.change:type_name -> tfplan.ResourceInstanceChange
	15, // 10: tfstackdata1.PlanResourceInstanceChangePlanned.prior_state:type_name -> tfstackdata1.StateResourceInstanceObjectV1
	27, // 11: tfstackdata1.PlanDeferredResourceInstanceChange.deferred:type_name -> tfplan.Deferred
	11, // 12: tfstackdata1.PlanDeferredResourceInstanceChange.change:type_name -> tfstackdata1.PlanResourceInstanceChangePlanned
	19, // 13: tfstackdata1.StateComponentInstanceV1.output_values:type_name -> tfstackdata1.StateComponentInstanceV1.OutputValuesEntry
	20, // 14: tfstackdata1.StateComponentInstanceV1.input_variables:type_name -> tfstackdata1.StateComponentInstanceV1.InputVariablesEntry
	28, // 15: tfstackdata1.StateResourceInstanceObjectV1.sensitive_paths:type_name -> tfplan.Path
	0,  // 16: tfstackdata1.StateResourceInstanceObjectV1.status:type_name -> tfstackdata1.StateResourceInstanceObjectV1.Status
	29, // 17: tfstackdata1.DynamicValue.value:type_name -> tfplan.DynamicValue
	28, // 18: tfstackdata1.DynamicValue.sensitive_paths:type_name -> tfplan.Path
	16, // 19: tfstackdata1.PlanComponentInstance.PlannedInputValuesEntry.value:type_name -> tfstackdata1.DynamicValue
	16, // 20: tfstackdata1.PlanComponentInstance.PlannedOutputValuesEntry.value:type_name -> tfstackdata1.DynamicValue
	16, // 21: tfstackdata1.StateComponentInstanceV1.OutputValuesEntry.value:type_name -> tfstackdata1.DynamicValue
	16, // 22: tfstackdata1.StateComponentInstanceV1.InputVariablesEntry.value:type_name -> tfstackdata1.DynamicValue
	23, // [23:23] is the sub-list for method output_type
	23, // [23:23] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_tfstackdata1_proto_init() }
func file_tfstackdata1_proto_init() {
	if File_tfstackdata1_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_tfstackdata1_proto_rawDesc), len(file_tfstackdata1_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_tfstackdata1_proto_goTypes,
		DependencyIndexes: file_tfstackdata1_proto_depIdxs,
		EnumInfos:         file_tfstackdata1_proto_enumTypes,
		MessageInfos:      file_tfstackdata1_proto_msgTypes,
	}.Build()
	File_tfstackdata1_proto = out.File
	file_tfstackdata1_proto_goTypes = nil
	file_tfstackdata1_proto_depIdxs = nil
}
