# Colored changelog

## [2.3.1] - 2025-07-28

### Changed
- Refactor: Optimized Windows Terminal Mode initialization: Moved `Colored.enable_windows_terminal_mode()` call from `Colored.__init__` to module-level execution. This ensures the Windows virtual terminal processing is enabled only once when the `colored` module is imported, instead of on every `Colored` object instantiation. This change improves performance by avoiding redundant API calls and checks.
- Refactor: Reduce `Colored` instance attributes: Removed redundant instance attributes (`_ESC`, `_END`, `_STYLES`, etc.) from the `Colored` class's `__init__` method. These constants are now accessed directly from the `Library` module, reducing memory footprint per instance and improving adherence to Pylint's `R0902` warning.

### Fixed
- Resolved static analysis warnings in `enable_windows_terminal_mode()`: Modified `enable_windows_terminal_mode()` to ensure consistent return statements and handle all possible execution paths explicitly. This addresses `mypy`'s "Missing return statement" error and `pylint`'s "inconsistent-return-statements" warning by making all return paths explicit and robustly handling potential `ctypes` related exceptions. The return type hint was also updated to `Optional[bool]`.
- Resolved type hinting and tuple unpacking warnings in `Utilities.is_percentage()`: Modified the `Utilities.is_percentage()` method to explicitly return a fixed-length `tuple[int, int, int]`. This addresses `mypy`'s "Incompatible return value type" error and `pylint`'s "unbalanced-tuple-unpacking" warning by ensuring consistent and statically verifiable return types.
- Refined type validation and error handling in `Controls.nav()`: Eliminated the redundant `_is_str_object` static method. Integrated string type validation directly into the `nav()` method. Replaced `AttributeError` with `TypeError` for improved semantic clarity when handling invalid argument types.
- Ensured `test_hex_1.py` correctly uses nearest ANSI codes for hex color representation, preventing `InvalidHexColor` exceptions during gradient and random color tests.

## [2.3.0] - 2025-02-07

### Added
- New `convert` function to convert between ANSI and HEX color formats.
- Tests for the `convert` module.

### Changed
- Updated `convert_percentages(percent: str)` to return an integer.
- Improved code quality with enhanced type annotations and docstrings.

### Fixed
- Removed duplicated HEX color codes.
- Updated utilities to raise `InvalidHexColor` exception instead of `InvalidColor`.

## [2.2.5] - 2025-01-27

### Added
- Support for static typing (#33).

## [2.2.4] - 2023-12-15

### Fixed
- Fixed `cprint` to preserve `fore_color` and `back_color` when omitted (#20).

## [2.2.3] - 2023-07-07

### Fixed
- Corrected typing error (#29).

## [2.2.2] - 2023-06-26

### Added
- Added support for the `COLORTERM` environment variable.

### Changed
- Expanded the maximum range for RGB color values.

## [2.2.1] - 2023-06-25

### Changed
- Renamed `InvalidNavigation` exception to `InvalidControl`.

## [2.2.0] - 2023-06-24

### Added
- Support for CSI (Control Sequence Introducer) sequences.
- Added SGR (Select Graphic Rendition) parameter for underline color.
- Introduced RGB color schema support.

### Changed
- Updated `cprint()` to support RGB colors.

### Fixed
- Corrected typo: changed `underlined` to `underline` in style definitions.

## [2.1.1] - 2023-06-20

### Changed
- Restored legacy support for version 1.x.x:
  - Reintroduced `fg()`, `bg()`, and `attr()` functions (to be deprecated in future releases).
  - Made class attributes `fore`, `back`, and `style` accessible via direct imports, e.g.:
    ```python
    from colored.foreground import fore
    from colored.background import back
    from colored.attributes import style
    ```

## [2.1.0] - 2023-06-20

### Added
- Introduced `cprint()` function.

### Changed
- Updated library to use default values.
- Replaced `show_colour()` with `cprint()`.

## [2.0.0] - 2023-06-19

### Added
- Launched documentation site: https://dslackw.gitlab.io/colored
- Added `italic` and `strikeout` styles (#22).
- Introduced `show_colour()` function.

### Changed
- Improved coding style and added type hints.
- Renamed classes:
  - `fore` to `Fore`
  - `back` to `Back`
  - `style` to `Style`
- Renamed functions:
  - `fg()` to `fore()`
  - `bg()` to `back()`
  - `attr()` to `style()`
- Made class attributes case-insensitive (e.g., `Fore.red` is equivalent to `Fore.RED`, `Style.bold` to `Style.BOLD`).

## [1.4.4] - 2022-11-09

### Changed
- Improved code style with f-strings.
- Removed Python 2 support.
- Replaced raw `ctypes` with Windows types (#25).

## [1.4.3] - 2021-10-23

### Changed
- Enhanced color enabling mechanism (#18).

## [1.4.2] - 2019-12-09

### Changed
- Improved Python 3 compatibility.
- Updated `setup.py` file.

## [1.4.1] - 2019-10-28

### Fixed
- Resolved `UnsupportedOperation: fileno` error when detecting TTY (#14).

## [1.4.0] - 2019-10-02

### Added
- Ensured package data inclusion (!7).
- Converted package spec files to new format (!9).
- Improved HEX color handling (!11).
- Enabled colors in Windows terminal (!12).
- Added TTY awareness option (!13).

## [1.3.93] - 2018-07-06

### Fixed
- Corrected typo in `MANIFEST` file.

## [1.3.92] - 2018-07-02

### Fixed
- Updated `CHANGELOG`, `LICENSE`, and `MANIFEST` for PyPI compatibility (#12).
- Adjusted `setup.py` accordingly.

## [1.3.8] - 2018-06-26

### Fixed
- Resolved issues with `pip install` (#12).

## [1.3.7] - 2018-06-26

### Fixed
- Corrected license typo and `pip install` issues (#12).

## [1.3.6] - 2018-06-24

### Fixed
- Fixed license in `setup.py` file.

## [1.3.5] - 2018-06-24

### Changed
- Migrated to GitLab repository.
- Switched to MIT license.

## [1.3.4] - 2017-05-07

### Added
- Added `readline`-safe `stylize_interactive()` method (#6).

## [1.3.4] - 2017-01-20

### Changed
- Updated license year.

### Fixed
- Fixed color capitalization issues.

## [1.3.3] - 2016-11-19

### Added
- Made HEX codes case-insensitive (#2).
- Added `stylize()` convenience method (#3).

## [1.3.2] - 2016-11-02

### Changed
- Merged `fore` and `back` color names.

## [1.3.1] - 2016-09-20

### Added
- Introduced `RED_3B` color.

### Fixed
- Improved Python 3 print test compatibility.

## [1.3.0] - 2016-09-20

### Changed
- Switched libraries to use `vars()` method.

## [1.2.2] - 2016-05-18

### Changed
- Updated file licenses.
- Renamed color `dark_sea_sreen_X` to `dark_sea_green_X` (thanks to Clifford Ireland).

## [1.2.1] - 2015-06-06

### Changed
- Fixed Python 3 installation.
- Added license to each file.

## [1.2.0] - 2015-06-06

### Changed
- Restored `KeyError` message for exceptions.
- Fixed duplicate foreground key.
- Updated module imports.
- Improved tests.

## [1.1.5] - 2015-02-25

### Changed
- Improved PEP 8 style compliance.

## [1.1.4] - 2014-08-01

### Changed
- Added `egg-info` directory.

## [1.1.3] - 2014-07-11

### Changed
- Fixed version and resolved `attr.py` conflict with `colored.py`.

## [1.1.2] - 2014-07-11

### Added
- Introduced `fore`, `back`, and `style` classes.

## [1.1.1] - 2014-07-10

### Added
- Added support for HEX color codes.
- Introduced `test_2.py` and HEX color list.

## [1.1.0] - 2014-07-09

### Added
- Added `test_2.py` and `colors_list.txt`.

### Changed
- Improved Python 3 support.

## [1.0.9] - 2014-07-09

### Changed
- Removed numbers from dictionary.
- Fixed `KeyError` issues.

## [1.0.8] - 2014-07-08

### Changed
- Created aliases `fg()`, `bg()`, and `attr()`.

## [1.0.7] - 2014-07-08

### Changed
- Consolidated two dictionaries into one.

## [1.0.6] - 2014-07-07

### Changed
- Integrated 16 colors into 256-color support.
- Introduced class and attribute structure.

## [1.0.5] - 2014-07-05

### Added
- Added `test_3.py`.

## [1.0.4] - 2014-07-04

### Added
- Added `test_2.py`.

## [1.0.3] - 2014-07-03

### Changed
- Removed `screenshots` directory.

## [1.0.2] - 2014-07-02

### Added
- Added support for 256 colors.

## [1.0.1] - 2014-07-02

### Added
- Added initial test suite.

## [1.0.0] - 2014-07-02

### Added
- Initial release of the `colored` library.