#!/usr/bin/env python
# -*- coding: utf-8 -*-

from colored import back, fore, style
from colored.library import Library


def main() -> None:
    """Test foreground and background colors.
    """

    # Prints foreground colors
    for name in Library.COLORS:
        print(f"{fore(name)}{name:>3}{style('reset')}", end='  ')

    # Prints background colors
    for name in Library.COLORS:
        print(f"{style(4, name)}{back(name)}{name:>3}{style('reset')}", end='  ')

    # Prints underline with colors
    for name in Library.COLORS:
        print(f"{style(4, name)}{name:>3}{style(59)}", end='  ')


if __name__ == '__main__':
    main()
