#!/usr/bin/env python
# -*- coding: utf-8 -*-

from colored import Back, Fore, Style
from colored.library import Library


def main() -> None:
    """Test foreground and background colors.
    """

    for color in Library.COLORS:
        print(f"{getattr(Fore, color)} This is the color {color} {Style.RESET}")

    for color in Library.COLORS:
        print(f"{getattr(Back, color)} This is the color {color:>20} {Style.RESET}")


if __name__ == '__main__':
    main()
