#!/usr/bin/env python
# -*- coding: utf-8 -*-

from colored import fore, style
from colored.convert import Convert
from colored.library import Library


def main() -> None:
    """Print all codes and names side by side.
    """
    convert = Convert()
    for hex_code, (color, ansi_code) in zip(Library.HEX_COLORS.values(), Library.COLORS.items()):
        print(f'{fore(ansi_code)}{color:<19}{style(0)} {repr(convert.hex_to_ansi(hex_code)):<16}'
              f'{repr(convert.ansi_to_hex(int(ansi_code))):>9}')


if __name__ == '__main__':
    main()
