import unittest

from colored.background import Back
from colored.colored import Colored, back, back_rgb
from colored.library import Library

# pylint: disable=invalid-name


class TestBackground(unittest.TestCase):

    """Test for background colors names and codes.
    """

    def setUp(self) -> None:
        self.ESC: str = '\x1b['
        self.BACKGROUND_256: str = f'{self.ESC}48;5;'
        self.BACKGROUND_RGB: str = f'{self.ESC}48;2;'
        self.END: str = 'm'

    def test_background_256_code(self) -> None:
        """Test backgrounds color by code.
        """
        for code in Library.COLORS.values():
            color = Colored(code)
            self.assertEqual(f'{self.BACKGROUND_256}{code}{self.END}', color.background())

    def test_background_256_name(self) -> None:
        """Test background by name.
        """
        for name, code in Library.COLORS.items():
            color = Colored(name)
            self.assertEqual(f'{self.BACKGROUND_256}{code}{self.END}', color.background())

    def test_back_256_func(self) -> None:
        """Test function backgrounds color by code.
        """
        for name, code in Library.COLORS.items():
            color = Colored(name)
            self.assertEqual(back(code), color.background())

    def test_background_rgb(self) -> None:
        """Test rgb background colors.
        """
        for code in Library.COLORS.values():
            self.assertEqual(f'{self.BACKGROUND_RGB}{code};{code};{code}{self.END}', Back.rgb(code, code, code))

    def test_background_rgb_func(self) -> None:
        """Test function rgb background colors.
        """
        for code in Library.COLORS.values():
            self.assertEqual(f'{self.BACKGROUND_RGB}{code};{code};{code}{self.END}', back_rgb(code, code, code))


if __name__ == '__main__':
    unittest.main()
